
variable "aws_access_key" {
  type      = string
  default   = ""
  sensitive = true
}

variable "aws_region" {
  type = string
}

variable "aws_secondary_region" {
  type    = string
  default = "${env("AWS_DEFAULT_REGION")}"
}

variable "aws_secret_key" {
  type      = string
  default   = ""
  sensitive = true
}

variable "secret_account" {
  type      = string
  default   = "🤷"
  sensitive = true
}

data "amazon-secretsmanager" "autogenerated_1" {
  name = "sample/app/password"
}

data "amazon-secretsmanager" "autogenerated_2" {
  key  = "api_key"
  name = "sample/app/passwords"
}

local "password" {
  sensitive  = true
  expression = "${data.amazon-secretsmanager.autogenerated_1.value}"
}

locals {
  password_key = "MY_KEY_${data.amazon-secretsmanager.autogenerated_2.value}"
}
