// Code generated by sdkgen. DO NOT EDIT.

//nolint
package vpc

import (
	"context"

	"google.golang.org/grpc"

	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	vpc "github.com/yandex-cloud/go-genproto/yandex/cloud/vpc/v1"
)

//revive:disable

// NetworkServiceClient is a vpc.NetworkServiceClient with
// lazy GRPC connection initialization.
type NetworkServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements vpc.NetworkServiceClient
func (c *NetworkServiceClient) Create(ctx context.Context, in *vpc.CreateNetworkRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewNetworkServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements vpc.NetworkServiceClient
func (c *NetworkServiceClient) Delete(ctx context.Context, in *vpc.DeleteNetworkRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewNetworkServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements vpc.NetworkServiceClient
func (c *NetworkServiceClient) Get(ctx context.Context, in *vpc.GetNetworkRequest, opts ...grpc.CallOption) (*vpc.Network, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewNetworkServiceClient(conn).Get(ctx, in, opts...)
}

// List implements vpc.NetworkServiceClient
func (c *NetworkServiceClient) List(ctx context.Context, in *vpc.ListNetworksRequest, opts ...grpc.CallOption) (*vpc.ListNetworksResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewNetworkServiceClient(conn).List(ctx, in, opts...)
}

type NetworkIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err     error
	started bool

	client  *NetworkServiceClient
	request *vpc.ListNetworksRequest

	items []*vpc.Network
}

func (c *NetworkServiceClient) NetworkIterator(ctx context.Context, folderId string, opts ...grpc.CallOption) *NetworkIterator {
	return &NetworkIterator{
		ctx:    ctx,
		opts:   opts,
		client: c,
		request: &vpc.ListNetworksRequest{
			FolderId: folderId,
			PageSize: 1000,
		},
	}
}

func (it *NetworkIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Networks
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *NetworkIterator) Value() *vpc.Network {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *NetworkIterator) Error() error {
	return it.err
}

// ListOperations implements vpc.NetworkServiceClient
func (c *NetworkServiceClient) ListOperations(ctx context.Context, in *vpc.ListNetworkOperationsRequest, opts ...grpc.CallOption) (*vpc.ListNetworkOperationsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewNetworkServiceClient(conn).ListOperations(ctx, in, opts...)
}

type NetworkOperationsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err     error
	started bool

	client  *NetworkServiceClient
	request *vpc.ListNetworkOperationsRequest

	items []*operation.Operation
}

func (c *NetworkServiceClient) NetworkOperationsIterator(ctx context.Context, networkId string, opts ...grpc.CallOption) *NetworkOperationsIterator {
	return &NetworkOperationsIterator{
		ctx:    ctx,
		opts:   opts,
		client: c,
		request: &vpc.ListNetworkOperationsRequest{
			NetworkId: networkId,
			PageSize:  1000,
		},
	}
}

func (it *NetworkOperationsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	response, err := it.client.ListOperations(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Operations
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *NetworkOperationsIterator) Value() *operation.Operation {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *NetworkOperationsIterator) Error() error {
	return it.err
}

// ListSubnets implements vpc.NetworkServiceClient
func (c *NetworkServiceClient) ListSubnets(ctx context.Context, in *vpc.ListNetworkSubnetsRequest, opts ...grpc.CallOption) (*vpc.ListNetworkSubnetsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewNetworkServiceClient(conn).ListSubnets(ctx, in, opts...)
}

type NetworkSubnetsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err     error
	started bool

	client  *NetworkServiceClient
	request *vpc.ListNetworkSubnetsRequest

	items []*vpc.Subnet
}

func (c *NetworkServiceClient) NetworkSubnetsIterator(ctx context.Context, networkId string, opts ...grpc.CallOption) *NetworkSubnetsIterator {
	return &NetworkSubnetsIterator{
		ctx:    ctx,
		opts:   opts,
		client: c,
		request: &vpc.ListNetworkSubnetsRequest{
			NetworkId: networkId,
			PageSize:  1000,
		},
	}
}

func (it *NetworkSubnetsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	response, err := it.client.ListSubnets(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Subnets
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *NetworkSubnetsIterator) Value() *vpc.Subnet {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *NetworkSubnetsIterator) Error() error {
	return it.err
}

// Move implements vpc.NetworkServiceClient
func (c *NetworkServiceClient) Move(ctx context.Context, in *vpc.MoveNetworkRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewNetworkServiceClient(conn).Move(ctx, in, opts...)
}

// Update implements vpc.NetworkServiceClient
func (c *NetworkServiceClient) Update(ctx context.Context, in *vpc.UpdateNetworkRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return vpc.NewNetworkServiceClient(conn).Update(ctx, in, opts...)
}
