// Code generated by sdkgen. DO NOT EDIT.

//nolint
package dataproc

import (
	"context"

	"google.golang.org/grpc"

	dataproc "github.com/yandex-cloud/go-genproto/yandex/cloud/dataproc/v1"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// JobServiceClient is a dataproc.JobServiceClient with
// lazy GRPC connection initialization.
type JobServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements dataproc.JobServiceClient
func (c *JobServiceClient) Create(ctx context.Context, in *dataproc.CreateJobRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return dataproc.NewJobServiceClient(conn).Create(ctx, in, opts...)
}

// Get implements dataproc.JobServiceClient
func (c *JobServiceClient) Get(ctx context.Context, in *dataproc.GetJobRequest, opts ...grpc.CallOption) (*dataproc.Job, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return dataproc.NewJobServiceClient(conn).Get(ctx, in, opts...)
}

// List implements dataproc.JobServiceClient
func (c *JobServiceClient) List(ctx context.Context, in *dataproc.ListJobsRequest, opts ...grpc.CallOption) (*dataproc.ListJobsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return dataproc.NewJobServiceClient(conn).List(ctx, in, opts...)
}

type JobIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err     error
	started bool

	client  *JobServiceClient
	request *dataproc.ListJobsRequest

	items []*dataproc.Job
}

func (c *JobServiceClient) JobIterator(ctx context.Context, clusterId string, opts ...grpc.CallOption) *JobIterator {
	return &JobIterator{
		ctx:    ctx,
		opts:   opts,
		client: c,
		request: &dataproc.ListJobsRequest{
			ClusterId: clusterId,
			PageSize:  1000,
		},
	}
}

func (it *JobIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Jobs
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *JobIterator) Value() *dataproc.Job {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *JobIterator) Error() error {
	return it.err
}

// ListLog implements dataproc.JobServiceClient
func (c *JobServiceClient) ListLog(ctx context.Context, in *dataproc.ListJobLogRequest, opts ...grpc.CallOption) (*dataproc.ListJobLogResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return dataproc.NewJobServiceClient(conn).ListLog(ctx, in, opts...)
}
