// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0-devel
// 	protoc        v3.6.1
// source: yandex/cloud/compute/v1/instance.proto

package compute

import (
	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

type IpVersion int32

const (
	IpVersion_IP_VERSION_UNSPECIFIED IpVersion = 0
	// IPv4 address, for example 192.0.2.235.
	IpVersion_IPV4 IpVersion = 1
	// IPv6 address. Not available yet.
	IpVersion_IPV6 IpVersion = 2
)

// Enum value maps for IpVersion.
var (
	IpVersion_name = map[int32]string{
		0: "IP_VERSION_UNSPECIFIED",
		1: "IPV4",
		2: "IPV6",
	}
	IpVersion_value = map[string]int32{
		"IP_VERSION_UNSPECIFIED": 0,
		"IPV4":                   1,
		"IPV6":                   2,
	}
)

func (x IpVersion) Enum() *IpVersion {
	p := new(IpVersion)
	*p = x
	return p
}

func (x IpVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IpVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_compute_v1_instance_proto_enumTypes[0].Descriptor()
}

func (IpVersion) Type() protoreflect.EnumType {
	return &file_yandex_cloud_compute_v1_instance_proto_enumTypes[0]
}

func (x IpVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IpVersion.Descriptor instead.
func (IpVersion) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_instance_proto_rawDescGZIP(), []int{0}
}

type Instance_Status int32

const (
	Instance_STATUS_UNSPECIFIED Instance_Status = 0
	// Instance is waiting for resources to be allocated.
	Instance_PROVISIONING Instance_Status = 1
	// Instance is running normally.
	Instance_RUNNING Instance_Status = 2
	// Instance is being stopped.
	Instance_STOPPING Instance_Status = 3
	// Instance stopped.
	Instance_STOPPED Instance_Status = 4
	// Instance is being started.
	Instance_STARTING Instance_Status = 5
	// Instance is being restarted.
	Instance_RESTARTING Instance_Status = 6
	// Instance is being updated.
	Instance_UPDATING Instance_Status = 7
	// Instance encountered a problem and cannot operate.
	Instance_ERROR Instance_Status = 8
	// Instance crashed and will be restarted automatically.
	Instance_CRASHED Instance_Status = 9
	// Instance is being deleted.
	Instance_DELETING Instance_Status = 10
)

// Enum value maps for Instance_Status.
var (
	Instance_Status_name = map[int32]string{
		0:  "STATUS_UNSPECIFIED",
		1:  "PROVISIONING",
		2:  "RUNNING",
		3:  "STOPPING",
		4:  "STOPPED",
		5:  "STARTING",
		6:  "RESTARTING",
		7:  "UPDATING",
		8:  "ERROR",
		9:  "CRASHED",
		10: "DELETING",
	}
	Instance_Status_value = map[string]int32{
		"STATUS_UNSPECIFIED": 0,
		"PROVISIONING":       1,
		"RUNNING":            2,
		"STOPPING":           3,
		"STOPPED":            4,
		"STARTING":           5,
		"RESTARTING":         6,
		"UPDATING":           7,
		"ERROR":              8,
		"CRASHED":            9,
		"DELETING":           10,
	}
)

func (x Instance_Status) Enum() *Instance_Status {
	p := new(Instance_Status)
	*p = x
	return p
}

func (x Instance_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Instance_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_compute_v1_instance_proto_enumTypes[1].Descriptor()
}

func (Instance_Status) Type() protoreflect.EnumType {
	return &file_yandex_cloud_compute_v1_instance_proto_enumTypes[1]
}

func (x Instance_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Instance_Status.Descriptor instead.
func (Instance_Status) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_instance_proto_rawDescGZIP(), []int{0, 0}
}

type AttachedDisk_Mode int32

const (
	AttachedDisk_MODE_UNSPECIFIED AttachedDisk_Mode = 0
	// Read-only access.
	AttachedDisk_READ_ONLY AttachedDisk_Mode = 1
	// Read/Write access.
	AttachedDisk_READ_WRITE AttachedDisk_Mode = 2
)

// Enum value maps for AttachedDisk_Mode.
var (
	AttachedDisk_Mode_name = map[int32]string{
		0: "MODE_UNSPECIFIED",
		1: "READ_ONLY",
		2: "READ_WRITE",
	}
	AttachedDisk_Mode_value = map[string]int32{
		"MODE_UNSPECIFIED": 0,
		"READ_ONLY":        1,
		"READ_WRITE":       2,
	}
)

func (x AttachedDisk_Mode) Enum() *AttachedDisk_Mode {
	p := new(AttachedDisk_Mode)
	*p = x
	return p
}

func (x AttachedDisk_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AttachedDisk_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_compute_v1_instance_proto_enumTypes[2].Descriptor()
}

func (AttachedDisk_Mode) Type() protoreflect.EnumType {
	return &file_yandex_cloud_compute_v1_instance_proto_enumTypes[2]
}

func (x AttachedDisk_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AttachedDisk_Mode.Descriptor instead.
func (AttachedDisk_Mode) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_instance_proto_rawDescGZIP(), []int{2, 0}
}

type NetworkSettings_Type int32

const (
	NetworkSettings_TYPE_UNSPECIFIED NetworkSettings_Type = 0
	// Standard network.
	NetworkSettings_STANDARD NetworkSettings_Type = 1
	// Software accelerated network.
	NetworkSettings_SOFTWARE_ACCELERATED NetworkSettings_Type = 2
	// Hardware accelerated network (not available yet, reserved for future use).
	NetworkSettings_HARDWARE_ACCELERATED NetworkSettings_Type = 3
)

// Enum value maps for NetworkSettings_Type.
var (
	NetworkSettings_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "STANDARD",
		2: "SOFTWARE_ACCELERATED",
		3: "HARDWARE_ACCELERATED",
	}
	NetworkSettings_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":     0,
		"STANDARD":             1,
		"SOFTWARE_ACCELERATED": 2,
		"HARDWARE_ACCELERATED": 3,
	}
)

func (x NetworkSettings_Type) Enum() *NetworkSettings_Type {
	p := new(NetworkSettings_Type)
	*p = x
	return p
}

func (x NetworkSettings_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkSettings_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_compute_v1_instance_proto_enumTypes[3].Descriptor()
}

func (NetworkSettings_Type) Type() protoreflect.EnumType {
	return &file_yandex_cloud_compute_v1_instance_proto_enumTypes[3]
}

func (x NetworkSettings_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkSettings_Type.Descriptor instead.
func (NetworkSettings_Type) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_instance_proto_rawDescGZIP(), []int{7, 0}
}

type PlacementPolicy_HostAffinityRule_Operator int32

const (
	PlacementPolicy_HostAffinityRule_OPERATOR_UNSPECIFIED PlacementPolicy_HostAffinityRule_Operator = 0
	PlacementPolicy_HostAffinityRule_IN                   PlacementPolicy_HostAffinityRule_Operator = 1
	PlacementPolicy_HostAffinityRule_NOT_IN               PlacementPolicy_HostAffinityRule_Operator = 2
)

// Enum value maps for PlacementPolicy_HostAffinityRule_Operator.
var (
	PlacementPolicy_HostAffinityRule_Operator_name = map[int32]string{
		0: "OPERATOR_UNSPECIFIED",
		1: "IN",
		2: "NOT_IN",
	}
	PlacementPolicy_HostAffinityRule_Operator_value = map[string]int32{
		"OPERATOR_UNSPECIFIED": 0,
		"IN":                   1,
		"NOT_IN":               2,
	}
)

func (x PlacementPolicy_HostAffinityRule_Operator) Enum() *PlacementPolicy_HostAffinityRule_Operator {
	p := new(PlacementPolicy_HostAffinityRule_Operator)
	*p = x
	return p
}

func (x PlacementPolicy_HostAffinityRule_Operator) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PlacementPolicy_HostAffinityRule_Operator) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_compute_v1_instance_proto_enumTypes[4].Descriptor()
}

func (PlacementPolicy_HostAffinityRule_Operator) Type() protoreflect.EnumType {
	return &file_yandex_cloud_compute_v1_instance_proto_enumTypes[4]
}

func (x PlacementPolicy_HostAffinityRule_Operator) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PlacementPolicy_HostAffinityRule_Operator.Descriptor instead.
func (PlacementPolicy_HostAffinityRule_Operator) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_instance_proto_rawDescGZIP(), []int{8, 0, 0}
}

// An Instance resource. For more information, see [Instances](/docs/compute/concepts/vm).
type Instance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the instance.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the folder that the instance belongs to.
	FolderId  string               `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	CreatedAt *timestamp.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Name of the instance. 1-63 characters long.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the instance. 0-256 characters long.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `key:value` pairs. Maximum of 64 per resource.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// ID of the availability zone where the instance resides.
	ZoneId string `protobuf:"bytes,7,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// ID of the hardware platform configuration for the instance.
	PlatformId string `protobuf:"bytes,8,opt,name=platform_id,json=platformId,proto3" json:"platform_id,omitempty"`
	// Computing resources of the instance such as the amount of memory and number of cores.
	Resources *Resources `protobuf:"bytes,9,opt,name=resources,proto3" json:"resources,omitempty"`
	// Status of the instance.
	Status Instance_Status `protobuf:"varint,10,opt,name=status,proto3,enum=yandex.cloud.compute.v1.Instance_Status" json:"status,omitempty"`
	// The metadata `key:value` pairs assigned to this instance. This includes custom metadata and predefined keys.
	//
	// For example, you may use the metadata in order to provide your public SSH key to the instance.
	// For more information, see [Metadata](/docs/compute/concepts/vm-metadata).
	Metadata map[string]string `protobuf:"bytes,11,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Boot disk that is attached to the instance.
	BootDisk *AttachedDisk `protobuf:"bytes,12,opt,name=boot_disk,json=bootDisk,proto3" json:"boot_disk,omitempty"`
	// Array of secondary disks that are attached to the instance.
	SecondaryDisks []*AttachedDisk `protobuf:"bytes,13,rep,name=secondary_disks,json=secondaryDisks,proto3" json:"secondary_disks,omitempty"`
	// Array of network interfaces that are attached to the instance.
	NetworkInterfaces []*NetworkInterface `protobuf:"bytes,14,rep,name=network_interfaces,json=networkInterfaces,proto3" json:"network_interfaces,omitempty"`
	// A domain name of the instance. FQDN is defined by the server
	// in the format `<hostname>.<region_id>.internal` when the instance is created.
	// If the hostname were not specified when the instance was created, FQDN would be `<id>.auto.internal`.
	Fqdn string `protobuf:"bytes,16,opt,name=fqdn,proto3" json:"fqdn,omitempty"` // output only
	// Scheduling policy configuration.
	SchedulingPolicy *SchedulingPolicy `protobuf:"bytes,17,opt,name=scheduling_policy,json=schedulingPolicy,proto3" json:"scheduling_policy,omitempty"`
	// ID of the service account to use for [authentication inside the instance](/docs/compute/operations/vm-connect/auth-inside-vm).
	// To get the service account ID, use a [yandex.cloud.iam.v1.ServiceAccountService.List] request.
	ServiceAccountId string `protobuf:"bytes,18,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	// Network Settings
	NetworkSettings *NetworkSettings `protobuf:"bytes,19,opt,name=network_settings,json=networkSettings,proto3" json:"network_settings,omitempty"`
	// Placement policy configuration.
	PlacementPolicy *PlacementPolicy `protobuf:"bytes,20,opt,name=placement_policy,json=placementPolicy,proto3" json:"placement_policy,omitempty"`
}

func (x *Instance) Reset() {
	*x = Instance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_compute_v1_instance_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Instance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Instance) ProtoMessage() {}

func (x *Instance) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_instance_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Instance.ProtoReflect.Descriptor instead.
func (*Instance) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_instance_proto_rawDescGZIP(), []int{0}
}

func (x *Instance) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Instance) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *Instance) GetCreatedAt() *timestamp.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *Instance) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Instance) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Instance) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Instance) GetZoneId() string {
	if x != nil {
		return x.ZoneId
	}
	return ""
}

func (x *Instance) GetPlatformId() string {
	if x != nil {
		return x.PlatformId
	}
	return ""
}

func (x *Instance) GetResources() *Resources {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *Instance) GetStatus() Instance_Status {
	if x != nil {
		return x.Status
	}
	return Instance_STATUS_UNSPECIFIED
}

func (x *Instance) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *Instance) GetBootDisk() *AttachedDisk {
	if x != nil {
		return x.BootDisk
	}
	return nil
}

func (x *Instance) GetSecondaryDisks() []*AttachedDisk {
	if x != nil {
		return x.SecondaryDisks
	}
	return nil
}

func (x *Instance) GetNetworkInterfaces() []*NetworkInterface {
	if x != nil {
		return x.NetworkInterfaces
	}
	return nil
}

func (x *Instance) GetFqdn() string {
	if x != nil {
		return x.Fqdn
	}
	return ""
}

func (x *Instance) GetSchedulingPolicy() *SchedulingPolicy {
	if x != nil {
		return x.SchedulingPolicy
	}
	return nil
}

func (x *Instance) GetServiceAccountId() string {
	if x != nil {
		return x.ServiceAccountId
	}
	return ""
}

func (x *Instance) GetNetworkSettings() *NetworkSettings {
	if x != nil {
		return x.NetworkSettings
	}
	return nil
}

func (x *Instance) GetPlacementPolicy() *PlacementPolicy {
	if x != nil {
		return x.PlacementPolicy
	}
	return nil
}

type Resources struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The amount of memory available to the instance, specified in bytes.
	Memory int64 `protobuf:"varint,1,opt,name=memory,proto3" json:"memory,omitempty"`
	// The number of cores available to the instance.
	Cores int64 `protobuf:"varint,2,opt,name=cores,proto3" json:"cores,omitempty"`
	// Baseline level of CPU performance with the ability to burst performance above that baseline level.
	// This field sets baseline performance for each core.
	CoreFraction int64 `protobuf:"varint,3,opt,name=core_fraction,json=coreFraction,proto3" json:"core_fraction,omitempty"`
	// The number of GPUs available to the instance.
	Gpus int64 `protobuf:"varint,4,opt,name=gpus,proto3" json:"gpus,omitempty"`
}

func (x *Resources) Reset() {
	*x = Resources{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_compute_v1_instance_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Resources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Resources) ProtoMessage() {}

func (x *Resources) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_instance_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Resources.ProtoReflect.Descriptor instead.
func (*Resources) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_instance_proto_rawDescGZIP(), []int{1}
}

func (x *Resources) GetMemory() int64 {
	if x != nil {
		return x.Memory
	}
	return 0
}

func (x *Resources) GetCores() int64 {
	if x != nil {
		return x.Cores
	}
	return 0
}

func (x *Resources) GetCoreFraction() int64 {
	if x != nil {
		return x.CoreFraction
	}
	return 0
}

func (x *Resources) GetGpus() int64 {
	if x != nil {
		return x.Gpus
	}
	return 0
}

type AttachedDisk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Access mode to the Disk resource.
	Mode AttachedDisk_Mode `protobuf:"varint,1,opt,name=mode,proto3,enum=yandex.cloud.compute.v1.AttachedDisk_Mode" json:"mode,omitempty"`
	// Serial number that is reflected into the /dev/disk/by-id/ tree
	// of a Linux operating system running within the instance.
	//
	// This value can be used to reference the device for mounting, resizing, and so on, from within the instance.
	DeviceName string `protobuf:"bytes,2,opt,name=device_name,json=deviceName,proto3" json:"device_name,omitempty"`
	// Specifies whether the disk will be auto-deleted when the instance is deleted.
	AutoDelete bool `protobuf:"varint,3,opt,name=auto_delete,json=autoDelete,proto3" json:"auto_delete,omitempty"`
	// ID of the disk that is attached to the instance.
	DiskId string `protobuf:"bytes,4,opt,name=disk_id,json=diskId,proto3" json:"disk_id,omitempty"`
}

func (x *AttachedDisk) Reset() {
	*x = AttachedDisk{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_compute_v1_instance_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AttachedDisk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttachedDisk) ProtoMessage() {}

func (x *AttachedDisk) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_instance_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttachedDisk.ProtoReflect.Descriptor instead.
func (*AttachedDisk) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_instance_proto_rawDescGZIP(), []int{2}
}

func (x *AttachedDisk) GetMode() AttachedDisk_Mode {
	if x != nil {
		return x.Mode
	}
	return AttachedDisk_MODE_UNSPECIFIED
}

func (x *AttachedDisk) GetDeviceName() string {
	if x != nil {
		return x.DeviceName
	}
	return ""
}

func (x *AttachedDisk) GetAutoDelete() bool {
	if x != nil {
		return x.AutoDelete
	}
	return false
}

func (x *AttachedDisk) GetDiskId() string {
	if x != nil {
		return x.DiskId
	}
	return ""
}

type NetworkInterface struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The index of the network interface, generated by the server, 0,1,2... etc.
	// Currently only one network interface is supported per instance.
	Index string `protobuf:"bytes,1,opt,name=index,proto3" json:"index,omitempty"`
	// MAC address that is assigned to the network interface.
	MacAddress string `protobuf:"bytes,2,opt,name=mac_address,json=macAddress,proto3" json:"mac_address,omitempty"`
	// ID of the subnet.
	SubnetId string `protobuf:"bytes,3,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Primary IPv4 address that is assigned to the instance for this network interface.
	PrimaryV4Address *PrimaryAddress `protobuf:"bytes,4,opt,name=primary_v4_address,json=primaryV4Address,proto3" json:"primary_v4_address,omitempty"`
	// Primary IPv6 address that is assigned to the instance for this network interface. IPv6 not available yet.
	PrimaryV6Address *PrimaryAddress `protobuf:"bytes,5,opt,name=primary_v6_address,json=primaryV6Address,proto3" json:"primary_v6_address,omitempty"`
	// ID's of security groups attached to the interface
	SecurityGroupIds []string `protobuf:"bytes,6,rep,name=security_group_ids,json=securityGroupIds,proto3" json:"security_group_ids,omitempty"`
}

func (x *NetworkInterface) Reset() {
	*x = NetworkInterface{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_compute_v1_instance_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkInterface) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkInterface) ProtoMessage() {}

func (x *NetworkInterface) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_instance_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkInterface.ProtoReflect.Descriptor instead.
func (*NetworkInterface) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_instance_proto_rawDescGZIP(), []int{3}
}

func (x *NetworkInterface) GetIndex() string {
	if x != nil {
		return x.Index
	}
	return ""
}

func (x *NetworkInterface) GetMacAddress() string {
	if x != nil {
		return x.MacAddress
	}
	return ""
}

func (x *NetworkInterface) GetSubnetId() string {
	if x != nil {
		return x.SubnetId
	}
	return ""
}

func (x *NetworkInterface) GetPrimaryV4Address() *PrimaryAddress {
	if x != nil {
		return x.PrimaryV4Address
	}
	return nil
}

func (x *NetworkInterface) GetPrimaryV6Address() *PrimaryAddress {
	if x != nil {
		return x.PrimaryV6Address
	}
	return nil
}

func (x *NetworkInterface) GetSecurityGroupIds() []string {
	if x != nil {
		return x.SecurityGroupIds
	}
	return nil
}

type PrimaryAddress struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An IPv4 internal network address that is assigned to the instance for this network interface.
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// One-to-one NAT configuration. If missing, NAT has not been set up.
	OneToOneNat *OneToOneNat `protobuf:"bytes,2,opt,name=one_to_one_nat,json=oneToOneNat,proto3" json:"one_to_one_nat,omitempty"`
}

func (x *PrimaryAddress) Reset() {
	*x = PrimaryAddress{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_compute_v1_instance_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrimaryAddress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrimaryAddress) ProtoMessage() {}

func (x *PrimaryAddress) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_instance_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrimaryAddress.ProtoReflect.Descriptor instead.
func (*PrimaryAddress) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_instance_proto_rawDescGZIP(), []int{4}
}

func (x *PrimaryAddress) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *PrimaryAddress) GetOneToOneNat() *OneToOneNat {
	if x != nil {
		return x.OneToOneNat
	}
	return nil
}

type OneToOneNat struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An external IP address associated with this instance.
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// IP version for the external IP address.
	IpVersion IpVersion `protobuf:"varint,2,opt,name=ip_version,json=ipVersion,proto3,enum=yandex.cloud.compute.v1.IpVersion" json:"ip_version,omitempty"`
}

func (x *OneToOneNat) Reset() {
	*x = OneToOneNat{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_compute_v1_instance_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OneToOneNat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OneToOneNat) ProtoMessage() {}

func (x *OneToOneNat) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_instance_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OneToOneNat.ProtoReflect.Descriptor instead.
func (*OneToOneNat) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_instance_proto_rawDescGZIP(), []int{5}
}

func (x *OneToOneNat) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *OneToOneNat) GetIpVersion() IpVersion {
	if x != nil {
		return x.IpVersion
	}
	return IpVersion_IP_VERSION_UNSPECIFIED
}

type SchedulingPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// True for short-lived compute instances. For more information, see [Preemptible VMs](/docs/compute/concepts/preemptible-vm).
	Preemptible bool `protobuf:"varint,1,opt,name=preemptible,proto3" json:"preemptible,omitempty"`
}

func (x *SchedulingPolicy) Reset() {
	*x = SchedulingPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_compute_v1_instance_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SchedulingPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SchedulingPolicy) ProtoMessage() {}

func (x *SchedulingPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_instance_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SchedulingPolicy.ProtoReflect.Descriptor instead.
func (*SchedulingPolicy) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_instance_proto_rawDescGZIP(), []int{6}
}

func (x *SchedulingPolicy) GetPreemptible() bool {
	if x != nil {
		return x.Preemptible
	}
	return false
}

type NetworkSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Network Type
	Type NetworkSettings_Type `protobuf:"varint,1,opt,name=type,proto3,enum=yandex.cloud.compute.v1.NetworkSettings_Type" json:"type,omitempty"`
}

func (x *NetworkSettings) Reset() {
	*x = NetworkSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_compute_v1_instance_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkSettings) ProtoMessage() {}

func (x *NetworkSettings) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_instance_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkSettings.ProtoReflect.Descriptor instead.
func (*NetworkSettings) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_instance_proto_rawDescGZIP(), []int{7}
}

func (x *NetworkSettings) GetType() NetworkSettings_Type {
	if x != nil {
		return x.Type
	}
	return NetworkSettings_TYPE_UNSPECIFIED
}

type PlacementPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Placement group ID.
	PlacementGroupId string `protobuf:"bytes,1,opt,name=placement_group_id,json=placementGroupId,proto3" json:"placement_group_id,omitempty"`
	// List of affinity rules. Scheduler will attempt to allocate instances according to order of rules.
	HostAffinityRules []*PlacementPolicy_HostAffinityRule `protobuf:"bytes,2,rep,name=host_affinity_rules,json=hostAffinityRules,proto3" json:"host_affinity_rules,omitempty"`
}

func (x *PlacementPolicy) Reset() {
	*x = PlacementPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_compute_v1_instance_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlacementPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlacementPolicy) ProtoMessage() {}

func (x *PlacementPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_instance_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlacementPolicy.ProtoReflect.Descriptor instead.
func (*PlacementPolicy) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_instance_proto_rawDescGZIP(), []int{8}
}

func (x *PlacementPolicy) GetPlacementGroupId() string {
	if x != nil {
		return x.PlacementGroupId
	}
	return ""
}

func (x *PlacementPolicy) GetHostAffinityRules() []*PlacementPolicy_HostAffinityRule {
	if x != nil {
		return x.HostAffinityRules
	}
	return nil
}

// Affinitity definition
type PlacementPolicy_HostAffinityRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Affinity label or one of reserved values - 'yc.hostId', 'yc.hostGroupId'
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Include or exclude action
	Op PlacementPolicy_HostAffinityRule_Operator `protobuf:"varint,2,opt,name=op,proto3,enum=yandex.cloud.compute.v1.PlacementPolicy_HostAffinityRule_Operator" json:"op,omitempty"`
	// Affinity value or host ID or host group ID
	Values []string `protobuf:"bytes,3,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *PlacementPolicy_HostAffinityRule) Reset() {
	*x = PlacementPolicy_HostAffinityRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_yandex_cloud_compute_v1_instance_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PlacementPolicy_HostAffinityRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlacementPolicy_HostAffinityRule) ProtoMessage() {}

func (x *PlacementPolicy_HostAffinityRule) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_compute_v1_instance_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlacementPolicy_HostAffinityRule.ProtoReflect.Descriptor instead.
func (*PlacementPolicy_HostAffinityRule) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_compute_v1_instance_proto_rawDescGZIP(), []int{8, 0}
}

func (x *PlacementPolicy_HostAffinityRule) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *PlacementPolicy_HostAffinityRule) GetOp() PlacementPolicy_HostAffinityRule_Operator {
	if x != nil {
		return x.Op
	}
	return PlacementPolicy_HostAffinityRule_OPERATOR_UNSPECIFIED
}

func (x *PlacementPolicy_HostAffinityRule) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

var File_yandex_cloud_compute_v1_instance_proto protoreflect.FileDescriptor

var file_yandex_cloud_compute_v1_instance_proto_rawDesc = []byte{
	0x0a, 0x26, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x17, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x76,
	0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xd3, 0x0a, 0x0a, 0x08, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12,
	0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12,
	0x1b, 0x0a, 0x09, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x49, 0x64, 0x12, 0x39, 0x0a, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x45, 0x0a,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d,
	0x70, 0x75, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x12, 0x17, 0x0a, 0x07, 0x7a, 0x6f, 0x6e, 0x65, 0x5f, 0x69, 0x64, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x7a, 0x6f, 0x6e, 0x65, 0x49, 0x64, 0x12, 0x1f, 0x0a,
	0x0b, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x49, 0x64, 0x12, 0x40,
	0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x22, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x12, 0x40, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x28, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x12, 0x4b, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0b,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x42, 0x0a, 0x09, 0x62, 0x6f, 0x6f, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x25, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74,
	0x61, 0x63, 0x68, 0x65, 0x64, 0x44, 0x69, 0x73, 0x6b, 0x52, 0x08, 0x62, 0x6f, 0x6f, 0x74, 0x44,
	0x69, 0x73, 0x6b, 0x12, 0x4e, 0x0a, 0x0f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79,
	0x5f, 0x64, 0x69, 0x73, 0x6b, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x70,
	0x75, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x44,
	0x69, 0x73, 0x6b, 0x52, 0x0e, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x44, 0x69,
	0x73, 0x6b, 0x73, 0x12, 0x58, 0x0a, 0x12, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x52, 0x11, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x73, 0x12, 0x12, 0x0a,
	0x04, 0x66, 0x71, 0x64, 0x6e, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x66, 0x71, 0x64,
	0x6e, 0x12, 0x56, 0x0a, 0x11, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x5f,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x79,
	0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x70,
	0x75, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e,
	0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x10, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c,
	0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x2c, 0x0a, 0x12, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x12, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x53, 0x0a, 0x10, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x13, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x0f, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x53, 0x0a, 0x10,
	0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x52, 0x0f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3b, 0x0a, 0x0d,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xac, 0x01, 0x0a, 0x06, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c,
	0x50, 0x52, 0x4f, 0x56, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b,
	0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x53,
	0x54, 0x4f, 0x50, 0x50, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54, 0x4f,
	0x50, 0x50, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x41, 0x52, 0x54, 0x49,
	0x4e, 0x47, 0x10, 0x05, 0x12, 0x0e, 0x0a, 0x0a, 0x52, 0x45, 0x53, 0x54, 0x41, 0x52, 0x54, 0x49,
	0x4e, 0x47, 0x10, 0x06, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47,
	0x10, 0x07, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x08, 0x12, 0x0b, 0x0a,
	0x07, 0x43, 0x52, 0x41, 0x53, 0x48, 0x45, 0x44, 0x10, 0x09, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45,
	0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x0a, 0x22, 0x72, 0x0a, 0x09, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x63, 0x6f, 0x72, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x63, 0x6f,
	0x72, 0x65, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x72, 0x65, 0x5f, 0x66, 0x72, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c, 0x63, 0x6f, 0x72, 0x65,
	0x46, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x67, 0x70, 0x75, 0x73,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x04, 0x67, 0x70, 0x75, 0x73, 0x22, 0xe6, 0x01, 0x0a,
	0x0c, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x44, 0x69, 0x73, 0x6b, 0x12, 0x3e, 0x0a,
	0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x79, 0x61,
	0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x70, 0x75,
	0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x44, 0x69,
	0x73, 0x6b, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x12, 0x1f, 0x0a,
	0x0b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f,
	0x0a, 0x0b, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0a, 0x61, 0x75, 0x74, 0x6f, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x12,
	0x17, 0x0a, 0x07, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x64, 0x69, 0x73, 0x6b, 0x49, 0x64, 0x22, 0x3b, 0x0a, 0x04, 0x4d, 0x6f, 0x64, 0x65,
	0x12, 0x14, 0x0a, 0x10, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x4f,
	0x4e, 0x4c, 0x59, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x57, 0x52,
	0x49, 0x54, 0x45, 0x10, 0x02, 0x22, 0xc2, 0x02, 0x0a, 0x10, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78,
	0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x61, 0x63, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6d, 0x61, 0x63, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x49, 0x64, 0x12, 0x55,
	0x0a, 0x12, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x76, 0x34, 0x5f, 0x61, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x41, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x52, 0x10, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x56, 0x34, 0x41, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x55, 0x0a, 0x12, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79,
	0x5f, 0x76, 0x36, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x27, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x6d,
	0x61, 0x72, 0x79, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x52, 0x10, 0x70, 0x72, 0x69, 0x6d,
	0x61, 0x72, 0x79, 0x56, 0x36, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x2c, 0x0a, 0x12,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69,
	0x64, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x73, 0x22, 0x75, 0x0a, 0x0e, 0x50, 0x72,
	0x69, 0x6d, 0x61, 0x72, 0x79, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x18, 0x0a, 0x07,
	0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x49, 0x0a, 0x0e, 0x6f, 0x6e, 0x65, 0x5f, 0x74, 0x6f,
	0x5f, 0x6f, 0x6e, 0x65, 0x5f, 0x6e, 0x61, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24,
	0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x6e, 0x65, 0x54, 0x6f, 0x4f, 0x6e,
	0x65, 0x4e, 0x61, 0x74, 0x52, 0x0b, 0x6f, 0x6e, 0x65, 0x54, 0x6f, 0x4f, 0x6e, 0x65, 0x4e, 0x61,
	0x74, 0x22, 0x6a, 0x0a, 0x0b, 0x4f, 0x6e, 0x65, 0x54, 0x6f, 0x4f, 0x6e, 0x65, 0x4e, 0x61, 0x74,
	0x12, 0x18, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x41, 0x0a, 0x0a, 0x69, 0x70,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22,
	0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x70, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x09, 0x69, 0x70, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x34, 0x0a,
	0x10, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x12, 0x20, 0x0a, 0x0b, 0x70, 0x72, 0x65, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x62, 0x6c, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x70, 0x72, 0x65, 0x65, 0x6d, 0x70, 0x74, 0x69,
	0x62, 0x6c, 0x65, 0x22, 0xb4, 0x01, 0x0a, 0x0f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x41, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x5e, 0x0a, 0x04, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x41, 0x4e,
	0x44, 0x41, 0x52, 0x44, 0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x53, 0x4f, 0x46, 0x54, 0x57, 0x41,
	0x52, 0x45, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x4c, 0x45, 0x52, 0x41, 0x54, 0x45, 0x44, 0x10, 0x02,
	0x12, 0x18, 0x0a, 0x14, 0x48, 0x41, 0x52, 0x44, 0x57, 0x41, 0x52, 0x45, 0x5f, 0x41, 0x43, 0x43,
	0x45, 0x4c, 0x45, 0x52, 0x41, 0x54, 0x45, 0x44, 0x10, 0x03, 0x22, 0xf7, 0x02, 0x0a, 0x0f, 0x50,
	0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x2c,
	0x0a, 0x12, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x70, 0x6c, 0x61, 0x63,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x12, 0x69, 0x0a, 0x13,
	0x68, 0x6f, 0x73, 0x74, 0x5f, 0x61, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x5f, 0x72, 0x75,
	0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x79, 0x61, 0x6e, 0x64,
	0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x2e, 0x48, 0x6f, 0x73, 0x74, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79,
	0x52, 0x75, 0x6c, 0x65, 0x52, 0x11, 0x68, 0x6f, 0x73, 0x74, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69,
	0x74, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x1a, 0xca, 0x01, 0x0a, 0x10, 0x48, 0x6f, 0x73, 0x74,
	0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x52,
	0x0a, 0x02, 0x6f, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x2e, 0x48, 0x6f, 0x73, 0x74, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74,
	0x79, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x02,
	0x6f, 0x70, 0x12, 0x16, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0x38, 0x0a, 0x08, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x18, 0x0a, 0x14, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54,
	0x4f, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x06, 0x0a, 0x02, 0x49, 0x4e, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x4e, 0x4f, 0x54, 0x5f,
	0x49, 0x4e, 0x10, 0x02, 0x2a, 0x3b, 0x0a, 0x09, 0x49, 0x70, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x1a, 0x0a, 0x16, 0x49, 0x50, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a,
	0x04, 0x49, 0x50, 0x56, 0x34, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x49, 0x50, 0x56, 0x36, 0x10,
	0x02, 0x42, 0x62, 0x0a, 0x1b, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x76, 0x31,
	0x5a, 0x43, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x79, 0x61, 0x6e,
	0x64, 0x65, 0x78, 0x2d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6f, 0x2d, 0x67, 0x65, 0x6e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x79, 0x61, 0x6e, 0x64, 0x65, 0x78, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2f, 0x76, 0x31, 0x3b, 0x63, 0x6f,
	0x6d, 0x70, 0x75, 0x74, 0x65, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_yandex_cloud_compute_v1_instance_proto_rawDescOnce sync.Once
	file_yandex_cloud_compute_v1_instance_proto_rawDescData = file_yandex_cloud_compute_v1_instance_proto_rawDesc
)

func file_yandex_cloud_compute_v1_instance_proto_rawDescGZIP() []byte {
	file_yandex_cloud_compute_v1_instance_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_compute_v1_instance_proto_rawDescData = protoimpl.X.CompressGZIP(file_yandex_cloud_compute_v1_instance_proto_rawDescData)
	})
	return file_yandex_cloud_compute_v1_instance_proto_rawDescData
}

var file_yandex_cloud_compute_v1_instance_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_yandex_cloud_compute_v1_instance_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_yandex_cloud_compute_v1_instance_proto_goTypes = []interface{}{
	(IpVersion)(0),                                 // 0: yandex.cloud.compute.v1.IpVersion
	(Instance_Status)(0),                           // 1: yandex.cloud.compute.v1.Instance.Status
	(AttachedDisk_Mode)(0),                         // 2: yandex.cloud.compute.v1.AttachedDisk.Mode
	(NetworkSettings_Type)(0),                      // 3: yandex.cloud.compute.v1.NetworkSettings.Type
	(PlacementPolicy_HostAffinityRule_Operator)(0), // 4: yandex.cloud.compute.v1.PlacementPolicy.HostAffinityRule.Operator
	(*Instance)(nil),                               // 5: yandex.cloud.compute.v1.Instance
	(*Resources)(nil),                              // 6: yandex.cloud.compute.v1.Resources
	(*AttachedDisk)(nil),                           // 7: yandex.cloud.compute.v1.AttachedDisk
	(*NetworkInterface)(nil),                       // 8: yandex.cloud.compute.v1.NetworkInterface
	(*PrimaryAddress)(nil),                         // 9: yandex.cloud.compute.v1.PrimaryAddress
	(*OneToOneNat)(nil),                            // 10: yandex.cloud.compute.v1.OneToOneNat
	(*SchedulingPolicy)(nil),                       // 11: yandex.cloud.compute.v1.SchedulingPolicy
	(*NetworkSettings)(nil),                        // 12: yandex.cloud.compute.v1.NetworkSettings
	(*PlacementPolicy)(nil),                        // 13: yandex.cloud.compute.v1.PlacementPolicy
	nil,                                            // 14: yandex.cloud.compute.v1.Instance.LabelsEntry
	nil,                                            // 15: yandex.cloud.compute.v1.Instance.MetadataEntry
	(*PlacementPolicy_HostAffinityRule)(nil),       // 16: yandex.cloud.compute.v1.PlacementPolicy.HostAffinityRule
	(*timestamp.Timestamp)(nil),                    // 17: google.protobuf.Timestamp
}
var file_yandex_cloud_compute_v1_instance_proto_depIdxs = []int32{
	17, // 0: yandex.cloud.compute.v1.Instance.created_at:type_name -> google.protobuf.Timestamp
	14, // 1: yandex.cloud.compute.v1.Instance.labels:type_name -> yandex.cloud.compute.v1.Instance.LabelsEntry
	6,  // 2: yandex.cloud.compute.v1.Instance.resources:type_name -> yandex.cloud.compute.v1.Resources
	1,  // 3: yandex.cloud.compute.v1.Instance.status:type_name -> yandex.cloud.compute.v1.Instance.Status
	15, // 4: yandex.cloud.compute.v1.Instance.metadata:type_name -> yandex.cloud.compute.v1.Instance.MetadataEntry
	7,  // 5: yandex.cloud.compute.v1.Instance.boot_disk:type_name -> yandex.cloud.compute.v1.AttachedDisk
	7,  // 6: yandex.cloud.compute.v1.Instance.secondary_disks:type_name -> yandex.cloud.compute.v1.AttachedDisk
	8,  // 7: yandex.cloud.compute.v1.Instance.network_interfaces:type_name -> yandex.cloud.compute.v1.NetworkInterface
	11, // 8: yandex.cloud.compute.v1.Instance.scheduling_policy:type_name -> yandex.cloud.compute.v1.SchedulingPolicy
	12, // 9: yandex.cloud.compute.v1.Instance.network_settings:type_name -> yandex.cloud.compute.v1.NetworkSettings
	13, // 10: yandex.cloud.compute.v1.Instance.placement_policy:type_name -> yandex.cloud.compute.v1.PlacementPolicy
	2,  // 11: yandex.cloud.compute.v1.AttachedDisk.mode:type_name -> yandex.cloud.compute.v1.AttachedDisk.Mode
	9,  // 12: yandex.cloud.compute.v1.NetworkInterface.primary_v4_address:type_name -> yandex.cloud.compute.v1.PrimaryAddress
	9,  // 13: yandex.cloud.compute.v1.NetworkInterface.primary_v6_address:type_name -> yandex.cloud.compute.v1.PrimaryAddress
	10, // 14: yandex.cloud.compute.v1.PrimaryAddress.one_to_one_nat:type_name -> yandex.cloud.compute.v1.OneToOneNat
	0,  // 15: yandex.cloud.compute.v1.OneToOneNat.ip_version:type_name -> yandex.cloud.compute.v1.IpVersion
	3,  // 16: yandex.cloud.compute.v1.NetworkSettings.type:type_name -> yandex.cloud.compute.v1.NetworkSettings.Type
	16, // 17: yandex.cloud.compute.v1.PlacementPolicy.host_affinity_rules:type_name -> yandex.cloud.compute.v1.PlacementPolicy.HostAffinityRule
	4,  // 18: yandex.cloud.compute.v1.PlacementPolicy.HostAffinityRule.op:type_name -> yandex.cloud.compute.v1.PlacementPolicy.HostAffinityRule.Operator
	19, // [19:19] is the sub-list for method output_type
	19, // [19:19] is the sub-list for method input_type
	19, // [19:19] is the sub-list for extension type_name
	19, // [19:19] is the sub-list for extension extendee
	0,  // [0:19] is the sub-list for field type_name
}

func init() { file_yandex_cloud_compute_v1_instance_proto_init() }
func file_yandex_cloud_compute_v1_instance_proto_init() {
	if File_yandex_cloud_compute_v1_instance_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_yandex_cloud_compute_v1_instance_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Instance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_compute_v1_instance_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Resources); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_compute_v1_instance_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AttachedDisk); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_compute_v1_instance_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkInterface); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_compute_v1_instance_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrimaryAddress); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_compute_v1_instance_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OneToOneNat); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_compute_v1_instance_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SchedulingPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_compute_v1_instance_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_compute_v1_instance_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlacementPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_yandex_cloud_compute_v1_instance_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PlacementPolicy_HostAffinityRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_yandex_cloud_compute_v1_instance_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_yandex_cloud_compute_v1_instance_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_compute_v1_instance_proto_depIdxs,
		EnumInfos:         file_yandex_cloud_compute_v1_instance_proto_enumTypes,
		MessageInfos:      file_yandex_cloud_compute_v1_instance_proto_msgTypes,
	}.Build()
	File_yandex_cloud_compute_v1_instance_proto = out.File
	file_yandex_cloud_compute_v1_instance_proto_rawDesc = nil
	file_yandex_cloud_compute_v1_instance_proto_goTypes = nil
	file_yandex_cloud_compute_v1_instance_proto_depIdxs = nil
}
