//Code is generated by ucloud code generator, don't modify it by hand, it will cause undefined behaviors.
//go:generate ucloud-gen-go-api UNet AllocateVIP

package unet

import (
	"github.com/ucloud/ucloud-sdk-go/ucloud/request"
	"github.com/ucloud/ucloud-sdk-go/ucloud/response"
)

// AllocateVIPRequest is request schema for AllocateVIP action
type AllocateVIPRequest struct {
	request.CommonBase

	// [公共参数] 地域
	// Region *string `required:"true"`

	// [公共参数] 可用区
	// Zone *string `required:"false"`

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// 指定vip所属的VPC
	VPCId *string `required:"true"`

	// 子网id
	SubnetId *string `required:"true"`

	// 申请数量，默认: 1
	Count *int `required:"false"`

	// vip名，默认为VIP
	Name *string `required:"false"`

	// 业务组名称，默认为Default
	Tag *string `required:"false"`

	// 备注
	Remark *string `required:"false"`

	// 业务组
	BusinessId *string `required:"false"`
}

// AllocateVIPResponse is response schema for AllocateVIP action
type AllocateVIPResponse struct {
	response.CommonBase

	// 申请到的VIP资源相关信息
	VIPSet []VIPSet

	// 申请到的VIP地址
	DataSet []string
}

// NewAllocateVIPRequest will create request of AllocateVIP action.
func (c *UNetClient) NewAllocateVIPRequest() *AllocateVIPRequest {
	req := &AllocateVIPRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(false)
	return req
}

// AllocateVIP - 根据提供信息，申请内网VIP(Virtual IP），多用于高可用程序作为漂移IP。
func (c *UNetClient) AllocateVIP(req *AllocateVIPRequest) (*AllocateVIPResponse, error) {
	var err error
	var res AllocateVIPResponse

	err = c.Client.InvokeAction("AllocateVIP", req, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}
