/*
 * 3DS OUTSCALE API
 *
 * Welcome to the 3DS OUTSCALE's API documentation.<br /><br />  The 3DS OUTSCALE API enables you to manage your resources in the 3DS OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the 3DS OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the 3DS OUTSCALE API. You can find a list of the differences [here](https://wiki.outscale.net/display/EN/3DS+OUTSCALE+APIs+Reference).<br /><br />  You can also manage your resources using the [Cockpit](https://wiki.outscale.net/display/EN/About+Cockpit) web interface.
 *
 * API version: 1.2
 * Contact: support@outscale.com
 * Generated by: OpenAPI Generator (https://openapi-generator.tech)
 */

package osc
// FiltersApiLog One or more filters.
type FiltersApiLog struct {
	// One or more API keys used for the query.
	QueryAccessKeys []string `json:"QueryAccessKeys,omitempty"`
	// The name of one or more API services used for the query.
	QueryApiNames []string `json:"QueryApiNames,omitempty"`
	// The name of one or more calls.
	QueryCallNames []string `json:"QueryCallNames,omitempty"`
	// The logs of the queries made after the date and time you specify (in ISO 8601 base or extended format).
	QueryDateAfter string `json:"QueryDateAfter,omitempty"`
	// The logs of the queries made before the date and time you specify (in ISO 8601 base or extended format).
	QueryDateBefore string `json:"QueryDateBefore,omitempty"`
	// One or more IP addresses used for the query.
	QueryIpAddresses []string `json:"QueryIpAddresses,omitempty"`
	// One or more user agents used for the HTTP request.
	QueryUserAgents []string `json:"QueryUserAgents,omitempty"`
	// One or more request IDs.
	RequestIds []string `json:"RequestIds,omitempty"`
	// One or more HTTP codes provided by the responses.
	ResponseStatusCodes []int32 `json:"ResponseStatusCodes,omitempty"`
}
