# Go API client for openapi

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

## Overview
This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [OpenAPI-spec](https://www.openapis.org/) from a remote server, you can easily generate an API client.

- API version: 0.0.2
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.GoClientCodegen

## Installation

Install the following dependencies:

```shell
go get github.com/stretchr/testify/assert
go get golang.org/x/oauth2
go get golang.org/x/net/context
go get github.com/antihax/optional
```

Put the package under your project folder and add the following in import:

```golang
import "./openapi"
```

## Documentation for API Endpoints

All URIs are relative to *https://api.hyperone.com/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AgentApi* | [**AgentActionStart**](docs/AgentApi.md#agentactionstart) | **Post** /agent/{agentId}/actions/start | /actions/start
*AgentApi* | [**AgentActionSuspend**](docs/AgentApi.md#agentactionsuspend) | **Post** /agent/{agentId}/actions/suspend | /actions/suspend
*AgentApi* | [**AgentActionTransfer**](docs/AgentApi.md#agentactiontransfer) | **Post** /agent/{agentId}/actions/transfer | /actions/transfer
*AgentApi* | [**AgentActionUpdateEnabledServices**](docs/AgentApi.md#agentactionupdateenabledservices) | **Post** /agent/{agentId}/actions/update_enabledServices | /actions/update_enabledServices
*AgentApi* | [**AgentCreate**](docs/AgentApi.md#agentcreate) | **Post** /agent | Create
*AgentApi* | [**AgentDelete**](docs/AgentApi.md#agentdelete) | **Delete** /agent/{agentId} | Delete
*AgentApi* | [**AgentDeleteAccessrightsIdentity**](docs/AgentApi.md#agentdeleteaccessrightsidentity) | **Delete** /agent/{agentId}/accessrights/{identity} | /accessrights/:identity
*AgentApi* | [**AgentDeleteCredentialId**](docs/AgentApi.md#agentdeletecredentialid) | **Delete** /agent/{agentId}/credential/{id} | /credential/:id
*AgentApi* | [**AgentDeleteCredentialcertificateId**](docs/AgentApi.md#agentdeletecredentialcertificateid) | **Delete** /agent/{agentId}/credential/certificate/{id} | /credential/certificate/:id
*AgentApi* | [**AgentDeleteTagKey**](docs/AgentApi.md#agentdeletetagkey) | **Delete** /agent/{agentId}/tag/{key} | /tag/:key
*AgentApi* | [**AgentGetCredentialId**](docs/AgentApi.md#agentgetcredentialid) | **Get** /agent/{agentId}/credential/{id} | /credential/:id
*AgentApi* | [**AgentGetCredentialcertificateId**](docs/AgentApi.md#agentgetcredentialcertificateid) | **Get** /agent/{agentId}/credential/certificate/{id} | /credential/certificate/:id
*AgentApi* | [**AgentGetInspect**](docs/AgentApi.md#agentgetinspect) | **Get** /agent/{agentId}/inspect | /inspect
*AgentApi* | [**AgentGetResourceResourceIdinspect**](docs/AgentApi.md#agentgetresourceresourceidinspect) | **Get** /agent/{agentId}/resource/{resourceId}/inspect | /resource/:resourceId/inspect
*AgentApi* | [**AgentGetServicesServiceId**](docs/AgentApi.md#agentgetservicesserviceid) | **Get** /agent/{agentId}/services/{serviceId} | /services/:serviceId
*AgentApi* | [**AgentGetTag**](docs/AgentApi.md#agentgettag) | **Get** /agent/{agentId}/tag | /tag
*AgentApi* | [**AgentList**](docs/AgentApi.md#agentlist) | **Get** /agent | List
*AgentApi* | [**AgentListAccessrights**](docs/AgentApi.md#agentlistaccessrights) | **Get** /agent/{agentId}/accessrights | /accessrights
*AgentApi* | [**AgentListCredential**](docs/AgentApi.md#agentlistcredential) | **Get** /agent/{agentId}/credential | /credential
*AgentApi* | [**AgentListCredentialcertificate**](docs/AgentApi.md#agentlistcredentialcertificate) | **Get** /agent/{agentId}/credential/certificate | /credential/certificate
*AgentApi* | [**AgentListEnabledServices**](docs/AgentApi.md#agentlistenabledservices) | **Get** /agent/{agentId}/enabledServices | /enabledServices
*AgentApi* | [**AgentListQueue**](docs/AgentApi.md#agentlistqueue) | **Get** /agent/{agentId}/queue | /queue
*AgentApi* | [**AgentListResource**](docs/AgentApi.md#agentlistresource) | **Get** /agent/{agentId}/resource | /resource
*AgentApi* | [**AgentListResourceResourceIdqueue**](docs/AgentApi.md#agentlistresourceresourceidqueue) | **Get** /agent/{agentId}/resource/{resourceId}/queue | /resource/:resourceId/queue
*AgentApi* | [**AgentListServices**](docs/AgentApi.md#agentlistservices) | **Get** /agent/{agentId}/services | /services
*AgentApi* | [**AgentPatchCredentialId**](docs/AgentApi.md#agentpatchcredentialid) | **Patch** /agent/{agentId}/credential/{id} | /credential/:id
*AgentApi* | [**AgentPatchCredentialcertificateId**](docs/AgentApi.md#agentpatchcredentialcertificateid) | **Patch** /agent/{agentId}/credential/certificate/{id} | /credential/certificate/:id
*AgentApi* | [**AgentPatchTag**](docs/AgentApi.md#agentpatchtag) | **Patch** /agent/{agentId}/tag | /tag
*AgentApi* | [**AgentPostAccessrights**](docs/AgentApi.md#agentpostaccessrights) | **Post** /agent/{agentId}/accessrights | /accessrights
*AgentApi* | [**AgentPostCredential**](docs/AgentApi.md#agentpostcredential) | **Post** /agent/{agentId}/credential | /credential
*AgentApi* | [**AgentPostCredentialcertificate**](docs/AgentApi.md#agentpostcredentialcertificate) | **Post** /agent/{agentId}/credential/certificate | /credential/certificate
*AgentApi* | [**AgentPostResourceResourceIdactionsrecreate**](docs/AgentApi.md#agentpostresourceresourceidactionsrecreate) | **Post** /agent/{agentId}/resource/{resourceId}/actions/recreate | /resource/:resourceId/actions/recreate
*AgentApi* | [**AgentPutEnabledServices**](docs/AgentApi.md#agentputenabledservices) | **Put** /agent/{agentId}/enabledServices | /enabledServices
*AgentApi* | [**AgentPutTag**](docs/AgentApi.md#agentputtag) | **Put** /agent/{agentId}/tag | /tag
*AgentApi* | [**AgentShow**](docs/AgentApi.md#agentshow) | **Get** /agent/{agentId} | Get
*AgentApi* | [**AgentUpdate**](docs/AgentApi.md#agentupdate) | **Patch** /agent/{agentId} | Update
*ContainerApi* | [**ContainerActionRestart**](docs/ContainerApi.md#containeractionrestart) | **Post** /container/{containerId}/actions/restart | /actions/restart
*ContainerApi* | [**ContainerActionStart**](docs/ContainerApi.md#containeractionstart) | **Post** /container/{containerId}/actions/start | /actions/start
*ContainerApi* | [**ContainerActionStop**](docs/ContainerApi.md#containeractionstop) | **Post** /container/{containerId}/actions/stop | /actions/stop
*ContainerApi* | [**ContainerCreate**](docs/ContainerApi.md#containercreate) | **Post** /container | Create
*ContainerApi* | [**ContainerDelete**](docs/ContainerApi.md#containerdelete) | **Delete** /container/{containerId} | Delete
*ContainerApi* | [**ContainerDeleteAccessrightsIdentity**](docs/ContainerApi.md#containerdeleteaccessrightsidentity) | **Delete** /container/{containerId}/accessrights/{identity} | /accessrights/:identity
*ContainerApi* | [**ContainerDeleteTagKey**](docs/ContainerApi.md#containerdeletetagkey) | **Delete** /container/{containerId}/tag/{key} | /tag/:key
*ContainerApi* | [**ContainerGetServicesServiceId**](docs/ContainerApi.md#containergetservicesserviceid) | **Get** /container/{containerId}/services/{serviceId} | /services/:serviceId
*ContainerApi* | [**ContainerGetTag**](docs/ContainerApi.md#containergettag) | **Get** /container/{containerId}/tag | /tag
*ContainerApi* | [**ContainerList**](docs/ContainerApi.md#containerlist) | **Get** /container | List
*ContainerApi* | [**ContainerListAccessrights**](docs/ContainerApi.md#containerlistaccessrights) | **Get** /container/{containerId}/accessrights | /accessrights
*ContainerApi* | [**ContainerListProcess**](docs/ContainerApi.md#containerlistprocess) | **Get** /container/{containerId}/process | /process
*ContainerApi* | [**ContainerListQueue**](docs/ContainerApi.md#containerlistqueue) | **Get** /container/{containerId}/queue | /queue
*ContainerApi* | [**ContainerListServices**](docs/ContainerApi.md#containerlistservices) | **Get** /container/{containerId}/services | /services
*ContainerApi* | [**ContainerPatchTag**](docs/ContainerApi.md#containerpatchtag) | **Patch** /container/{containerId}/tag | /tag
*ContainerApi* | [**ContainerPostAccessrights**](docs/ContainerApi.md#containerpostaccessrights) | **Post** /container/{containerId}/accessrights | /accessrights
*ContainerApi* | [**ContainerPutTag**](docs/ContainerApi.md#containerputtag) | **Put** /container/{containerId}/tag | /tag
*ContainerApi* | [**ContainerShow**](docs/ContainerApi.md#containershow) | **Get** /container/{containerId} | Get
*ContainerApi* | [**ContainerUpdate**](docs/ContainerApi.md#containerupdate) | **Patch** /container/{containerId} | Update
*DatabaseApi* | [**DatabaseActionStart**](docs/DatabaseApi.md#databaseactionstart) | **Post** /database/{databaseId}/actions/start | /actions/start
*DatabaseApi* | [**DatabaseActionStop**](docs/DatabaseApi.md#databaseactionstop) | **Post** /database/{databaseId}/actions/stop | /actions/stop
*DatabaseApi* | [**DatabaseActionTransfer**](docs/DatabaseApi.md#databaseactiontransfer) | **Post** /database/{databaseId}/actions/transfer | /actions/transfer
*DatabaseApi* | [**DatabaseCreate**](docs/DatabaseApi.md#databasecreate) | **Post** /database | Create
*DatabaseApi* | [**DatabaseDelete**](docs/DatabaseApi.md#databasedelete) | **Delete** /database/{databaseId} | Delete
*DatabaseApi* | [**DatabaseDeleteAccessrightsIdentity**](docs/DatabaseApi.md#databasedeleteaccessrightsidentity) | **Delete** /database/{databaseId}/accessrights/{identity} | /accessrights/:identity
*DatabaseApi* | [**DatabaseDeleteCredentialId**](docs/DatabaseApi.md#databasedeletecredentialid) | **Delete** /database/{databaseId}/credential/{id} | /credential/:id
*DatabaseApi* | [**DatabaseDeleteCredentialpasswordId**](docs/DatabaseApi.md#databasedeletecredentialpasswordid) | **Delete** /database/{databaseId}/credential/password/{id} | /credential/password/:id
*DatabaseApi* | [**DatabaseDeleteTagKey**](docs/DatabaseApi.md#databasedeletetagkey) | **Delete** /database/{databaseId}/tag/{key} | /tag/:key
*DatabaseApi* | [**DatabaseGetCredentialId**](docs/DatabaseApi.md#databasegetcredentialid) | **Get** /database/{databaseId}/credential/{id} | /credential/:id
*DatabaseApi* | [**DatabaseGetCredentialpasswordId**](docs/DatabaseApi.md#databasegetcredentialpasswordid) | **Get** /database/{databaseId}/credential/password/{id} | /credential/password/:id
*DatabaseApi* | [**DatabaseGetServicesServiceId**](docs/DatabaseApi.md#databasegetservicesserviceid) | **Get** /database/{databaseId}/services/{serviceId} | /services/:serviceId
*DatabaseApi* | [**DatabaseGetTag**](docs/DatabaseApi.md#databasegettag) | **Get** /database/{databaseId}/tag | /tag
*DatabaseApi* | [**DatabaseList**](docs/DatabaseApi.md#databaselist) | **Get** /database | List
*DatabaseApi* | [**DatabaseListAccessrights**](docs/DatabaseApi.md#databaselistaccessrights) | **Get** /database/{databaseId}/accessrights | /accessrights
*DatabaseApi* | [**DatabaseListCredential**](docs/DatabaseApi.md#databaselistcredential) | **Get** /database/{databaseId}/credential | /credential
*DatabaseApi* | [**DatabaseListCredentialpassword**](docs/DatabaseApi.md#databaselistcredentialpassword) | **Get** /database/{databaseId}/credential/password | /credential/password
*DatabaseApi* | [**DatabaseListQueue**](docs/DatabaseApi.md#databaselistqueue) | **Get** /database/{databaseId}/queue | /queue
*DatabaseApi* | [**DatabaseListServices**](docs/DatabaseApi.md#databaselistservices) | **Get** /database/{databaseId}/services | /services
*DatabaseApi* | [**DatabasePatchCredentialId**](docs/DatabaseApi.md#databasepatchcredentialid) | **Patch** /database/{databaseId}/credential/{id} | /credential/:id
*DatabaseApi* | [**DatabasePatchCredentialpasswordId**](docs/DatabaseApi.md#databasepatchcredentialpasswordid) | **Patch** /database/{databaseId}/credential/password/{id} | /credential/password/:id
*DatabaseApi* | [**DatabasePatchTag**](docs/DatabaseApi.md#databasepatchtag) | **Patch** /database/{databaseId}/tag | /tag
*DatabaseApi* | [**DatabasePostAccessrights**](docs/DatabaseApi.md#databasepostaccessrights) | **Post** /database/{databaseId}/accessrights | /accessrights
*DatabaseApi* | [**DatabasePostCredential**](docs/DatabaseApi.md#databasepostcredential) | **Post** /database/{databaseId}/credential | /credential
*DatabaseApi* | [**DatabasePostCredentialpassword**](docs/DatabaseApi.md#databasepostcredentialpassword) | **Post** /database/{databaseId}/credential/password | /credential/password
*DatabaseApi* | [**DatabasePutTag**](docs/DatabaseApi.md#databaseputtag) | **Put** /database/{databaseId}/tag | /tag
*DatabaseApi* | [**DatabaseShow**](docs/DatabaseApi.md#databaseshow) | **Get** /database/{databaseId} | Get
*DatabaseApi* | [**DatabaseUpdate**](docs/DatabaseApi.md#databaseupdate) | **Patch** /database/{databaseId} | Update
*DiskApi* | [**DiskActionClone**](docs/DiskApi.md#diskactionclone) | **Post** /disk/{diskId}/actions/clone | /actions/clone
*DiskApi* | [**DiskActionResize**](docs/DiskApi.md#diskactionresize) | **Post** /disk/{diskId}/actions/resize | /actions/resize
*DiskApi* | [**DiskActionTransfer**](docs/DiskApi.md#diskactiontransfer) | **Post** /disk/{diskId}/actions/transfer | /actions/transfer
*DiskApi* | [**DiskCreate**](docs/DiskApi.md#diskcreate) | **Post** /disk | Create
*DiskApi* | [**DiskDelete**](docs/DiskApi.md#diskdelete) | **Delete** /disk/{diskId} | Delete
*DiskApi* | [**DiskDeleteAccessrightsIdentity**](docs/DiskApi.md#diskdeleteaccessrightsidentity) | **Delete** /disk/{diskId}/accessrights/{identity} | /accessrights/:identity
*DiskApi* | [**DiskDeleteTagKey**](docs/DiskApi.md#diskdeletetagkey) | **Delete** /disk/{diskId}/tag/{key} | /tag/:key
*DiskApi* | [**DiskGetDownload**](docs/DiskApi.md#diskgetdownload) | **Get** /disk/{diskId}/download | /download
*DiskApi* | [**DiskGetServicesServiceId**](docs/DiskApi.md#diskgetservicesserviceid) | **Get** /disk/{diskId}/services/{serviceId} | /services/:serviceId
*DiskApi* | [**DiskGetTag**](docs/DiskApi.md#diskgettag) | **Get** /disk/{diskId}/tag | /tag
*DiskApi* | [**DiskList**](docs/DiskApi.md#disklist) | **Get** /disk | List
*DiskApi* | [**DiskListAccessrights**](docs/DiskApi.md#disklistaccessrights) | **Get** /disk/{diskId}/accessrights | /accessrights
*DiskApi* | [**DiskListQueue**](docs/DiskApi.md#disklistqueue) | **Get** /disk/{diskId}/queue | /queue
*DiskApi* | [**DiskListServices**](docs/DiskApi.md#disklistservices) | **Get** /disk/{diskId}/services | /services
*DiskApi* | [**DiskPatchTag**](docs/DiskApi.md#diskpatchtag) | **Patch** /disk/{diskId}/tag | /tag
*DiskApi* | [**DiskPostAccessrights**](docs/DiskApi.md#diskpostaccessrights) | **Post** /disk/{diskId}/accessrights | /accessrights
*DiskApi* | [**DiskPutTag**](docs/DiskApi.md#diskputtag) | **Put** /disk/{diskId}/tag | /tag
*DiskApi* | [**DiskShow**](docs/DiskApi.md#diskshow) | **Get** /disk/{diskId} | Get
*DiskApi* | [**DiskUpdate**](docs/DiskApi.md#diskupdate) | **Patch** /disk/{diskId} | Update
*FirewallApi* | [**FirewallActionAttach**](docs/FirewallApi.md#firewallactionattach) | **Post** /firewall/{firewallId}/actions/attach | /actions/attach
*FirewallApi* | [**FirewallActionDetach**](docs/FirewallApi.md#firewallactiondetach) | **Post** /firewall/{firewallId}/actions/detach | /actions/detach
*FirewallApi* | [**FirewallActionTransfer**](docs/FirewallApi.md#firewallactiontransfer) | **Post** /firewall/{firewallId}/actions/transfer | /actions/transfer
*FirewallApi* | [**FirewallCreate**](docs/FirewallApi.md#firewallcreate) | **Post** /firewall | Create
*FirewallApi* | [**FirewallDelete**](docs/FirewallApi.md#firewalldelete) | **Delete** /firewall/{firewallId} | Delete
*FirewallApi* | [**FirewallDeleteAccessrightsIdentity**](docs/FirewallApi.md#firewalldeleteaccessrightsidentity) | **Delete** /firewall/{firewallId}/accessrights/{identity} | /accessrights/:identity
*FirewallApi* | [**FirewallDeleteEgressRuleId**](docs/FirewallApi.md#firewalldeleteegressruleid) | **Delete** /firewall/{firewallId}/egress/{ruleId} | /egress/:ruleId
*FirewallApi* | [**FirewallDeleteIngressRuleId**](docs/FirewallApi.md#firewalldeleteingressruleid) | **Delete** /firewall/{firewallId}/ingress/{ruleId} | /ingress/:ruleId
*FirewallApi* | [**FirewallDeleteTagKey**](docs/FirewallApi.md#firewalldeletetagkey) | **Delete** /firewall/{firewallId}/tag/{key} | /tag/:key
*FirewallApi* | [**FirewallGetEgressRuleId**](docs/FirewallApi.md#firewallgetegressruleid) | **Get** /firewall/{firewallId}/egress/{ruleId} | /egress/:ruleId
*FirewallApi* | [**FirewallGetIngressRuleId**](docs/FirewallApi.md#firewallgetingressruleid) | **Get** /firewall/{firewallId}/ingress/{ruleId} | /ingress/:ruleId
*FirewallApi* | [**FirewallGetServicesServiceId**](docs/FirewallApi.md#firewallgetservicesserviceid) | **Get** /firewall/{firewallId}/services/{serviceId} | /services/:serviceId
*FirewallApi* | [**FirewallGetTag**](docs/FirewallApi.md#firewallgettag) | **Get** /firewall/{firewallId}/tag | /tag
*FirewallApi* | [**FirewallList**](docs/FirewallApi.md#firewalllist) | **Get** /firewall | List
*FirewallApi* | [**FirewallListAccessrights**](docs/FirewallApi.md#firewalllistaccessrights) | **Get** /firewall/{firewallId}/accessrights | /accessrights
*FirewallApi* | [**FirewallListEgress**](docs/FirewallApi.md#firewalllistegress) | **Get** /firewall/{firewallId}/egress | /egress
*FirewallApi* | [**FirewallListIngress**](docs/FirewallApi.md#firewalllistingress) | **Get** /firewall/{firewallId}/ingress | /ingress
*FirewallApi* | [**FirewallListQueue**](docs/FirewallApi.md#firewalllistqueue) | **Get** /firewall/{firewallId}/queue | /queue
*FirewallApi* | [**FirewallListServices**](docs/FirewallApi.md#firewalllistservices) | **Get** /firewall/{firewallId}/services | /services
*FirewallApi* | [**FirewallPatchTag**](docs/FirewallApi.md#firewallpatchtag) | **Patch** /firewall/{firewallId}/tag | /tag
*FirewallApi* | [**FirewallPostAccessrights**](docs/FirewallApi.md#firewallpostaccessrights) | **Post** /firewall/{firewallId}/accessrights | /accessrights
*FirewallApi* | [**FirewallPostEgress**](docs/FirewallApi.md#firewallpostegress) | **Post** /firewall/{firewallId}/egress | /egress
*FirewallApi* | [**FirewallPostIngress**](docs/FirewallApi.md#firewallpostingress) | **Post** /firewall/{firewallId}/ingress | /ingress
*FirewallApi* | [**FirewallPutEgress**](docs/FirewallApi.md#firewallputegress) | **Put** /firewall/{firewallId}/egress | /egress
*FirewallApi* | [**FirewallPutIngress**](docs/FirewallApi.md#firewallputingress) | **Put** /firewall/{firewallId}/ingress | /ingress
*FirewallApi* | [**FirewallPutTag**](docs/FirewallApi.md#firewallputtag) | **Put** /firewall/{firewallId}/tag | /tag
*FirewallApi* | [**FirewallShow**](docs/FirewallApi.md#firewallshow) | **Get** /firewall/{firewallId} | Get
*FirewallApi* | [**FirewallUpdate**](docs/FirewallApi.md#firewallupdate) | **Patch** /firewall/{firewallId} | Update
*ImageApi* | [**ImageActionTransfer**](docs/ImageApi.md#imageactiontransfer) | **Post** /image/{imageId}/actions/transfer | /actions/transfer
*ImageApi* | [**ImageCreate**](docs/ImageApi.md#imagecreate) | **Post** /image | Create
*ImageApi* | [**ImageDelete**](docs/ImageApi.md#imagedelete) | **Delete** /image/{imageId} | Delete
*ImageApi* | [**ImageDeleteAccessrightsIdentity**](docs/ImageApi.md#imagedeleteaccessrightsidentity) | **Delete** /image/{imageId}/accessrights/{identity} | /accessrights/:identity
*ImageApi* | [**ImageDeleteTagKey**](docs/ImageApi.md#imagedeletetagkey) | **Delete** /image/{imageId}/tag/{key} | /tag/:key
*ImageApi* | [**ImageGetServicesServiceId**](docs/ImageApi.md#imagegetservicesserviceid) | **Get** /image/{imageId}/services/{serviceId} | /services/:serviceId
*ImageApi* | [**ImageGetTag**](docs/ImageApi.md#imagegettag) | **Get** /image/{imageId}/tag | /tag
*ImageApi* | [**ImageList**](docs/ImageApi.md#imagelist) | **Get** /image | List
*ImageApi* | [**ImageListAccessrights**](docs/ImageApi.md#imagelistaccessrights) | **Get** /image/{imageId}/accessrights | /accessrights
*ImageApi* | [**ImageListQueue**](docs/ImageApi.md#imagelistqueue) | **Get** /image/{imageId}/queue | /queue
*ImageApi* | [**ImageListServices**](docs/ImageApi.md#imagelistservices) | **Get** /image/{imageId}/services | /services
*ImageApi* | [**ImagePatchTag**](docs/ImageApi.md#imagepatchtag) | **Patch** /image/{imageId}/tag | /tag
*ImageApi* | [**ImagePostAccessrights**](docs/ImageApi.md#imagepostaccessrights) | **Post** /image/{imageId}/accessrights | /accessrights
*ImageApi* | [**ImagePutTag**](docs/ImageApi.md#imageputtag) | **Put** /image/{imageId}/tag | /tag
*ImageApi* | [**ImageShow**](docs/ImageApi.md#imageshow) | **Get** /image/{imageId} | Get
*ImageApi* | [**ImageUpdate**](docs/ImageApi.md#imageupdate) | **Patch** /image/{imageId} | Update
*IpApi* | [**IpActionAllocate**](docs/IpApi.md#ipactionallocate) | **Post** /ip/{ipId}/actions/allocate | /actions/allocate
*IpApi* | [**IpActionAssociate**](docs/IpApi.md#ipactionassociate) | **Post** /ip/{ipId}/actions/associate | /actions/associate
*IpApi* | [**IpActionDisassociate**](docs/IpApi.md#ipactiondisassociate) | **Post** /ip/{ipId}/actions/disassociate | /actions/disassociate
*IpApi* | [**IpActionTransfer**](docs/IpApi.md#ipactiontransfer) | **Post** /ip/{ipId}/actions/transfer | /actions/transfer
*IpApi* | [**IpCreate**](docs/IpApi.md#ipcreate) | **Post** /ip | Create
*IpApi* | [**IpDelete**](docs/IpApi.md#ipdelete) | **Delete** /ip/{ipId} | Delete
*IpApi* | [**IpDeleteAccessrightsIdentity**](docs/IpApi.md#ipdeleteaccessrightsidentity) | **Delete** /ip/{ipId}/accessrights/{identity} | /accessrights/:identity
*IpApi* | [**IpDeleteTagKey**](docs/IpApi.md#ipdeletetagkey) | **Delete** /ip/{ipId}/tag/{key} | /tag/:key
*IpApi* | [**IpGetServicesServiceId**](docs/IpApi.md#ipgetservicesserviceid) | **Get** /ip/{ipId}/services/{serviceId} | /services/:serviceId
*IpApi* | [**IpGetTag**](docs/IpApi.md#ipgettag) | **Get** /ip/{ipId}/tag | /tag
*IpApi* | [**IpList**](docs/IpApi.md#iplist) | **Get** /ip | List
*IpApi* | [**IpListAccessrights**](docs/IpApi.md#iplistaccessrights) | **Get** /ip/{ipId}/accessrights | /accessrights
*IpApi* | [**IpListQueue**](docs/IpApi.md#iplistqueue) | **Get** /ip/{ipId}/queue | /queue
*IpApi* | [**IpListServices**](docs/IpApi.md#iplistservices) | **Get** /ip/{ipId}/services | /services
*IpApi* | [**IpPatchTag**](docs/IpApi.md#ippatchtag) | **Patch** /ip/{ipId}/tag | /tag
*IpApi* | [**IpPostAccessrights**](docs/IpApi.md#ippostaccessrights) | **Post** /ip/{ipId}/accessrights | /accessrights
*IpApi* | [**IpPutTag**](docs/IpApi.md#ipputtag) | **Put** /ip/{ipId}/tag | /tag
*IpApi* | [**IpShow**](docs/IpApi.md#ipshow) | **Get** /ip/{ipId} | Get
*IpApi* | [**IpUpdate**](docs/IpApi.md#ipupdate) | **Patch** /ip/{ipId} | Update
*IsoApi* | [**IsoActionTransfer**](docs/IsoApi.md#isoactiontransfer) | **Post** /iso/{isoId}/actions/transfer | /actions/transfer
*IsoApi* | [**IsoCreate**](docs/IsoApi.md#isocreate) | **Post** /iso | Create
*IsoApi* | [**IsoDelete**](docs/IsoApi.md#isodelete) | **Delete** /iso/{isoId} | Delete
*IsoApi* | [**IsoDeleteAccessrightsIdentity**](docs/IsoApi.md#isodeleteaccessrightsidentity) | **Delete** /iso/{isoId}/accessrights/{identity} | /accessrights/:identity
*IsoApi* | [**IsoDeleteTagKey**](docs/IsoApi.md#isodeletetagkey) | **Delete** /iso/{isoId}/tag/{key} | /tag/:key
*IsoApi* | [**IsoGetServicesServiceId**](docs/IsoApi.md#isogetservicesserviceid) | **Get** /iso/{isoId}/services/{serviceId} | /services/:serviceId
*IsoApi* | [**IsoGetTag**](docs/IsoApi.md#isogettag) | **Get** /iso/{isoId}/tag | /tag
*IsoApi* | [**IsoList**](docs/IsoApi.md#isolist) | **Get** /iso | List
*IsoApi* | [**IsoListAccessrights**](docs/IsoApi.md#isolistaccessrights) | **Get** /iso/{isoId}/accessrights | /accessrights
*IsoApi* | [**IsoListQueue**](docs/IsoApi.md#isolistqueue) | **Get** /iso/{isoId}/queue | /queue
*IsoApi* | [**IsoListServices**](docs/IsoApi.md#isolistservices) | **Get** /iso/{isoId}/services | /services
*IsoApi* | [**IsoPatchTag**](docs/IsoApi.md#isopatchtag) | **Patch** /iso/{isoId}/tag | /tag
*IsoApi* | [**IsoPostAccessrights**](docs/IsoApi.md#isopostaccessrights) | **Post** /iso/{isoId}/accessrights | /accessrights
*IsoApi* | [**IsoPutTag**](docs/IsoApi.md#isoputtag) | **Put** /iso/{isoId}/tag | /tag
*IsoApi* | [**IsoShow**](docs/IsoApi.md#isoshow) | **Get** /iso/{isoId} | Get
*IsoApi* | [**IsoUpdate**](docs/IsoApi.md#isoupdate) | **Patch** /iso/{isoId} | Update
*JournalApi* | [**JournalActionTransfer**](docs/JournalApi.md#journalactiontransfer) | **Post** /journal/{journalId}/actions/transfer | /actions/transfer
*JournalApi* | [**JournalActionUpdateRetention**](docs/JournalApi.md#journalactionupdateretention) | **Post** /journal/{journalId}/actions/update_retention | /actions/update_retention
*JournalApi* | [**JournalCreate**](docs/JournalApi.md#journalcreate) | **Post** /journal | Create
*JournalApi* | [**JournalDelete**](docs/JournalApi.md#journaldelete) | **Delete** /journal/{journalId} | Delete
*JournalApi* | [**JournalDeleteAccessrightsIdentity**](docs/JournalApi.md#journaldeleteaccessrightsidentity) | **Delete** /journal/{journalId}/accessrights/{identity} | /accessrights/:identity
*JournalApi* | [**JournalDeleteCredentialId**](docs/JournalApi.md#journaldeletecredentialid) | **Delete** /journal/{journalId}/credential/{id} | /credential/:id
*JournalApi* | [**JournalDeleteCredentialpasswordId**](docs/JournalApi.md#journaldeletecredentialpasswordid) | **Delete** /journal/{journalId}/credential/password/{id} | /credential/password/:id
*JournalApi* | [**JournalDeleteTagKey**](docs/JournalApi.md#journaldeletetagkey) | **Delete** /journal/{journalId}/tag/{key} | /tag/:key
*JournalApi* | [**JournalGetCredentialId**](docs/JournalApi.md#journalgetcredentialid) | **Get** /journal/{journalId}/credential/{id} | /credential/:id
*JournalApi* | [**JournalGetCredentialpasswordId**](docs/JournalApi.md#journalgetcredentialpasswordid) | **Get** /journal/{journalId}/credential/password/{id} | /credential/password/:id
*JournalApi* | [**JournalGetLog**](docs/JournalApi.md#journalgetlog) | **Get** /journal/{journalId}/log | /log
*JournalApi* | [**JournalGetServicesServiceId**](docs/JournalApi.md#journalgetservicesserviceid) | **Get** /journal/{journalId}/services/{serviceId} | /services/:serviceId
*JournalApi* | [**JournalGetTag**](docs/JournalApi.md#journalgettag) | **Get** /journal/{journalId}/tag | /tag
*JournalApi* | [**JournalList**](docs/JournalApi.md#journallist) | **Get** /journal | List
*JournalApi* | [**JournalListAccessrights**](docs/JournalApi.md#journallistaccessrights) | **Get** /journal/{journalId}/accessrights | /accessrights
*JournalApi* | [**JournalListCredential**](docs/JournalApi.md#journallistcredential) | **Get** /journal/{journalId}/credential | /credential
*JournalApi* | [**JournalListCredentialpassword**](docs/JournalApi.md#journallistcredentialpassword) | **Get** /journal/{journalId}/credential/password | /credential/password
*JournalApi* | [**JournalListQueue**](docs/JournalApi.md#journallistqueue) | **Get** /journal/{journalId}/queue | /queue
*JournalApi* | [**JournalListServices**](docs/JournalApi.md#journallistservices) | **Get** /journal/{journalId}/services | /services
*JournalApi* | [**JournalPatchCredentialId**](docs/JournalApi.md#journalpatchcredentialid) | **Patch** /journal/{journalId}/credential/{id} | /credential/:id
*JournalApi* | [**JournalPatchCredentialpasswordId**](docs/JournalApi.md#journalpatchcredentialpasswordid) | **Patch** /journal/{journalId}/credential/password/{id} | /credential/password/:id
*JournalApi* | [**JournalPatchTag**](docs/JournalApi.md#journalpatchtag) | **Patch** /journal/{journalId}/tag | /tag
*JournalApi* | [**JournalPostAccessrights**](docs/JournalApi.md#journalpostaccessrights) | **Post** /journal/{journalId}/accessrights | /accessrights
*JournalApi* | [**JournalPostCredential**](docs/JournalApi.md#journalpostcredential) | **Post** /journal/{journalId}/credential | /credential
*JournalApi* | [**JournalPostCredentialpassword**](docs/JournalApi.md#journalpostcredentialpassword) | **Post** /journal/{journalId}/credential/password | /credential/password
*JournalApi* | [**JournalPutTag**](docs/JournalApi.md#journalputtag) | **Put** /journal/{journalId}/tag | /tag
*JournalApi* | [**JournalShow**](docs/JournalApi.md#journalshow) | **Get** /journal/{journalId} | Get
*JournalApi* | [**JournalUpdate**](docs/JournalApi.md#journalupdate) | **Patch** /journal/{journalId} | Update
*NetadpApi* | [**NetadpActionFirewallAdd**](docs/NetadpApi.md#netadpactionfirewalladd) | **Post** /netadp/{netadpId}/actions/firewall_add | /actions/firewall_add
*NetadpApi* | [**NetadpActionFirewallRemove**](docs/NetadpApi.md#netadpactionfirewallremove) | **Post** /netadp/{netadpId}/actions/firewall_remove | /actions/firewall_remove
*NetadpApi* | [**NetadpDeleteAccessrightsIdentity**](docs/NetadpApi.md#netadpdeleteaccessrightsidentity) | **Delete** /netadp/{netadpId}/accessrights/{identity} | /accessrights/:identity
*NetadpApi* | [**NetadpDeleteTagKey**](docs/NetadpApi.md#netadpdeletetagkey) | **Delete** /netadp/{netadpId}/tag/{key} | /tag/:key
*NetadpApi* | [**NetadpGetServicesServiceId**](docs/NetadpApi.md#netadpgetservicesserviceid) | **Get** /netadp/{netadpId}/services/{serviceId} | /services/:serviceId
*NetadpApi* | [**NetadpGetTag**](docs/NetadpApi.md#netadpgettag) | **Get** /netadp/{netadpId}/tag | /tag
*NetadpApi* | [**NetadpList**](docs/NetadpApi.md#netadplist) | **Get** /netadp | List
*NetadpApi* | [**NetadpListAccessrights**](docs/NetadpApi.md#netadplistaccessrights) | **Get** /netadp/{netadpId}/accessrights | /accessrights
*NetadpApi* | [**NetadpListQueue**](docs/NetadpApi.md#netadplistqueue) | **Get** /netadp/{netadpId}/queue | /queue
*NetadpApi* | [**NetadpListServices**](docs/NetadpApi.md#netadplistservices) | **Get** /netadp/{netadpId}/services | /services
*NetadpApi* | [**NetadpPatchTag**](docs/NetadpApi.md#netadppatchtag) | **Patch** /netadp/{netadpId}/tag | /tag
*NetadpApi* | [**NetadpPostAccessrights**](docs/NetadpApi.md#netadppostaccessrights) | **Post** /netadp/{netadpId}/accessrights | /accessrights
*NetadpApi* | [**NetadpPutTag**](docs/NetadpApi.md#netadpputtag) | **Put** /netadp/{netadpId}/tag | /tag
*NetadpApi* | [**NetadpShow**](docs/NetadpApi.md#netadpshow) | **Get** /netadp/{netadpId} | Get
*NetgwApi* | [**NetgwActionAttach**](docs/NetgwApi.md#netgwactionattach) | **Post** /netgw/{netgwId}/actions/attach | /actions/attach
*NetgwApi* | [**NetgwActionDetach**](docs/NetgwApi.md#netgwactiondetach) | **Post** /netgw/{netgwId}/actions/detach | /actions/detach
*NetgwApi* | [**NetgwCreate**](docs/NetgwApi.md#netgwcreate) | **Post** /netgw | Create
*NetgwApi* | [**NetgwDelete**](docs/NetgwApi.md#netgwdelete) | **Delete** /netgw/{netgwId} | Delete
*NetgwApi* | [**NetgwDeleteAccessrightsIdentity**](docs/NetgwApi.md#netgwdeleteaccessrightsidentity) | **Delete** /netgw/{netgwId}/accessrights/{identity} | /accessrights/:identity
*NetgwApi* | [**NetgwDeleteTagKey**](docs/NetgwApi.md#netgwdeletetagkey) | **Delete** /netgw/{netgwId}/tag/{key} | /tag/:key
*NetgwApi* | [**NetgwGetServicesServiceId**](docs/NetgwApi.md#netgwgetservicesserviceid) | **Get** /netgw/{netgwId}/services/{serviceId} | /services/:serviceId
*NetgwApi* | [**NetgwGetTag**](docs/NetgwApi.md#netgwgettag) | **Get** /netgw/{netgwId}/tag | /tag
*NetgwApi* | [**NetgwList**](docs/NetgwApi.md#netgwlist) | **Get** /netgw | List
*NetgwApi* | [**NetgwListAccessrights**](docs/NetgwApi.md#netgwlistaccessrights) | **Get** /netgw/{netgwId}/accessrights | /accessrights
*NetgwApi* | [**NetgwListQueue**](docs/NetgwApi.md#netgwlistqueue) | **Get** /netgw/{netgwId}/queue | /queue
*NetgwApi* | [**NetgwListServices**](docs/NetgwApi.md#netgwlistservices) | **Get** /netgw/{netgwId}/services | /services
*NetgwApi* | [**NetgwPatchTag**](docs/NetgwApi.md#netgwpatchtag) | **Patch** /netgw/{netgwId}/tag | /tag
*NetgwApi* | [**NetgwPostAccessrights**](docs/NetgwApi.md#netgwpostaccessrights) | **Post** /netgw/{netgwId}/accessrights | /accessrights
*NetgwApi* | [**NetgwPutTag**](docs/NetgwApi.md#netgwputtag) | **Put** /netgw/{netgwId}/tag | /tag
*NetgwApi* | [**NetgwShow**](docs/NetgwApi.md#netgwshow) | **Get** /netgw/{netgwId} | Get
*NetgwApi* | [**NetgwUpdate**](docs/NetgwApi.md#netgwupdate) | **Patch** /netgw/{netgwId} | Update
*NetworkApi* | [**NetworkActionFirewallAdd**](docs/NetworkApi.md#networkactionfirewalladd) | **Post** /network/{networkId}/actions/firewall_add | /actions/firewall_add
*NetworkApi* | [**NetworkActionFirewallRemove**](docs/NetworkApi.md#networkactionfirewallremove) | **Post** /network/{networkId}/actions/firewall_remove | /actions/firewall_remove
*NetworkApi* | [**NetworkCreate**](docs/NetworkApi.md#networkcreate) | **Post** /network | Create
*NetworkApi* | [**NetworkDelete**](docs/NetworkApi.md#networkdelete) | **Delete** /network/{networkId} | Delete
*NetworkApi* | [**NetworkDeleteAccessrightsIdentity**](docs/NetworkApi.md#networkdeleteaccessrightsidentity) | **Delete** /network/{networkId}/accessrights/{identity} | /accessrights/:identity
*NetworkApi* | [**NetworkDeleteIpIpId**](docs/NetworkApi.md#networkdeleteipipid) | **Delete** /network/{networkId}/ip/{ipId} | /ip/:ipId
*NetworkApi* | [**NetworkDeleteTagKey**](docs/NetworkApi.md#networkdeletetagkey) | **Delete** /network/{networkId}/tag/{key} | /tag/:key
*NetworkApi* | [**NetworkGetIpIpId**](docs/NetworkApi.md#networkgetipipid) | **Get** /network/{networkId}/ip/{ipId} | /ip/:ipId
*NetworkApi* | [**NetworkGetServicesServiceId**](docs/NetworkApi.md#networkgetservicesserviceid) | **Get** /network/{networkId}/services/{serviceId} | /services/:serviceId
*NetworkApi* | [**NetworkGetTag**](docs/NetworkApi.md#networkgettag) | **Get** /network/{networkId}/tag | /tag
*NetworkApi* | [**NetworkList**](docs/NetworkApi.md#networklist) | **Get** /network | List
*NetworkApi* | [**NetworkListAccessrights**](docs/NetworkApi.md#networklistaccessrights) | **Get** /network/{networkId}/accessrights | /accessrights
*NetworkApi* | [**NetworkListIp**](docs/NetworkApi.md#networklistip) | **Get** /network/{networkId}/ip | /ip
*NetworkApi* | [**NetworkListQueue**](docs/NetworkApi.md#networklistqueue) | **Get** /network/{networkId}/queue | /queue
*NetworkApi* | [**NetworkListServices**](docs/NetworkApi.md#networklistservices) | **Get** /network/{networkId}/services | /services
*NetworkApi* | [**NetworkPatchTag**](docs/NetworkApi.md#networkpatchtag) | **Patch** /network/{networkId}/tag | /tag
*NetworkApi* | [**NetworkPostAccessrights**](docs/NetworkApi.md#networkpostaccessrights) | **Post** /network/{networkId}/accessrights | /accessrights
*NetworkApi* | [**NetworkPostIp**](docs/NetworkApi.md#networkpostip) | **Post** /network/{networkId}/ip | /ip
*NetworkApi* | [**NetworkPutTag**](docs/NetworkApi.md#networkputtag) | **Put** /network/{networkId}/tag | /tag
*NetworkApi* | [**NetworkShow**](docs/NetworkApi.md#networkshow) | **Get** /network/{networkId} | Get
*NetworkApi* | [**NetworkUpdate**](docs/NetworkApi.md#networkupdate) | **Patch** /network/{networkId} | Update
*OrganisationApi* | [**OrganisationActionPaymentAssign**](docs/OrganisationApi.md#organisationactionpaymentassign) | **Post** /organisation/{organisationId}/actions/payment_assign | /actions/payment_assign
*OrganisationApi* | [**OrganisationActionTransferAccept**](docs/OrganisationApi.md#organisationactiontransferaccept) | **Post** /organisation/{organisationId}/actions/transfer_accept | /actions/transfer_accept
*OrganisationApi* | [**OrganisationCreate**](docs/OrganisationApi.md#organisationcreate) | **Post** /organisation | Create
*OrganisationApi* | [**OrganisationDeleteAccessrightsId**](docs/OrganisationApi.md#organisationdeleteaccessrightsid) | **Delete** /organisation/{organisationId}/accessrights/{id} | /accessrights/:id
*OrganisationApi* | [**OrganisationDeleteTagKey**](docs/OrganisationApi.md#organisationdeletetagkey) | **Delete** /organisation/{organisationId}/tag/{key} | /tag/:key
*OrganisationApi* | [**OrganisationGetTag**](docs/OrganisationApi.md#organisationgettag) | **Get** /organisation/{organisationId}/tag | /tag
*OrganisationApi* | [**OrganisationList**](docs/OrganisationApi.md#organisationlist) | **Get** /organisation | List
*OrganisationApi* | [**OrganisationListAccessrights**](docs/OrganisationApi.md#organisationlistaccessrights) | **Get** /organisation/{organisationId}/accessrights | /accessrights
*OrganisationApi* | [**OrganisationListBilling**](docs/OrganisationApi.md#organisationlistbilling) | **Get** /organisation/{organisationId}/billing | /billing
*OrganisationApi* | [**OrganisationListQueue**](docs/OrganisationApi.md#organisationlistqueue) | **Get** /organisation/{organisationId}/queue | /queue
*OrganisationApi* | [**OrganisationPatchTag**](docs/OrganisationApi.md#organisationpatchtag) | **Patch** /organisation/{organisationId}/tag | /tag
*OrganisationApi* | [**OrganisationPostAccessrights**](docs/OrganisationApi.md#organisationpostaccessrights) | **Post** /organisation/{organisationId}/accessrights | /accessrights
*OrganisationApi* | [**OrganisationPutTag**](docs/OrganisationApi.md#organisationputtag) | **Put** /organisation/{organisationId}/tag | /tag
*OrganisationApi* | [**OrganisationShow**](docs/OrganisationApi.md#organisationshow) | **Get** /organisation/{organisationId} | Get
*OrganisationApi* | [**OrganisationUpdate**](docs/OrganisationApi.md#organisationupdate) | **Patch** /organisation/{organisationId} | Update
*ProjectApi* | [**ProjectCreate**](docs/ProjectApi.md#projectcreate) | **Post** /project | Create
*ProjectApi* | [**ProjectDelete**](docs/ProjectApi.md#projectdelete) | **Delete** /project/{projectId} | Delete
*ProjectApi* | [**ProjectDeleteAccessrightsId**](docs/ProjectApi.md#projectdeleteaccessrightsid) | **Delete** /project/{projectId}/accessrights/{id} | /accessrights/:id
*ProjectApi* | [**ProjectDeleteCredentialStoreId**](docs/ProjectApi.md#projectdeletecredentialstoreid) | **Delete** /project/{projectId}/credentialStore/{id} | /credentialStore/:id
*ProjectApi* | [**ProjectDeleteCredentialStorecertificateId**](docs/ProjectApi.md#projectdeletecredentialstorecertificateid) | **Delete** /project/{projectId}/credentialStore/certificate/{id} | /credentialStore/certificate/:id
*ProjectApi* | [**ProjectDeleteTagKey**](docs/ProjectApi.md#projectdeletetagkey) | **Delete** /project/{projectId}/tag/{key} | /tag/:key
*ProjectApi* | [**ProjectGetCredentialStoreId**](docs/ProjectApi.md#projectgetcredentialstoreid) | **Get** /project/{projectId}/credentialStore/{id} | /credentialStore/:id
*ProjectApi* | [**ProjectGetCredentialStorecertificateId**](docs/ProjectApi.md#projectgetcredentialstorecertificateid) | **Get** /project/{projectId}/credentialStore/certificate/{id} | /credentialStore/certificate/:id
*ProjectApi* | [**ProjectGetLimit**](docs/ProjectApi.md#projectgetlimit) | **Get** /project/{projectId}/limit | /limit
*ProjectApi* | [**ProjectGetServicesServiceId**](docs/ProjectApi.md#projectgetservicesserviceid) | **Get** /project/{projectId}/services/{serviceId} | /services/:serviceId
*ProjectApi* | [**ProjectGetTag**](docs/ProjectApi.md#projectgettag) | **Get** /project/{projectId}/tag | /tag
*ProjectApi* | [**ProjectList**](docs/ProjectApi.md#projectlist) | **Get** /project | List
*ProjectApi* | [**ProjectListAccessrights**](docs/ProjectApi.md#projectlistaccessrights) | **Get** /project/{projectId}/accessrights | /accessrights
*ProjectApi* | [**ProjectListBilling**](docs/ProjectApi.md#projectlistbilling) | **Get** /project/{projectId}/billing | /billing
*ProjectApi* | [**ProjectListCredentialStore**](docs/ProjectApi.md#projectlistcredentialstore) | **Get** /project/{projectId}/credentialStore | /credentialStore
*ProjectApi* | [**ProjectListCredentialStorecertificate**](docs/ProjectApi.md#projectlistcredentialstorecertificate) | **Get** /project/{projectId}/credentialStore/certificate | /credentialStore/certificate
*ProjectApi* | [**ProjectListQueue**](docs/ProjectApi.md#projectlistqueue) | **Get** /project/{projectId}/queue | /queue
*ProjectApi* | [**ProjectListServices**](docs/ProjectApi.md#projectlistservices) | **Get** /project/{projectId}/services | /services
*ProjectApi* | [**ProjectListStats**](docs/ProjectApi.md#projectliststats) | **Get** /project/{projectId}/stats | /stats
*ProjectApi* | [**ProjectPatchCredentialStoreId**](docs/ProjectApi.md#projectpatchcredentialstoreid) | **Patch** /project/{projectId}/credentialStore/{id} | /credentialStore/:id
*ProjectApi* | [**ProjectPatchCredentialStorecertificateId**](docs/ProjectApi.md#projectpatchcredentialstorecertificateid) | **Patch** /project/{projectId}/credentialStore/certificate/{id} | /credentialStore/certificate/:id
*ProjectApi* | [**ProjectPatchTag**](docs/ProjectApi.md#projectpatchtag) | **Patch** /project/{projectId}/tag | /tag
*ProjectApi* | [**ProjectPostAccessrights**](docs/ProjectApi.md#projectpostaccessrights) | **Post** /project/{projectId}/accessrights | /accessrights
*ProjectApi* | [**ProjectPostCredentialStore**](docs/ProjectApi.md#projectpostcredentialstore) | **Post** /project/{projectId}/credentialStore | /credentialStore
*ProjectApi* | [**ProjectPostCredentialStorecertificate**](docs/ProjectApi.md#projectpostcredentialstorecertificate) | **Post** /project/{projectId}/credentialStore/certificate | /credentialStore/certificate
*ProjectApi* | [**ProjectPutTag**](docs/ProjectApi.md#projectputtag) | **Put** /project/{projectId}/tag | /tag
*ProjectApi* | [**ProjectShow**](docs/ProjectApi.md#projectshow) | **Get** /project/{projectId} | Get
*ProjectApi* | [**ProjectUpdate**](docs/ProjectApi.md#projectupdate) | **Patch** /project/{projectId} | Update
*RegistryApi* | [**RegistryActionStart**](docs/RegistryApi.md#registryactionstart) | **Post** /registry/{registryId}/actions/start | /actions/start
*RegistryApi* | [**RegistryActionStop**](docs/RegistryApi.md#registryactionstop) | **Post** /registry/{registryId}/actions/stop | /actions/stop
*RegistryApi* | [**RegistryActionTransfer**](docs/RegistryApi.md#registryactiontransfer) | **Post** /registry/{registryId}/actions/transfer | /actions/transfer
*RegistryApi* | [**RegistryActionUpdateDomain**](docs/RegistryApi.md#registryactionupdatedomain) | **Post** /registry/{registryId}/actions/update_domain | /actions/update_domain
*RegistryApi* | [**RegistryCreate**](docs/RegistryApi.md#registrycreate) | **Post** /registry | Create
*RegistryApi* | [**RegistryDelete**](docs/RegistryApi.md#registrydelete) | **Delete** /registry/{registryId} | Delete
*RegistryApi* | [**RegistryDeleteAccessrightsIdentity**](docs/RegistryApi.md#registrydeleteaccessrightsidentity) | **Delete** /registry/{registryId}/accessrights/{identity} | /accessrights/:identity
*RegistryApi* | [**RegistryDeleteCredentialId**](docs/RegistryApi.md#registrydeletecredentialid) | **Delete** /registry/{registryId}/credential/{id} | /credential/:id
*RegistryApi* | [**RegistryDeleteCredentialpasswordId**](docs/RegistryApi.md#registrydeletecredentialpasswordid) | **Delete** /registry/{registryId}/credential/password/{id} | /credential/password/:id
*RegistryApi* | [**RegistryDeleteRepositoryRepositoryIdtagTagId**](docs/RegistryApi.md#registrydeleterepositoryrepositoryidtagtagid) | **Delete** /registry/{registryId}/repository/{repositoryId}/tag/{tagId} | /repository/:repositoryId/tag/:tagId
*RegistryApi* | [**RegistryDeleteTagKey**](docs/RegistryApi.md#registrydeletetagkey) | **Delete** /registry/{registryId}/tag/{key} | /tag/:key
*RegistryApi* | [**RegistryGetCredentialId**](docs/RegistryApi.md#registrygetcredentialid) | **Get** /registry/{registryId}/credential/{id} | /credential/:id
*RegistryApi* | [**RegistryGetCredentialpasswordId**](docs/RegistryApi.md#registrygetcredentialpasswordid) | **Get** /registry/{registryId}/credential/password/{id} | /credential/password/:id
*RegistryApi* | [**RegistryGetRepositoryRepositoryId**](docs/RegistryApi.md#registrygetrepositoryrepositoryid) | **Get** /registry/{registryId}/repository/{repositoryId} | /repository/:repositoryId
*RegistryApi* | [**RegistryGetRepositoryRepositoryIdtagTagId**](docs/RegistryApi.md#registrygetrepositoryrepositoryidtagtagid) | **Get** /registry/{registryId}/repository/{repositoryId}/tag/{tagId} | /repository/:repositoryId/tag/:tagId
*RegistryApi* | [**RegistryGetServicesServiceId**](docs/RegistryApi.md#registrygetservicesserviceid) | **Get** /registry/{registryId}/services/{serviceId} | /services/:serviceId
*RegistryApi* | [**RegistryGetTag**](docs/RegistryApi.md#registrygettag) | **Get** /registry/{registryId}/tag | /tag
*RegistryApi* | [**RegistryList**](docs/RegistryApi.md#registrylist) | **Get** /registry | List
*RegistryApi* | [**RegistryListAccessrights**](docs/RegistryApi.md#registrylistaccessrights) | **Get** /registry/{registryId}/accessrights | /accessrights
*RegistryApi* | [**RegistryListCredential**](docs/RegistryApi.md#registrylistcredential) | **Get** /registry/{registryId}/credential | /credential
*RegistryApi* | [**RegistryListCredentialpassword**](docs/RegistryApi.md#registrylistcredentialpassword) | **Get** /registry/{registryId}/credential/password | /credential/password
*RegistryApi* | [**RegistryListQueue**](docs/RegistryApi.md#registrylistqueue) | **Get** /registry/{registryId}/queue | /queue
*RegistryApi* | [**RegistryListRepository**](docs/RegistryApi.md#registrylistrepository) | **Get** /registry/{registryId}/repository | /repository
*RegistryApi* | [**RegistryListRepositoryRepositoryIdtag**](docs/RegistryApi.md#registrylistrepositoryrepositoryidtag) | **Get** /registry/{registryId}/repository/{repositoryId}/tag | /repository/:repositoryId/tag
*RegistryApi* | [**RegistryListServices**](docs/RegistryApi.md#registrylistservices) | **Get** /registry/{registryId}/services | /services
*RegistryApi* | [**RegistryPatchCredentialId**](docs/RegistryApi.md#registrypatchcredentialid) | **Patch** /registry/{registryId}/credential/{id} | /credential/:id
*RegistryApi* | [**RegistryPatchCredentialpasswordId**](docs/RegistryApi.md#registrypatchcredentialpasswordid) | **Patch** /registry/{registryId}/credential/password/{id} | /credential/password/:id
*RegistryApi* | [**RegistryPatchTag**](docs/RegistryApi.md#registrypatchtag) | **Patch** /registry/{registryId}/tag | /tag
*RegistryApi* | [**RegistryPostAccessrights**](docs/RegistryApi.md#registrypostaccessrights) | **Post** /registry/{registryId}/accessrights | /accessrights
*RegistryApi* | [**RegistryPostCredential**](docs/RegistryApi.md#registrypostcredential) | **Post** /registry/{registryId}/credential | /credential
*RegistryApi* | [**RegistryPostCredentialpassword**](docs/RegistryApi.md#registrypostcredentialpassword) | **Post** /registry/{registryId}/credential/password | /credential/password
*RegistryApi* | [**RegistryPutTag**](docs/RegistryApi.md#registryputtag) | **Put** /registry/{registryId}/tag | /tag
*RegistryApi* | [**RegistryShow**](docs/RegistryApi.md#registryshow) | **Get** /registry/{registryId} | Get
*RegistryApi* | [**RegistryUpdate**](docs/RegistryApi.md#registryupdate) | **Patch** /registry/{registryId} | Update
*ReplicaApi* | [**ReplicaActionImage**](docs/ReplicaApi.md#replicaactionimage) | **Post** /replica/{replicaId}/actions/image | /actions/image
*ReplicaApi* | [**ReplicaCreate**](docs/ReplicaApi.md#replicacreate) | **Post** /replica | Create
*ReplicaApi* | [**ReplicaDelete**](docs/ReplicaApi.md#replicadelete) | **Delete** /replica/{replicaId} | Delete
*ReplicaApi* | [**ReplicaDeleteAccessrightsIdentity**](docs/ReplicaApi.md#replicadeleteaccessrightsidentity) | **Delete** /replica/{replicaId}/accessrights/{identity} | /accessrights/:identity
*ReplicaApi* | [**ReplicaDeleteTagKey**](docs/ReplicaApi.md#replicadeletetagkey) | **Delete** /replica/{replicaId}/tag/{key} | /tag/:key
*ReplicaApi* | [**ReplicaGetServicesServiceId**](docs/ReplicaApi.md#replicagetservicesserviceid) | **Get** /replica/{replicaId}/services/{serviceId} | /services/:serviceId
*ReplicaApi* | [**ReplicaGetTag**](docs/ReplicaApi.md#replicagettag) | **Get** /replica/{replicaId}/tag | /tag
*ReplicaApi* | [**ReplicaList**](docs/ReplicaApi.md#replicalist) | **Get** /replica | List
*ReplicaApi* | [**ReplicaListAccessrights**](docs/ReplicaApi.md#replicalistaccessrights) | **Get** /replica/{replicaId}/accessrights | /accessrights
*ReplicaApi* | [**ReplicaListQueue**](docs/ReplicaApi.md#replicalistqueue) | **Get** /replica/{replicaId}/queue | /queue
*ReplicaApi* | [**ReplicaListServices**](docs/ReplicaApi.md#replicalistservices) | **Get** /replica/{replicaId}/services | /services
*ReplicaApi* | [**ReplicaPatchTag**](docs/ReplicaApi.md#replicapatchtag) | **Patch** /replica/{replicaId}/tag | /tag
*ReplicaApi* | [**ReplicaPostAccessrights**](docs/ReplicaApi.md#replicapostaccessrights) | **Post** /replica/{replicaId}/accessrights | /accessrights
*ReplicaApi* | [**ReplicaPutTag**](docs/ReplicaApi.md#replicaputtag) | **Put** /replica/{replicaId}/tag | /tag
*ReplicaApi* | [**ReplicaShow**](docs/ReplicaApi.md#replicashow) | **Get** /replica/{replicaId} | Get
*ReservationApi* | [**ReservationActionAssign**](docs/ReservationApi.md#reservationactionassign) | **Post** /reservation/{reservationId}/actions/assign | /actions/assign
*ReservationApi* | [**ReservationActionExtend**](docs/ReservationApi.md#reservationactionextend) | **Post** /reservation/{reservationId}/actions/extend | /actions/extend
*ReservationApi* | [**ReservationCreate**](docs/ReservationApi.md#reservationcreate) | **Post** /reservation | Create
*ReservationApi* | [**ReservationDelete**](docs/ReservationApi.md#reservationdelete) | **Delete** /reservation/{reservationId} | Delete
*ReservationApi* | [**ReservationDeleteAccessrightsIdentity**](docs/ReservationApi.md#reservationdeleteaccessrightsidentity) | **Delete** /reservation/{reservationId}/accessrights/{identity} | /accessrights/:identity
*ReservationApi* | [**ReservationDeleteTagKey**](docs/ReservationApi.md#reservationdeletetagkey) | **Delete** /reservation/{reservationId}/tag/{key} | /tag/:key
*ReservationApi* | [**ReservationGetServicesServiceId**](docs/ReservationApi.md#reservationgetservicesserviceid) | **Get** /reservation/{reservationId}/services/{serviceId} | /services/:serviceId
*ReservationApi* | [**ReservationGetTag**](docs/ReservationApi.md#reservationgettag) | **Get** /reservation/{reservationId}/tag | /tag
*ReservationApi* | [**ReservationList**](docs/ReservationApi.md#reservationlist) | **Get** /reservation | List
*ReservationApi* | [**ReservationListAccessrights**](docs/ReservationApi.md#reservationlistaccessrights) | **Get** /reservation/{reservationId}/accessrights | /accessrights
*ReservationApi* | [**ReservationListQueue**](docs/ReservationApi.md#reservationlistqueue) | **Get** /reservation/{reservationId}/queue | /queue
*ReservationApi* | [**ReservationListServices**](docs/ReservationApi.md#reservationlistservices) | **Get** /reservation/{reservationId}/services | /services
*ReservationApi* | [**ReservationPatchTag**](docs/ReservationApi.md#reservationpatchtag) | **Patch** /reservation/{reservationId}/tag | /tag
*ReservationApi* | [**ReservationPostAccessrights**](docs/ReservationApi.md#reservationpostaccessrights) | **Post** /reservation/{reservationId}/accessrights | /accessrights
*ReservationApi* | [**ReservationPutTag**](docs/ReservationApi.md#reservationputtag) | **Put** /reservation/{reservationId}/tag | /tag
*ReservationApi* | [**ReservationShow**](docs/ReservationApi.md#reservationshow) | **Get** /reservation/{reservationId} | Get
*ReservationApi* | [**ReservationUpdate**](docs/ReservationApi.md#reservationupdate) | **Patch** /reservation/{reservationId} | Update
*ServiceApi* | [**ServiceList**](docs/ServiceApi.md#servicelist) | **Get** /service | List
*ServiceApi* | [**ServiceShow**](docs/ServiceApi.md#serviceshow) | **Get** /service/{serviceId} | Get
*SnapshotApi* | [**SnapshotCreate**](docs/SnapshotApi.md#snapshotcreate) | **Post** /snapshot | Create
*SnapshotApi* | [**SnapshotDelete**](docs/SnapshotApi.md#snapshotdelete) | **Delete** /snapshot/{snapshotId} | Delete
*SnapshotApi* | [**SnapshotDeleteAccessrightsIdentity**](docs/SnapshotApi.md#snapshotdeleteaccessrightsidentity) | **Delete** /snapshot/{snapshotId}/accessrights/{identity} | /accessrights/:identity
*SnapshotApi* | [**SnapshotDeleteTagKey**](docs/SnapshotApi.md#snapshotdeletetagkey) | **Delete** /snapshot/{snapshotId}/tag/{key} | /tag/:key
*SnapshotApi* | [**SnapshotGetServicesServiceId**](docs/SnapshotApi.md#snapshotgetservicesserviceid) | **Get** /snapshot/{snapshotId}/services/{serviceId} | /services/:serviceId
*SnapshotApi* | [**SnapshotGetTag**](docs/SnapshotApi.md#snapshotgettag) | **Get** /snapshot/{snapshotId}/tag | /tag
*SnapshotApi* | [**SnapshotList**](docs/SnapshotApi.md#snapshotlist) | **Get** /snapshot | List
*SnapshotApi* | [**SnapshotListAccessrights**](docs/SnapshotApi.md#snapshotlistaccessrights) | **Get** /snapshot/{snapshotId}/accessrights | /accessrights
*SnapshotApi* | [**SnapshotListQueue**](docs/SnapshotApi.md#snapshotlistqueue) | **Get** /snapshot/{snapshotId}/queue | /queue
*SnapshotApi* | [**SnapshotListServices**](docs/SnapshotApi.md#snapshotlistservices) | **Get** /snapshot/{snapshotId}/services | /services
*SnapshotApi* | [**SnapshotPatchTag**](docs/SnapshotApi.md#snapshotpatchtag) | **Patch** /snapshot/{snapshotId}/tag | /tag
*SnapshotApi* | [**SnapshotPostAccessrights**](docs/SnapshotApi.md#snapshotpostaccessrights) | **Post** /snapshot/{snapshotId}/accessrights | /accessrights
*SnapshotApi* | [**SnapshotPutTag**](docs/SnapshotApi.md#snapshotputtag) | **Put** /snapshot/{snapshotId}/tag | /tag
*SnapshotApi* | [**SnapshotShow**](docs/SnapshotApi.md#snapshotshow) | **Get** /snapshot/{snapshotId} | Get
*SnapshotApi* | [**SnapshotUpdate**](docs/SnapshotApi.md#snapshotupdate) | **Patch** /snapshot/{snapshotId} | Update
*UserApi* | [**UserDeleteCredentialId**](docs/UserApi.md#userdeletecredentialid) | **Delete** /user/{userId}/credential/{id} | /credential/:id
*UserApi* | [**UserDeleteCredentialauthtokenId**](docs/UserApi.md#userdeletecredentialauthtokenid) | **Delete** /user/{userId}/credential/authtoken/:id | /credential/authtoken/:id
*UserApi* | [**UserDeleteCredentialcertificateId**](docs/UserApi.md#userdeletecredentialcertificateid) | **Delete** /user/{userId}/credential/certificate/{id} | /credential/certificate/:id
*UserApi* | [**UserDeleteCredentialpasswordId**](docs/UserApi.md#userdeletecredentialpasswordid) | **Delete** /user/{userId}/credential/password/{id} | /credential/password/:id
*UserApi* | [**UserDeleteTagKey**](docs/UserApi.md#userdeletetagkey) | **Delete** /user/{userId}/tag/{key} | /tag/:key
*UserApi* | [**UserGetCredentialId**](docs/UserApi.md#usergetcredentialid) | **Get** /user/{userId}/credential/{id} | /credential/:id
*UserApi* | [**UserGetCredentialauthtokenId**](docs/UserApi.md#usergetcredentialauthtokenid) | **Get** /user/{userId}/credential/authtoken/:id | /credential/authtoken/:id
*UserApi* | [**UserGetCredentialcertificateId**](docs/UserApi.md#usergetcredentialcertificateid) | **Get** /user/{userId}/credential/certificate/{id} | /credential/certificate/:id
*UserApi* | [**UserGetCredentialpasswordId**](docs/UserApi.md#usergetcredentialpasswordid) | **Get** /user/{userId}/credential/password/{id} | /credential/password/:id
*UserApi* | [**UserGetServicesServiceId**](docs/UserApi.md#usergetservicesserviceid) | **Get** /user/{userId}/services/{serviceId} | /services/:serviceId
*UserApi* | [**UserGetTag**](docs/UserApi.md#usergettag) | **Get** /user/{userId}/tag | /tag
*UserApi* | [**UserListCredential**](docs/UserApi.md#userlistcredential) | **Get** /user/{userId}/credential | /credential
*UserApi* | [**UserListCredentialauthtoken**](docs/UserApi.md#userlistcredentialauthtoken) | **Get** /user/{userId}/credential/authtoken | /credential/authtoken
*UserApi* | [**UserListCredentialcertificate**](docs/UserApi.md#userlistcredentialcertificate) | **Get** /user/{userId}/credential/certificate | /credential/certificate
*UserApi* | [**UserListCredentialpassword**](docs/UserApi.md#userlistcredentialpassword) | **Get** /user/{userId}/credential/password | /credential/password
*UserApi* | [**UserListInvitation**](docs/UserApi.md#userlistinvitation) | **Get** /user/{userId}/invitation | /invitation
*UserApi* | [**UserListServices**](docs/UserApi.md#userlistservices) | **Get** /user/{userId}/services | /services
*UserApi* | [**UserPatchCredentialId**](docs/UserApi.md#userpatchcredentialid) | **Patch** /user/{userId}/credential/{id} | /credential/:id
*UserApi* | [**UserPatchCredentialcertificateId**](docs/UserApi.md#userpatchcredentialcertificateid) | **Patch** /user/{userId}/credential/certificate/{id} | /credential/certificate/:id
*UserApi* | [**UserPatchCredentialpasswordId**](docs/UserApi.md#userpatchcredentialpasswordid) | **Patch** /user/{userId}/credential/password/{id} | /credential/password/:id
*UserApi* | [**UserPatchTag**](docs/UserApi.md#userpatchtag) | **Patch** /user/{userId}/tag | /tag
*UserApi* | [**UserPostCredential**](docs/UserApi.md#userpostcredential) | **Post** /user/{userId}/credential | /credential
*UserApi* | [**UserPostCredentialcertificate**](docs/UserApi.md#userpostcredentialcertificate) | **Post** /user/{userId}/credential/certificate | /credential/certificate
*UserApi* | [**UserPostCredentialpassword**](docs/UserApi.md#userpostcredentialpassword) | **Post** /user/{userId}/credential/password | /credential/password
*UserApi* | [**UserPostInvitationInvitationIdaccept**](docs/UserApi.md#userpostinvitationinvitationidaccept) | **Post** /user/{userId}/invitation/{invitationId}/accept | /invitation/:invitationId/accept
*UserApi* | [**UserPostInvitationInvitationIddecline**](docs/UserApi.md#userpostinvitationinvitationiddecline) | **Post** /user/{userId}/invitation/{invitationId}/decline | /invitation/:invitationId/decline
*UserApi* | [**UserPutTag**](docs/UserApi.md#userputtag) | **Put** /user/{userId}/tag | /tag
*UserApi* | [**UserShow**](docs/UserApi.md#usershow) | **Get** /user/{userId} | Get
*UserApi* | [**UserUpdate**](docs/UserApi.md#userupdate) | **Patch** /user/{userId} | Update
*VaultApi* | [**VaultActionResize**](docs/VaultApi.md#vaultactionresize) | **Post** /vault/{vaultId}/actions/resize | /actions/resize
*VaultApi* | [**VaultActionSnapshot**](docs/VaultApi.md#vaultactionsnapshot) | **Post** /vault/{vaultId}/actions/snapshot | /actions/snapshot
*VaultApi* | [**VaultActionStart**](docs/VaultApi.md#vaultactionstart) | **Post** /vault/{vaultId}/actions/start | /actions/start
*VaultApi* | [**VaultActionStop**](docs/VaultApi.md#vaultactionstop) | **Post** /vault/{vaultId}/actions/stop | /actions/stop
*VaultApi* | [**VaultCreate**](docs/VaultApi.md#vaultcreate) | **Post** /vault | Create
*VaultApi* | [**VaultDelete**](docs/VaultApi.md#vaultdelete) | **Delete** /vault/{vaultId} | Delete
*VaultApi* | [**VaultDeleteAccessrightsIdentity**](docs/VaultApi.md#vaultdeleteaccessrightsidentity) | **Delete** /vault/{vaultId}/accessrights/{identity} | /accessrights/:identity
*VaultApi* | [**VaultDeleteCredentialId**](docs/VaultApi.md#vaultdeletecredentialid) | **Delete** /vault/{vaultId}/credential/{id} | /credential/:id
*VaultApi* | [**VaultDeleteCredentialcertificateId**](docs/VaultApi.md#vaultdeletecredentialcertificateid) | **Delete** /vault/{vaultId}/credential/certificate/{id} | /credential/certificate/:id
*VaultApi* | [**VaultDeleteCredentialpasswordId**](docs/VaultApi.md#vaultdeletecredentialpasswordid) | **Delete** /vault/{vaultId}/credential/password/{id} | /credential/password/:id
*VaultApi* | [**VaultDeleteTagKey**](docs/VaultApi.md#vaultdeletetagkey) | **Delete** /vault/{vaultId}/tag/{key} | /tag/:key
*VaultApi* | [**VaultGetCredentialId**](docs/VaultApi.md#vaultgetcredentialid) | **Get** /vault/{vaultId}/credential/{id} | /credential/:id
*VaultApi* | [**VaultGetCredentialcertificateId**](docs/VaultApi.md#vaultgetcredentialcertificateid) | **Get** /vault/{vaultId}/credential/certificate/{id} | /credential/certificate/:id
*VaultApi* | [**VaultGetCredentialpasswordId**](docs/VaultApi.md#vaultgetcredentialpasswordid) | **Get** /vault/{vaultId}/credential/password/{id} | /credential/password/:id
*VaultApi* | [**VaultGetServicesServiceId**](docs/VaultApi.md#vaultgetservicesserviceid) | **Get** /vault/{vaultId}/services/{serviceId} | /services/:serviceId
*VaultApi* | [**VaultGetTag**](docs/VaultApi.md#vaultgettag) | **Get** /vault/{vaultId}/tag | /tag
*VaultApi* | [**VaultList**](docs/VaultApi.md#vaultlist) | **Get** /vault | List
*VaultApi* | [**VaultListAccessrights**](docs/VaultApi.md#vaultlistaccessrights) | **Get** /vault/{vaultId}/accessrights | /accessrights
*VaultApi* | [**VaultListCredential**](docs/VaultApi.md#vaultlistcredential) | **Get** /vault/{vaultId}/credential | /credential
*VaultApi* | [**VaultListCredentialcertificate**](docs/VaultApi.md#vaultlistcredentialcertificate) | **Get** /vault/{vaultId}/credential/certificate | /credential/certificate
*VaultApi* | [**VaultListCredentialpassword**](docs/VaultApi.md#vaultlistcredentialpassword) | **Get** /vault/{vaultId}/credential/password | /credential/password
*VaultApi* | [**VaultListQueue**](docs/VaultApi.md#vaultlistqueue) | **Get** /vault/{vaultId}/queue | /queue
*VaultApi* | [**VaultListServices**](docs/VaultApi.md#vaultlistservices) | **Get** /vault/{vaultId}/services | /services
*VaultApi* | [**VaultPatchCredentialId**](docs/VaultApi.md#vaultpatchcredentialid) | **Patch** /vault/{vaultId}/credential/{id} | /credential/:id
*VaultApi* | [**VaultPatchCredentialcertificateId**](docs/VaultApi.md#vaultpatchcredentialcertificateid) | **Patch** /vault/{vaultId}/credential/certificate/{id} | /credential/certificate/:id
*VaultApi* | [**VaultPatchCredentialpasswordId**](docs/VaultApi.md#vaultpatchcredentialpasswordid) | **Patch** /vault/{vaultId}/credential/password/{id} | /credential/password/:id
*VaultApi* | [**VaultPatchTag**](docs/VaultApi.md#vaultpatchtag) | **Patch** /vault/{vaultId}/tag | /tag
*VaultApi* | [**VaultPostAccessrights**](docs/VaultApi.md#vaultpostaccessrights) | **Post** /vault/{vaultId}/accessrights | /accessrights
*VaultApi* | [**VaultPostCredential**](docs/VaultApi.md#vaultpostcredential) | **Post** /vault/{vaultId}/credential | /credential
*VaultApi* | [**VaultPostCredentialcertificate**](docs/VaultApi.md#vaultpostcredentialcertificate) | **Post** /vault/{vaultId}/credential/certificate | /credential/certificate
*VaultApi* | [**VaultPostCredentialpassword**](docs/VaultApi.md#vaultpostcredentialpassword) | **Post** /vault/{vaultId}/credential/password | /credential/password
*VaultApi* | [**VaultPutTag**](docs/VaultApi.md#vaultputtag) | **Put** /vault/{vaultId}/tag | /tag
*VaultApi* | [**VaultShow**](docs/VaultApi.md#vaultshow) | **Get** /vault/{vaultId} | Get
*VaultApi* | [**VaultUpdate**](docs/VaultApi.md#vaultupdate) | **Patch** /vault/{vaultId} | Update
*VmApi* | [**VmActionFlavour**](docs/VmApi.md#vmactionflavour) | **Post** /vm/{vmId}/actions/flavour | /actions/flavour
*VmApi* | [**VmActionImage**](docs/VmApi.md#vmactionimage) | **Post** /vm/{vmId}/actions/image | /actions/image
*VmApi* | [**VmActionPasswordReset**](docs/VmApi.md#vmactionpasswordreset) | **Post** /vm/{vmId}/actions/password_reset | /actions/password_reset
*VmApi* | [**VmActionRename**](docs/VmApi.md#vmactionrename) | **Post** /vm/{vmId}/actions/rename | /actions/rename
*VmApi* | [**VmActionRestart**](docs/VmApi.md#vmactionrestart) | **Post** /vm/{vmId}/actions/restart | /actions/restart
*VmApi* | [**VmActionStart**](docs/VmApi.md#vmactionstart) | **Post** /vm/{vmId}/actions/start | /actions/start
*VmApi* | [**VmActionStop**](docs/VmApi.md#vmactionstop) | **Post** /vm/{vmId}/actions/stop | /actions/stop
*VmApi* | [**VmActionTurnoff**](docs/VmApi.md#vmactionturnoff) | **Post** /vm/{vmId}/actions/turnoff | /actions/turnoff
*VmApi* | [**VmCreate**](docs/VmApi.md#vmcreate) | **Post** /vm | Create
*VmApi* | [**VmDelete**](docs/VmApi.md#vmdelete) | **Delete** /vm/{vmId} | Delete
*VmApi* | [**VmDeleteAccessrightsIdentity**](docs/VmApi.md#vmdeleteaccessrightsidentity) | **Delete** /vm/{vmId}/accessrights/{identity} | /accessrights/:identity
*VmApi* | [**VmDeleteHddDiskId**](docs/VmApi.md#vmdeletehdddiskid) | **Delete** /vm/{vmId}/hdd/{diskId} | /hdd/:diskId
*VmApi* | [**VmDeleteNetadpNetadpId**](docs/VmApi.md#vmdeletenetadpnetadpid) | **Delete** /vm/{vmId}/netadp/{netadpId} | /netadp/:netadpId
*VmApi* | [**VmDeleteTagKey**](docs/VmApi.md#vmdeletetagkey) | **Delete** /vm/{vmId}/tag/{key} | /tag/:key
*VmApi* | [**VmGetConsole**](docs/VmApi.md#vmgetconsole) | **Get** /vm/{vmId}/console | /console
*VmApi* | [**VmGetServicesServiceId**](docs/VmApi.md#vmgetservicesserviceid) | **Get** /vm/{vmId}/services/{serviceId} | /services/:serviceId
*VmApi* | [**VmGetTag**](docs/VmApi.md#vmgettag) | **Get** /vm/{vmId}/tag | /tag
*VmApi* | [**VmList**](docs/VmApi.md#vmlist) | **Get** /vm | List
*VmApi* | [**VmListAccessrights**](docs/VmApi.md#vmlistaccessrights) | **Get** /vm/{vmId}/accessrights | /accessrights
*VmApi* | [**VmListHdd**](docs/VmApi.md#vmlisthdd) | **Get** /vm/{vmId}/hdd | /hdd
*VmApi* | [**VmListNetadp**](docs/VmApi.md#vmlistnetadp) | **Get** /vm/{vmId}/netadp | /netadp
*VmApi* | [**VmListQueue**](docs/VmApi.md#vmlistqueue) | **Get** /vm/{vmId}/queue | /queue
*VmApi* | [**VmListServices**](docs/VmApi.md#vmlistservices) | **Get** /vm/{vmId}/services | /services
*VmApi* | [**VmPatchTag**](docs/VmApi.md#vmpatchtag) | **Patch** /vm/{vmId}/tag | /tag
*VmApi* | [**VmPostAccessrights**](docs/VmApi.md#vmpostaccessrights) | **Post** /vm/{vmId}/accessrights | /accessrights
*VmApi* | [**VmPostHdd**](docs/VmApi.md#vmposthdd) | **Post** /vm/{vmId}/hdd | /hdd
*VmApi* | [**VmPostNetadp**](docs/VmApi.md#vmpostnetadp) | **Post** /vm/{vmId}/netadp | /netadp
*VmApi* | [**VmPutTag**](docs/VmApi.md#vmputtag) | **Put** /vm/{vmId}/tag | /tag
*VmApi* | [**VmShow**](docs/VmApi.md#vmshow) | **Get** /vm/{vmId} | Get
*VmApi* | [**VmUpdate**](docs/VmApi.md#vmupdate) | **Patch** /vm/{vmId} | Update
*VmhostApi* | [**VmhostDeleteAccessrightsIdentity**](docs/VmhostApi.md#vmhostdeleteaccessrightsidentity) | **Delete** /vmhost/{vmhostId}/accessrights/{identity} | /accessrights/:identity
*VmhostApi* | [**VmhostDeleteTagKey**](docs/VmhostApi.md#vmhostdeletetagkey) | **Delete** /vmhost/{vmhostId}/tag/{key} | /tag/:key
*VmhostApi* | [**VmhostGetServicesServiceId**](docs/VmhostApi.md#vmhostgetservicesserviceid) | **Get** /vmhost/{vmhostId}/services/{serviceId} | /services/:serviceId
*VmhostApi* | [**VmhostGetTag**](docs/VmhostApi.md#vmhostgettag) | **Get** /vmhost/{vmhostId}/tag | /tag
*VmhostApi* | [**VmhostList**](docs/VmhostApi.md#vmhostlist) | **Get** /vmhost | List
*VmhostApi* | [**VmhostListAccessrights**](docs/VmhostApi.md#vmhostlistaccessrights) | **Get** /vmhost/{vmhostId}/accessrights | /accessrights
*VmhostApi* | [**VmhostListQueue**](docs/VmhostApi.md#vmhostlistqueue) | **Get** /vmhost/{vmhostId}/queue | /queue
*VmhostApi* | [**VmhostListServices**](docs/VmhostApi.md#vmhostlistservices) | **Get** /vmhost/{vmhostId}/services | /services
*VmhostApi* | [**VmhostPatchTag**](docs/VmhostApi.md#vmhostpatchtag) | **Patch** /vmhost/{vmhostId}/tag | /tag
*VmhostApi* | [**VmhostPostAccessrights**](docs/VmhostApi.md#vmhostpostaccessrights) | **Post** /vmhost/{vmhostId}/accessrights | /accessrights
*VmhostApi* | [**VmhostPutTag**](docs/VmhostApi.md#vmhostputtag) | **Put** /vmhost/{vmhostId}/tag | /tag
*VmhostApi* | [**VmhostShow**](docs/VmhostApi.md#vmhostshow) | **Get** /vmhost/{vmhostId} | Get
*VolumeApi* | [**VolumeCreate**](docs/VolumeApi.md#volumecreate) | **Post** /volume | Create
*VolumeApi* | [**VolumeDelete**](docs/VolumeApi.md#volumedelete) | **Delete** /volume/{volumeId} | Delete
*VolumeApi* | [**VolumeDeleteAccessrightsIdentity**](docs/VolumeApi.md#volumedeleteaccessrightsidentity) | **Delete** /volume/{volumeId}/accessrights/{identity} | /accessrights/:identity
*VolumeApi* | [**VolumeDeleteTagKey**](docs/VolumeApi.md#volumedeletetagkey) | **Delete** /volume/{volumeId}/tag/{key} | /tag/:key
*VolumeApi* | [**VolumeGetServicesServiceId**](docs/VolumeApi.md#volumegetservicesserviceid) | **Get** /volume/{volumeId}/services/{serviceId} | /services/:serviceId
*VolumeApi* | [**VolumeGetTag**](docs/VolumeApi.md#volumegettag) | **Get** /volume/{volumeId}/tag | /tag
*VolumeApi* | [**VolumeList**](docs/VolumeApi.md#volumelist) | **Get** /volume | List
*VolumeApi* | [**VolumeListAccessrights**](docs/VolumeApi.md#volumelistaccessrights) | **Get** /volume/{volumeId}/accessrights | /accessrights
*VolumeApi* | [**VolumeListQueue**](docs/VolumeApi.md#volumelistqueue) | **Get** /volume/{volumeId}/queue | /queue
*VolumeApi* | [**VolumeListServices**](docs/VolumeApi.md#volumelistservices) | **Get** /volume/{volumeId}/services | /services
*VolumeApi* | [**VolumePatchTag**](docs/VolumeApi.md#volumepatchtag) | **Patch** /volume/{volumeId}/tag | /tag
*VolumeApi* | [**VolumePostAccessrights**](docs/VolumeApi.md#volumepostaccessrights) | **Post** /volume/{volumeId}/accessrights | /accessrights
*VolumeApi* | [**VolumePutTag**](docs/VolumeApi.md#volumeputtag) | **Put** /volume/{volumeId}/tag | /tag
*VolumeApi* | [**VolumeShow**](docs/VolumeApi.md#volumeshow) | **Get** /volume/{volumeId} | Get
*VolumeApi* | [**VolumeUpdate**](docs/VolumeApi.md#volumeupdate) | **Patch** /volume/{volumeId} | Update
*WebsiteApi* | [**WebsiteActionRestart**](docs/WebsiteApi.md#websiteactionrestart) | **Post** /website/{websiteId}/actions/restart | /actions/restart
*WebsiteApi* | [**WebsiteActionStart**](docs/WebsiteApi.md#websiteactionstart) | **Post** /website/{websiteId}/actions/start | /actions/start
*WebsiteApi* | [**WebsiteActionStop**](docs/WebsiteApi.md#websiteactionstop) | **Post** /website/{websiteId}/actions/stop | /actions/stop
*WebsiteApi* | [**WebsiteActionTransfer**](docs/WebsiteApi.md#websiteactiontransfer) | **Post** /website/{websiteId}/actions/transfer | /actions/transfer
*WebsiteApi* | [**WebsiteActionUpdateDomain**](docs/WebsiteApi.md#websiteactionupdatedomain) | **Post** /website/{websiteId}/actions/update_domain | /actions/update_domain
*WebsiteApi* | [**WebsiteCreate**](docs/WebsiteApi.md#websitecreate) | **Post** /website | Create
*WebsiteApi* | [**WebsiteDelete**](docs/WebsiteApi.md#websitedelete) | **Delete** /website/{websiteId} | Delete
*WebsiteApi* | [**WebsiteDeleteAccessrightsIdentity**](docs/WebsiteApi.md#websitedeleteaccessrightsidentity) | **Delete** /website/{websiteId}/accessrights/{identity} | /accessrights/:identity
*WebsiteApi* | [**WebsiteDeleteCredentialId**](docs/WebsiteApi.md#websitedeletecredentialid) | **Delete** /website/{websiteId}/credential/{id} | /credential/:id
*WebsiteApi* | [**WebsiteDeleteCredentialcertificateId**](docs/WebsiteApi.md#websitedeletecredentialcertificateid) | **Delete** /website/{websiteId}/credential/certificate/{id} | /credential/certificate/:id
*WebsiteApi* | [**WebsiteDeleteCredentialpasswordId**](docs/WebsiteApi.md#websitedeletecredentialpasswordid) | **Delete** /website/{websiteId}/credential/password/{id} | /credential/password/:id
*WebsiteApi* | [**WebsiteDeleteSnapshotId**](docs/WebsiteApi.md#websitedeletesnapshotid) | **Delete** /website/{websiteId}/snapshot/{id} | /snapshot/:id
*WebsiteApi* | [**WebsiteDeleteTagKey**](docs/WebsiteApi.md#websitedeletetagkey) | **Delete** /website/{websiteId}/tag/{key} | /tag/:key
*WebsiteApi* | [**WebsiteGetCredentialId**](docs/WebsiteApi.md#websitegetcredentialid) | **Get** /website/{websiteId}/credential/{id} | /credential/:id
*WebsiteApi* | [**WebsiteGetCredentialcertificateId**](docs/WebsiteApi.md#websitegetcredentialcertificateid) | **Get** /website/{websiteId}/credential/certificate/{id} | /credential/certificate/:id
*WebsiteApi* | [**WebsiteGetCredentialpasswordId**](docs/WebsiteApi.md#websitegetcredentialpasswordid) | **Get** /website/{websiteId}/credential/password/{id} | /credential/password/:id
*WebsiteApi* | [**WebsiteGetServicesServiceId**](docs/WebsiteApi.md#websitegetservicesserviceid) | **Get** /website/{websiteId}/services/{serviceId} | /services/:serviceId
*WebsiteApi* | [**WebsiteGetSnapshotId**](docs/WebsiteApi.md#websitegetsnapshotid) | **Get** /website/{websiteId}/snapshot/{id} | /snapshot/:id
*WebsiteApi* | [**WebsiteGetSnapshotIddownload**](docs/WebsiteApi.md#websitegetsnapshotiddownload) | **Get** /website/{websiteId}/snapshot/:id/download | /snapshot/:id/download
*WebsiteApi* | [**WebsiteGetTag**](docs/WebsiteApi.md#websitegettag) | **Get** /website/{websiteId}/tag | /tag
*WebsiteApi* | [**WebsiteList**](docs/WebsiteApi.md#websitelist) | **Get** /website | List
*WebsiteApi* | [**WebsiteListAccessrights**](docs/WebsiteApi.md#websitelistaccessrights) | **Get** /website/{websiteId}/accessrights | /accessrights
*WebsiteApi* | [**WebsiteListCredential**](docs/WebsiteApi.md#websitelistcredential) | **Get** /website/{websiteId}/credential | /credential
*WebsiteApi* | [**WebsiteListCredentialcertificate**](docs/WebsiteApi.md#websitelistcredentialcertificate) | **Get** /website/{websiteId}/credential/certificate | /credential/certificate
*WebsiteApi* | [**WebsiteListCredentialpassword**](docs/WebsiteApi.md#websitelistcredentialpassword) | **Get** /website/{websiteId}/credential/password | /credential/password
*WebsiteApi* | [**WebsiteListQueue**](docs/WebsiteApi.md#websitelistqueue) | **Get** /website/{websiteId}/queue | /queue
*WebsiteApi* | [**WebsiteListServices**](docs/WebsiteApi.md#websitelistservices) | **Get** /website/{websiteId}/services | /services
*WebsiteApi* | [**WebsiteListSnapshot**](docs/WebsiteApi.md#websitelistsnapshot) | **Get** /website/{websiteId}/snapshot | /snapshot
*WebsiteApi* | [**WebsitePatchCredentialId**](docs/WebsiteApi.md#websitepatchcredentialid) | **Patch** /website/{websiteId}/credential/{id} | /credential/:id
*WebsiteApi* | [**WebsitePatchCredentialcertificateId**](docs/WebsiteApi.md#websitepatchcredentialcertificateid) | **Patch** /website/{websiteId}/credential/certificate/{id} | /credential/certificate/:id
*WebsiteApi* | [**WebsitePatchCredentialpasswordId**](docs/WebsiteApi.md#websitepatchcredentialpasswordid) | **Patch** /website/{websiteId}/credential/password/{id} | /credential/password/:id
*WebsiteApi* | [**WebsitePatchTag**](docs/WebsiteApi.md#websitepatchtag) | **Patch** /website/{websiteId}/tag | /tag
*WebsiteApi* | [**WebsitePostAccessrights**](docs/WebsiteApi.md#websitepostaccessrights) | **Post** /website/{websiteId}/accessrights | /accessrights
*WebsiteApi* | [**WebsitePostCredential**](docs/WebsiteApi.md#websitepostcredential) | **Post** /website/{websiteId}/credential | /credential
*WebsiteApi* | [**WebsitePostCredentialcertificate**](docs/WebsiteApi.md#websitepostcredentialcertificate) | **Post** /website/{websiteId}/credential/certificate | /credential/certificate
*WebsiteApi* | [**WebsitePostCredentialpassword**](docs/WebsiteApi.md#websitepostcredentialpassword) | **Post** /website/{websiteId}/credential/password | /credential/password
*WebsiteApi* | [**WebsitePostSnapshot**](docs/WebsiteApi.md#websitepostsnapshot) | **Post** /website/{websiteId}/snapshot | /snapshot
*WebsiteApi* | [**WebsitePutTag**](docs/WebsiteApi.md#websiteputtag) | **Put** /website/{websiteId}/tag | /tag
*WebsiteApi* | [**WebsiteShow**](docs/WebsiteApi.md#websiteshow) | **Get** /website/{websiteId} | Get
*WebsiteApi* | [**WebsiteUpdate**](docs/WebsiteApi.md#websiteupdate) | **Patch** /website/{websiteId} | Update
*ZoneApi* | [**ZoneCreate**](docs/ZoneApi.md#zonecreate) | **Post** /zone | Create
*ZoneApi* | [**ZoneDelete**](docs/ZoneApi.md#zonedelete) | **Delete** /zone/{zoneId} | Delete
*ZoneApi* | [**ZoneDeleteAccessrightsIdentity**](docs/ZoneApi.md#zonedeleteaccessrightsidentity) | **Delete** /zone/{zoneId}/accessrights/{identity} | /accessrights/:identity
*ZoneApi* | [**ZoneDeleteRecordsetRecordsetId**](docs/ZoneApi.md#zonedeleterecordsetrecordsetid) | **Delete** /zone/{zoneId}/recordset/{recordsetId} | /recordset/:recordsetId
*ZoneApi* | [**ZoneDeleteTagKey**](docs/ZoneApi.md#zonedeletetagkey) | **Delete** /zone/{zoneId}/tag/{key} | /tag/:key
*ZoneApi* | [**ZoneGetRecordsetRecordsetId**](docs/ZoneApi.md#zonegetrecordsetrecordsetid) | **Get** /zone/{zoneId}/recordset/{recordsetId} | /recordset/:recordsetId
*ZoneApi* | [**ZoneGetServicesServiceId**](docs/ZoneApi.md#zonegetservicesserviceid) | **Get** /zone/{zoneId}/services/{serviceId} | /services/:serviceId
*ZoneApi* | [**ZoneGetTag**](docs/ZoneApi.md#zonegettag) | **Get** /zone/{zoneId}/tag | /tag
*ZoneApi* | [**ZoneList**](docs/ZoneApi.md#zonelist) | **Get** /zone | List
*ZoneApi* | [**ZoneListAccessrights**](docs/ZoneApi.md#zonelistaccessrights) | **Get** /zone/{zoneId}/accessrights | /accessrights
*ZoneApi* | [**ZoneListQueue**](docs/ZoneApi.md#zonelistqueue) | **Get** /zone/{zoneId}/queue | /queue
*ZoneApi* | [**ZoneListRecordset**](docs/ZoneApi.md#zonelistrecordset) | **Get** /zone/{zoneId}/recordset | /recordset
*ZoneApi* | [**ZoneListRecordsetRecordsetIdrecord**](docs/ZoneApi.md#zonelistrecordsetrecordsetidrecord) | **Get** /zone/{zoneId}/recordset/{recordsetId}/record | /recordset/:recordsetId/record
*ZoneApi* | [**ZoneListServices**](docs/ZoneApi.md#zonelistservices) | **Get** /zone/{zoneId}/services | /services
*ZoneApi* | [**ZonePatchRecordsetRecordsetId**](docs/ZoneApi.md#zonepatchrecordsetrecordsetid) | **Patch** /zone/{zoneId}/recordset/{recordsetId} | /recordset/:recordsetId
*ZoneApi* | [**ZonePatchTag**](docs/ZoneApi.md#zonepatchtag) | **Patch** /zone/{zoneId}/tag | /tag
*ZoneApi* | [**ZonePostAccessrights**](docs/ZoneApi.md#zonepostaccessrights) | **Post** /zone/{zoneId}/accessrights | /accessrights
*ZoneApi* | [**ZonePostRecordset**](docs/ZoneApi.md#zonepostrecordset) | **Post** /zone/{zoneId}/recordset | /recordset
*ZoneApi* | [**ZonePutRecordsetRecordsetIdrecord**](docs/ZoneApi.md#zoneputrecordsetrecordsetidrecord) | **Put** /zone/{zoneId}/recordset/{recordsetId}/record | /recordset/:recordsetId/record
*ZoneApi* | [**ZonePutTag**](docs/ZoneApi.md#zoneputtag) | **Put** /zone/{zoneId}/tag | /tag
*ZoneApi* | [**ZoneShow**](docs/ZoneApi.md#zoneshow) | **Get** /zone/{zoneId} | Get
*ZoneApi* | [**ZoneUpdate**](docs/ZoneApi.md#zoneupdate) | **Patch** /zone/{zoneId} | Update


## Documentation For Models

 - [AccessrightsUserRole](docs/AccessrightsUserRole.md)
 - [Agent](docs/Agent.md)
 - [AgentActionTransfer](docs/AgentActionTransfer.md)
 - [AgentActionUpdateEnabledServices](docs/AgentActionUpdateEnabledServices.md)
 - [AgentCreate](docs/AgentCreate.md)
 - [AgentCreateCredential](docs/AgentCreateCredential.md)
 - [AgentCreateCredentialCertificate](docs/AgentCreateCredentialCertificate.md)
 - [AgentPatchCredentialId](docs/AgentPatchCredentialId.md)
 - [AgentPatchCredentialcertificateId](docs/AgentPatchCredentialcertificateId.md)
 - [AgentPostAccessrights](docs/AgentPostAccessrights.md)
 - [AgentPostCredential](docs/AgentPostCredential.md)
 - [AgentPostCredentialcertificate](docs/AgentPostCredentialcertificate.md)
 - [AgentResource](docs/AgentResource.md)
 - [AgentResourceEvent](docs/AgentResourceEvent.md)
 - [AgentServices](docs/AgentServices.md)
 - [AgentUpdate](docs/AgentUpdate.md)
 - [AuthToken](docs/AuthToken.md)
 - [AuthTokenAccess](docs/AuthTokenAccess.md)
 - [Billing](docs/Billing.md)
 - [BillingCharges](docs/BillingCharges.md)
 - [BillingService](docs/BillingService.md)
 - [Container](docs/Container.md)
 - [ContainerCreate](docs/ContainerCreate.md)
 - [ContainerCreateRegistry](docs/ContainerCreateRegistry.md)
 - [ContainerCreateVolumes](docs/ContainerCreateVolumes.md)
 - [ContainerExpose](docs/ContainerExpose.md)
 - [ContainerPostAccessrights](docs/ContainerPostAccessrights.md)
 - [ContainerServices](docs/ContainerServices.md)
 - [ContainerUpdate](docs/ContainerUpdate.md)
 - [ContainerVolumes](docs/ContainerVolumes.md)
 - [CredentialCertificate](docs/CredentialCertificate.md)
 - [CredentialPassword](docs/CredentialPassword.md)
 - [Database](docs/Database.md)
 - [DatabaseActionTransfer](docs/DatabaseActionTransfer.md)
 - [DatabaseCreate](docs/DatabaseCreate.md)
 - [DatabasePatchCredentialId](docs/DatabasePatchCredentialId.md)
 - [DatabasePatchCredentialpasswordId](docs/DatabasePatchCredentialpasswordId.md)
 - [DatabasePostAccessrights](docs/DatabasePostAccessrights.md)
 - [DatabasePostCredential](docs/DatabasePostCredential.md)
 - [DatabasePostCredentialpassword](docs/DatabasePostCredentialpassword.md)
 - [DatabaseServices](docs/DatabaseServices.md)
 - [DatabaseUpdate](docs/DatabaseUpdate.md)
 - [Disk](docs/Disk.md)
 - [DiskActionClone](docs/DiskActionClone.md)
 - [DiskActionResize](docs/DiskActionResize.md)
 - [DiskActionTransfer](docs/DiskActionTransfer.md)
 - [DiskCreate](docs/DiskCreate.md)
 - [DiskMetadata](docs/DiskMetadata.md)
 - [DiskMetadataSource](docs/DiskMetadataSource.md)
 - [DiskPostAccessrights](docs/DiskPostAccessrights.md)
 - [DiskServices](docs/DiskServices.md)
 - [DiskUpdate](docs/DiskUpdate.md)
 - [Event](docs/Event.md)
 - [EventResource](docs/EventResource.md)
 - [Firewall](docs/Firewall.md)
 - [FirewallActionAttach](docs/FirewallActionAttach.md)
 - [FirewallActionTransfer](docs/FirewallActionTransfer.md)
 - [FirewallCreate](docs/FirewallCreate.md)
 - [FirewallCreateIngress](docs/FirewallCreateIngress.md)
 - [FirewallPostAccessrights](docs/FirewallPostAccessrights.md)
 - [FirewallPostEgress](docs/FirewallPostEgress.md)
 - [FirewallPostIngress](docs/FirewallPostIngress.md)
 - [FirewallServices](docs/FirewallServices.md)
 - [FirewallUpdate](docs/FirewallUpdate.md)
 - [Hdd](docs/Hdd.md)
 - [HddDisk](docs/HddDisk.md)
 - [Image](docs/Image.md)
 - [ImageActionTransfer](docs/ImageActionTransfer.md)
 - [ImageAttachedOn](docs/ImageAttachedOn.md)
 - [ImageCreate](docs/ImageCreate.md)
 - [ImageDisk](docs/ImageDisk.md)
 - [ImageDisks](docs/ImageDisks.md)
 - [ImagePostAccessrights](docs/ImagePostAccessrights.md)
 - [ImageServices](docs/ImageServices.md)
 - [ImageUpdate](docs/ImageUpdate.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [InlineResponse2001](docs/InlineResponse2001.md)
 - [InlineResponse2002](docs/InlineResponse2002.md)
 - [InlineResponse2003](docs/InlineResponse2003.md)
 - [InlineResponse2004](docs/InlineResponse2004.md)
 - [InlineResponse2005](docs/InlineResponse2005.md)
 - [InlineResponse400](docs/InlineResponse400.md)
 - [Ip](docs/Ip.md)
 - [IpActionAssociate](docs/IpActionAssociate.md)
 - [IpActionTransfer](docs/IpActionTransfer.md)
 - [IpAssociated](docs/IpAssociated.md)
 - [IpCreate](docs/IpCreate.md)
 - [IpPostAccessrights](docs/IpPostAccessrights.md)
 - [IpServices](docs/IpServices.md)
 - [IpUpdate](docs/IpUpdate.md)
 - [Iso](docs/Iso.md)
 - [IsoActionTransfer](docs/IsoActionTransfer.md)
 - [IsoCreate](docs/IsoCreate.md)
 - [IsoPostAccessrights](docs/IsoPostAccessrights.md)
 - [IsoServices](docs/IsoServices.md)
 - [IsoUpdate](docs/IsoUpdate.md)
 - [Journal](docs/Journal.md)
 - [JournalActionTransfer](docs/JournalActionTransfer.md)
 - [JournalActionUpdateRetention](docs/JournalActionUpdateRetention.md)
 - [JournalCreate](docs/JournalCreate.md)
 - [JournalCreateCredential](docs/JournalCreateCredential.md)
 - [JournalCreateCredentialPassword](docs/JournalCreateCredentialPassword.md)
 - [JournalPatchCredentialId](docs/JournalPatchCredentialId.md)
 - [JournalPatchCredentialpasswordId](docs/JournalPatchCredentialpasswordId.md)
 - [JournalPostAccessrights](docs/JournalPostAccessrights.md)
 - [JournalPostCredential](docs/JournalPostCredential.md)
 - [JournalPostCredentialpassword](docs/JournalPostCredentialpassword.md)
 - [JournalServices](docs/JournalServices.md)
 - [JournalUpdate](docs/JournalUpdate.md)
 - [Netadp](docs/Netadp.md)
 - [NetadpActionFirewallAdd](docs/NetadpActionFirewallAdd.md)
 - [NetadpAssigned](docs/NetadpAssigned.md)
 - [NetadpPostAccessrights](docs/NetadpPostAccessrights.md)
 - [NetadpServices](docs/NetadpServices.md)
 - [Netgw](docs/Netgw.md)
 - [NetgwActionAttach](docs/NetgwActionAttach.md)
 - [NetgwActionAttachPrivate](docs/NetgwActionAttachPrivate.md)
 - [NetgwCreate](docs/NetgwCreate.md)
 - [NetgwCreatePublic](docs/NetgwCreatePublic.md)
 - [NetgwPostAccessrights](docs/NetgwPostAccessrights.md)
 - [NetgwServices](docs/NetgwServices.md)
 - [NetgwUpdate](docs/NetgwUpdate.md)
 - [Network](docs/Network.md)
 - [NetworkActionFirewallAdd](docs/NetworkActionFirewallAdd.md)
 - [NetworkCreate](docs/NetworkCreate.md)
 - [NetworkDns](docs/NetworkDns.md)
 - [NetworkPostAccessrights](docs/NetworkPostAccessrights.md)
 - [NetworkPostIp](docs/NetworkPostIp.md)
 - [NetworkServices](docs/NetworkServices.md)
 - [NetworkUpdate](docs/NetworkUpdate.md)
 - [Organisation](docs/Organisation.md)
 - [OrganisationActionPaymentAssign](docs/OrganisationActionPaymentAssign.md)
 - [OrganisationActionTransferAccept](docs/OrganisationActionTransferAccept.md)
 - [OrganisationBilling](docs/OrganisationBilling.md)
 - [OrganisationBillingAddress](docs/OrganisationBillingAddress.md)
 - [OrganisationCreate](docs/OrganisationCreate.md)
 - [OrganisationCreateAccessRights](docs/OrganisationCreateAccessRights.md)
 - [OrganisationCreateBilling](docs/OrganisationCreateBilling.md)
 - [OrganisationCreateBillingAddress](docs/OrganisationCreateBillingAddress.md)
 - [OrganisationLimit](docs/OrganisationLimit.md)
 - [OrganisationLimitOrganisation](docs/OrganisationLimitOrganisation.md)
 - [OrganisationPostAccessrights](docs/OrganisationPostAccessrights.md)
 - [OrganisationTransfer](docs/OrganisationTransfer.md)
 - [OrganisationUpdate](docs/OrganisationUpdate.md)
 - [OrganisationUpdateBilling](docs/OrganisationUpdateBilling.md)
 - [OrganisationUpdateBillingAddress](docs/OrganisationUpdateBillingAddress.md)
 - [Payment](docs/Payment.md)
 - [Project](docs/Project.md)
 - [ProjectAccessRights](docs/ProjectAccessRights.md)
 - [ProjectBilling](docs/ProjectBilling.md)
 - [ProjectCompliance](docs/ProjectCompliance.md)
 - [ProjectCreate](docs/ProjectCreate.md)
 - [ProjectCreateAccessRights](docs/ProjectCreateAccessRights.md)
 - [ProjectDuplicate](docs/ProjectDuplicate.md)
 - [ProjectInvoices](docs/ProjectInvoices.md)
 - [ProjectLimit](docs/ProjectLimit.md)
 - [ProjectLimitAgent](docs/ProjectLimitAgent.md)
 - [ProjectLimitContainer](docs/ProjectLimitContainer.md)
 - [ProjectLimitDisk](docs/ProjectLimitDisk.md)
 - [ProjectLimitNetwork](docs/ProjectLimitNetwork.md)
 - [ProjectLimitRegistry](docs/ProjectLimitRegistry.md)
 - [ProjectLimitReservation](docs/ProjectLimitReservation.md)
 - [ProjectLimitSnapshot](docs/ProjectLimitSnapshot.md)
 - [ProjectLimitVault](docs/ProjectLimitVault.md)
 - [ProjectLimitVm](docs/ProjectLimitVm.md)
 - [ProjectLimitVolume](docs/ProjectLimitVolume.md)
 - [ProjectPatchCredentialStoreId](docs/ProjectPatchCredentialStoreId.md)
 - [ProjectPatchCredentialStorecertificateId](docs/ProjectPatchCredentialStorecertificateId.md)
 - [ProjectPostAccessrights](docs/ProjectPostAccessrights.md)
 - [ProjectPostCredentialStore](docs/ProjectPostCredentialStore.md)
 - [ProjectPostCredentialStorecertificate](docs/ProjectPostCredentialStorecertificate.md)
 - [ProjectRoles](docs/ProjectRoles.md)
 - [ProjectServices](docs/ProjectServices.md)
 - [ProjectThreshold](docs/ProjectThreshold.md)
 - [ProjectThresholdCredits](docs/ProjectThresholdCredits.md)
 - [ProjectTransfer](docs/ProjectTransfer.md)
 - [ProjectUpdate](docs/ProjectUpdate.md)
 - [Registry](docs/Registry.md)
 - [RegistryActionTransfer](docs/RegistryActionTransfer.md)
 - [RegistryActionUpdateDomain](docs/RegistryActionUpdateDomain.md)
 - [RegistryCreate](docs/RegistryCreate.md)
 - [RegistryPatchCredentialId](docs/RegistryPatchCredentialId.md)
 - [RegistryPatchCredentialpasswordId](docs/RegistryPatchCredentialpasswordId.md)
 - [RegistryPostAccessrights](docs/RegistryPostAccessrights.md)
 - [RegistryPostCredential](docs/RegistryPostCredential.md)
 - [RegistryPostCredentialpassword](docs/RegistryPostCredentialpassword.md)
 - [RegistryServices](docs/RegistryServices.md)
 - [RegistryUpdate](docs/RegistryUpdate.md)
 - [Replica](docs/Replica.md)
 - [ReplicaActionImage](docs/ReplicaActionImage.md)
 - [ReplicaCreate](docs/ReplicaCreate.md)
 - [ReplicaPostAccessrights](docs/ReplicaPostAccessrights.md)
 - [ReplicaServices](docs/ReplicaServices.md)
 - [Reservation](docs/Reservation.md)
 - [ReservationActionAssign](docs/ReservationActionAssign.md)
 - [ReservationCreate](docs/ReservationCreate.md)
 - [ReservationPostAccessrights](docs/ReservationPostAccessrights.md)
 - [ReservationServices](docs/ReservationServices.md)
 - [ReservationUpdate](docs/ReservationUpdate.md)
 - [Service](docs/Service.md)
 - [ServiceBilling](docs/ServiceBilling.md)
 - [ServiceBillingPrice](docs/ServiceBillingPrice.md)
 - [ServiceBillingReservations](docs/ServiceBillingReservations.md)
 - [Snapshot](docs/Snapshot.md)
 - [SnapshotCreate](docs/SnapshotCreate.md)
 - [SnapshotPostAccessrights](docs/SnapshotPostAccessrights.md)
 - [SnapshotServices](docs/SnapshotServices.md)
 - [SnapshotUpdate](docs/SnapshotUpdate.md)
 - [User](docs/User.md)
 - [UserCredential](docs/UserCredential.md)
 - [UserCredentialPassword](docs/UserCredentialPassword.md)
 - [UserLimit](docs/UserLimit.md)
 - [UserNetworkAcl](docs/UserNetworkAcl.md)
 - [UserPasswordReset](docs/UserPasswordReset.md)
 - [UserPatchCredentialId](docs/UserPatchCredentialId.md)
 - [UserPatchCredentialcertificateId](docs/UserPatchCredentialcertificateId.md)
 - [UserPatchCredentialpasswordId](docs/UserPatchCredentialpasswordId.md)
 - [UserPostCredential](docs/UserPostCredential.md)
 - [UserPostCredentialcertificate](docs/UserPostCredentialcertificate.md)
 - [UserPostCredentialpassword](docs/UserPostCredentialpassword.md)
 - [UserServices](docs/UserServices.md)
 - [UserUpdate](docs/UserUpdate.md)
 - [Vault](docs/Vault.md)
 - [VaultActionResize](docs/VaultActionResize.md)
 - [VaultActionSnapshot](docs/VaultActionSnapshot.md)
 - [VaultCreate](docs/VaultCreate.md)
 - [VaultDelete](docs/VaultDelete.md)
 - [VaultPatchCredentialId](docs/VaultPatchCredentialId.md)
 - [VaultPatchCredentialcertificateId](docs/VaultPatchCredentialcertificateId.md)
 - [VaultPatchCredentialpasswordId](docs/VaultPatchCredentialpasswordId.md)
 - [VaultPostAccessrights](docs/VaultPostAccessrights.md)
 - [VaultPostCredential](docs/VaultPostCredential.md)
 - [VaultPostCredentialcertificate](docs/VaultPostCredentialcertificate.md)
 - [VaultPostCredentialpassword](docs/VaultPostCredentialpassword.md)
 - [VaultServices](docs/VaultServices.md)
 - [VaultUpdate](docs/VaultUpdate.md)
 - [Vm](docs/Vm.md)
 - [VmActionFlavour](docs/VmActionFlavour.md)
 - [VmActionImage](docs/VmActionImage.md)
 - [VmActionPasswordReset](docs/VmActionPasswordReset.md)
 - [VmActionRename](docs/VmActionRename.md)
 - [VmCreate](docs/VmCreate.md)
 - [VmCreateDisk](docs/VmCreateDisk.md)
 - [VmCreateNetadp](docs/VmCreateNetadp.md)
 - [VmCreatePassword](docs/VmCreatePassword.md)
 - [VmData](docs/VmData.md)
 - [VmDelete](docs/VmDelete.md)
 - [VmPostAccessrights](docs/VmPostAccessrights.md)
 - [VmPostHdd](docs/VmPostHdd.md)
 - [VmPostNetadp](docs/VmPostNetadp.md)
 - [VmServices](docs/VmServices.md)
 - [VmSourceImage](docs/VmSourceImage.md)
 - [VmUpdate](docs/VmUpdate.md)
 - [Vmhost](docs/Vmhost.md)
 - [VmhostPostAccessrights](docs/VmhostPostAccessrights.md)
 - [VmhostServices](docs/VmhostServices.md)
 - [Volume](docs/Volume.md)
 - [VolumeCreate](docs/VolumeCreate.md)
 - [VolumePostAccessrights](docs/VolumePostAccessrights.md)
 - [VolumeServices](docs/VolumeServices.md)
 - [VolumeUpdate](docs/VolumeUpdate.md)
 - [Website](docs/Website.md)
 - [WebsiteActionTransfer](docs/WebsiteActionTransfer.md)
 - [WebsiteActionUpdateDomain](docs/WebsiteActionUpdateDomain.md)
 - [WebsiteCreate](docs/WebsiteCreate.md)
 - [WebsiteCreateCredential](docs/WebsiteCreateCredential.md)
 - [WebsiteCreateSource](docs/WebsiteCreateSource.md)
 - [WebsitePatchCredentialId](docs/WebsitePatchCredentialId.md)
 - [WebsitePatchCredentialcertificateId](docs/WebsitePatchCredentialcertificateId.md)
 - [WebsitePatchCredentialpasswordId](docs/WebsitePatchCredentialpasswordId.md)
 - [WebsitePostAccessrights](docs/WebsitePostAccessrights.md)
 - [WebsitePostCredential](docs/WebsitePostCredential.md)
 - [WebsitePostCredentialcertificate](docs/WebsitePostCredentialcertificate.md)
 - [WebsitePostCredentialpassword](docs/WebsitePostCredentialpassword.md)
 - [WebsitePostSnapshot](docs/WebsitePostSnapshot.md)
 - [WebsiteServices](docs/WebsiteServices.md)
 - [WebsiteUpdate](docs/WebsiteUpdate.md)
 - [Zone](docs/Zone.md)
 - [ZoneCreate](docs/ZoneCreate.md)
 - [ZoneCreateSource](docs/ZoneCreateSource.md)
 - [ZonePatchRecordsetRecordsetId](docs/ZonePatchRecordsetRecordsetId.md)
 - [ZonePostAccessrights](docs/ZonePostAccessrights.md)
 - [ZonePostRecordset](docs/ZonePostRecordset.md)
 - [ZonePostRecordsetRecord](docs/ZonePostRecordsetRecord.md)
 - [ZoneRecordset](docs/ZoneRecordset.md)
 - [ZoneRecordset0](docs/ZoneRecordset0.md)
 - [ZoneRecordset0Record](docs/ZoneRecordset0Record.md)
 - [ZoneRecordsetRecord](docs/ZoneRecordsetRecord.md)
 - [ZoneRrsets](docs/ZoneRrsets.md)
 - [ZoneServices](docs/ZoneServices.md)
 - [ZoneUpdate](docs/ZoneUpdate.md)


## Documentation For Authorization



## Project

- **Type**: API key

Example

```golang
auth := context.WithValue(context.Background(), sw.ContextAPIKey, sw.APIKey{
    Key: "APIKEY",
    Prefix: "Bearer", // Omit if not necessary.
})
r, err := client.Service.Operation(auth, args)
```


## ServiceAccount

- **Type**: HTTP basic authentication

Example

```golang
auth := context.WithValue(context.Background(), sw.ContextBasicAuth, sw.BasicAuth{
    UserName: "username",
    Password: "password",
})
r, err := client.Service.Operation(auth, args)
```


## Session

- **Type**: HTTP basic authentication

Example

```golang
auth := context.WithValue(context.Background(), sw.ContextBasicAuth, sw.BasicAuth{
    UserName: "username",
    Password: "password",
})
r, err := client.Service.Operation(auth, args)
```


## Author



