// Code generated by sdkgen. DO NOT EDIT.

//nolint
package k8s

import (
	"context"

	"google.golang.org/grpc"

	k8s "github.com/yandex-cloud/go-genproto/yandex/cloud/k8s/v1"
	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
)

//revive:disable

// NodeGroupServiceClient is a k8s.NodeGroupServiceClient with
// lazy GRPC connection initialization.
type NodeGroupServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements k8s.NodeGroupServiceClient
func (c *NodeGroupServiceClient) Create(ctx context.Context, in *k8s.CreateNodeGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return k8s.NewNodeGroupServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements k8s.NodeGroupServiceClient
func (c *NodeGroupServiceClient) Delete(ctx context.Context, in *k8s.DeleteNodeGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return k8s.NewNodeGroupServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements k8s.NodeGroupServiceClient
func (c *NodeGroupServiceClient) Get(ctx context.Context, in *k8s.GetNodeGroupRequest, opts ...grpc.CallOption) (*k8s.NodeGroup, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return k8s.NewNodeGroupServiceClient(conn).Get(ctx, in, opts...)
}

// List implements k8s.NodeGroupServiceClient
func (c *NodeGroupServiceClient) List(ctx context.Context, in *k8s.ListNodeGroupsRequest, opts ...grpc.CallOption) (*k8s.ListNodeGroupsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return k8s.NewNodeGroupServiceClient(conn).List(ctx, in, opts...)
}

type NodeGroupIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err     error
	started bool

	client  *NodeGroupServiceClient
	request *k8s.ListNodeGroupsRequest

	items []*k8s.NodeGroup
}

func (c *NodeGroupServiceClient) NodeGroupIterator(ctx context.Context, folderId string, opts ...grpc.CallOption) *NodeGroupIterator {
	return &NodeGroupIterator{
		ctx:    ctx,
		opts:   opts,
		client: c,
		request: &k8s.ListNodeGroupsRequest{
			FolderId: folderId,
			PageSize: 1000,
		},
	}
}

func (it *NodeGroupIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.NodeGroups
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *NodeGroupIterator) Value() *k8s.NodeGroup {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *NodeGroupIterator) Error() error {
	return it.err
}

// ListNodes implements k8s.NodeGroupServiceClient
func (c *NodeGroupServiceClient) ListNodes(ctx context.Context, in *k8s.ListNodeGroupNodesRequest, opts ...grpc.CallOption) (*k8s.ListNodeGroupNodesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return k8s.NewNodeGroupServiceClient(conn).ListNodes(ctx, in, opts...)
}

type NodeGroupNodesIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err     error
	started bool

	client  *NodeGroupServiceClient
	request *k8s.ListNodeGroupNodesRequest

	items []*k8s.Node
}

func (c *NodeGroupServiceClient) NodeGroupNodesIterator(ctx context.Context, nodeGroupId string, opts ...grpc.CallOption) *NodeGroupNodesIterator {
	return &NodeGroupNodesIterator{
		ctx:    ctx,
		opts:   opts,
		client: c,
		request: &k8s.ListNodeGroupNodesRequest{
			NodeGroupId: nodeGroupId,
			PageSize:    1000,
		},
	}
}

func (it *NodeGroupNodesIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	response, err := it.client.ListNodes(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Nodes
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *NodeGroupNodesIterator) Value() *k8s.Node {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *NodeGroupNodesIterator) Error() error {
	return it.err
}

// ListOperations implements k8s.NodeGroupServiceClient
func (c *NodeGroupServiceClient) ListOperations(ctx context.Context, in *k8s.ListNodeGroupOperationsRequest, opts ...grpc.CallOption) (*k8s.ListNodeGroupOperationsResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return k8s.NewNodeGroupServiceClient(conn).ListOperations(ctx, in, opts...)
}

type NodeGroupOperationsIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err     error
	started bool

	client  *NodeGroupServiceClient
	request *k8s.ListNodeGroupOperationsRequest

	items []*operation.Operation
}

func (c *NodeGroupServiceClient) NodeGroupOperationsIterator(ctx context.Context, nodeGroupId string, opts ...grpc.CallOption) *NodeGroupOperationsIterator {
	return &NodeGroupOperationsIterator{
		ctx:    ctx,
		opts:   opts,
		client: c,
		request: &k8s.ListNodeGroupOperationsRequest{
			NodeGroupId: nodeGroupId,
			PageSize:    1000,
		},
	}
}

func (it *NodeGroupOperationsIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	response, err := it.client.ListOperations(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Operations
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *NodeGroupOperationsIterator) Value() *operation.Operation {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *NodeGroupOperationsIterator) Error() error {
	return it.err
}

// Update implements k8s.NodeGroupServiceClient
func (c *NodeGroupServiceClient) Update(ctx context.Context, in *k8s.UpdateNodeGroupRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return k8s.NewNodeGroupServiceClient(conn).Update(ctx, in, opts...)
}
