/*
 * 3DS OUTSCALE API
 *
 * Welcome to the 3DS OUTSCALE's API documentation.<br /><br />  The 3DS OUTSCALE API enables you to manage your resources in the 3DS OUTSCALE Cloud. This documentation describes the different actions available along with code examples.<br /><br />  Note that the 3DS OUTSCALE Cloud is compatible with Amazon Web Services (AWS) APIs, but some resources have different names in AWS than in the 3DS OUTSCALE API. You can find a list of the differences [here](https://wiki.outscale.net/display/EN/3DS+OUTSCALE+APIs+Reference).<br /><br />  You can also manage your resources using the [Cockpit](https://wiki.outscale.net/display/EN/About+Cockpit) web interface.
 *
 * API version: 1.2
 * Contact: support@outscale.com
 * Generated by: OpenAPI Generator (https://openapi-generator.tech)
 */

package osc
// Volume Information about the volume.
type Volume struct {
	// The number of I/O operations per second (IOPS):<br /> - For `io1` volumes, the number of provisioned IOPS<br /> - For `gp2` volumes, the baseline performance of the volume
	Iops int32 `json:"Iops,omitempty"`
	// Information about your volume attachment.
	LinkedVolumes []LinkedVolume `json:"LinkedVolumes,omitempty"`
	// The size of the volume, in gibibytes (GiB).
	Size int32 `json:"Size,omitempty"`
	// The snapshot from which the volume was created.
	SnapshotId string `json:"SnapshotId,omitempty"`
	// The state of the volume (`creating` \\| `available` \\| `in-use` \\| `deleting` \\| `error`).
	State string `json:"State,omitempty"`
	// The Subregion in which the volume was created.
	SubregionName string `json:"SubregionName,omitempty"`
	// One or more tags associated with the volume.
	Tags []ResourceTag `json:"Tags,omitempty"`
	// The ID of the volume.
	VolumeId string `json:"VolumeId,omitempty"`
	// The type of the volume (`standard` \\| `gp2` \\| `io1`).
	VolumeType string `json:"VolumeType,omitempty"`
}
