## v1.23.0

### Additions

- (Alpha) New optional validator to help verify if a bundle matches criteria for multiple architecture support. More info: https://olm.operatorframework.io/docs/advanced-tasks/ship-operator-supporting-multiarch/. You can test it out by running `$ operator-sdk bundle validate ./bundle --select-optional name=multiarch`. ([#5908](https://github.com/operator-framework/operator-sdk/pull/5908))
- Add an option, `WatchAnnotationsChanges`, to trigger reconciliations on annotation changes on watched resources. ([#5611](https://github.com/operator-framework/operator-sdk/pull/5611))
- Add a plugin (deploy-image/v1-alpha) for Golang projects that scaffolds the code to deploy and manage an Operand(image). You can test it out by running `operator-sdk --group=example.com --version=v1alpha1 --kind=Memcached --image=memcached:1.6.15-alpine --image-container-command="memcached,-m=64,modern,-v" --image-container-port="11211" --run-as-user="1001" --plugins="deploy-image/v1-alpha"` [More info](https://master.book.kubebuilder.io/plugins/deploy-image-plugin-v1-alpha.html). ([#5965](https://github.com/operator-framework/operator-sdk/pull/5965))
- Add a plugin (grafana/v1-alpha) valid for all languages to help you generate Grafana dashboards. You can test it out by running `operator-sdk edit --plugins=grafana.kubebuilder.io/v1-alpha` [More info](https://master.book.kubebuilder.io/plugins/grafana-v1-alpha.html). ([#5965](https://github.com/operator-framework/operator-sdk/pull/5965))
- Add new golang plugin `go/v4-alpha` which adds support for Apple Silicon(`darwin/arm64`). ([#5965](https://github.com/operator-framework/operator-sdk/pull/5965))
- Test containers defined by `config.yaml` can now read the environment variable `SCORECARD_STORAGE` to get a storage path defined in the `config.yaml`. ([#5829](https://github.com/operator-framework/operator-sdk/pull/5829))
- (deploy-image/v1alpha plugin) Add support to generate SDK bundle manifests. ([#5997](https://github.com/operator-framework/operator-sdk/pull/5997))
- (ansible/v1,helm/v1) Add support for Apple Silicon(`darwin/arm64`). [Release Notes](https://github.com/kubernetes-sigs/kustomize/releases/tag/kustomize%2Fv4.0.0). ([#5965](https://github.com/operator-framework/operator-sdk/pull/5965))

### Changes

- Upgrade kube rbac proxy image `gcr.io/kubebuilder/kube-rbac-proxy` from `v0.11.0` to `v0.12.0`. [More info](https://github.com/brancz/kube-rbac-proxy/releases/tag/v0.12.0). ([#5903](https://github.com/operator-framework/operator-sdk/pull/5903))
- (go/v3) Update `controller-tools` from `0.9.0` to `0.9.2`. [More info](https://github.com/kubernetes-sigs/controller-tools/releases/tag/v0.9.2). ([#5965](https://github.com/operator-framework/operator-sdk/pull/5965))
- (go/v3) Update `controller-runtime` from `v0.12.1` to `v0.12.2` and Kubernetes dependencies from `v0.24.0` to `v0.24.2`. [More info](https://github.com/kubernetes-sigs/controller-runtime/releases/tag/v0.12.2). ([#5965](https://github.com/operator-framework/operator-sdk/pull/5965))
- (go/v3,ansible/v1,helm/v1) Update `gcr.io/kubebuilder/kube-rbac-proxy` from `0.12.0` to `0.13.0`. [More info](https://github.com/brancz/kube-rbac-proxy/releases/tag/v0.13.0). ([#5965](https://github.com/operator-framework/operator-sdk/pull/5965))
- **Breaking change**: (ansible/v1,helm/v1) Upgraded `kustomize` version from `v3.8.7` to `v4.5.5`. [Release Notes](https://github.com/kubernetes-sigs/kustomize/releases/tag/kustomize%2Fv4.0.0). ([#5965](https://github.com/operator-framework/operator-sdk/pull/5965))
- Update the supported OLM versions to 0.20.0, 0.21.2, 0.22.0. ([#6000](https://github.com/operator-framework/operator-sdk/pull/6000))
- Moved bundle name validation check to the good-practices validator. You can test it out by running `$ operator-sdk bundle validate ./bundle --select-optional name=good-practices`. ([#5908](https://github.com/operator-framework/operator-sdk/pull/5908))

### Deprecations

- Legacy layout "Kubebuilder 2.x" provided via the go/v2 plugin is officially deprecated. Be aware that since `Apr 2021`, the default layout produced is done via the `go/v3`. ([More info](https://github.com/kubernetes-sigs/kubebuilder/discussions/2842)) Check your `PROJECT` file to make sure that your project layout is `go.kubebuilder.io/v3`, if not please follow the [migration guide](https://sdk.operatorframework.io/docs/building-operators/golang/migration/) to upgrade your project. ([#5965](https://github.com/operator-framework/operator-sdk/pull/5965))
- Dropped support for installing `olm` version `0.19.1`. ([#6000](https://github.com/operator-framework/operator-sdk/pull/6000))

### Bug Fixes

- For Hybrid Helm (hybrid.helm/v1-alpha) language based operators: Bump Dockerfile Go version to 1.18. ([#5772](https://github.com/operator-framework/operator-sdk/pull/5772))
- Fix Makefile targets to not download binaries when they are found already. ([#5965](https://github.com/operator-framework/operator-sdk/pull/5965))
- Remove the option to call `kustomize/v1` plugin alone. If you are looking to use this project as a base for you to generate other plugins, please use [Kubebuilder](https://github.com/kubernetes-sigs/kubebuilder) instead. ([#5965](https://github.com/operator-framework/operator-sdk/pull/5965))
- Fix operator-sdk run bundle and upgrade bundle subCommands to allow them to work against Kubernetes versions < 1.19 and vendors like Openshift. ([#5973](https://github.com/operator-framework/operator-sdk/pull/5973))
- Fixed scorecard testOutput tightly coupling with scorecard storage mountPath. ([#5714](https://github.com/operator-framework/operator-sdk/pull/5714))
- Fix operator-sdk generate kustomize manifests to respect changes made by users in the config/manifests. ([#5960](https://github.com/operator-framework/operator-sdk/pull/5960))
- For `operator-sdk run bundle-upgrade`: fix a bug that caused `InstallPlan`s occasionally not being approved when attempting to upgrade a bundle. ([#5901](https://github.com/operator-framework/operator-sdk/pull/5901))
- For run bundle-upgrade, generate just the extra FBC of the bundle instead of rendering the entire index and appending bundle contents to it. ([#5891](https://github.com/operator-framework/operator-sdk/pull/5891))
- Honor `--skip-tls-verify` and `--use-http` flags from run bundle(-upgrade). ([#5921](https://github.com/operator-framework/operator-sdk/pull/5921))
