---
title: CRD Scope
linkTitle: CRD Scope
weight: 60
---

## Overview

This page details the various methods to control the scope of a CRD. See the [operator scope doc](/docs/building-operators/golang/operator-scope/) for information on configuring operator scope, such as which namespaces to watch.

Custom Resource Definitions (CRDs) contain a scope field that determines whether the resulting Custom Resource (CR)
is cluster or namespace scoped. An operator author might use a namespaced-scoped CRD
to restrict access to a CR to certain namespaces, or to have different versions of CRs accessible in different namespaces.
Alternatively, an operator author might want a cluster-scoped CRD so all namespaces have visibility and access to CRs.

The CRD manifests are generated by the `operator-sdk create api` command in `config/crd/bases`. A CRD's `spec.scope` field controls API scope; valid values are [`Cluster` and `Namespaced`](https://kubernetes.io/docs/tasks/extend-kubernetes/custom-resources/custom-resource-definitions/#create-a-customresourcedefinition).
For an Operator-sdk Go project, this value is determined by the `operator-sdk create api --namespaced` boolean flag, which edits the
`types.go` file for the resource. For other operator types, the command edits `spec.scope` in the CRD's YAML manifest directly.

## Set `create api` --namespaced flag

When creating a new API, the `--namespaced` flag controls whether the resulting CRD will be cluster or namespace scoped.
By default, `--namespaced` is set to `true` which sets the scope to `Namespaced`. An example command to create a cluster-scoped API would be:

```console
$ operator-sdk create api --group cache --version v1alpha1 --kind Memcached --resource=true --controller=true --namespaced=false
```

## Set Scope Marker in types.go

You can also manually set the scope in the Go `types.go` file by adding or changing the [kubebuilder scope marker][kubebuilder_crd_markers]
to your resource. This file is usually located in `api/<version>/<kind>_types.go` or `apis/<group>/<version>/<kind>_types.go` if
you are using the [multigroup][kubebuilder_multigroup] layout. Once this marker is set, the CRD files will be generated with the approriate scope.
Here is an example API type with the marker set to cluster scope:

```golang
//+kubebuilder:object:root=true
//+kubebuilder:subresource:status
//+kubebuilder:resource:scope=Cluster

// Memcached is the Schema for the memcacheds API
type Memcached struct {
	metav1.TypeMeta   `json:",inline"`
	metav1.ObjectMeta `json:"metadata,omitempty"`

	Spec   MemcachedSpec   `json:"spec,omitempty"`
	Status MemcachedStatus `json:"status,omitempty"`
}
```
To set the scope to namespaced, the marker would be set to `//+kubebuilder:resource:scope=Namespaced` instead.


## Set scope in CRD YAML file

The scope can be manually set directly in the CRD's Kind YAML file, normally located in  `config/crd/bases/<group>.<domain>_<kind>.yaml`.
An example YAML file for a namespace-scoped CRD is shown below:

```YAML
apiVersion: apiextensions.k8s.io/v1beta1
kind: CustomResourceDefinition
metadata:
  annotations:
    controller-gen.kubebuilder.io/version: v0.2.5
  creationTimestamp: null
  name: memcacheds.cache.example.com
spec:
  group: cache.example.com
  names:
    kind: Memcached
    listKind: MemcachedList
    plural: memcacheds
    singular: memcached
  scope: Namespaced
  subresources:
    status: {}
...   
``` 



[manager_options]: https://pkg.go.dev/sigs.k8s.io/controller-runtime/pkg/manager#Options
[manager_user_guide]:/docs/building-operators/golang/tutorial/#manager
[k8s_crd_scope]: https://kubernetes.io/docs/tasks/extend-kubernetes/custom-resources/custom-resource-definitions/#create-a-customresourcedefinition 
[kubebuilder_crd_markers]: https://book.kubebuilder.io/reference/markers/crd.html
[kubebuilder_multigroup]: https://book.kubebuilder.io/migration/multi-group.html
[RBAC]: https://kubernetes.io/docs/reference/access-authn-authz/rbac/
