---
title: v1.7.0
weight: 998993000
---

## Add the manager config patch to config/default/kustomization.yaml

The scaffolded `--config` flag was not added to either ansible-/helm-operator binary when [config file](https://master.book.kubebuilder.io/component-config-tutorial/tutorial.html) support was originally added, so does not currently work. The `--config` flag supports configuration of both binaries by file; this method of configuration only applies to the underlying [controller manager](https://pkg.go.dev/sigs.k8s.io/controller-runtime/pkg/manager#Manager), not the operator as a whole. To optionally configure the operator's Deployment with a config file, make the following update to config/default/kustomization.yaml:
```diff 
# If you want your controller-manager to expose the /metrics # endpoint w/o any authn/z, please comment the following line. 
- manager_auth_proxy_patch.yaml 
+# Mount the controller config file for loading manager configurations 
+# through a ComponentConfig type 
+- manager_config_patch.yaml 
```
This feature is opt-in: flags can be used as-is or to override config file values.

_See [#4776](https://github.com/operator-framework/operator-sdk/pull/4776) for more details._

## Deprecate support for packagemanifests.

The operator-framework is removing support for the packagemanifests format in the near future. Hence, `operator-sdk generate packagemanifests` and `operator-sdk run packagemanifests` commands are deprecated. In order to migrate packagemanifests to bundles, `operator-sdk pkgman-to-bundle` command can be used. Run `operator-sdk pkgman-to-bundle --help` for more details.

_See [#4838](https://github.com/operator-framework/operator-sdk/pull/4838) for more details._

## (go/v3, ansible/v1, helm/v1) Move `leases.coordination.k8s.io` to its own proxy-role rule

Make the following changes to config/rbac/leader_election_role.yaml:
```diff
rules: \- apiGroups:
  - ""
-  - coordination.k8s.io
  resources:
  - configmaps
+ verbs: 
+- get 
+- list 
+- watch 
+- create 
+- update 
+- patch 
+- delete 
+- apiGroups: 
+- coordination.k8s.io 
+ resources:
    - leases
  verbs:
    - get
```

_See [#4835](https://github.com/operator-framework/operator-sdk/pull/4835) for more details._

## (go/v3) Set the Makefile's `SHELL` variable to the system's `bash` binary

Importing `setup-envtest.sh` needs bash, so your Makefile's `SHELL` variable should be set to `bash` with error options:
```diff
else GOBIN=$(shell go env GOBIN)
endif
+# Setting SHELL to bash allows bash commands to be executed by recipes. 
+# This is a requirement for 'setup-envtest.sh' in the test target. 
+# Options are set to exit when a recipe line exits non-zero or a piped command fails. 
+SHELL = /usr/bin/env bash -o pipefail 
+.SHELLFLAGS = -ec 
+ all: build 
```
_See [#4835](https://github.com/operator-framework/operator-sdk/pull/4835) for more details._
