---
title: v1.21.0
weight: 998979000
---

## (go/v3):For golang-language based operators, fix suite test using global cfg

In the suite test files, replace `cfg, err := testEnv.Start()` with:

```go
var err error
// cfg is defined in this file globally.
cfg, err = testEnv.Start()
```

Note: You can find suite test files scaffold for the APIs created for your project
such as `api/webhook_suitetest.go` directory as for your controllers in `controllers/suite_test.go`.

_See [#4863](https://github.com/operator-framework/operator-sdk/pull/4863) for more details._

## For Golang-based operators, update Dockerfile if you are using the [declarative/v1 plugin](https://book.kubebuilder.io/plugins/declarative-v1.html)

If you are using the declarative/v1 plugin for your scaffolds, then following the steps to update the Dockerfile.
a) After `COPY controllers/ controllers/` add:

```sh
# https://github.com/kubernetes-sigs/kubebuilder-declarative-pattern/blob/master/docs/addon/walkthrough/README.md#adding-a-manifest
# Stage channels and make readable
COPY channels/ /channels/
RUN chmod -R a+rx /channels/
```

b)  After the `COPY --from=builder /workspace/manager .`" add:

```sh
# copy channels
COPY --from=builder /channels /channels
```

_See [#4863](https://github.com/operator-framework/operator-sdk/pull/4863) for more details._

## (go/v3):For Golang-based operators, upgrade controller-runtime from v0.11.0 to v0.11.2 and Kubernetes deps from 1.23.0 to 1.23.5

Update your go.mod by replacing `sigs.k8s.io/controller-runtime v0.11.0` with `sigs.k8s.io/controller-runtime v0.11.2` and run `go mod tidy`
to update the K8s dependencies.

_See [#4863](https://github.com/operator-framework/operator-sdk/pull/4863) for more details._

## For Golang/Helm/Ansible-based operators, upgrade kube-rbac-proxy image from v0.8.0 to v0.11.0. (For further information see the kube-rbac-proxy [release notes](https://github.com/brancz/kube-rbac-proxy/releases))

Update the tag version used for the image `gcr.io/kubebuilder/kube-rbac-proxy` in the file config/default/manager_auth_proxy_patch.yaml.
Replace `gcr.io/kubebuilder/kube-rbac-proxy:v0.8.0` with `gcr.io/kubebuilder/kube-rbac-proxy:v0.11.0`

_See [#4863](https://github.com/operator-framework/operator-sdk/pull/4863) for more details._

## For Golang-based operators,  change Makefile targets to replace go get with go install

The targets kustomize, controller-gen and envtest were changed. Update the Makefile replacing:

```sh
CONTROLLER_GEN = $(shell pwd)/bin/controller-gen
.PHONY: controller-gen
controller-gen: ## Download controller-gen locally if necessary.
	$(call go-get-tool,$(CONTROLLER_GEN),sigs.k8s.io/controller-tools/cmd/controller-gen@v0.8.0)

KUSTOMIZE = $(shell pwd)/bin/kustomize
.PHONY: kustomize
kustomize: ## Download kustomize locally if necessary.
	$(call go-get-tool,$(KUSTOMIZE),sigs.k8s.io/kustomize/kustomize/v3@v3.8.7)

ENVTEST = $(shell pwd)/bin/setup-envtest
.PHONY: envtest
envtest: ## Download envtest-setup locally if necessary.
	$(call go-get-tool,$(ENVTEST),sigs.k8s.io/controller-runtime/tools/setup-envtest@latest)

# go-get-tool will 'go get' any package $2 and install it to $1.
PROJECT_DIR := $(shell dirname $(abspath $(lastword $(MAKEFILE_LIST))))
define go-get-tool
@[ -f $(1) ] || { \
set -e ;\
TMP_DIR=$$(mktemp -d) ;\
cd $$TMP_DIR ;\
go mod init tmp ;\
echo "Downloading $(2)" ;\
GOBIN=$(PROJECT_DIR)/bin go get $(2) ;\
rm -rf $$TMP_DIR ;\
}
endef
```

With:

```sh
##@ Build Dependencies

## Location to install dependencies to
LOCALBIN ?= $(shell pwd)/bin
$(LOCALBIN):
	mkdir -p $(LOCALBIN)

## Tool Binaries
KUSTOMIZE ?= $(LOCALBIN)/kustomize
CONTROLLER_GEN ?= $(LOCALBIN)/controller-gen
ENVTEST ?= $(LOCALBIN)/setup-envtest

## Tool Versions
KUSTOMIZE_VERSION ?= v3.8.7
CONTROLLER_TOOLS_VERSION ?= v0.8.0

KUSTOMIZE_INSTALL_SCRIPT ?= "https://raw.githubusercontent.com/kubernetes-sigs/kustomize/master/hack/install_kustomize.sh"
.PHONY: kustomize
kustomize: $(KUSTOMIZE) ## Download kustomize locally if necessary.
$(KUSTOMIZE): $(LOCALBIN)
	curl -s $(KUSTOMIZE_INSTALL_SCRIPT) | bash -s -- $(subst v,,$(KUSTOMIZE_VERSION)) $(LOCALBIN)

.PHONY: controller-gen
controller-gen: $(CONTROLLER_GEN) ## Download controller-gen locally if necessary.
$(CONTROLLER_GEN): $(LOCALBIN)
	GOBIN=$(LOCALBIN) go install sigs.k8s.io/controller-tools/cmd/controller-gen@$(CONTROLLER_TOOLS_VERSION)

.PHONY: envtest
envtest: $(ENVTEST) ## Download envtest-setup locally if necessary.
$(ENVTEST): $(LOCALBIN)
	GOBIN=$(LOCALBIN) go install sigs.k8s.io/controller-runtime/tools/setup-envtest@latest
```

_See [#4863](https://github.com/operator-framework/operator-sdk/pull/4863) for more details._
