---
title: v1.16.0
weight: 998984000
---

## Ansible-based operators: add resource limits

Add into the `config/manager/manager.yaml` the following limits which are now scaffolded by default:
```yaml
 ... 
 # TODO(user): Configure the resources accordingly based on the project requirements. # More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/ resources:
  limits:
    cpu: 500m
    memory: 768Mi
  requests:
    cpu: 10m
    memory: 256Mi
```
**IMPORTANT:** Having resource limits is a best-practice and these values are reasonable defaults, but Operator authors should optimize these values based on their project's requirements.

_See [#5274](https://github.com/operator-framework/operator-sdk/pull/5274) for more details._

## Bump operator_sdk.util in requirements.yml

Update `requirements.yml` to point to 0.3.1 of operator_sdk.util instead of 0.2.0

_See [#5462](https://github.com/operator-framework/operator-sdk/pull/5462) for more details._

## Add annotation to specify the default container

Add the following annotation into the file `config/manager/manager.yaml`
```yaml
...
template:
  metadata:
    annotations:
      kubectl.kubernetes.io/default-container: manager
...
```

_See [#5330](https://github.com/operator-framework/operator-sdk/pull/5330) for more details._

## Add PHONY targets to Makefile

Add PHONY target to all Makefile targets. For example, refer to the `Makefile` in `operator-sdk/testdata` directory of [OperatorSDK](https://github.com/operator-framework/operator-sdk) tagged by the release containing this change.

_See [#5330](https://github.com/operator-framework/operator-sdk/pull/5330) for more details._

## For Golang-based projects, add the flag `ignore-not-found` into the Makefile for the `uninstall` and `undeploy` targets

Update the Makefile with the following changes. 
1) Above `##@ Deployment` add the following:
```
...
ifndef ignore-not-found
  ignore-not-found = false
endif
...
```
2) Replace: ```sh kubectl delete -f - ``` With: ```sh kubectl delete --ignore-not-found=$(ignore-not-found) -f - ``` 

**NOTE**  You can also compare your `Makefile` with the one tagged by this release, in `operator-sdk/testdata` of the [OperatorSDK](https://github.com/operator-framework/operator-sdk) project.

_See [#5330](https://github.com/operator-framework/operator-sdk/pull/5330) for more details._
