---
title: "operator-sdk generate bundle"
---
## operator-sdk generate bundle

Generates bundle data for the operator

### Synopsis


Running 'generate bundle' is the first step to publishing your operator to a catalog and deploying it with OLM.
This command both generates and packages files into an on-disk representation of an operator called a bundle.
A bundle consists of a ClusterServiceVersion (CSV), CustomResourceDefinitions (CRDs),
manifests not part of the CSV but required by the operator, some metadata (annotations.yaml),
and a bundle.Dockerfile to build a bundle image.

A CSV manifest is generated by collecting data from the set of manifests passed to this command (see below),
such as CRDs, RBAC, etc., and applying that data to a "base" CSV manifest. This base CSV can contain metadata,
added by hand or by the 'generate kustomize manifests' command, and can be passed in like any other manifest
(see below) or by file at the exact path '&lt;kustomize-dir&gt;/bases/&lt;package-name&gt;.clusterserviceversion.yaml'.
Be aware that 'generate bundle' idempotently regenerates a bundle, so all non-metadata values in a base
will be overwritten. If no base was passed in, input manifest data will be applied to an empty CSV.

There are two ways to pass the to-be-bundled set of manifests to this command: stdin via a Unix pipe,
or in a directory using '--input-dir'. See command help for more information on these modes.
Passing a directory is useful for running 'generate bundle' outside of a project or within a project
that does not use kustomize and/or contains cluster-ready manifests on disk.

Set '--version' to supply a semantic version for your bundle if you are creating one
for the first time or upgrading an existing one.

If '--output-dir' is set and you wish to build bundle images from that directory,
either manually update your bundle.Dockerfile or set '--overwrite'.

More information on bundles:
https://github.com/operator-framework/operator-registry/#manifest-format


```
operator-sdk generate bundle [flags]
```

### Examples

```

  # If running within a project or in a project that uses kustomize to generate manifests,
	# make sure a kustomize directory exists that looks like the following 'config/manifests' directory:
  $ tree config/manifests
  config/manifests
  ├── bases
  │   └── memcached-operator.clusterserviceversion.yaml
  └── kustomization.yaml

  # Generate a 0.0.1 bundle by passing manifests to stdin:
  $ kustomize build config/manifests | operator-sdk generate bundle --version 0.0.1
  Generating bundle version 0.0.1
  ...

  # If running outside of a project or in a project that does not use kustomize to generate manifests,
	# make sure cluster-ready manifests are available on disk:
  $ tree deploy/
  deploy/
  ├── crds
  │   └── cache.my.domain_memcacheds.yaml
  ├── deployment.yaml
  ├── role.yaml
  ├── role_binding.yaml
  ├── service_account.yaml
  └── webhooks.yaml

  # Generate a 0.0.1 bundle by passing manifests by dir:
  $ operator-sdk generate bundle --input-dir deploy --version 0.0.1
  Generating bundle version 0.0.1
  ...

  # After running in either of the above modes, you should see this directory structure:
  $ tree bundle/
  bundle/
  ├── manifests
  │   ├── cache.my.domain_memcacheds.yaml
  │   └── memcached-operator.clusterserviceversion.yaml
  └── metadata
      └── annotations.yaml

```

### Options

```
      --channels string                  A comma-separated list of channels the bundle belongs to (default "alpha")
      --crds-dir string                  Directory to read cluster-ready CustomResoureDefinition manifests from. This option can only be used if --deploy-dir is set
      --default-channel string           The default channel for the bundle
      --deploy-dir string                Directory to read cluster-ready operator manifests from. If --crds-dir is not set, CRDs are ready from this directory. This option is mutually exclusive with --input-dir and piping to stdin
      --extra-service-accounts strings   Names of service accounts, outside of the operator's Deployment account, that have bindings to {Cluster}Roles that should be added to the CSV
  -h, --help                             help for bundle
      --input-dir string                 Directory to read cluster-ready operator manifests from. This option is mutually exclusive with --deploy-dir/--crds-dir and piping to stdin. This option should not be passed an existing bundle directory, as this bundle will not contain the correct set of manifests required to generate a CSV. Use --kustomize-dir to pass a base CSV
      --kustomize-dir string             Directory containing kustomize bases in a "bases" dir and a kustomization.yaml for operator-framework manifests (default "config/manifests")
      --manifests                        Generate bundle manifests
      --metadata                         Generate bundle metadata and Dockerfile
      --output-dir string                Directory to write the bundle to
      --overwrite                        Overwrite the bundle's metadata and Dockerfile if they exist (default true)
      --package string                   Bundle's package name
  -q, --quiet                            Run in quiet mode
      --stdout                           Write bundle manifest to stdout
      --use-image-digests                Use SHA Digest for images
  -v, --version string                   Semantic version of the operator in the generated bundle. Only set if creating a new bundle or upgrading your operator
```

### Options inherited from parent commands

```
      --plugins strings   plugin keys to be used for this subcommand execution
      --verbose           Enable verbose logging
```

### SEE ALSO

* [operator-sdk generate](../operator-sdk_generate)	 - Invokes a specific generator

