# low
low level data type and utils in Golang.

[![Travis-CI](https://api.travis-ci.org/openacid/low.svg?branch=master)](https://travis-ci.org/openacid/low)
[![AppVeyor](https://ci.appveyor.com/api/projects/status/1jnttodaenbrv3va/branch/master?svg=true)](https://ci.appveyor.com/project/drmingdrmer/low/branch/master)
[![GoDoc](https://godoc.org/github.com/openacid/low?status.svg)](http://godoc.org/github.com/openacid/low)
[![Report card](https://goreportcard.com/badge/github.com/openacid/low)](https://goreportcard.com/report/github.com/openacid/low)
[![GolangCI](https://golangci.com/badges/github.com/openacid/low.svg)](https://golangci.com/r/github.com/openacid/low)
[![Sourcegraph](https://sourcegraph.com/github.com/openacid/low/-/badge.svg)](https://sourcegraph.com/github.com/openacid/low?badge)
[![Coverage Status](https://coveralls.io/repos/github/openacid/low/badge.svg?branch=master)](https://coveralls.io/github/openacid/low?branch=master)

A stable low level function set is the basis of a robust architecture.
It focuses on stability and requires high test coverage.

# Status

![stability-stable](https://img.shields.io/badge/stability-stable-green.svg)

This project has been supporting all of our other go projects.

# Install

```sh
go get github.com/openacid/low/...
```

# Modules

-   `bitmap` provides bitmap operations.  [![GoDoc](https://godoc.org/github.com/openacid/low/bitmap?status.svg)](http://godoc.org/github.com/openacid/low/bitmap)
-   `bitword` provides n-bit word conversion to and from string.  [![GoDoc](https://godoc.org/github.com/openacid/low/bitword?status.svg)](http://godoc.org/github.com/openacid/low/bitword)
-   `bmtree` encode a binary tree into a bitmap. [![GoDoc](https://godoc.org/github.com/openacid/low/bmtree?status.svg)](http://godoc.org/github.com/openacid/low/bmtree)
-   `iohelper` provides extra interfaces than package io.  [![GoDoc](https://godoc.org/github.com/openacid/low/iohelper?status.svg)](http://godoc.org/github.com/openacid/low/iohelper)
-   `pbcmpl` adds a header for proto.Message to make it self-described.  [![GoDoc](https://godoc.org/github.com/openacid/low/pbcmpl?status.svg)](http://godoc.org/github.com/openacid/low/pbcmpl)
-   `sigbits` extracts significant bits from a sorted list of strings..  [![GoDoc](https://godoc.org/github.com/openacid/low/sigbits?status.svg)](http://godoc.org/github.com/openacid/low/sigbits)
-   `size` provides value size operations.  [![GoDoc](https://godoc.org/github.com/openacid/low/size?status.svg)](http://godoc.org/github.com/openacid/low/size)
-   `tree` provides abstract tree operations.  [![GoDoc](https://godoc.org/github.com/openacid/low/tree?status.svg)](http://godoc.org/github.com/openacid/low/tree)
