# OpenACID's Code of Conduct

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->


- [Why have a Code of Conduct?](#why-have-a-code-of-conduct)
- [Our Standards](#our-standards)
- [Social Rules](#social-rules)
  - [No feigning surprise](#no-feigning-surprise)
  - [No condescending well-actually’s](#no-condescending-well-actually%E2%80%99s)
  - [No backseat driving](#no-backseat-driving)
  - [No subtle -isms](#no-subtle--isms)
- [Giving and Receiving Feedback](#giving-and-receiving-feedback)
- [Enforcement](#enforcement)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

## Why have a Code of Conduct?

This Code of Conduct is designed to help all of us build a pleasant, productive,
and fearless community.

We are striving to make our community a great group of people to work with.

This Code of Conduct applies both within project spaces and in public spaces
when an individual is representing the project or its community.


## Our Standards

Examples of behavior that contributes to creating a positive environment
include:

* Using welcoming and inclusive language
* Being respectful of differing viewpoints and experiences
* Gracefully accepting constructive criticism
* Focusing on what is best for the community
* Showing empathy towards other community members

Examples of unacceptable behavior by participants include:

* The use of sexualized language or imagery and unwelcome sexual attention or
  advances
* Trolling, insulting/derogatory comments, and personal or political attacks
* Public or private harassment
* Publishing others' private information, such as a physical or electronic
  address, without explicit permission
* Other conduct which could reasonably be considered inappropriate in a
  professional setting


## Social Rules


### No feigning surprise

**The first rule means you shouldn't act surprised when people say they don't know
something**.

This applies to both technical things ("What?! I can't believe you
don't know what the stack is!") and non-technical things ("You don't know who
RMS is?!").

Feigning surprise has absolutely no social or educational benefit: When people
feign surprise, it's usually to make them feel better about themselves and
others feel worse.
And even when that's not the intention, it's almost always the effect.

As you've probably already guessed, this rule is tightly coupled to our belief
in the importance of people **feeling comfortable saying "I don't know" and "I
don't understand."**


### No condescending well-actually’s

**A well-actually happens when someone says something that's almost— but not
entirely— correct, and you say, "well, actually…" and then give a minor
correction**.

Even in complicated environments where small details and edge-cases can be
forgotten, unless they are critical, they should not be interjected.

If they are critical to the conversation phrasing can be the difference between
a valuable clarification and condescension e.g. instead of “well actually …” a
simple change to “don’t forget …” or “it’s easy to forget …”


### No backseat driving

**If you overhear people working through a problem, you shouldn't intermittently
lob advice across the room**.

This can lead to the "too many cooks" problem, but more important, it can be
rude and disruptive to half-participate in a conversation.
This is particularly true in a distributed environment involving conversations
in Slack.
The occasional interjection to an on-going conversation, particularly based on
backscroll, can be very disruptive.

This isn't to say you shouldn't help, offer advice, or join conversations.
On the contrary, we encourage all those things.
Rather, it just means that when you want to help out or work with others, you
should fully engage and not just interject sporadically.


### No subtle -isms

**Subtle -isms, also called microaggressions, are small things that make others
feel uncomfortable**, for example, saying "It's so easy my grandmother could do
it" is a subtle -ism, as it is both subtly sexist and ageist.

The "subtle" in "subtle -isms" means that it's probably not obvious to everyone
right away what was wrong with the comment, even people in the group otherwise
affected by the comment.
And, even though they are subtle, might seem insignificant, and are
often unintentional, a steady stream of them compounds to make people in
under-represented groups feel less welcome.


## Giving and Receiving Feedback

**Give constructive, not critical feedback**.

Feedback is negatively critical when it surfaces something wrong with someone or
something they produced, especially without any mention of ways to make their
behavior or their product better.

- **Critical feedback** on work often looks like "you don't write enough tests" or
  "your code quality isn't good enough".
  Personal criticism can be more severe and often looks like "you should be less
  judgemental" or "you are a burden because you ask too many questions”.

- **Constructive feedback** is more about how a person can do better rather than what
  they are doing wrong.
  If you want someone to do something better, you should tell them what better
  looks like.
  Ask a question to get a discussion rolling, to gain context, and then if you see
  room for improvement give declarative feedback to that effect.

  This creates an environment where people understand what success looks like
  instead of just feeling like they are unsuccessful.

**Code, configurations, and their reviews are also mechanisms for communication**.

Just as you shouldn't interact with people poorly in person, do not interact
poorly through code or code review.

**You are not your products**.
Technical critiques are integral, and should be hard on the product, not on the
producer.
While it is important to care about your work and producing the best thing you
can, this can make review difficult.
It is important to realize that it’s better to find errors in review than in
production and recognize that your work fits into a larger whole.

**Go about your review under the assumption that the decisions were made for a
reason, not in a vacuum**.
Ask about circumstances if you’re confused.

Be pragmatic, ask for context, don’t filibuster, don’t block on style not
explicitly covered in DO’s style guides.

Code, configurations, architecture, platforms, frameworks will need to be
changed. Fight for your way if you think it’s right, **but not only to be right**.


## Enforcement

Enforcement of the Code of Conduct is essential.

If there is no enforcement, then the Code of Conduct becomes a feel-good
document without value.
