// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: opentelemetry/proto/metrics/v1/metrics.proto

package v1

import (
	encoding_binary "encoding/binary"
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	v11 "go.opentelemetry.io/otel/exporters/otlp/internal/opentelemetry-proto-gen/common/v1"
	v1 "go.opentelemetry.io/otel/exporters/otlp/internal/opentelemetry-proto-gen/resource/v1"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// Type is the type of values a metric has.
type MetricDescriptor_Type int32

const (
	// INVALID_TYPE is the default Type, it MUST not be used.
	MetricDescriptor_INVALID_TYPE MetricDescriptor_Type = 0
	// INT64 values are signed 64-bit integers.
	//
	// A Metric of this Type MUST store its values as Int64DataPoint.
	MetricDescriptor_INT64 MetricDescriptor_Type = 1
	// MONOTONIC_INT64 values are monotonically increasing signed 64-bit
	// integers.
	//
	// A Metric of this Type MUST store its values as Int64DataPoint.
	MetricDescriptor_MONOTONIC_INT64 MetricDescriptor_Type = 2
	// DOUBLE values are double-precision floating-point numbers.
	//
	// A Metric of this Type MUST store its values as DoubleDataPoint.
	MetricDescriptor_DOUBLE MetricDescriptor_Type = 3
	// MONOTONIC_DOUBLE values are monotonically increasing double-precision
	// floating-point numbers.
	//
	// A Metric of this Type MUST store its values as DoubleDataPoint.
	MetricDescriptor_MONOTONIC_DOUBLE MetricDescriptor_Type = 4
	// Histogram measurement.
	// Corresponding values are stored in HistogramDataPoint.
	MetricDescriptor_HISTOGRAM MetricDescriptor_Type = 5
	// Summary value. Some frameworks implemented Histograms as a summary of observations
	// (usually things like request durations and response sizes). While it
	// also provides a total count of observations and a sum of all observed
	// values, it calculates configurable percentiles over a sliding time
	// window.
	// Corresponding values are stored in SummaryDataPoint.
	MetricDescriptor_SUMMARY MetricDescriptor_Type = 6
)

var MetricDescriptor_Type_name = map[int32]string{
	0: "INVALID_TYPE",
	1: "INT64",
	2: "MONOTONIC_INT64",
	3: "DOUBLE",
	4: "MONOTONIC_DOUBLE",
	5: "HISTOGRAM",
	6: "SUMMARY",
}

var MetricDescriptor_Type_value = map[string]int32{
	"INVALID_TYPE":     0,
	"INT64":            1,
	"MONOTONIC_INT64":  2,
	"DOUBLE":           3,
	"MONOTONIC_DOUBLE": 4,
	"HISTOGRAM":        5,
	"SUMMARY":          6,
}

func (x MetricDescriptor_Type) String() string {
	return proto.EnumName(MetricDescriptor_Type_name, int32(x))
}

func (MetricDescriptor_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{3, 0}
}

// Temporality is the temporal quality values of a metric have. It
// describes how those values relate to the time interval over which they
// are reported.
type MetricDescriptor_Temporality int32

const (
	// INVALID_TEMPORALITY is the default Temporality, it MUST not be
	// used.
	MetricDescriptor_INVALID_TEMPORALITY MetricDescriptor_Temporality = 0
	// INSTANTANEOUS is a metric whose values are measured at a particular
	// instant. The values are not aggregated over any time interval and are
	// unique per timestamp. As such, these metrics are not expected to have
	// an associated start time.
	MetricDescriptor_INSTANTANEOUS MetricDescriptor_Temporality = 1
	// DELTA is a metric whose values are the aggregation of measurements
	// made over a time interval. Successive metrics contain aggregation of
	// values from continuous and non-overlapping intervals.
	//
	// The values for a DELTA metric are based only on the time interval
	// associated with one measurement cycle. There is no dependency on
	// previous measurements like is the case for CUMULATIVE metrics.
	//
	// For example, consider a system measuring the number of requests that
	// it receives and reports the sum of these requests every second as a
	// DELTA metric:
	//
	//   1. The system starts receiving at time=t_0.
	//   2. A request is received, the system measures 1 request.
	//   3. A request is received, the system measures 1 request.
	//   4. A request is received, the system measures 1 request.
	//   5. The 1 second collection cycle ends. A metric is exported for the
	//      number of requests received over the interval of time t_0 to
	//      t_0+1 with a value of 3.
	//   6. A request is received, the system measures 1 request.
	//   7. A request is received, the system measures 1 request.
	//   8. The 1 second collection cycle ends. A metric is exported for the
	//      number of requests received over the interval of time t_0+1 to
	//      t_0+2 with a value of 2.
	MetricDescriptor_DELTA MetricDescriptor_Temporality = 2
	// CUMULATIVE is a metric whose values are the aggregation of
	// successively made measurements from a fixed start time until the last
	// reported measurement. This means that current values of a CUMULATIVE
	// metric depend on all previous measurements since the start time.
	// Because of this, the sender is required to retain this state in some
	// form. If this state is lost or invalidated, the CUMULATIVE metric
	// values MUST be reset and a new fixed start time following the last
	// reported measurement time sent MUST be used.
	//
	// For example, consider a system measuring the number of requests that
	// it receives and reports the sum of these requests every second as a
	// CUMULATIVE metric:
	//
	//   1. The system starts receiving at time=t_0.
	//   2. A request is received, the system measures 1 request.
	//   3. A request is received, the system measures 1 request.
	//   4. A request is received, the system measures 1 request.
	//   5. The 1 second collection cycle ends. A metric is exported for the
	//      number of requests received over the interval of time t_0 to
	//      t_0+1 with a value of 3.
	//   6. A request is received, the system measures 1 request.
	//   7. A request is received, the system measures 1 request.
	//   8. The 1 second collection cycle ends. A metric is exported for the
	//      number of requests received over the interval of time t_0 to
	//      t_0+2 with a value of 5.
	//   9. The system experiences a fault and loses state.
	//   10. The system recovers and resumes receiving at time=t_1.
	//   11. A request is received, the system measures 1 request.
	//   12. The 1 second collection cycle ends. A metric is exported for the
	//      number of requests received over the interval of time t_1 to
	//      t_0+1 with a value of 1.
	MetricDescriptor_CUMULATIVE MetricDescriptor_Temporality = 3
)

var MetricDescriptor_Temporality_name = map[int32]string{
	0: "INVALID_TEMPORALITY",
	1: "INSTANTANEOUS",
	2: "DELTA",
	3: "CUMULATIVE",
}

var MetricDescriptor_Temporality_value = map[string]int32{
	"INVALID_TEMPORALITY": 0,
	"INSTANTANEOUS":       1,
	"DELTA":               2,
	"CUMULATIVE":          3,
}

func (x MetricDescriptor_Temporality) String() string {
	return proto.EnumName(MetricDescriptor_Temporality_name, int32(x))
}

func (MetricDescriptor_Temporality) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{3, 1}
}

// A collection of InstrumentationLibraryMetrics from a Resource.
type ResourceMetrics struct {
	// The resource for the metrics in this message.
	// If this field is not set then no resource info is known.
	Resource *v1.Resource `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	// A list of metrics that originate from a resource.
	InstrumentationLibraryMetrics []*InstrumentationLibraryMetrics `protobuf:"bytes,2,rep,name=instrumentation_library_metrics,json=instrumentationLibraryMetrics,proto3" json:"instrumentation_library_metrics,omitempty"`
	XXX_NoUnkeyedLiteral          struct{}                         `json:"-"`
	XXX_unrecognized              []byte                           `json:"-"`
	XXX_sizecache                 int32                            `json:"-"`
}

func (m *ResourceMetrics) Reset()         { *m = ResourceMetrics{} }
func (m *ResourceMetrics) String() string { return proto.CompactTextString(m) }
func (*ResourceMetrics) ProtoMessage()    {}
func (*ResourceMetrics) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{0}
}
func (m *ResourceMetrics) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResourceMetrics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResourceMetrics.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResourceMetrics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResourceMetrics.Merge(m, src)
}
func (m *ResourceMetrics) XXX_Size() int {
	return m.Size()
}
func (m *ResourceMetrics) XXX_DiscardUnknown() {
	xxx_messageInfo_ResourceMetrics.DiscardUnknown(m)
}

var xxx_messageInfo_ResourceMetrics proto.InternalMessageInfo

func (m *ResourceMetrics) GetResource() *v1.Resource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *ResourceMetrics) GetInstrumentationLibraryMetrics() []*InstrumentationLibraryMetrics {
	if m != nil {
		return m.InstrumentationLibraryMetrics
	}
	return nil
}

// A collection of Metrics produced by an InstrumentationLibrary.
type InstrumentationLibraryMetrics struct {
	// The instrumentation library information for the metrics in this message.
	// If this field is not set then no library info is known.
	InstrumentationLibrary *v11.InstrumentationLibrary `protobuf:"bytes,1,opt,name=instrumentation_library,json=instrumentationLibrary,proto3" json:"instrumentation_library,omitempty"`
	// A list of metrics that originate from an instrumentation library.
	Metrics              []*Metric `protobuf:"bytes,2,rep,name=metrics,proto3" json:"metrics,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *InstrumentationLibraryMetrics) Reset()         { *m = InstrumentationLibraryMetrics{} }
func (m *InstrumentationLibraryMetrics) String() string { return proto.CompactTextString(m) }
func (*InstrumentationLibraryMetrics) ProtoMessage()    {}
func (*InstrumentationLibraryMetrics) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{1}
}
func (m *InstrumentationLibraryMetrics) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *InstrumentationLibraryMetrics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_InstrumentationLibraryMetrics.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *InstrumentationLibraryMetrics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstrumentationLibraryMetrics.Merge(m, src)
}
func (m *InstrumentationLibraryMetrics) XXX_Size() int {
	return m.Size()
}
func (m *InstrumentationLibraryMetrics) XXX_DiscardUnknown() {
	xxx_messageInfo_InstrumentationLibraryMetrics.DiscardUnknown(m)
}

var xxx_messageInfo_InstrumentationLibraryMetrics proto.InternalMessageInfo

func (m *InstrumentationLibraryMetrics) GetInstrumentationLibrary() *v11.InstrumentationLibrary {
	if m != nil {
		return m.InstrumentationLibrary
	}
	return nil
}

func (m *InstrumentationLibraryMetrics) GetMetrics() []*Metric {
	if m != nil {
		return m.Metrics
	}
	return nil
}

// Defines a Metric which has one or more timeseries.
//
// The data model and relation between entities is shown in the diagram below.
//
// - Metric is composed of a MetricDescriptor and a list of data points.
// - MetricDescriptor contains a list of label keys (shown horizontally).
// - Data is a list of DataPoints (shown vertically).
// - DataPoint contains a list of label values and a value.
//
//     Metric
//  +----------+         +------------------------+
//  |descriptor|-------->| MetricDescriptor       |
//  |          |         |+-----+-----+   +-----+ |
//  |          |         ||label|label|...|label| |
//  |      data|--+      ||key1 |key2 |   |keyN | |
//  +----------+  |      |+-----+-----+   +-----+ |
//                |      +------------------------+
//                |
//                |      +---------------------------+
//                |      |DataPoint 1                |
//                v      |+------+------+   +------+ |
//             +-----+   ||label |label |...|label | |
//             |  1  |-->||value1|value2|...|valueN| |
//             +-----+   |+------+------+   +------+ |
//             |  .  |   |+-----+                    |
//             |  .  |   ||value|                    |
//             |  .  |   |+-----+                    |
//             |  .  |   +---------------------------+
//             |  .  |                   .
//             |  .  |                   .
//             |  .  |                   .
//             |  .  |   +---------------------------+
//             |  .  |   |DataPoint M                |
//             +-----+   |+------+------+   +------+ |
//             |  M  |-->||label |label |...|label | |
//             +-----+   ||value1|value2|...|valueN| |
//                       |+------+------+   +------+ |
//                       |+-----+                    |
//                       ||value|                    |
//                       |+-----+                    |
//                       +---------------------------+
//
//-----------------------------------------------------------------------
// DataPoint is a value of specific type corresponding to a given moment in
// time. Each DataPoint is timestamped.
//
// DataPoint is strongly typed: each DataPoint type has a specific Protobuf message
// depending on the value type of the metric and thus there are currently 4 DataPoint
// messages, which correspond to the types of metric values.
type Metric struct {
	// metric_descriptor describes the Metric.
	MetricDescriptor *MetricDescriptor `protobuf:"bytes,1,opt,name=metric_descriptor,json=metricDescriptor,proto3" json:"metric_descriptor,omitempty"`
	// Data is a list of one or more DataPoints for a single metric. Only one of the
	// following fields is used for the data, depending on the type of the metric defined
	// by MetricDescriptor.type field.
	Int64DataPoints      []*Int64DataPoint     `protobuf:"bytes,2,rep,name=int64_data_points,json=int64DataPoints,proto3" json:"int64_data_points,omitempty"`
	DoubleDataPoints     []*DoubleDataPoint    `protobuf:"bytes,3,rep,name=double_data_points,json=doubleDataPoints,proto3" json:"double_data_points,omitempty"`
	HistogramDataPoints  []*HistogramDataPoint `protobuf:"bytes,4,rep,name=histogram_data_points,json=histogramDataPoints,proto3" json:"histogram_data_points,omitempty"`
	SummaryDataPoints    []*SummaryDataPoint   `protobuf:"bytes,5,rep,name=summary_data_points,json=summaryDataPoints,proto3" json:"summary_data_points,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *Metric) Reset()         { *m = Metric{} }
func (m *Metric) String() string { return proto.CompactTextString(m) }
func (*Metric) ProtoMessage()    {}
func (*Metric) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{2}
}
func (m *Metric) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Metric) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Metric.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Metric) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metric.Merge(m, src)
}
func (m *Metric) XXX_Size() int {
	return m.Size()
}
func (m *Metric) XXX_DiscardUnknown() {
	xxx_messageInfo_Metric.DiscardUnknown(m)
}

var xxx_messageInfo_Metric proto.InternalMessageInfo

func (m *Metric) GetMetricDescriptor() *MetricDescriptor {
	if m != nil {
		return m.MetricDescriptor
	}
	return nil
}

func (m *Metric) GetInt64DataPoints() []*Int64DataPoint {
	if m != nil {
		return m.Int64DataPoints
	}
	return nil
}

func (m *Metric) GetDoubleDataPoints() []*DoubleDataPoint {
	if m != nil {
		return m.DoubleDataPoints
	}
	return nil
}

func (m *Metric) GetHistogramDataPoints() []*HistogramDataPoint {
	if m != nil {
		return m.HistogramDataPoints
	}
	return nil
}

func (m *Metric) GetSummaryDataPoints() []*SummaryDataPoint {
	if m != nil {
		return m.SummaryDataPoints
	}
	return nil
}

// Defines a metric type and its schema.
type MetricDescriptor struct {
	// name of the metric, including its DNS name prefix. It must be unique.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// description of the metric, which can be used in documentation.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// unit in which the metric value is reported. Follows the format
	// described by http://unitsofmeasure.org/ucum.html.
	Unit string `protobuf:"bytes,3,opt,name=unit,proto3" json:"unit,omitempty"`
	// type is the type of values this metric has.
	Type MetricDescriptor_Type `protobuf:"varint,4,opt,name=type,proto3,enum=opentelemetry.proto.metrics.v1.MetricDescriptor_Type" json:"type,omitempty"`
	// temporality is the Temporality of values this metric has.
	Temporality          MetricDescriptor_Temporality `protobuf:"varint,5,opt,name=temporality,proto3,enum=opentelemetry.proto.metrics.v1.MetricDescriptor_Temporality" json:"temporality,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *MetricDescriptor) Reset()         { *m = MetricDescriptor{} }
func (m *MetricDescriptor) String() string { return proto.CompactTextString(m) }
func (*MetricDescriptor) ProtoMessage()    {}
func (*MetricDescriptor) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{3}
}
func (m *MetricDescriptor) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MetricDescriptor) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MetricDescriptor.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MetricDescriptor) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MetricDescriptor.Merge(m, src)
}
func (m *MetricDescriptor) XXX_Size() int {
	return m.Size()
}
func (m *MetricDescriptor) XXX_DiscardUnknown() {
	xxx_messageInfo_MetricDescriptor.DiscardUnknown(m)
}

var xxx_messageInfo_MetricDescriptor proto.InternalMessageInfo

func (m *MetricDescriptor) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *MetricDescriptor) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *MetricDescriptor) GetUnit() string {
	if m != nil {
		return m.Unit
	}
	return ""
}

func (m *MetricDescriptor) GetType() MetricDescriptor_Type {
	if m != nil {
		return m.Type
	}
	return MetricDescriptor_INVALID_TYPE
}

func (m *MetricDescriptor) GetTemporality() MetricDescriptor_Temporality {
	if m != nil {
		return m.Temporality
	}
	return MetricDescriptor_INVALID_TEMPORALITY
}

// Int64DataPoint is a single data point in a timeseries that describes the time-varying
// values of a int64 metric.
type Int64DataPoint struct {
	// The set of labels that uniquely identify this timeseries.
	Labels []*v11.StringKeyValue `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty"`
	// start_time_unix_nano is the time when the cumulative value was reset to zero.
	// This is used for Counter type only. For Gauge the value is not specified and
	// defaults to 0.
	//
	// The cumulative value is over the time interval (start_time_unix_nano, time_unix_nano].
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
	//
	// Value of 0 indicates that the timestamp is unspecified. In that case the timestamp
	// may be decided by the backend.
	StartTimeUnixNano uint64 `protobuf:"fixed64,2,opt,name=start_time_unix_nano,json=startTimeUnixNano,proto3" json:"start_time_unix_nano,omitempty"`
	// time_unix_nano is the moment when this value was recorded.
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
	TimeUnixNano uint64 `protobuf:"fixed64,3,opt,name=time_unix_nano,json=timeUnixNano,proto3" json:"time_unix_nano,omitempty"`
	// value itself.
	Value                int64    `protobuf:"varint,4,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Int64DataPoint) Reset()         { *m = Int64DataPoint{} }
func (m *Int64DataPoint) String() string { return proto.CompactTextString(m) }
func (*Int64DataPoint) ProtoMessage()    {}
func (*Int64DataPoint) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{4}
}
func (m *Int64DataPoint) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Int64DataPoint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Int64DataPoint.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Int64DataPoint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Int64DataPoint.Merge(m, src)
}
func (m *Int64DataPoint) XXX_Size() int {
	return m.Size()
}
func (m *Int64DataPoint) XXX_DiscardUnknown() {
	xxx_messageInfo_Int64DataPoint.DiscardUnknown(m)
}

var xxx_messageInfo_Int64DataPoint proto.InternalMessageInfo

func (m *Int64DataPoint) GetLabels() []*v11.StringKeyValue {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Int64DataPoint) GetStartTimeUnixNano() uint64 {
	if m != nil {
		return m.StartTimeUnixNano
	}
	return 0
}

func (m *Int64DataPoint) GetTimeUnixNano() uint64 {
	if m != nil {
		return m.TimeUnixNano
	}
	return 0
}

func (m *Int64DataPoint) GetValue() int64 {
	if m != nil {
		return m.Value
	}
	return 0
}

// DoubleDataPoint is a single data point in a timeseries that describes the time-varying
// value of a double metric.
type DoubleDataPoint struct {
	// The set of labels that uniquely identify this timeseries.
	Labels []*v11.StringKeyValue `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty"`
	// start_time_unix_nano is the time when the cumulative value was reset to zero.
	// This is used for Counter type only. For Gauge the value is not specified and
	// defaults to 0.
	//
	// The cumulative value is over the time interval (start_time_unix_nano, time_unix_nano].
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
	//
	// Value of 0 indicates that the timestamp is unspecified. In that case the timestamp
	// may be decided by the backend.
	StartTimeUnixNano uint64 `protobuf:"fixed64,2,opt,name=start_time_unix_nano,json=startTimeUnixNano,proto3" json:"start_time_unix_nano,omitempty"`
	// time_unix_nano is the moment when this value was recorded.
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
	TimeUnixNano uint64 `protobuf:"fixed64,3,opt,name=time_unix_nano,json=timeUnixNano,proto3" json:"time_unix_nano,omitempty"`
	// value itself.
	Value                float64  `protobuf:"fixed64,4,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DoubleDataPoint) Reset()         { *m = DoubleDataPoint{} }
func (m *DoubleDataPoint) String() string { return proto.CompactTextString(m) }
func (*DoubleDataPoint) ProtoMessage()    {}
func (*DoubleDataPoint) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{5}
}
func (m *DoubleDataPoint) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DoubleDataPoint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DoubleDataPoint.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DoubleDataPoint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DoubleDataPoint.Merge(m, src)
}
func (m *DoubleDataPoint) XXX_Size() int {
	return m.Size()
}
func (m *DoubleDataPoint) XXX_DiscardUnknown() {
	xxx_messageInfo_DoubleDataPoint.DiscardUnknown(m)
}

var xxx_messageInfo_DoubleDataPoint proto.InternalMessageInfo

func (m *DoubleDataPoint) GetLabels() []*v11.StringKeyValue {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *DoubleDataPoint) GetStartTimeUnixNano() uint64 {
	if m != nil {
		return m.StartTimeUnixNano
	}
	return 0
}

func (m *DoubleDataPoint) GetTimeUnixNano() uint64 {
	if m != nil {
		return m.TimeUnixNano
	}
	return 0
}

func (m *DoubleDataPoint) GetValue() float64 {
	if m != nil {
		return m.Value
	}
	return 0
}

// HistogramDataPoint is a single data point in a timeseries that describes the time-varying
// values of a Histogram. A Histogram contains summary statistics for a population of values,
// it may optionally contain the distribution of those values across a set of buckets.
type HistogramDataPoint struct {
	// The set of labels that uniquely identify this timeseries.
	Labels []*v11.StringKeyValue `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty"`
	// start_time_unix_nano is the time when the cumulative value was reset to zero.
	//
	// The cumulative value is over the time interval (start_time_unix_nano, time_unix_nano].
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
	//
	// Value of 0 indicates that the timestamp is unspecified. In that case the timestamp
	// may be decided by the backend.
	// Note: this field is always unspecified and ignored if MetricDescriptor.type==GAUGE_HISTOGRAM.
	StartTimeUnixNano uint64 `protobuf:"fixed64,2,opt,name=start_time_unix_nano,json=startTimeUnixNano,proto3" json:"start_time_unix_nano,omitempty"`
	// time_unix_nano is the moment when this value was recorded.
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
	TimeUnixNano uint64 `protobuf:"fixed64,3,opt,name=time_unix_nano,json=timeUnixNano,proto3" json:"time_unix_nano,omitempty"`
	// count is the number of values in the population. Must be non-negative. This value
	// must be equal to the sum of the "count" fields in buckets if a histogram is provided.
	Count uint64 `protobuf:"varint,4,opt,name=count,proto3" json:"count,omitempty"`
	// sum of the values in the population. If count is zero then this field
	// must be zero. This value must be equal to the sum of the "sum" fields in buckets if
	// a histogram is provided.
	Sum float64 `protobuf:"fixed64,5,opt,name=sum,proto3" json:"sum,omitempty"`
	// buckets is an optional field contains the values of histogram for each bucket.
	//
	// The sum of the values in the buckets "count" field must equal the value in the count field.
	//
	// The number of elements in buckets array must be by one greater than the
	// number of elements in bucket_bounds array.
	//
	// Note: if HistogramDataPoint.bucket_options defines bucket bounds then this field
	// must also be present and number of elements in this field must be equal to the
	// number of buckets defined by bucket_options.
	Buckets []*HistogramDataPoint_Bucket `protobuf:"bytes,6,rep,name=buckets,proto3" json:"buckets,omitempty"`
	// explicit_bounds specifies buckets with explicitly defined bounds for values.
	// The bucket boundaries are described by "bounds" field.
	//
	// This defines size(bounds) + 1 (= N) buckets. The boundaries for bucket
	// at index i are:
	//
	// [0, bounds[i]) for i == 0
	// [bounds[i-1], bounds[i]) for 0 < i < N-1
	// [bounds[i], +infinity) for i == N-1
	// The values in bounds array must be strictly increasing and > 0.
	//
	// Note: only [a, b) intervals are currently supported for each bucket. If we decides
	// to also support (a, b] intervals we should add support for these by defining a boolean
	// value which decides what type of intervals to use.
	ExplicitBounds       []float64 `protobuf:"fixed64,7,rep,packed,name=explicit_bounds,json=explicitBounds,proto3" json:"explicit_bounds,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *HistogramDataPoint) Reset()         { *m = HistogramDataPoint{} }
func (m *HistogramDataPoint) String() string { return proto.CompactTextString(m) }
func (*HistogramDataPoint) ProtoMessage()    {}
func (*HistogramDataPoint) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{6}
}
func (m *HistogramDataPoint) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HistogramDataPoint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HistogramDataPoint.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HistogramDataPoint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HistogramDataPoint.Merge(m, src)
}
func (m *HistogramDataPoint) XXX_Size() int {
	return m.Size()
}
func (m *HistogramDataPoint) XXX_DiscardUnknown() {
	xxx_messageInfo_HistogramDataPoint.DiscardUnknown(m)
}

var xxx_messageInfo_HistogramDataPoint proto.InternalMessageInfo

func (m *HistogramDataPoint) GetLabels() []*v11.StringKeyValue {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *HistogramDataPoint) GetStartTimeUnixNano() uint64 {
	if m != nil {
		return m.StartTimeUnixNano
	}
	return 0
}

func (m *HistogramDataPoint) GetTimeUnixNano() uint64 {
	if m != nil {
		return m.TimeUnixNano
	}
	return 0
}

func (m *HistogramDataPoint) GetCount() uint64 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *HistogramDataPoint) GetSum() float64 {
	if m != nil {
		return m.Sum
	}
	return 0
}

func (m *HistogramDataPoint) GetBuckets() []*HistogramDataPoint_Bucket {
	if m != nil {
		return m.Buckets
	}
	return nil
}

func (m *HistogramDataPoint) GetExplicitBounds() []float64 {
	if m != nil {
		return m.ExplicitBounds
	}
	return nil
}

// Bucket contains values for a bucket.
type HistogramDataPoint_Bucket struct {
	// The number of values in each bucket of the histogram, as described by
	// bucket_options.
	Count uint64 `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	// exemplar is an optional representative value of the bucket.
	Exemplar             *HistogramDataPoint_Bucket_Exemplar `protobuf:"bytes,2,opt,name=exemplar,proto3" json:"exemplar,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                            `json:"-"`
	XXX_unrecognized     []byte                              `json:"-"`
	XXX_sizecache        int32                               `json:"-"`
}

func (m *HistogramDataPoint_Bucket) Reset()         { *m = HistogramDataPoint_Bucket{} }
func (m *HistogramDataPoint_Bucket) String() string { return proto.CompactTextString(m) }
func (*HistogramDataPoint_Bucket) ProtoMessage()    {}
func (*HistogramDataPoint_Bucket) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{6, 0}
}
func (m *HistogramDataPoint_Bucket) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HistogramDataPoint_Bucket) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HistogramDataPoint_Bucket.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HistogramDataPoint_Bucket) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HistogramDataPoint_Bucket.Merge(m, src)
}
func (m *HistogramDataPoint_Bucket) XXX_Size() int {
	return m.Size()
}
func (m *HistogramDataPoint_Bucket) XXX_DiscardUnknown() {
	xxx_messageInfo_HistogramDataPoint_Bucket.DiscardUnknown(m)
}

var xxx_messageInfo_HistogramDataPoint_Bucket proto.InternalMessageInfo

func (m *HistogramDataPoint_Bucket) GetCount() uint64 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *HistogramDataPoint_Bucket) GetExemplar() *HistogramDataPoint_Bucket_Exemplar {
	if m != nil {
		return m.Exemplar
	}
	return nil
}

// Exemplars are example points that may be used to annotate aggregated
// Histogram values. They are metadata that gives information about a
// particular value added to a Histogram bucket.
type HistogramDataPoint_Bucket_Exemplar struct {
	// Value of the exemplar point. It determines which bucket the exemplar belongs to.
	// If bucket_options define bounds for this bucket then this value must be within
	// the defined bounds.
	Value float64 `protobuf:"fixed64,1,opt,name=value,proto3" json:"value,omitempty"`
	// time_unix_nano is the moment when this exemplar was recorded.
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
	TimeUnixNano uint64 `protobuf:"fixed64,2,opt,name=time_unix_nano,json=timeUnixNano,proto3" json:"time_unix_nano,omitempty"`
	// exemplar_attachments are contextual information about the example value.
	// Keys in this list must be unique.
	Attachments          []*v11.StringKeyValue `protobuf:"bytes,3,rep,name=attachments,proto3" json:"attachments,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *HistogramDataPoint_Bucket_Exemplar) Reset()         { *m = HistogramDataPoint_Bucket_Exemplar{} }
func (m *HistogramDataPoint_Bucket_Exemplar) String() string { return proto.CompactTextString(m) }
func (*HistogramDataPoint_Bucket_Exemplar) ProtoMessage()    {}
func (*HistogramDataPoint_Bucket_Exemplar) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{6, 0, 0}
}
func (m *HistogramDataPoint_Bucket_Exemplar) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HistogramDataPoint_Bucket_Exemplar) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HistogramDataPoint_Bucket_Exemplar.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HistogramDataPoint_Bucket_Exemplar) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HistogramDataPoint_Bucket_Exemplar.Merge(m, src)
}
func (m *HistogramDataPoint_Bucket_Exemplar) XXX_Size() int {
	return m.Size()
}
func (m *HistogramDataPoint_Bucket_Exemplar) XXX_DiscardUnknown() {
	xxx_messageInfo_HistogramDataPoint_Bucket_Exemplar.DiscardUnknown(m)
}

var xxx_messageInfo_HistogramDataPoint_Bucket_Exemplar proto.InternalMessageInfo

func (m *HistogramDataPoint_Bucket_Exemplar) GetValue() float64 {
	if m != nil {
		return m.Value
	}
	return 0
}

func (m *HistogramDataPoint_Bucket_Exemplar) GetTimeUnixNano() uint64 {
	if m != nil {
		return m.TimeUnixNano
	}
	return 0
}

func (m *HistogramDataPoint_Bucket_Exemplar) GetAttachments() []*v11.StringKeyValue {
	if m != nil {
		return m.Attachments
	}
	return nil
}

// SummaryDataPoint is a single data point in a timeseries that describes the time-varying
// values of a Summary metric.
type SummaryDataPoint struct {
	// The set of labels that uniquely identify this timeseries.
	Labels []*v11.StringKeyValue `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty"`
	// start_time_unix_nano is the time when the cumulative value was reset to zero.
	//
	// The cumulative value is over the time interval (start_time_unix_nano, time_unix_nano].
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
	//
	// Value of 0 indicates that the timestamp is unspecified. In that case the timestamp
	// may be decided by the backend.
	StartTimeUnixNano uint64 `protobuf:"fixed64,2,opt,name=start_time_unix_nano,json=startTimeUnixNano,proto3" json:"start_time_unix_nano,omitempty"`
	// time_unix_nano is the moment when this value was recorded.
	// Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
	TimeUnixNano uint64 `protobuf:"fixed64,3,opt,name=time_unix_nano,json=timeUnixNano,proto3" json:"time_unix_nano,omitempty"`
	// The total number of recorded values since start_time. Optional since
	// some systems don't expose this.
	Count uint64 `protobuf:"varint,4,opt,name=count,proto3" json:"count,omitempty"`
	// The total sum of recorded values since start_time. Optional since some
	// systems don't expose this. If count is zero then this field must be zero.
	Sum float64 `protobuf:"fixed64,5,opt,name=sum,proto3" json:"sum,omitempty"`
	// A list of values at different percentiles of the distribution calculated
	// from the current snapshot. The percentiles must be strictly increasing.
	PercentileValues     []*SummaryDataPoint_ValueAtPercentile `protobuf:"bytes,6,rep,name=percentile_values,json=percentileValues,proto3" json:"percentile_values,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                              `json:"-"`
	XXX_unrecognized     []byte                                `json:"-"`
	XXX_sizecache        int32                                 `json:"-"`
}

func (m *SummaryDataPoint) Reset()         { *m = SummaryDataPoint{} }
func (m *SummaryDataPoint) String() string { return proto.CompactTextString(m) }
func (*SummaryDataPoint) ProtoMessage()    {}
func (*SummaryDataPoint) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{7}
}
func (m *SummaryDataPoint) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SummaryDataPoint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SummaryDataPoint.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SummaryDataPoint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SummaryDataPoint.Merge(m, src)
}
func (m *SummaryDataPoint) XXX_Size() int {
	return m.Size()
}
func (m *SummaryDataPoint) XXX_DiscardUnknown() {
	xxx_messageInfo_SummaryDataPoint.DiscardUnknown(m)
}

var xxx_messageInfo_SummaryDataPoint proto.InternalMessageInfo

func (m *SummaryDataPoint) GetLabels() []*v11.StringKeyValue {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *SummaryDataPoint) GetStartTimeUnixNano() uint64 {
	if m != nil {
		return m.StartTimeUnixNano
	}
	return 0
}

func (m *SummaryDataPoint) GetTimeUnixNano() uint64 {
	if m != nil {
		return m.TimeUnixNano
	}
	return 0
}

func (m *SummaryDataPoint) GetCount() uint64 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *SummaryDataPoint) GetSum() float64 {
	if m != nil {
		return m.Sum
	}
	return 0
}

func (m *SummaryDataPoint) GetPercentileValues() []*SummaryDataPoint_ValueAtPercentile {
	if m != nil {
		return m.PercentileValues
	}
	return nil
}

// Represents the value at a given percentile of a distribution.
//
// To record Min and Max values following conventions are used:
// - The 100th percentile is equivalent to the maximum value observed.
// - The 0th percentile is equivalent to the minimum value observed.
//
// See the following issue for more context:
// https://github.com/open-telemetry/opentelemetry-proto/issues/125
type SummaryDataPoint_ValueAtPercentile struct {
	// The percentile of a distribution. Must be in the interval
	// [0.0, 100.0].
	Percentile float64 `protobuf:"fixed64,1,opt,name=percentile,proto3" json:"percentile,omitempty"`
	// The value at the given percentile of a distribution.
	Value                float64  `protobuf:"fixed64,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SummaryDataPoint_ValueAtPercentile) Reset()         { *m = SummaryDataPoint_ValueAtPercentile{} }
func (m *SummaryDataPoint_ValueAtPercentile) String() string { return proto.CompactTextString(m) }
func (*SummaryDataPoint_ValueAtPercentile) ProtoMessage()    {}
func (*SummaryDataPoint_ValueAtPercentile) Descriptor() ([]byte, []int) {
	return fileDescriptor_3c3112f9fa006917, []int{7, 0}
}
func (m *SummaryDataPoint_ValueAtPercentile) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SummaryDataPoint_ValueAtPercentile) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SummaryDataPoint_ValueAtPercentile.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SummaryDataPoint_ValueAtPercentile) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SummaryDataPoint_ValueAtPercentile.Merge(m, src)
}
func (m *SummaryDataPoint_ValueAtPercentile) XXX_Size() int {
	return m.Size()
}
func (m *SummaryDataPoint_ValueAtPercentile) XXX_DiscardUnknown() {
	xxx_messageInfo_SummaryDataPoint_ValueAtPercentile.DiscardUnknown(m)
}

var xxx_messageInfo_SummaryDataPoint_ValueAtPercentile proto.InternalMessageInfo

func (m *SummaryDataPoint_ValueAtPercentile) GetPercentile() float64 {
	if m != nil {
		return m.Percentile
	}
	return 0
}

func (m *SummaryDataPoint_ValueAtPercentile) GetValue() float64 {
	if m != nil {
		return m.Value
	}
	return 0
}

func init() {
	proto.RegisterEnum("opentelemetry.proto.metrics.v1.MetricDescriptor_Type", MetricDescriptor_Type_name, MetricDescriptor_Type_value)
	proto.RegisterEnum("opentelemetry.proto.metrics.v1.MetricDescriptor_Temporality", MetricDescriptor_Temporality_name, MetricDescriptor_Temporality_value)
	proto.RegisterType((*ResourceMetrics)(nil), "opentelemetry.proto.metrics.v1.ResourceMetrics")
	proto.RegisterType((*InstrumentationLibraryMetrics)(nil), "opentelemetry.proto.metrics.v1.InstrumentationLibraryMetrics")
	proto.RegisterType((*Metric)(nil), "opentelemetry.proto.metrics.v1.Metric")
	proto.RegisterType((*MetricDescriptor)(nil), "opentelemetry.proto.metrics.v1.MetricDescriptor")
	proto.RegisterType((*Int64DataPoint)(nil), "opentelemetry.proto.metrics.v1.Int64DataPoint")
	proto.RegisterType((*DoubleDataPoint)(nil), "opentelemetry.proto.metrics.v1.DoubleDataPoint")
	proto.RegisterType((*HistogramDataPoint)(nil), "opentelemetry.proto.metrics.v1.HistogramDataPoint")
	proto.RegisterType((*HistogramDataPoint_Bucket)(nil), "opentelemetry.proto.metrics.v1.HistogramDataPoint.Bucket")
	proto.RegisterType((*HistogramDataPoint_Bucket_Exemplar)(nil), "opentelemetry.proto.metrics.v1.HistogramDataPoint.Bucket.Exemplar")
	proto.RegisterType((*SummaryDataPoint)(nil), "opentelemetry.proto.metrics.v1.SummaryDataPoint")
	proto.RegisterType((*SummaryDataPoint_ValueAtPercentile)(nil), "opentelemetry.proto.metrics.v1.SummaryDataPoint.ValueAtPercentile")
}

func init() {
	proto.RegisterFile("opentelemetry/proto/metrics/v1/metrics.proto", fileDescriptor_3c3112f9fa006917)
}

var fileDescriptor_3c3112f9fa006917 = []byte{
	// 1040 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xdc, 0x57, 0xdf, 0x6e, 0xe3, 0xc4,
	0x17, 0xde, 0x89, 0xd3, 0x74, 0xf7, 0xa4, 0xdb, 0x3a, 0xd3, 0xfe, 0x7e, 0x1b, 0x55, 0xda, 0x52,
	0x22, 0x04, 0x05, 0x51, 0x87, 0x96, 0x52, 0x09, 0x09, 0x24, 0x92, 0x4d, 0xc4, 0x46, 0xe4, 0x9f,
	0x26, 0x4e, 0xa5, 0xae, 0xb4, 0x6b, 0x9c, 0x74, 0x68, 0x47, 0xd8, 0x33, 0x96, 0x3d, 0xa9, 0x9a,
	0x07, 0xe0, 0x0d, 0x56, 0x82, 0x07, 0x02, 0x89, 0x4b, 0xb8, 0xe0, 0x7e, 0xd5, 0x6b, 0xee, 0x78,
	0x01, 0xe4, 0xb1, 0x9d, 0x38, 0x69, 0xda, 0x50, 0xae, 0x80, 0xbb, 0x33, 0xdf, 0x9c, 0xf3, 0x9d,
	0xef, 0x9c, 0x39, 0xe3, 0x49, 0xe0, 0x43, 0xe1, 0x51, 0x2e, 0xa9, 0x43, 0x5d, 0x2a, 0xfd, 0x71,
	0xd9, 0xf3, 0x85, 0x14, 0xe5, 0xd0, 0x66, 0xc3, 0xa0, 0x7c, 0x79, 0x90, 0x98, 0x86, 0xda, 0xc0,
	0x3b, 0x33, 0xde, 0x11, 0x68, 0x24, 0x2e, 0x97, 0x07, 0xdb, 0x1f, 0x2c, 0x62, 0x1b, 0x0a, 0xd7,
	0x15, 0x3c, 0x24, 0x8b, 0xac, 0x28, 0x6c, 0xdb, 0x58, 0xe4, 0xeb, 0xd3, 0x40, 0x8c, 0xfc, 0x21,
	0x0d, 0xbd, 0x13, 0x3b, 0xf2, 0x2f, 0xbd, 0x41, 0xb0, 0x41, 0x62, 0xa8, 0x15, 0xa5, 0xc4, 0x75,
	0x78, 0x98, 0x78, 0x15, 0xd1, 0x2e, 0xda, 0xcb, 0x1f, 0xbe, 0x6f, 0x2c, 0x92, 0x38, 0xa1, 0xba,
	0x3c, 0x30, 0x12, 0x0e, 0x32, 0x09, 0xc5, 0xdf, 0x21, 0x78, 0x8b, 0xf1, 0x40, 0xfa, 0x23, 0x97,
	0x72, 0x69, 0x4b, 0x26, 0xb8, 0xe5, 0xb0, 0x81, 0x6f, 0xfb, 0x63, 0x2b, 0xae, 0xae, 0x98, 0xd9,
	0xd5, 0xf6, 0xf2, 0x87, 0x9f, 0x1b, 0x77, 0x77, 0xc0, 0x68, 0xcc, 0xd2, 0x34, 0x23, 0x96, 0x58,
	0x2f, 0x79, 0xca, 0xee, 0xda, 0x2e, 0xfd, 0x8a, 0xe0, 0xe9, 0x9d, 0x04, 0x98, 0xc3, 0x93, 0x5b,
	0x84, 0xc6, 0xf5, 0x7f, 0xb2, 0x50, 0x60, 0xdc, 0xf8, 0x5b, 0xf5, 0x91, 0xff, 0x2f, 0x16, 0x86,
	0xbf, 0x80, 0xd5, 0xd9, 0x06, 0xbc, 0xbb, 0xac, 0x01, 0x91, 0x52, 0x92, 0x84, 0x95, 0x7e, 0xd7,
	0x20, 0x17, 0x61, 0xf8, 0x25, 0x14, 0x22, 0xd4, 0x3a, 0xa3, 0xc1, 0xd0, 0x67, 0x9e, 0x14, 0x7e,
	0x2c, 0xfb, 0xa3, 0xbf, 0x46, 0x5b, 0x9b, 0xc4, 0x11, 0xdd, 0x9d, 0x43, 0xf0, 0x0b, 0x28, 0x30,
	0x2e, 0x8f, 0x8f, 0xac, 0x33, 0x5b, 0xda, 0x96, 0x27, 0x18, 0x97, 0x89, 0x6a, 0x63, 0xf9, 0xb1,
	0xc9, 0xe3, 0xa3, 0x9a, 0x2d, 0xed, 0x6e, 0x18, 0x46, 0x36, 0xd8, 0xcc, 0x3a, 0xc0, 0x2f, 0x01,
	0x9f, 0x89, 0xd1, 0xc0, 0xa1, 0x33, 0xe4, 0x9a, 0x22, 0x2f, 0x2f, 0x23, 0xaf, 0xa9, 0xc8, 0x29,
	0xbb, 0x7e, 0x36, 0x0b, 0x04, 0xf8, 0x1b, 0xf8, 0xdf, 0x05, 0x0b, 0xa4, 0x38, 0xf7, 0x6d, 0x77,
	0x26, 0x43, 0x56, 0x65, 0x38, 0x5c, 0x96, 0xe1, 0x79, 0x12, 0x3c, 0x4d, 0xb2, 0x79, 0x71, 0x03,
	0x0b, 0xf0, 0xd7, 0xb0, 0x19, 0x8c, 0x5c, 0x37, 0x9c, 0xeb, 0x74, 0x96, 0x15, 0x95, 0x65, 0xe9,
	0x19, 0xf4, 0xa2, 0xd0, 0x69, 0x8e, 0x42, 0x30, 0x87, 0x04, 0xa5, 0xdf, 0x34, 0xd0, 0xe7, 0xcf,
	0x0a, 0x63, 0xc8, 0x72, 0xdb, 0x8d, 0xae, 0xe8, 0x23, 0xa2, 0x6c, 0xbc, 0x0b, 0xf9, 0x64, 0x0a,
	0x98, 0xe0, 0xc5, 0x8c, 0xda, 0x4a, 0x43, 0x61, 0xd4, 0x88, 0x33, 0x59, 0xd4, 0xa2, 0xa8, 0xd0,
	0xc6, 0x0d, 0xc8, 0xca, 0xb1, 0x47, 0x8b, 0xd9, 0x5d, 0xb4, 0xb7, 0x7e, 0xcb, 0xb0, 0xdf, 0x31,
	0x35, 0x86, 0x39, 0xf6, 0x28, 0x51, 0x14, 0xf8, 0x15, 0xe4, 0x25, 0x75, 0x3d, 0xe1, 0xdb, 0x0e,
	0x93, 0xe3, 0xe2, 0x8a, 0x62, 0xfc, 0xec, 0xfe, 0x8c, 0x53, 0x0e, 0x92, 0x26, 0x2c, 0x5d, 0x42,
	0x36, 0xcc, 0x86, 0x75, 0x58, 0x6b, 0xb4, 0x4f, 0x2a, 0xcd, 0x46, 0xcd, 0x32, 0x4f, 0xbb, 0x75,
	0xfd, 0x01, 0x7e, 0x04, 0x2b, 0x8d, 0xb6, 0x79, 0x7c, 0xa4, 0x23, 0xbc, 0x09, 0x1b, 0xad, 0x4e,
	0xbb, 0x63, 0x76, 0xda, 0x8d, 0x67, 0x56, 0x04, 0x66, 0x30, 0x40, 0xae, 0xd6, 0xe9, 0x57, 0x9b,
	0x75, 0x5d, 0xc3, 0x5b, 0xa0, 0x4f, 0x1d, 0x62, 0x34, 0x8b, 0x1f, 0xc3, 0xa3, 0xe7, 0x8d, 0x9e,
	0xd9, 0xf9, 0x92, 0x54, 0x5a, 0xfa, 0x0a, 0xce, 0xc3, 0x6a, 0xaf, 0xdf, 0x6a, 0x55, 0xc8, 0xa9,
	0x9e, 0x2b, 0x99, 0x90, 0x4f, 0x69, 0xc2, 0x4f, 0x60, 0x73, 0x92, 0xbe, 0xde, 0xea, 0x76, 0x48,
	0xa5, 0xd9, 0x30, 0x4f, 0xf5, 0x07, 0xb8, 0x00, 0x8f, 0x1b, 0xed, 0x9e, 0x59, 0x69, 0x9b, 0x95,
	0x76, 0xbd, 0xd3, 0xef, 0xe9, 0x28, 0x14, 0x56, 0xab, 0x37, 0xcd, 0x8a, 0x9e, 0xc1, 0xeb, 0x00,
	0xcf, 0xfa, 0xad, 0x7e, 0xb3, 0x62, 0x36, 0x4e, 0xea, 0xba, 0x56, 0xfa, 0x11, 0xc1, 0xfa, 0xec,
	0x25, 0xc1, 0x75, 0xc8, 0x39, 0xf6, 0x80, 0x3a, 0x41, 0x11, 0xa9, 0xf9, 0xd9, 0x5f, 0xf2, 0xe9,
	0xe9, 0x49, 0x9f, 0xf1, 0xf3, 0xaf, 0xe8, 0xf8, 0xc4, 0x76, 0x46, 0x94, 0xc4, 0xc1, 0xb8, 0x0c,
	0x5b, 0x81, 0xb4, 0x7d, 0x69, 0x49, 0xe6, 0x52, 0x6b, 0xc4, 0xd9, 0x95, 0xc5, 0x6d, 0x2e, 0xd4,
	0x44, 0xe4, 0x48, 0x41, 0xed, 0x99, 0xcc, 0xa5, 0x7d, 0xce, 0xae, 0xda, 0x36, 0x17, 0xf8, 0x1d,
	0x58, 0x9f, 0x73, 0xd5, 0x94, 0xeb, 0x9a, 0x4c, 0x7b, 0x6d, 0xc1, 0xca, 0x65, 0x98, 0x47, 0x8d,
	0x8a, 0x46, 0xa2, 0x45, 0xe9, 0x27, 0x04, 0x1b, 0x73, 0xd7, 0xf1, 0xdf, 0x54, 0x07, 0x4a, 0xea,
	0xf8, 0x23, 0x0b, 0xf8, 0xe6, 0xa5, 0xff, 0xe7, 0x97, 0x32, 0x14, 0x23, 0x2e, 0x55, 0x29, 0x59,
	0x12, 0x2d, 0xb0, 0x0e, 0x5a, 0x30, 0x72, 0xd5, 0xfd, 0x43, 0x24, 0x34, 0x71, 0x0f, 0x56, 0x07,
	0xa3, 0xe1, 0xb7, 0x54, 0x06, 0xc5, 0x9c, 0x2a, 0xe3, 0xd3, 0xfb, 0x7f, 0xff, 0x8c, 0xaa, 0x62,
	0x20, 0x09, 0x13, 0x7e, 0x0f, 0x36, 0xe8, 0x95, 0xe7, 0xb0, 0x21, 0x93, 0xd6, 0x40, 0x8c, 0xf8,
	0x59, 0x50, 0x5c, 0xdd, 0xd5, 0xf6, 0x10, 0x59, 0x4f, 0xe0, 0xaa, 0x42, 0xb7, 0x7f, 0xc8, 0x40,
	0x2e, 0x0a, 0x9e, 0x0a, 0x46, 0x69, 0xc1, 0xaf, 0xe0, 0x21, 0xbd, 0xa2, 0xae, 0xe7, 0xd8, 0xbe,
	0xea, 0x48, 0xfe, 0xb0, 0xfa, 0xb7, 0xf5, 0x19, 0xf5, 0x98, 0x89, 0x4c, 0x38, 0xb7, 0xbf, 0x47,
	0xf0, 0x30, 0x81, 0xa7, 0xc7, 0x8f, 0x52, 0xc7, 0xbf, 0xa0, 0xdf, 0x99, 0x05, 0xfd, 0xee, 0x40,
	0xde, 0x96, 0xd2, 0x1e, 0x5e, 0x84, 0xcf, 0x7a, 0xf2, 0x5a, 0xdd, 0x73, 0x24, 0xd2, 0x0c, 0xa5,
	0xd7, 0x1a, 0xe8, 0xf3, 0x8f, 0xc0, 0x7f, 0x64, 0xe6, 0x04, 0x14, 0x3c, 0xea, 0x0f, 0x29, 0x97,
	0xcc, 0xa1, 0x96, 0xea, 0x72, 0x32, 0x7d, 0xd5, 0xfb, 0xbe, 0x8b, 0x86, 0xaa, 0xac, 0x22, 0xbb,
	0x13, 0x42, 0xa2, 0x4f, 0xc9, 0xd5, 0x66, 0xb0, 0xdd, 0x80, 0xc2, 0x0d, 0x37, 0xbc, 0x03, 0x30,
	0x75, 0x8c, 0x8f, 0x3c, 0x85, 0x4c, 0xa7, 0x21, 0x93, 0x9a, 0x86, 0xea, 0x6b, 0xf4, 0xf3, 0xf5,
	0x0e, 0xfa, 0xe5, 0x7a, 0x07, 0xbd, 0xb9, 0xde, 0x41, 0xf0, 0x36, 0x13, 0x4b, 0x14, 0x57, 0xd7,
	0xe2, 0xdf, 0x93, 0xdd, 0x70, 0xa3, 0x8b, 0x5e, 0xf4, 0xce, 0xe7, 0x43, 0x98, 0x28, 0x0b, 0x49,
	0x9d, 0x32, 0xbd, 0xf2, 0x84, 0x2f, 0xa9, 0x1f, 0x94, 0x85, 0x74, 0xbc, 0x32, 0xe3, 0x92, 0xfa,
	0xdc, 0x76, 0xca, 0x33, 0xde, 0xfb, 0x2a, 0xc1, 0xfe, 0x39, 0xe5, 0xa9, 0xbf, 0x0e, 0x83, 0x9c,
	0x42, 0x3f, 0xfe, 0x33, 0x00, 0x00, 0xff, 0xff, 0x5c, 0x39, 0xe1, 0x06, 0x63, 0x0c, 0x00, 0x00,
}

func (m *ResourceMetrics) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResourceMetrics) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ResourceMetrics) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.InstrumentationLibraryMetrics) > 0 {
		for iNdEx := len(m.InstrumentationLibraryMetrics) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.InstrumentationLibraryMetrics[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Resource != nil {
		{
			size, err := m.Resource.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMetrics(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *InstrumentationLibraryMetrics) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InstrumentationLibraryMetrics) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *InstrumentationLibraryMetrics) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Metrics) > 0 {
		for iNdEx := len(m.Metrics) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Metrics[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.InstrumentationLibrary != nil {
		{
			size, err := m.InstrumentationLibrary.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMetrics(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Metric) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Metric) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Metric) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.SummaryDataPoints) > 0 {
		for iNdEx := len(m.SummaryDataPoints) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.SummaryDataPoints[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.HistogramDataPoints) > 0 {
		for iNdEx := len(m.HistogramDataPoints) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.HistogramDataPoints[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.DoubleDataPoints) > 0 {
		for iNdEx := len(m.DoubleDataPoints) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.DoubleDataPoints[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Int64DataPoints) > 0 {
		for iNdEx := len(m.Int64DataPoints) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Int64DataPoints[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.MetricDescriptor != nil {
		{
			size, err := m.MetricDescriptor.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMetrics(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MetricDescriptor) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MetricDescriptor) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MetricDescriptor) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Temporality != 0 {
		i = encodeVarintMetrics(dAtA, i, uint64(m.Temporality))
		i--
		dAtA[i] = 0x28
	}
	if m.Type != 0 {
		i = encodeVarintMetrics(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Unit) > 0 {
		i -= len(m.Unit)
		copy(dAtA[i:], m.Unit)
		i = encodeVarintMetrics(dAtA, i, uint64(len(m.Unit)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintMetrics(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintMetrics(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Int64DataPoint) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Int64DataPoint) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Int64DataPoint) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Value != 0 {
		i = encodeVarintMetrics(dAtA, i, uint64(m.Value))
		i--
		dAtA[i] = 0x20
	}
	if m.TimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.TimeUnixNano))
		i--
		dAtA[i] = 0x19
	}
	if m.StartTimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.StartTimeUnixNano))
		i--
		dAtA[i] = 0x11
	}
	if len(m.Labels) > 0 {
		for iNdEx := len(m.Labels) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Labels[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *DoubleDataPoint) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DoubleDataPoint) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DoubleDataPoint) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Value != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Value))))
		i--
		dAtA[i] = 0x21
	}
	if m.TimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.TimeUnixNano))
		i--
		dAtA[i] = 0x19
	}
	if m.StartTimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.StartTimeUnixNano))
		i--
		dAtA[i] = 0x11
	}
	if len(m.Labels) > 0 {
		for iNdEx := len(m.Labels) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Labels[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *HistogramDataPoint) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HistogramDataPoint) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HistogramDataPoint) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ExplicitBounds) > 0 {
		for iNdEx := len(m.ExplicitBounds) - 1; iNdEx >= 0; iNdEx-- {
			f4 := math.Float64bits(float64(m.ExplicitBounds[iNdEx]))
			i -= 8
			encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(f4))
		}
		i = encodeVarintMetrics(dAtA, i, uint64(len(m.ExplicitBounds)*8))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Buckets) > 0 {
		for iNdEx := len(m.Buckets) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Buckets[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	if m.Sum != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Sum))))
		i--
		dAtA[i] = 0x29
	}
	if m.Count != 0 {
		i = encodeVarintMetrics(dAtA, i, uint64(m.Count))
		i--
		dAtA[i] = 0x20
	}
	if m.TimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.TimeUnixNano))
		i--
		dAtA[i] = 0x19
	}
	if m.StartTimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.StartTimeUnixNano))
		i--
		dAtA[i] = 0x11
	}
	if len(m.Labels) > 0 {
		for iNdEx := len(m.Labels) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Labels[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *HistogramDataPoint_Bucket) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HistogramDataPoint_Bucket) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HistogramDataPoint_Bucket) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Exemplar != nil {
		{
			size, err := m.Exemplar.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMetrics(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Count != 0 {
		i = encodeVarintMetrics(dAtA, i, uint64(m.Count))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *HistogramDataPoint_Bucket_Exemplar) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HistogramDataPoint_Bucket_Exemplar) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HistogramDataPoint_Bucket_Exemplar) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Attachments) > 0 {
		for iNdEx := len(m.Attachments) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Attachments[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.TimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.TimeUnixNano))
		i--
		dAtA[i] = 0x11
	}
	if m.Value != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Value))))
		i--
		dAtA[i] = 0x9
	}
	return len(dAtA) - i, nil
}

func (m *SummaryDataPoint) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SummaryDataPoint) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SummaryDataPoint) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.PercentileValues) > 0 {
		for iNdEx := len(m.PercentileValues) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.PercentileValues[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	if m.Sum != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Sum))))
		i--
		dAtA[i] = 0x29
	}
	if m.Count != 0 {
		i = encodeVarintMetrics(dAtA, i, uint64(m.Count))
		i--
		dAtA[i] = 0x20
	}
	if m.TimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.TimeUnixNano))
		i--
		dAtA[i] = 0x19
	}
	if m.StartTimeUnixNano != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.StartTimeUnixNano))
		i--
		dAtA[i] = 0x11
	}
	if len(m.Labels) > 0 {
		for iNdEx := len(m.Labels) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Labels[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *SummaryDataPoint_ValueAtPercentile) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SummaryDataPoint_ValueAtPercentile) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SummaryDataPoint_ValueAtPercentile) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Value != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Value))))
		i--
		dAtA[i] = 0x11
	}
	if m.Percentile != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Percentile))))
		i--
		dAtA[i] = 0x9
	}
	return len(dAtA) - i, nil
}

func encodeVarintMetrics(dAtA []byte, offset int, v uint64) int {
	offset -= sovMetrics(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ResourceMetrics) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Resource != nil {
		l = m.Resource.Size()
		n += 1 + l + sovMetrics(uint64(l))
	}
	if len(m.InstrumentationLibraryMetrics) > 0 {
		for _, e := range m.InstrumentationLibraryMetrics {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *InstrumentationLibraryMetrics) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.InstrumentationLibrary != nil {
		l = m.InstrumentationLibrary.Size()
		n += 1 + l + sovMetrics(uint64(l))
	}
	if len(m.Metrics) > 0 {
		for _, e := range m.Metrics {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Metric) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MetricDescriptor != nil {
		l = m.MetricDescriptor.Size()
		n += 1 + l + sovMetrics(uint64(l))
	}
	if len(m.Int64DataPoints) > 0 {
		for _, e := range m.Int64DataPoints {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if len(m.DoubleDataPoints) > 0 {
		for _, e := range m.DoubleDataPoints {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if len(m.HistogramDataPoints) > 0 {
		for _, e := range m.HistogramDataPoints {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if len(m.SummaryDataPoints) > 0 {
		for _, e := range m.SummaryDataPoints {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MetricDescriptor) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovMetrics(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovMetrics(uint64(l))
	}
	l = len(m.Unit)
	if l > 0 {
		n += 1 + l + sovMetrics(uint64(l))
	}
	if m.Type != 0 {
		n += 1 + sovMetrics(uint64(m.Type))
	}
	if m.Temporality != 0 {
		n += 1 + sovMetrics(uint64(m.Temporality))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Int64DataPoint) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Labels) > 0 {
		for _, e := range m.Labels {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.StartTimeUnixNano != 0 {
		n += 9
	}
	if m.TimeUnixNano != 0 {
		n += 9
	}
	if m.Value != 0 {
		n += 1 + sovMetrics(uint64(m.Value))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DoubleDataPoint) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Labels) > 0 {
		for _, e := range m.Labels {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.StartTimeUnixNano != 0 {
		n += 9
	}
	if m.TimeUnixNano != 0 {
		n += 9
	}
	if m.Value != 0 {
		n += 9
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HistogramDataPoint) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Labels) > 0 {
		for _, e := range m.Labels {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.StartTimeUnixNano != 0 {
		n += 9
	}
	if m.TimeUnixNano != 0 {
		n += 9
	}
	if m.Count != 0 {
		n += 1 + sovMetrics(uint64(m.Count))
	}
	if m.Sum != 0 {
		n += 9
	}
	if len(m.Buckets) > 0 {
		for _, e := range m.Buckets {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if len(m.ExplicitBounds) > 0 {
		n += 1 + sovMetrics(uint64(len(m.ExplicitBounds)*8)) + len(m.ExplicitBounds)*8
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HistogramDataPoint_Bucket) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Count != 0 {
		n += 1 + sovMetrics(uint64(m.Count))
	}
	if m.Exemplar != nil {
		l = m.Exemplar.Size()
		n += 1 + l + sovMetrics(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HistogramDataPoint_Bucket_Exemplar) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Value != 0 {
		n += 9
	}
	if m.TimeUnixNano != 0 {
		n += 9
	}
	if len(m.Attachments) > 0 {
		for _, e := range m.Attachments {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SummaryDataPoint) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Labels) > 0 {
		for _, e := range m.Labels {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.StartTimeUnixNano != 0 {
		n += 9
	}
	if m.TimeUnixNano != 0 {
		n += 9
	}
	if m.Count != 0 {
		n += 1 + sovMetrics(uint64(m.Count))
	}
	if m.Sum != 0 {
		n += 9
	}
	if len(m.PercentileValues) > 0 {
		for _, e := range m.PercentileValues {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SummaryDataPoint_ValueAtPercentile) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Percentile != 0 {
		n += 9
	}
	if m.Value != 0 {
		n += 9
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovMetrics(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozMetrics(x uint64) (n int) {
	return sovMetrics(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ResourceMetrics) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResourceMetrics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResourceMetrics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resource", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Resource == nil {
				m.Resource = &v1.Resource{}
			}
			if err := m.Resource.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InstrumentationLibraryMetrics", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.InstrumentationLibraryMetrics = append(m.InstrumentationLibraryMetrics, &InstrumentationLibraryMetrics{})
			if err := m.InstrumentationLibraryMetrics[len(m.InstrumentationLibraryMetrics)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InstrumentationLibraryMetrics) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InstrumentationLibraryMetrics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InstrumentationLibraryMetrics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InstrumentationLibrary", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.InstrumentationLibrary == nil {
				m.InstrumentationLibrary = &v11.InstrumentationLibrary{}
			}
			if err := m.InstrumentationLibrary.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metrics", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Metrics = append(m.Metrics, &Metric{})
			if err := m.Metrics[len(m.Metrics)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Metric) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Metric: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Metric: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MetricDescriptor", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MetricDescriptor == nil {
				m.MetricDescriptor = &MetricDescriptor{}
			}
			if err := m.MetricDescriptor.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Int64DataPoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Int64DataPoints = append(m.Int64DataPoints, &Int64DataPoint{})
			if err := m.Int64DataPoints[len(m.Int64DataPoints)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DoubleDataPoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DoubleDataPoints = append(m.DoubleDataPoints, &DoubleDataPoint{})
			if err := m.DoubleDataPoints[len(m.DoubleDataPoints)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HistogramDataPoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HistogramDataPoints = append(m.HistogramDataPoints, &HistogramDataPoint{})
			if err := m.HistogramDataPoints[len(m.HistogramDataPoints)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SummaryDataPoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SummaryDataPoints = append(m.SummaryDataPoints, &SummaryDataPoint{})
			if err := m.SummaryDataPoints[len(m.SummaryDataPoints)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MetricDescriptor) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MetricDescriptor: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MetricDescriptor: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Unit", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Unit = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= MetricDescriptor_Type(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Temporality", wireType)
			}
			m.Temporality = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Temporality |= MetricDescriptor_Temporality(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Int64DataPoint) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Int64DataPoint: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Int64DataPoint: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Labels = append(m.Labels, &v11.StringKeyValue{})
			if err := m.Labels[len(m.Labels)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTimeUnixNano", wireType)
			}
			m.StartTimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.StartTimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			m.TimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.TimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			m.Value = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Value |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DoubleDataPoint) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DoubleDataPoint: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DoubleDataPoint: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Labels = append(m.Labels, &v11.StringKeyValue{})
			if err := m.Labels[len(m.Labels)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTimeUnixNano", wireType)
			}
			m.StartTimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.StartTimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			m.TimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.TimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 4:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Value = float64(math.Float64frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HistogramDataPoint) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HistogramDataPoint: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HistogramDataPoint: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Labels = append(m.Labels, &v11.StringKeyValue{})
			if err := m.Labels[len(m.Labels)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTimeUnixNano", wireType)
			}
			m.StartTimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.StartTimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			m.TimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.TimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Count", wireType)
			}
			m.Count = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Count |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sum", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Sum = float64(math.Float64frombits(v))
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Buckets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Buckets = append(m.Buckets, &HistogramDataPoint_Bucket{})
			if err := m.Buckets[len(m.Buckets)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType == 1 {
				var v uint64
				if (iNdEx + 8) > l {
					return io.ErrUnexpectedEOF
				}
				v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
				iNdEx += 8
				v2 := float64(math.Float64frombits(v))
				m.ExplicitBounds = append(m.ExplicitBounds, v2)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMetrics
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthMetrics
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthMetrics
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				elementCount = packedLen / 8
				if elementCount != 0 && len(m.ExplicitBounds) == 0 {
					m.ExplicitBounds = make([]float64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint64
					if (iNdEx + 8) > l {
						return io.ErrUnexpectedEOF
					}
					v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
					iNdEx += 8
					v2 := float64(math.Float64frombits(v))
					m.ExplicitBounds = append(m.ExplicitBounds, v2)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field ExplicitBounds", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HistogramDataPoint_Bucket) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Bucket: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Bucket: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Count", wireType)
			}
			m.Count = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Count |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Exemplar", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Exemplar == nil {
				m.Exemplar = &HistogramDataPoint_Bucket_Exemplar{}
			}
			if err := m.Exemplar.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HistogramDataPoint_Bucket_Exemplar) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Exemplar: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Exemplar: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Value = float64(math.Float64frombits(v))
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			m.TimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.TimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attachments", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attachments = append(m.Attachments, &v11.StringKeyValue{})
			if err := m.Attachments[len(m.Attachments)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SummaryDataPoint) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SummaryDataPoint: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SummaryDataPoint: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Labels = append(m.Labels, &v11.StringKeyValue{})
			if err := m.Labels[len(m.Labels)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTimeUnixNano", wireType)
			}
			m.StartTimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.StartTimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			m.TimeUnixNano = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.TimeUnixNano = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Count", wireType)
			}
			m.Count = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Count |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sum", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Sum = float64(math.Float64frombits(v))
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PercentileValues", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PercentileValues = append(m.PercentileValues, &SummaryDataPoint_ValueAtPercentile{})
			if err := m.PercentileValues[len(m.PercentileValues)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SummaryDataPoint_ValueAtPercentile) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ValueAtPercentile: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ValueAtPercentile: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Percentile", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Percentile = float64(math.Float64frombits(v))
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Value = float64(math.Float64frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipMetrics(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthMetrics
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupMetrics
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthMetrics
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthMetrics        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowMetrics          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupMetrics = fmt.Errorf("proto: unexpected end of group")
)
