// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	json "encoding/json"
	"fmt"
	"time"

	v1 "github.com/openshift/api/operator/v1"
	operatorv1 "github.com/openshift/client-go/operator/applyconfigurations/operator/v1"
	scheme "github.com/openshift/client-go/operator/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// MachineConfigurationsGetter has a method to return a MachineConfigurationInterface.
// A group's client should implement this interface.
type MachineConfigurationsGetter interface {
	MachineConfigurations() MachineConfigurationInterface
}

// MachineConfigurationInterface has methods to work with MachineConfiguration resources.
type MachineConfigurationInterface interface {
	Create(ctx context.Context, machineConfiguration *v1.MachineConfiguration, opts metav1.CreateOptions) (*v1.MachineConfiguration, error)
	Update(ctx context.Context, machineConfiguration *v1.MachineConfiguration, opts metav1.UpdateOptions) (*v1.MachineConfiguration, error)
	UpdateStatus(ctx context.Context, machineConfiguration *v1.MachineConfiguration, opts metav1.UpdateOptions) (*v1.MachineConfiguration, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.MachineConfiguration, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.MachineConfigurationList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.MachineConfiguration, err error)
	Apply(ctx context.Context, machineConfiguration *operatorv1.MachineConfigurationApplyConfiguration, opts metav1.ApplyOptions) (result *v1.MachineConfiguration, err error)
	ApplyStatus(ctx context.Context, machineConfiguration *operatorv1.MachineConfigurationApplyConfiguration, opts metav1.ApplyOptions) (result *v1.MachineConfiguration, err error)
	MachineConfigurationExpansion
}

// machineConfigurations implements MachineConfigurationInterface
type machineConfigurations struct {
	client rest.Interface
}

// newMachineConfigurations returns a MachineConfigurations
func newMachineConfigurations(c *OperatorV1Client) *machineConfigurations {
	return &machineConfigurations{
		client: c.RESTClient(),
	}
}

// Get takes name of the machineConfiguration, and returns the corresponding machineConfiguration object, and an error if there is any.
func (c *machineConfigurations) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.MachineConfiguration, err error) {
	result = &v1.MachineConfiguration{}
	err = c.client.Get().
		Resource("machineconfigurations").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of MachineConfigurations that match those selectors.
func (c *machineConfigurations) List(ctx context.Context, opts metav1.ListOptions) (result *v1.MachineConfigurationList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.MachineConfigurationList{}
	err = c.client.Get().
		Resource("machineconfigurations").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested machineConfigurations.
func (c *machineConfigurations) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("machineconfigurations").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a machineConfiguration and creates it.  Returns the server's representation of the machineConfiguration, and an error, if there is any.
func (c *machineConfigurations) Create(ctx context.Context, machineConfiguration *v1.MachineConfiguration, opts metav1.CreateOptions) (result *v1.MachineConfiguration, err error) {
	result = &v1.MachineConfiguration{}
	err = c.client.Post().
		Resource("machineconfigurations").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(machineConfiguration).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a machineConfiguration and updates it. Returns the server's representation of the machineConfiguration, and an error, if there is any.
func (c *machineConfigurations) Update(ctx context.Context, machineConfiguration *v1.MachineConfiguration, opts metav1.UpdateOptions) (result *v1.MachineConfiguration, err error) {
	result = &v1.MachineConfiguration{}
	err = c.client.Put().
		Resource("machineconfigurations").
		Name(machineConfiguration.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(machineConfiguration).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *machineConfigurations) UpdateStatus(ctx context.Context, machineConfiguration *v1.MachineConfiguration, opts metav1.UpdateOptions) (result *v1.MachineConfiguration, err error) {
	result = &v1.MachineConfiguration{}
	err = c.client.Put().
		Resource("machineconfigurations").
		Name(machineConfiguration.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(machineConfiguration).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the machineConfiguration and deletes it. Returns an error if one occurs.
func (c *machineConfigurations) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("machineconfigurations").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *machineConfigurations) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("machineconfigurations").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched machineConfiguration.
func (c *machineConfigurations) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.MachineConfiguration, err error) {
	result = &v1.MachineConfiguration{}
	err = c.client.Patch(pt).
		Resource("machineconfigurations").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// Apply takes the given apply declarative configuration, applies it and returns the applied machineConfiguration.
func (c *machineConfigurations) Apply(ctx context.Context, machineConfiguration *operatorv1.MachineConfigurationApplyConfiguration, opts metav1.ApplyOptions) (result *v1.MachineConfiguration, err error) {
	if machineConfiguration == nil {
		return nil, fmt.Errorf("machineConfiguration provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(machineConfiguration)
	if err != nil {
		return nil, err
	}
	name := machineConfiguration.Name
	if name == nil {
		return nil, fmt.Errorf("machineConfiguration.Name must be provided to Apply")
	}
	result = &v1.MachineConfiguration{}
	err = c.client.Patch(types.ApplyPatchType).
		Resource("machineconfigurations").
		Name(*name).
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *machineConfigurations) ApplyStatus(ctx context.Context, machineConfiguration *operatorv1.MachineConfigurationApplyConfiguration, opts metav1.ApplyOptions) (result *v1.MachineConfiguration, err error) {
	if machineConfiguration == nil {
		return nil, fmt.Errorf("machineConfiguration provided to Apply must not be nil")
	}
	patchOpts := opts.ToPatchOptions()
	data, err := json.Marshal(machineConfiguration)
	if err != nil {
		return nil, err
	}

	name := machineConfiguration.Name
	if name == nil {
		return nil, fmt.Errorf("machineConfiguration.Name must be provided to Apply")
	}

	result = &v1.MachineConfiguration{}
	err = c.client.Patch(types.ApplyPatchType).
		Resource("machineconfigurations").
		Name(*name).
		SubResource("status").
		VersionedParams(&patchOpts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
