// Copyright 2024-2025 The NATS Authors
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package util

import (
	"fmt"
	"strconv"

	"github.com/choria-io/fisk"
)

// Int64RangeValidator validates an integer is in a range inclusive of the given values
func Int64RangeValidator(min int64, max int64) fisk.OptionValidator {
	return func(v string) error {
		iv, err := strconv.ParseInt(v, 10, 64)
		if err != nil {
			return err
		}

		if iv < min {
			return fmt.Errorf("must be greater than or equal to %d", min)
		}

		if iv > max {
			return fmt.Errorf("must be less than or equal to %d", max)
		}

		return nil
	}
}
