# v2.6

This update has introduced a potential breaking change: variables now need to be defined before usage otherwise the commandline will fail. Read notes to learn how to disable this feature where needed. Also included in this release is the `select` command as part of the standard build.

### Breaking Changes:

* `strict-vars` is enabled by default. This means if a variable doesn't exist / hasn't been instantiated then your command will fail. You can disable this by putting `config: set proc strict-vars false` inside any affected `function`s and/or in your `~/.murex_profile`

### Features:

* `select` builtin now added to the default build. This built in will stream tabulated data into an in memory sqlite3 database and take SQL arguments to query that data. Thus allowing you to inline SQL queries as part of your native command line. This addition will add complications for anyone building from source on Windows. If you are a Windows user you are recommended to use WSL or, if you desperately need to use Murex natively on Windows, download the appropriate per-compiled binary from the downloads page

* When used in WSL, any Windows mounts included in `$PATH` will now be subject to the same inclusion rules as Windows file systems when Murex is used in Windows. This means only executables (ie files with `.exe`, amongst other, extensions are present). This has dramatically cleaned up autocomplete suggestions when running Murex in WSL.

* New `autocomplete` directive: `FileRegexp`. Use this if you want to return only files where the file name matches a defined pattern (eg only **.txt** files: `\.txt$`)

* HTTP client (as used by `get`, `getfile`, `post`, `open`, etc) supports additional logic with dynamically guessing the correct data type to assign to stdout where the `Content-Type` hasn't been mapped. Any `Content-Type` with a `+json` suffix will be assumed to be `json` data type

* `getfile` output has been revamped. If stdout is a TTY then you'll now see a progress bar

* `.tfstate` (Terraform state files) have been added to supported JSON extensions

* `~/.ssh/config` hosts have been added to SSH (et al)'s autocomplete suggestions

* `murex-package: reload` now only reloads packages, not `.murex_preload nor `.murex_profile`

* website tweaks: updated INSTALL doc, CSS fixes

* debug message added to warn when fork FIDs are being killed

### Non-user facing changes (internal changes to the Murex code base):

* Additional tests

* Older function definitions replaced with the newer (correct) way to define functions and methods. This allows for greater discovery in the interactive terminal

* Root unit tests finish quicker

### Bug fixes:

* HTTP client (as used by `get`, `getfile`, `post`, `open`, etc) wasn't breaking down the `Content-Type` header correctly. This only affected unknown MIME types where Murex had to guess the correct data type to assign to stdout. This is an edge case bug.

* `while`, when used without a separate parameter for the conditional logic, was buffering the stdout for each loop and outputting it after that iteration had ended. `while` now uses a "tee" stdio writer which means it can stream stdout while the iteration is in progress  Synonyms:

<hr>

Published: 26.02.2022 at 18:33

## See Also

* [`autocomplete`](../commands/autocomplete.md):
  Set definitions for tab-completion in the command line
* [`config`](../commands/config.md):
  Query or define Murex runtime settings
* [`select`](../optional/select.md):
  Inlining SQL into shell pipelines
* [`while`](../commands/while.md):
  Loop until condition false

<hr/>

This document was generated from [gen/changelog/v2.6_doc.yaml](https://github.com/lmorg/murex/blob/master/gen/changelog/v2.6_doc.yaml).