# v5.3

Caching has been vastly improved in this release due to a new sqlite3-backed persistent `cache.db`. There have also been some improvements to `[f1]` help pages

## Breaking Changes

None

## v5.3.6000

### Features

* Copyright messages update for 2024

### Bug Fixes

* ANSI escape code for string terminations was updated to incorrect values in preview release. This has been fixed here

## v5.3.5000

### Features

* new `runtime` flag for managing cache: `--flush-cache`

### Bug Fixes

* Windows, Linux and Darwin (macOS) now default to GCO-less builds of sqlite3

* ANSI escape code for window title changes changed from xterm-specific standard (`BELL` terminated) to ANSI standard (`ST` terminated)

* integrations and default profile scripts have all be rewritten to follow latest Murex code style best practices

## v5.3.4000

### Features

* new `runtime` flags for managing cache: `--cache` and `--trim-cache`

### Bug Fixes

* cache: sqlite3 would lock `cache.db`, breaking caching when multiple murex sessions were open at a time

* cache: cache.db wasn't getting set in `config` correctly (should have been enabled by default but was disabled by default instead)

## v5.3.3000

### Features

* persistent cache added using sqlite3 backend. This cache is optional however it is enabled by default. You can disable it by placing the following into your `.murex_profile`:
  ```
  config set shell cache.db-enabled false
  ```

* new `autocomplete` directive for `[f1]` previews: `DynamicPreview`

* dynamic previews added for `git` and `aws`

### Bug Fixes

* `export` now supports whitespace like an expression ([issue #679](https://github.com/lmorg/murex/issues/679))

* bugfix: structures in variables would sometimes output base64 encoded values when converting those structures to arrays ([issue #768](https://github.com/lmorg/murex/issues/768))

* some `ReadArrayWithType()` calls weren't handling the returned error (if there were an error). They're now all surfacing errors correctly

* whats new message moved to shell `Start()`
  
## Special Thanks

Special thank you to everyone in the community for raising bug reports and design discussions.

You rock!

<hr>

Published: 02.01.2024 at 15:45

## See Also

* [Contributing](../Murex/CONTRIBUTING.md):
  Guide to contributing to Murex
* [`autocomplete`](../commands/autocomplete.md):
  Set definitions for tab-completion in the command line
* [`config`](../commands/config.md):
  Query or define Murex runtime settings
* [`export`](../commands/export.md):
  Define an environmental variable and set it's value
* [`runtime`](../commands/runtime.md):
  Returns runtime information on the internal state of Murex

<hr/>

This document was generated from [gen/changelog/v5.3_doc.yaml](https://github.com/lmorg/murex/blob/master/gen/changelog/v5.3_doc.yaml).