# `ta` (mkarray)

> A sophisticated yet simple way to build an array of a user defined data-type

## Description

Murex has a pretty sophisticated builtin for generating arrays. It works
a little bit like Bash's `{1..9}` syntax but includes a few additional nifty
features and the output format is user defined.

## Usage

```
ta data-type [start..end] -> <stdout>
ta data-type [start..end.base] -> <stdout>
ta data-type [start..end,start..end] -> <stdout>
ta data-type [start..end][start..end] -> <stdout>
```

## Examples

```
» ta json [1..5]
[
    "1",
    "2",
    "3",
    "4",
    "5"
]
```

```
» ta json [Monday..Sunday]
[
    "Monday",
    "Tuesday",
    "Wednesday",
    "Thursday",
    "Friday",
    "Saturday",
    "Sunday"
]
```

Please note that as per the first example, all arrays generated by `ta` are
arrays of strings - even if you're command is ranging over integers. Also
if you are only creating arrays in JSON then you could use `ja` instead.

## Detail

Please read the documentation on `a` for a more detailed breakdown on of
`ta`'s supported features.

## See Also

* [`%[]` Create Array](../parser/create-array.md):
  Quickly generate arrays
* [`[ ..Range ]`](../parser/range.md):
  Outputs a ranged subset of data from STDIN
* [`[ Index ]`](../parser/item-index.md):
  Outputs an element from an array, map or table
* [`[[ Element ]]`](../parser/element.md):
  Outputs an element from a nested structure
* [`a` (mkarray)](../commands/a.md):
  A sophisticated yet simple way to build an array or list
* [`count`](../commands/count.md):
  Count items in a map, list or array
* [`ja` (mkarray)](../commands/ja.md):
  A sophisticated yet simply way to build a JSON array
* [`mtac`](../commands/mtac.md):
  Reverse the order of an array

<hr/>

This document was generated from [builtins/core/mkarray/array_doc.yaml](https://github.com/lmorg/murex/blob/master/builtins/core/mkarray/array_doc.yaml).