# `?:` Elvis Operator

> Returns the right operand if the left operand is falsy

## Description

The elvis operator is a little like a conditional where the result of the
operation is the first non-falsy value from left to right.

A falsy value is any of the following:

* an unset / undefined variable
* any value with a `null` data type
* a `str` or generic with the value `false`, `null`, `0`, `no`, `off`, `fail`,
  `failed`, or `disabled`
* a number (`num`, `float` or `int`) with the value `0`
* an empty object or zero length array 
* and, of course, a boolean with the value `false`



## Examples

**Assign a variable with a default value:**

```
» $foo = $bar ?: "baz"
```

If `$bar` is falsy, then the value of `$foo` will be **"baz"**.

**Multiple elvis operators:**

```
» $unset_variable ?: null ?: false ?: "foobar"
foobar
```

## Detail

### Whats in a name?

[Wikipedia](https://en.wikipedia.org/wiki/Elvis_operator) explains this best
where it says:

> The name "Elvis operator" refers to the fact that when its common notation,
> `?:`, is viewed sideways, it resembles an emoticon of Elvis Presley with his
> signature hairstyle.

## See Also

* [Pipeline](../user-guide/pipeline.md):
  Overview of what a "pipeline" is
* [Schedulers](../user-guide/schedulers.md):
  Overview of the different schedulers (or 'run modes') in Murex
* [`&&` And Logical Operator](../parser/logical-and.md):
  Continues next operation if previous operation passes
* [`??` Null Coalescing Operator](../parser/null-coalescing.md):
  Returns the right operand if the left operand is empty / undefined
* [`?` STDERR Pipe](../parser/pipe-err.md):
  Pipes STDERR from the left hand command to STDIN of the right hand command (DEPRECATED)
* [`err`](../commands/err.md):
  Print a line to the STDERR
* [`out`](../commands/out.md):
  Print a string to the STDOUT with a trailing new line character
* [`try`](../commands/try.md):
  Handles errors inside a block of code
* [`trypipe`](../commands/trypipe.md):
  Checks state of each function in a pipeline and exits block on error
* [`||` Or Logical Operator](../parser/logical-or.md):
  Continues next operation only if previous operation fails
* [null](../commands/devnull.md):
  null function. Similar to /dev/null

<hr/>

This document was generated from [gen/parser/elvis_op_doc.yaml](https://github.com/lmorg/murex/blob/master/gen/parser/elvis_op_doc.yaml).