package docs

func init() {

	Definition["exec"] = "# `exec` - Command Reference\n\n> Runs an executable\n\n## Description\n\nWith Murex, like most other shells, you launch a process by calling the\nname of that executable directly. While this is suitable 99% of the time,\noccasionally you might run into an edge case where that wouldn't work. The\nprimary reason being if you needed to launch a process from a variable, eg\n\n    » set exe=uname\n    » $exe\n    uname\n    \nAs you can see here, Murex's behavior here is to output the contents of\nthe variable rather then executing the contents of the variable. This is\ndone for safety reasons, however if you wanted to override that behavior\nthen you could prefix the variable with exec:\n\n    » set exe=uname\n    » exec $exe\n    Linux\n\n## Usage\n\n    <stdin> -> exec\n    <stdin> -> exec -> <stdout>\n               exec -> <stdout>\n\n## Examples\n\n    » exec printf \"Hello, world!\"\n    Hello, world!\n    \n**Working around aliases:**\n\nIf you have an alias like `alias ls=ls --color=auto` and you wanted to run `ls`\nbut without colour, you might run `exec ls`.\n\n## Detail\n\nIf any command doesn't exist as a builtin, function nor alias, then Murex\nwill default to forking out to any command with this name (subject to an\nabsolute path or the order of precedence in `$PATH`). Any forked process will\nshow up in both the operating systems process viewer (eg `ps`) but also\nMurex's own process viewer, `fid-list`. However inside `fid-list` you will\nnotice that all external processes are listed as `exec` with the process name\nas part of `exec`'s parameters. That is because `exec` is handler for programs\nthat aren't native to Murex.\n\n### Compatibility with POSIX\n\nFor compatibility with traditional shells like Bash and Zsh, `command` is an\nalias for `exec`.\n\n## Synonyms\n\n* `exec`\n* `command`\n\n\n## See Also\n\n* [`bexists`](../commands/bexists.md):\n  Check which builtins exist\n* [`bg`](../commands/bg.md):\n  Run processes in the background\n* [`builtins`](../commands/runtime.md):\n  Returns runtime information on the internal state of Murex\n* [`fexec` ](../commands/fexec.md):\n  Execute a command or function, bypassing the usual order of precedence.\n* [`fg`](../commands/fg.md):\n  Sends a background process into the foreground\n* [`fid-kill`](../commands/fid-kill.md):\n  Terminate a running Murex function\n* [`fid-killall`](../commands/fid-killall.md):\n  Terminate _all_ running Murex functions\n* [`fid-list`](../commands/fid-list.md):\n  Lists all running functions within the current Murex session\n* [`jobs`](../commands/fid-list.md):\n  Lists all running functions within the current Murex session\n* [`murex-update-exe-list`](../commands/murex-update-exe-list.md):\n  Forces Murex to rescan $PATH looking for executables\n* [`set`](../commands/set.md):\n  Define a local variable and set it's value"

}
