# User Guide

This section contains miscellaneous documents on using and configuring the
shell and Murex's numerous features.

## Other Reference Material

There are other sections for which are dedicated to Murex's parser, builtin
commands and such like:

### Language Guides

1. [Language Tour](GUIDE.quick-start.md), which is an introduction into
   the Murex language.

2. [Rosetta Stone](user-guide/rosetta-stone.md), which is a reference
   table comparing Bash syntax to Murex's.

3. [Builtins](./GUIDE.builtin-functions.md), for docs on the core builtins.

4. [Syntax](./GUIDE.parser.md), lists tokens and other syntactic sugar
   supported by Murex's parser.

## Pages

* [ANSI Constants](user-guide/ansi.md):
  Infixed constants that return ANSI escape sequences
* [Bang Prefix](user-guide/bang-prefix.md):
  Bang prefixing to reverse default actions
* [Code Block Parsing](user-guide/code-block.md):
  Overview of how code blocks are parsed
* [FileRef](user-guide/fileref.md):
  How to track what code was loaded and from where
* [Modules and Packages](user-guide/modules.md):
  An introduction to Murex modules and packages
* [Murex Named Pipes](user-guide/namedpipes.md):
  A detailed breakdown of named pipes in Murex
* [Pipeline](user-guide/pipeline.md):
  Overview of what a "pipeline" is
* [Reserved Variables](user-guide/reserved-vars.md):
  Special variables reserved by Murex
* [Rosetta Stone](user-guide/rosetta-stone.md):
  A tabulated list of Bashism's and their equivalent Murex syntax
* [Schedulers](user-guide/schedulers.md):
  Overview of the different schedulers (or 'run modes') in Murex
* [Spellcheck](user-guide/spellcheck.md):
  How to enable inline spellchecking
* [Terminal Hotkeys](user-guide/terminal-keys.md):
  A list of all the terminal hotkeys and their uses
* [Variable and Config Scoping](user-guide/scoping.md):
  How scoping works within Murex
* [Murex Profile Files](user-guide/profile.md):
  A breakdown of the different files loaded on start up
* [Murex's Interactive Shell](user-guide/interactive-shell.md):
  What's different about Murex's interactive shell?