# What's new in murex v2.6 - Change Log

Breaking Change:

* `strict-vars` is enabled by default. This means if a variable doesn't exist / hasn't been instantiated then your command will fail. You can disable this by putting `config: set proc strict-vars false` inside any affected `function`s and/or in your `~/.murex_profile`

Features:

* `select` builtin now added to the default build. This built in will stream tabulated data into an in memory sqlite3 database and take SQL arguments to query that data. Thus allowing you to inline SQL queries as part of your native command line. This addition will add complications for anyone building from source on Windows. If you are a Windows user you are recommended to use WSL or, if you desperately need to use _murex_ natively on Windows, download the appropriate per-compiled binary from the downloads page

* When used in WSL, any Windows mounts included in `$PATH` will now be subject to the same inclusion rules as Windows file systems when _murex_ is used in Windows. This means only executables (ie files with `.exe`, amongst other, extensions are present). This has dramatically cleaned up autocomplete suggestions when running _murex_ in WSL.

* New `autocomplete` directive: `FileRegexp`. Use this if you want to return only files where the file name matches a defined pattern (eg only **.txt** files: `\.txt$`)

* HTTP client (as used by `get`, `getfile`, `post`, `open`, etc) supports additional logic with dynamically guessing the correct data type to assign to STDOUT where the `Content-Type` hasn't been mapped. Any `Content-Type` with a `+json` suffix will be assumed to be `json` data type

* `getfile` output has been revamped. If STDOUT is a TTY then you'll now see a progress bar

* `.tfstate` (Terraform state files) have been added to supported JSON extensions

* `~/.ssh/config` hosts have been added to SSH (et al)'s autocomplete suggestions

* `murex-package: reload` now only reloads packages, not `.murex_preload nor `.murex_profile`

* website tweaks: updated INSTALL doc, CSS fixes

* debug message added to warn when fork FIDs are being killed

Non-user facing changes (internal changes to the _murex_ code base):

* Additional tests

* Older function definitions replaced with the newer (correct) way to define functions and methods. This allows for greater discovery in the interactive terminal

* Root unit tests finish quicker

Bug fixes:

* HTTP client (as used by `get`, `getfile`, `post`, `open`, etc) wasn't breaking down the `Content-Type` header correctly. This only affected unknown MIME types where _murex_ had to guess the correct data type to assign to STDOUT. This is an edge case bug.

* `while`, when used without a separate parameter for the conditional logic, was buffering the STDOUT for each loop and outputting it after that iteration had ended. `while` now uses a "tee" stdio writer which means it can stream STDOUT while the iteration is in progress  Synonyms:

<hr>

Published: 26.02.2022 at 18:33

## See Also

* [`autocomplete`](../commands/autocomplete.md):
  Set definitions for tab-completion in the command line
* [`config`](../commands/config.md):
  Query or define _murex_ runtime settings
* [`select` ](../optional/select.md):
  Inlining SQL into shell pipelines
* [`while`](../commands/while.md):
  Loop until condition false