package docs

func init() {

	Definition["right"] = "# `right` - Command Reference\n\n> Right substring every item in a list\n\n## Description\n\nTakes a list from STDIN and returns a right substring of that same list.\n\nOne parameter is required and that is the number of characters to return. If\nthe parameter is a negative then `right` counts from the left.\n\n## Usage\n\n    <stdin> -> right int -> <stdout>\n\n## Examples\n\nCount from the right\n\n    » ja: [Monday..Wednesday] -> right 4\n    [\n        \"nday\",\n        \"sday\",\n        \"sday\"\n    ]\n    \nCount from the left\n\n    » ja: [Monday..Wednesday] -> left -3\n    [\n        \"day\",\n        \"sday\",\n        \"nesday\"\n    ]\n\n## Detail\n\nSupported data types can queried via `runtime`\n\n    runtime: --marshallers\n    runtime: --unmarshallers\n\n## Synonyms\n\n* `right`\n* `list.right`\n\n\n## See Also\n\n* [`a` (mkarray)](../commands/a.md):\n  A sophisticated yet simple way to build an array or list\n* [`count`](../commands/count.md):\n  Count items in a map, list or array\n* [`ja` (mkarray)](../commands/ja.md):\n  A sophisticated yet simply way to build a JSON array\n* [`lang.MarshalData()` (system API)](../apis/lang.MarshalData.md):\n  Converts structured memory into a _murex_ data-type (eg for stdio)\n* [`lang.UnmarshalData()` (system API)](../apis/lang.UnmarshalData.md):\n  Converts a _murex_ data-type into structured memory\n* [`prefix`](../commands/prefix.md):\n  Prefix a string to every item in a list\n* [`right`](../commands/right.md):\n  Right substring every item in a list\n* [`runtime`](../commands/runtime.md):\n  Returns runtime information on the internal state of _murex_\n* [`suffix`](../commands/suffix.md):\n  Prefix a string to every item in a list"

}
