package docs

func init() {

	Definition["murex-package"] = "# _murex_ Shell Docs\n\n## Command Reference: `murex-package`\n\n> _murex_'s package manager\n\n## Description\n\n_murex_ comes with it's own package manager to make managing plugins easier.\n\nThe format of the packages is a directory, typically located at `~/.murex_modules`,\nwhich contains one or more murex scripts. Each script can be it's own module.\nie there are multiple modules that can be grouped together and distributed as a\nsingle package.\n\nThe way packages and modules are represented is as a path:\n    \n    package/module\n        \n`murex-package` is a package management tool for administrating murex modules\nand packages.\n\n## Usage\n\nInstall a new package\n\n    murex-package: install uri -> <stdout>\n    \nUpdate all packages\n\n    murex-package: update -> <stdout>\n    \nEnable a package or module which had been disabled\n\n    murex-package: enable package\n    \n    murex-package: enable package/module\n    \nDisable a package\n\n    murex-package: disable package\n    \n    murex-package: disable package/module\n    \nImport packages from another package database\n\n    murex-package: import [ uri/ | local/path/ ]packages.json -> <stdout>\n    \nCheck status of murex packages\n\n    murex-package: status -> <stdout>\n\n## Flags\n\n* `cd`\n    Changes working directory to a package's install location\n* `disable`\n    Disables a previously enabled package or module\n* `enable`\n    Enables a previously disabled package or module\n* `import`\n    Import packages described in a backup package DB from user defined URI or local path\n* `install`\n    Installs a package from a user defined URI\n* `list`\n    Returns a list of indexed packages/modules (eg what's enabled or disabled)\n* `reload`\n    Reloads all enabled modules\n* `status`\n    Returns the version status of locally installed packages\n* `update`\n    Updates all installed packages\n\n## Detail\n\n### `murex-package: list`... `enabled` vs `loaded`\n\n`enabled` and `disabled` reads the package status from disk rather than the\npackage cache in your current _murex_ session (like `runtime` reports). This\nbecause the typical use for `murex-package list enabled|disabled` is to view\nwhich packages and modules will be loaded with any new murex session.\n\nIf you wish to view what modules are loaded in a current session then use\n`murex-package list loaded` instead. This is also equivalent to using\n`runtime --modules`.\n\n## See Also\n\n* [Modules and Packages](../user-guide/modules.md):\n  An introduction to _murex_ modules and packages\n* [_murex_ Profile Files](../user-guide/profile.md):\n  A breakdown of the different files loaded on start up\n* [`alias`](../commands/alias.md):\n  Create an alias for a command\n* [`config`](../commands/config.md):\n  Query or define _murex_ runtime settings\n* [`function`](../commands/function.md):\n  Define a function block\n* [`murex-docs`](../commands/murex-docs.md):\n  Displays the man pages for _murex_ builtins\n* [`private`](../commands/private.md):\n  Define a private function block\n* [`runtime`](../commands/runtime.md):\n  Returns runtime information on the internal state of _murex_"

}
