# _murex_ Shell Docs

## Command Reference: `ja` (mkarray)

> A sophisticated yet simply way to build a JSON array

## Description

_murex_ has a pretty sophisticated builtin for generating JSON arrays.
It works a little bit like Bash's `{1..9}` syntax but includes a few
additional nifty features.

**Please note that while this builtin is not marked for deprecation, it has
been superseded by the `%[]` tokens.** ([read more](../parser/create-array.md))

## Usage

    ja: [start..end] -> <stdout>
    ja: [start..end.base] -> <stdout>
    ja: [start..end,start..end] -> <stdout>
    ja: [start..end][start..end] -> <stdout>

## Examples

    » ja: [1..5]
    [
        "1",
        "2",
        "3",
        "4",
        "5"
    ]
    
    » ja: [Monday..Sunday]
    [
        "Monday",
        "Tuesday",
        "Wednesday",
        "Thursday",
        "Friday",
        "Saturday",
        "Sunday"
    ]
    
Please note that as per the first example, all arrays generated by `ja` are
arrays of strings - even if you're command is ranging over integers.

## Detail

Please read the documentation on `a` for a more detailed breakdown on of
`ja`'s supported features.

## See Also

* [`[[` (element)](../commands/element.md):
  Outputs an element from a nested structure
* [`[` (index)](../commands/index.md):
  Outputs an element from an array, map or table
* [`[` (range) ](../commands/range.md):
  Outputs a ranged subset of data from STDIN
* [`a` (mkarray)](../commands/a.md):
  A sophisticated yet simple way to build an array or list
* [`count`](../commands/count.md):
  Count items in a map, list or array
* [`json` ](../types/json.md):
  JavaScript Object Notation (JSON) (primitive)
* [`mtac`](../commands/mtac.md):
  Reverse the order of an array
* [`ta` (mkarray)](../commands/ta.md):
  A sophisticated yet simple way to build an array of a user defined data-type
* [create-array](../parser/create-array.md):
  