# _murex_ Change Log

## What's new in murex v2.11

Breaking Changes:

* None

Features:

* File index caching for faster completions (eg on mechanical drives). This happens upon shell start up (except on Darwin for security reasons) and after every `cd`

* Relaxed `alias` syntax. It now supports whitespace between the `=` statement (like `set` and `let` do)

* New aliases added for common methods which work against lists/arrays. Type `list.{TAB}` to see the complete list of methods

* Added support for alternative separator values in `struct-keys`

* Hint summaries are now cached, to improve performance on slower machines

* Opt in support to pre-cache hint summaries. This will also auto-disable appending colon to command suggestions in autocomplete. This is not enabled by default because it could negatively affect performance on some slower machines and is more of an aesthetic improvement. You can enable it by adding `config: set shell pre-cache-hint-summaries true` to your _murex_ profile

* New autocompletions for `yay` (ArchLinux)

* Some minor performance improvements

* website: updates to docs

Bug Fixes:

* readline: max field size adjusted for autocompletes so more completions are visible at one time

* readline: all cropped autocompletions now provide an uncropped version in the hint text field

* readline: fix bug with history not getting written

* OS signals (^c et al) are now re-registered after each exec (fixes bug where some programs would "steal" ^c, breaking support for those signals upon subsequent execs)

* Fixed regression bug in man page parsing

* Added check for zero-length string used as a process name (this shouldn't ever happen under normal circumstances however closing this bug allows for a managed error rather than the code panicking)

* readline: Prompt environment reset on each loop (this change is to future-proof against potential bugs)

* Fixed race condition bug when some of the tests are run concurrently (this bug only existed in the unit tests but sometimes caused those tests to fail)

* Added CI tests for Go v19.x

<hr>

Published: 12.09.2022 at 08:10

## See Also

* [user-guide/_murex_ Profile Files](../user-guide/profile.md):
  A breakdown of the different files loaded on start up
* [commands/`alias`](../commands/alias.md):
  Create an alias for a command
* [commands/`autocomplete`](../commands/autocomplete.md):
  Set definitions for tab-completion in the command line
* [commands/`cd`](../commands/cd.md):
  Change (working) directory
* [commands/`config`](../commands/config.md):
  Query or define _murex_ runtime settings
* [commands/`let`](../commands/let.md):
  Evaluate a mathematical function and assign to variable (deprecated)
* [commands/`set`](../commands/set.md):
  Define a local variable and set it's value
* [commands/`struct-keys`](../commands/struct-keys.md):
  Outputs all the keys in a structure as a file path