package docs

func init() {

	Definition["g"] = "# _murex_ Shell Docs\n\n## Command Reference: `g`\n\n> Glob pattern matching for file system objects (eg `*.txt`)\n\n## Description\n\nReturns a list of files and directories that match a glob pattern.\n\nOutput is a JSON list.\n\n## Usage\n\n    g: pattern -> <stdout>\n    \n    [ <stdin> -> ] @g command pattern [ -> <stdout> ]\n    \n    !g: pattern -> <stdout>\n    \n    <stdin> -> g: pattern -> <stdout>\n    \n    <stdin> -> !g: pattern -> <stdout>\n\n## Examples\n\nInline globbing:\n\n    cat: @{ g: *.txt }\n    \nWriting a JSON array of files to disk:\n\n    g: *.txt |> filelist.json\n    \nWriting a list of files to disk:\n\n    g: *.txt -> format str |> filelist.txt\n    \nChecking if a file exists:\n\n    if { g: somefile.txt } then {\n        # file exists\n    }\n    \nChecking if a file does not exist:\n\n    !if { g: somefile.txt } then {\n        # file does not exist\n    }\n    \nReturn all files apart from text files:\n\n    !g: *.txt\n    \nFiltering a file list based on glob matches:\n\n    f: +f -> g: *.md\n    \nRemove any glob matches from a file list:\n\n    f: +f -> !g: *.md\n\n## Detail\n\n### Pattern Reference\n\n* `*` matches any number of (including zero) characters\n* `?` matches any single character\n\n### Inverse Matches\n\nIf you want to exclude any matches based on wildcards, rather than include\nthem, then you can use the bang prefix. eg\n\n    » g: READ*\n    [\n        \"README.md\"\n    ]\n    \n    » !g: *\n    Error in `!g` (1,1): No data returned.\n    \n### When Used As A Method\n\n`!g` first looks for files that match its pattern, then it reads the file list\nfrom STDIN. If STDIN contains contents that are not files then `!g` might not\nhandle those list items correctly. This shouldn't be an issue with `frx` in its\nnormal mode because it is only looking for matches however when used as `!g`\nany items that are not files will leak through.\n\nThis is its designed feature and not a bug. If you wish to remove anything that\nalso isn't a file then you should first pipe into either `g: *`, `rx: .*`, or\n`f +f` and then pipe that into `!g`.\n\nThe reason for this behavior is to separate this from `!regexp` and `!match`.\n\n## Synonyms\n\n* `g`\n* `!g`\n\n\n## See Also\n\n* [commands/`f`](../commands/f.md):\n  Lists or filters file system objects (eg files)\n* [commands/`match`](../commands/match.md):\n  Match an exact value in an array\n* [commands/`regexp`](../commands/regexp.md):\n  Regexp tools for arrays / lists of strings\n* [commands/`rx`](../commands/rx.md):\n  Regexp pattern matching for file system objects (eg `.*\\\\.txt`)"

}
