//go:build !windows && !plan9
// +build !windows,!plan9

package defaults

/*
   WARNING:
   --------

   This Go source file has been automatically generated from
   profile_posix.mx using docgen.

   Please do not manually edit this file because it will be automatically
   overwritten by the build pipeline. Instead please edit the aforementioned
   profile_posix.mx file located in the same directory.
*/

func init() {
	murexProfile = append(murexProfile, "#config set shell prompt {\n#    out \"${pwd -> egrep -o '[^/]+$'} » \"\n#}\n#\n#config set shell prompt-multiline {\n#    let len = ${pwd_short -> wc -c} - 1\n#    printf \"%${$len}s » \" $linenum\n#}\n\nfunction pwd_short {\n    # Normalise path to it's short form\n    pwd -> regexp \"s#^$HOME#\\~#\"\n}\n\nconfig: set shell prompt {\n    exitnum -> !if {\n        out \"{RESET}{YELLOW}${pwd_short -> egrep -o '[^/]+$'} {GREEN}»{RESET} \"\n    } else {\n        out \"{RESET}{YELLOW}${pwd_short -> egrep -o '[^/]+$'} {RED}»{RESET} \"\n    }\n}\n\nconfig: set shell prompt-multiline {\n    let len = ${pwd_short -> egrep -o '[^/]+$' -> wc -c} - 1\n    printf \"%${$len}s » \" $linenum\n}\n\nautocomplete set man { [{\n    \"IncExePath\": true\n}] }\n\nautocomplete set man-summary { [{\n    \"IncExePath\": true,\n    \"AllowMultiple\": true\n}] }\n\nautocomplete set which { [{\n    \"IncExePath\": true\n}] }\n\nautocomplete set whereis { [{\n    \"IncExePath\": true\n}] }\n\nautocomplete set sudo { [\n    {\n        \"IncFiles\": true,\n        \"IncDirs\": true,\n        \"IncExePath\": true\n    },\n    {\n        \"NestedCommand\": true\n    }\n] }\n\nautocomplete set dd { [{\n    \"Flags\": [ \"if=\", \"of=\", \"bs=\", \"iflag=\", \"oflag=\", \"count=\", \"status=\" ]\n}] }\n\nprivate getHostsFile {\n    # Parse the hosts file and return uniq host names and IPs\n    cat /etc/hosts -> !regexp: 'm/^(#.*|\\s*)$/' -> regexp: \"s/[\\s\\t]+/\\n/\" -> sort -> uniq -> cast: str\n}\n\ntest unit private getHostsFile {\n    \"StdoutRegex\": \"[-_.0-9a-zA-Z]+\\n\",\n    \"StdoutType\":  \"str\",\n    \"StdoutBlock\": ({\n        -> len -> set len;\n        if { = len>0 } then {\n            out \"Len greater than 0\"\n        } else {\n            err \"No elements returned\"\n        }\n    }),\n    \"StdoutIsArray\": true\n}\n\nautocomplete set ssh { [{\n    \"Dynamic\": ({ getHostsFile })\n}] }\n\nautocomplete set ping { [ {\n    \"Dynamic\": ({ getHostsFile })\n}] }\n\nautocomplete set rsync { [\n    {\n        \"DynamicDesc\": ({\n            rsync --help -> @[^Options$..--help]re -> tabulate: --map --split-comma --column-wraps --key-inc-hint\n        }),\n        \"AllowMultiple\": true,\n        \"Optional\": true\n    },\n    {\n        \"Dynamic\": ({ getHostsFile }),\n        \"AllowMultiple\": true\n    }\n] }\n\nautocomplete set sftp { [ {\n    \"Dynamic\": \"{ getHostsFile }\"\n}] }\n\nprivate autocomplete.kill {\n    # Autocomplete suggestion for `kill`\n    test define ps {\n        \"ExitNum\": 0\n    }\n    \n    test define map {\n        \"StdoutRegex\": (\\{(\".*?\":\".*?\",?)+\\})\n    }\n\n    ps <test_ps> -A -o pid -o command -> sed 1d -> set ps\n    map <test_map> { $ps[:0] } { $ps -> regexp 'f/^[ 0-9]+ (.*)$' }\n}\n\ntest unit private autocomplete.kill {\n    \"StdoutType\": \"json\",\n    \"StdoutRegex\": \"\\\\{\\\\\\\"[0-9]+\\\\\\\":\\\\\\\".*?\\\\\\\"(,|)\\\\}\"\n}\n\nautocomplete set kill {\n    [{\n        \"DynamicDesc\": ({ autocomplete.kill }),\n        \"ListView\": true,\n        \"AllowMultiple\": true\n    }]\n}\n\nautocomplete: set bg {\n    [{\n        \"DynamicDesc\": ({ fid-list --stopped }),\n        \"ListView\": true\n    }]\n}\n\nautocomplete: set fg {\n    [{\n        \"DynamicDesc\": ({\n            fid-list: --background -> alter -m / ${ fid-list --stopped }\n        }),\n        \"ListView\": true\n    }]\n}\n\nprivate go-package {\n    # returns all the packages in $GOPATH\n    find <!null> $GOPATH/src/ -type d -not -path */.* -> sed -r s:$GOPATH/src/::\n}\n\nautocomplete set go { [{\n    \"Flags\": [ \"help\" ],\n    \"DynamicDesc\": ({\n        go help -> @[^The commands are..^Use]r -> tabulate: --map\n    }),\n    \"FlagValues\": {\n        \"get\": [{\n            \"Flags\": [ \"github.com/\" ]\n        }],\n        \"run\": [{\n            \"Dynamic\": ({ go-package }),\n            \"AutoBranch\": true\n        }],\n        \"test\": [{\n            \"Dynamic\": ({ go-package }),\n            \"AutoBranch\": true,\n            \"Flags\": [ \"./...\" ]\n        }],\n        \"mod\": [{\n            \"DynamicDesc\": ({\n                go help mod -> @[^The commands are..^Use]r -> tabulate: --map\n            })\n        }],\n        \"help\": [{\n            \"DynamicDesc\": ({\n                go help -> tabulate: --map\n            })\n        }],\n        \"build\": [{ \"Dynamic\": ({ go-package }), \"AutoBranch\": true }],\n        \"install\": [{ \"Dynamic\": ({ go-package }), \"AutoBranch\": true }],\n        \"fmt\": [{ \"IncFiles\": true }],\n        \"vet\": [{ \"IncFiles\": true }],\n        \"generate\": [{ \"IncFiles\": true }]\n    }\n}] }\n\nautocomplete: set zfs {\n    [{\n        \"Dynamic\": ({\n             zfs ? egrep \"^\\t[a-z]+\" -> regexp 'f/\\t+([a-z]+)/' -> uniq \n        })\n    }]\n}\n\nautocomplete: set zpool {\n    [{\n        \"Dynamic\": ({\n             zpool ? egrep \"^\\t[a-z]+\" -> regexp 'f/\\t+([a-z]+)/' -> uniq \n        })\n    }]\n}\n\nconfig eval shell safe-commands {\n    -> alter --merge / ([\n        \"cat\", \"ps\", \"grep\", \"egrep\", \"ls\", \"head\", \"tail\", \"printf\", \"awk\", \"sed\", \"td\", \"cut\"\n    ])\n}\n\nif { which bash } then {\n    function bash {\n        # Wrapper script around GNU bash\n        config: set proc force-tty true\n        \n        if { $ARGS -> len -> = -1 } then {\n            exec bash @{ $ARGS -> @[1..] }\n        \n        } else {\n            exec bash\n        }\n    }\n\n    trypipe {\n        man-summary: <!null> bash -> set: bash_summary\n        summary bash $bash_summary\n        !set bash_summary\n    }\n}\n\nautocomplete set make { [\n    {\n        \"DynamicDesc\":  ({\n            make --help -> tabulate: --key-inc-hint --map --split-comma --column-wraps\n        }),\n        \"Optional\": true,\n        \"AllowMultiple\": true\n    },\n    {\n        \"Dynamic\": ({\n            grep '^[^\\.][-a-zA-Z\\.0-9_\\/]*:' ./Makefile -> regexp 's/:.*//g' -> uniq\n        })\n    }\n] }\n\nif { which: aspell } then {\n    config: set shell spellcheck-enabled true\n}")
}
