package docs

func init() {

	Definition["ja"] = "# _murex_ Shell Docs\n\n## Command Reference: `ja`\n\n> A sophisticated yet simply way to build a JSON array\n\n## Description\n\n_murex_ has a pretty sophisticated builtin for generating JSON arrays.\nIt works a little bit like Bash's `{1..9}` syntax but includes a few\nadditional nifty features.\n\n## Usage\n\n    ja: [start..end] -> <stdout>\n    ja: [start..end.base] -> <stdout>\n    ja: [start..end,start..end] -> <stdout>\n    ja: [start..end][start..end] -> <stdout>\n\n## Examples\n\n    » ja: [1..5]\n    [\n        \"1\",\n        \"2\",\n        \"3\",\n        \"4\",\n        \"5\"\n    ]\n    \n    » ja: [Monday..Sunday]\n    [\n        \"Monday\",\n        \"Tuesday\",\n        \"Wednesday\",\n        \"Thursday\",\n        \"Friday\",\n        \"Saturday\",\n        \"Sunday\"\n    ]\n    \nPlease note that as per the first example, all arrays generated by `ja` are\narrays of strings - even if you're command is ranging over integers.\n\n## Detail\n\nPlease read the documentation on `a` for a more detailed breakdown on of\n`ja`'s supported features.\n\n## See Also\n\n* [commands/`@[` (range) ](../commands/range.md):\n  Outputs a ranged subset of data from STDIN\n* [commands/`[[` (element)](../commands/element.md):\n  Outputs an element from a nested structure\n* [commands/`[` (index)](../commands/index.md):\n  Outputs an element from an array, map or table\n* [commands/`a` (mkarray)](../commands/a.md):\n  A sophisticated yet simple way to build an array or list\n* [types/`json` ](../types/json.md):\n  JavaScript Object Notation (JSON) (primitive)\n* [commands/`len` ](../commands/len.md):\n  Outputs the length of an array\n* [commands/`mtac`](../commands/mtac.md):\n  Reverse the order of an array\n* [commands/`ta`](../commands/ta.md):\n  A sophisticated yet simple way to build an array of a user defined data-type"

}
