package docs

func init() {

	Definition["rand"] = "# _murex_ Shell Docs\n\n## Command Reference: `rand`\n\n> Random field generator\n\n## Description\n\n`rand` can generate random numbers, strings and other data types.\n\n## Usage\n\n    rand data-type [ max-value ]\n\n## Examples\n\nRandom integer: 64-bit on 64-bit machines\n\n    rand int\n    \nRandom integer between 0 and 9\n\n    rand int 9\n    \nRandom floating point number between 0 and 1\n\n    rand float\n    \nRandom string, fixed to 5 characters long\n\n    rand str 5\n\n## Flags\n\n* `*`\n    Alias for **str** (string)\n* `float`\n    Random floating point number between 0 and 1. **max-value** not supported\n* `int`\n    Random integer, **max-value** specifies highest value for integer\n* `num`\n    Alias for **int** in this builtin\n* `str`\n    Random string of printable ASCII characters. **max-value** specifies the fixed length of the string\n\n## Detail\n\n### Security\n\nWARNING: is should be noted that while `rand` can produce random numbers and\nstrings which might be useful for password generation, neither the RNG nor the\nthe random string generator (which is ostensibly the same RNG but applied to an\narray of bytes within the range of printable ASCII characters) are considered\ncryptographically secure.\n\n## See Also\n\n* [commands/`format`](../commands/format.md):\n  Reformat one data-type into another data-type\n* [commands/`let`](../commands/let.md):\n  Evaluate a mathematical function and assign to variable\n* [commands/`set`](../commands/set.md):\n  Define a local variable and set it's value"

}
