package palette

import "github.com/muesli/gamut"

// https://developer.mozilla.org/en-US/docs/Web/CSS/color_value
func init() {
	CSS.AddColors(
		gamut.Colors{
			// CSS Level 1
			{Name: "black", Color: gamut.Hex("#000000"), Reference: ""},
			{Name: "silver", Color: gamut.Hex("silver"), Reference: ""},
			{Name: "gray", Color: gamut.Hex("#808080"), Reference: ""},
			{Name: "white", Color: gamut.Hex("#ffffff"), Reference: ""},
			{Name: "maroon", Color: gamut.Hex("#800000"), Reference: ""},
			{Name: "red", Color: gamut.Hex("#ff0000"), Reference: ""},
			{Name: "purple", Color: gamut.Hex("#800080"), Reference: ""},
			{Name: "fuchsia", Color: gamut.Hex("#ff00ff"), Reference: ""},
			{Name: "green", Color: gamut.Hex("#008000"), Reference: ""},
			{Name: "lime", Color: gamut.Hex("#00ff00"), Reference: ""},
			{Name: "olive", Color: gamut.Hex("#808000"), Reference: ""},
			{Name: "yellow", Color: gamut.Hex("#ffff00"), Reference: ""},
			{Name: "navy", Color: gamut.Hex("#000080"), Reference: ""},
			{Name: "blue", Color: gamut.Hex("#0000ff"), Reference: ""},
			{Name: "teal", Color: gamut.Hex("#008080"), Reference: ""},
			{Name: "aqua", Color: gamut.Hex("#00ffff"), Reference: ""},

			// CSS Level 2 (Revision 1)
			{Name: "orange", Color: gamut.Hex("#ffa500"), Reference: ""},

			// CSS Color Module Level 3
			{Name: "aliceblue", Color: gamut.Hex("#f0f8ff"), Reference: ""},
			{Name: "antiquewhite", Color: gamut.Hex("#faebd7"), Reference: ""},
			{Name: "aquamarine", Color: gamut.Hex("#7fffd4"), Reference: ""},
			{Name: "azure", Color: gamut.Hex("#f0ffff"), Reference: ""},
			{Name: "beige", Color: gamut.Hex("#f5f5dc"), Reference: ""},
			{Name: "bisque", Color: gamut.Hex("#ffe4c4"), Reference: ""},
			{Name: "blanchedalmond", Color: gamut.Hex("#ffebcd"), Reference: ""},
			{Name: "blueviolet", Color: gamut.Hex("#8a2be2"), Reference: ""},
			{Name: "brown", Color: gamut.Hex("#a52a2a"), Reference: ""},
			{Name: "burlywood", Color: gamut.Hex("#deb887"), Reference: ""},
			{Name: "cadetblue", Color: gamut.Hex("#5f9ea0"), Reference: ""},
			{Name: "chartreuse", Color: gamut.Hex("#7fff00"), Reference: ""},
			{Name: "chocolate", Color: gamut.Hex("#d2691e"), Reference: ""},
			{Name: "coral", Color: gamut.Hex("#ff7f50"), Reference: ""},
			{Name: "cornflowerblue", Color: gamut.Hex("#6495ed"), Reference: ""},
			{Name: "cornsilk", Color: gamut.Hex("#fff8dc"), Reference: ""},
			{Name: "crimson", Color: gamut.Hex("#dc143c"), Reference: ""},
			{Name: "cyan", Color: gamut.Hex("#00ffff"), Reference: ""}, // not: synonym of aqua
			{Name: "darkblue", Color: gamut.Hex("#00008b"), Reference: ""},
			{Name: "darkcyan", Color: gamut.Hex("#008b8b"), Reference: ""},
			{Name: "darkgoldenrod", Color: gamut.Hex("#b8860b"), Reference: ""},
			{Name: "darkgray", Color: gamut.Hex("#a9a9a9"), Reference: ""},
			{Name: "darkgreen", Color: gamut.Hex("#006400"), Reference: ""},
			{Name: "darkgrey", Color: gamut.Hex("#a9a9a9"), Reference: ""},
			{Name: "darkkhaki", Color: gamut.Hex("#bdb76b"), Reference: ""},
			{Name: "darkmagenta", Color: gamut.Hex("#8b008b"), Reference: ""},
			{Name: "darkolivegreen", Color: gamut.Hex("#556b2f"), Reference: ""},
			{Name: "darkorange", Color: gamut.Hex("#ff8c00"), Reference: ""},
			{Name: "darkorchid", Color: gamut.Hex("#9932cc"), Reference: ""},
			{Name: "darkred", Color: gamut.Hex("#8b0000"), Reference: ""},
			{Name: "darksalmon", Color: gamut.Hex("#e9967a"), Reference: ""},
			{Name: "darkseagreen", Color: gamut.Hex("#8fbc8f"), Reference: ""},
			{Name: "darkslateblue", Color: gamut.Hex("#483d8b"), Reference: ""},
			{Name: "darkslategray", Color: gamut.Hex("#2f4f4f"), Reference: ""},
			{Name: "darkturquoise", Color: gamut.Hex("#00ced1"), Reference: ""},
			{Name: "darkviolet", Color: gamut.Hex("#9400d3"), Reference: ""},
			{Name: "deeppink", Color: gamut.Hex("#ff1493"), Reference: ""},
			{Name: "deepskyblue", Color: gamut.Hex("#00bfff"), Reference: ""},
			{Name: "dimgray", Color: gamut.Hex("#696969"), Reference: ""},
			{Name: "dimgrey", Color: gamut.Hex("#696969"), Reference: ""}, // note: synonym of dimgray
			{Name: "dodgerblue", Color: gamut.Hex("#1e90ff"), Reference: ""},
			{Name: "firebrick", Color: gamut.Hex("#b22222"), Reference: ""},
			{Name: "floralwhite", Color: gamut.Hex("#fffaf0"), Reference: ""},
			{Name: "forestgreen", Color: gamut.Hex("#228b22"), Reference: ""},
			{Name: "gainsboro", Color: gamut.Hex("#dcdcdc"), Reference: ""},
			{Name: "ghostwhite", Color: gamut.Hex("#f8f8ff"), Reference: ""},
			{Name: "gold", Color: gamut.Hex("#ffd700"), Reference: ""},
			{Name: "goldenrod", Color: gamut.Hex("#daa520"), Reference: ""},
			{Name: "greenyellow", Color: gamut.Hex("#adff2f"), Reference: ""},
			{Name: "grey", Color: gamut.Hex("#808080"), Reference: ""},
			{Name: "honeydew", Color: gamut.Hex("#f0fff0"), Reference: ""},
			{Name: "hotpink", Color: gamut.Hex("#ff69b4"), Reference: ""},
			{Name: "indianred", Color: gamut.Hex("#cd5c5c"), Reference: ""},
			{Name: "indigo", Color: gamut.Hex("#4b0082"), Reference: ""},
			{Name: "ivory", Color: gamut.Hex("#fffff0"), Reference: ""},
			{Name: "khaki", Color: gamut.Hex("#f0e68c"), Reference: ""},
			{Name: "lavender", Color: gamut.Hex("#e6e6fa"), Reference: ""},
			{Name: "lavenderblush", Color: gamut.Hex("#fff0f5"), Reference: ""},
			{Name: "lawngreen", Color: gamut.Hex("#7cfc00"), Reference: ""},
			{Name: "lemonchiffon", Color: gamut.Hex("#fffacd"), Reference: ""},
			{Name: "lightblue", Color: gamut.Hex("#add8e6"), Reference: ""},
			{Name: "lightcoral", Color: gamut.Hex("#f08080"), Reference: ""},
			{Name: "lightcyan", Color: gamut.Hex("#e0ffff"), Reference: ""},
			{Name: "lightgoldenrodyellow", Color: gamut.Hex("#fafad2"), Reference: ""},
			{Name: "lightgray", Color: gamut.Hex("#d3d3d3"), Reference: ""},
			{Name: "lightgrey", Color: gamut.Hex("#d3d3d3"), Reference: ""}, // note: synonym of lightgray
			{Name: "lightgreen", Color: gamut.Hex("#90ee90"), Reference: ""},
			{Name: "lightgrey", Color: gamut.Hex("#d3d3d3"), Reference: ""},
			{Name: "lightpink", Color: gamut.Hex("#ffb6c1"), Reference: ""},
			{Name: "lightsalmon", Color: gamut.Hex("#ffa07a"), Reference: ""},
			{Name: "lightseagreen", Color: gamut.Hex("#20b2aa"), Reference: ""},
			{Name: "lightskyblue", Color: gamut.Hex("#87cefa"), Reference: ""},
			{Name: "lightslategray", Color: gamut.Hex("#778899"), Reference: ""},
			{Name: "lightslategrey", Color: gamut.Hex("#778899"), Reference: ""}, // note: synonym of lightslategray
			{Name: "lightsteelblue", Color: gamut.Hex("#b0c4de"), Reference: ""},
			{Name: "lightyellow", Color: gamut.Hex("#ffffe0"), Reference: ""},
			{Name: "limegreen", Color: gamut.Hex("#32cd32"), Reference: ""},
			{Name: "linen", Color: gamut.Hex("#faf0e6"), Reference: ""},
			{Name: "magenta", Color: gamut.Hex("#ff00ff"), Reference: ""}, // note: synonym of fuchsia
			{Name: "mediumaquamarine", Color: gamut.Hex("#66cdaa"), Reference: ""},
			{Name: "mediumblue", Color: gamut.Hex("#0000cd"), Reference: ""},
			{Name: "mediumorchid", Color: gamut.Hex("#ba55d3"), Reference: ""},
			{Name: "mediumpurple", Color: gamut.Hex("#9370db"), Reference: ""},
			{Name: "mediumseagreen", Color: gamut.Hex("#3cb371"), Reference: ""},
			{Name: "mediumslateblue", Color: gamut.Hex("#7b68ee"), Reference: ""},
			{Name: "mediumspringgreen", Color: gamut.Hex("#00fa9a"), Reference: ""},
			{Name: "mediumturquoise", Color: gamut.Hex("#48d1cc"), Reference: ""},
			{Name: "mediumvioletred", Color: gamut.Hex("#c71585"), Reference: ""},
			{Name: "midnightblue", Color: gamut.Hex("#191970"), Reference: ""},
			{Name: "mintcream", Color: gamut.Hex("#f5fffa"), Reference: ""},
			{Name: "mistyrose", Color: gamut.Hex("#ffe4e1"), Reference: ""},
			{Name: "moccasin", Color: gamut.Hex("#ffe4b5"), Reference: ""},
			{Name: "navajowhite", Color: gamut.Hex("#ffdead"), Reference: ""},
			{Name: "oldlace", Color: gamut.Hex("#fdf5e6"), Reference: ""},
			{Name: "olivedrab", Color: gamut.Hex("#6b8e23"), Reference: ""},
			{Name: "orangered", Color: gamut.Hex("#ff4500"), Reference: ""},
			{Name: "orchid", Color: gamut.Hex("#da70d6"), Reference: ""},
			{Name: "palegoldenrod", Color: gamut.Hex("#eee8aa"), Reference: ""},
			{Name: "palegreen", Color: gamut.Hex("#98fb98"), Reference: ""},
			{Name: "paleturquoise", Color: gamut.Hex("#afeeee"), Reference: ""},
			{Name: "palevioletred", Color: gamut.Hex("#db7093"), Reference: ""},
			{Name: "papayawhip", Color: gamut.Hex("#ffefd5"), Reference: ""},
			{Name: "peachpuff", Color: gamut.Hex("#ffdab9"), Reference: ""},
			{Name: "peru", Color: gamut.Hex("#cd853f"), Reference: ""},
			{Name: "pink", Color: gamut.Hex("#ffc0cb"), Reference: ""},
			{Name: "plum", Color: gamut.Hex("#dda0dd"), Reference: ""},
			{Name: "powderblue", Color: gamut.Hex("#b0e0e6"), Reference: ""},
			{Name: "rosybrown", Color: gamut.Hex("#bc8f8f"), Reference: ""},
			{Name: "royalblue", Color: gamut.Hex("#4169e1"), Reference: ""},
			{Name: "saddlebrown", Color: gamut.Hex("#8b4513"), Reference: ""},
			{Name: "salmon", Color: gamut.Hex("#fa8072"), Reference: ""},
			{Name: "sandybrown", Color: gamut.Hex("#f4a460"), Reference: ""},
			{Name: "seagreen", Color: gamut.Hex("#2e8b57"), Reference: ""},
			{Name: "seashell", Color: gamut.Hex("#fff5ee"), Reference: ""},
			{Name: "sienna", Color: gamut.Hex("#a0522d"), Reference: ""},
			{Name: "skyblue", Color: gamut.Hex("#87ceeb"), Reference: ""},
			{Name: "slateblue", Color: gamut.Hex("#6a5acd"), Reference: ""},
			{Name: "slategray", Color: gamut.Hex("#708090"), Reference: ""},
			{Name: "slategrey", Color: gamut.Hex("#708090"), Reference: ""}, // note: synonym of slategray
			{Name: "snow", Color: gamut.Hex("#fffafa"), Reference: ""},
			{Name: "springgreen", Color: gamut.Hex("#00ff7f"), Reference: ""},
			{Name: "steelblue", Color: gamut.Hex("#4682b4"), Reference: ""},
			{Name: "tan", Color: gamut.Hex("#d2b48c"), Reference: ""},
			{Name: "thistle", Color: gamut.Hex("#d8bfd8"), Reference: ""},
			{Name: "tomato", Color: gamut.Hex("#ff6347"), Reference: ""},
			{Name: "turquoise", Color: gamut.Hex("#40e0d0"), Reference: ""},
			{Name: "violet", Color: gamut.Hex("#ee82ee"), Reference: ""},
			{Name: "wheat", Color: gamut.Hex("#f5deb3"), Reference: ""},
			{Name: "whitesmoke", Color: gamut.Hex("#f5f5f5"), Reference: ""},
			{Name: "yellowgreen", Color: gamut.Hex("#9acd32"), Reference: ""},

			// CSS Color Module Level 4
			// https://en.wikipedia.org/wiki/Eric_A._Meyer#Personal_life
			{Name: "rebeccapurple", Color: gamut.Hex("#663399"), Reference: ""},
		})
}
