## mp init

Initialize a microplane workflow

### Synopsis

Initialize a microplane workflow.

There are two ways to init, either (1) from a file or (2) via search

## (1) Init from File

$ mp init -f repos.txt

where repos.txt has lines like:

	clever/repo2
	clever/repo2

## (2) Init via Search

### GitHub Code Search

- Search target repos based on a Github Code Search query.

For example:

$ mp init "org:Clever filename:circle.yml"

would target all Clever repos with a circle.yml file.

See https://help.github.com/articles/searching-code/ for more details about the search syntax on Github.

### Github Repo Search

- Search target repos based on a Github Repo Search query.

To init all repos belonging to a specific org use --all-repos flag.

$ mp init "clever" --all-repos

would target all repos in clever org.

To init repos with additional parameters use --repo-search flag

For example:

$ mp init "org:Clever language:Go" --repo-search

would target all Clever repos written in Go

See https://help.github.com/articles/searching-repositories/ for more details about the search syntax on Github.

### GitLab

Search target repos based on a GitLab search.

If you are using the *public* version of GitLab, search is done via the Global "projects" scope.
See https://docs.gitlab.com/ce/api/search.html#scope-projects for more information on the search syntax. For example

$ mp init "mp-test-1"

would target a specific repo called mp-test-1.

If you are using an *enterprise* GitLab instance, we assume you have an ElasticSearch setup.
See https://docs.gitlab.com/ee/user/search/advanced_search_syntax.html for more details about the search syntax on Gitlab.

```
mp init [query] [flags]
```

### Options

```
      --all-repos             get all repos for a given org
  -f, --file string           get repos from a file instead of searching
  -h, --help                  help for init
      --provider string       'github' or 'gitlab' (default "github")
      --provider-url string   custom URL for enterprise setups
      --repo-search           get repos from a github repo search
```

### Options inherited from parent commands

```
  -r, --repo string   single repo to operate on
```

### SEE ALSO

* [mp](mp.md)	 - Microplane makes git changes across many repos

###### Auto generated by spf13/cobra on 21-Mar-2021
