// Code generated by go-bindata.
// sources:
// larry3d.flf
// standard.flf
// DO NOT EDIT!

package figlet4go

import (
	"bytes"
	"compress/gzip"
	"fmt"
	"io"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)

func bindataRead(data []byte, name string) ([]byte, error) {
	gz, err := gzip.NewReader(bytes.NewBuffer(data))
	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}

	var buf bytes.Buffer
	_, err = io.Copy(&buf, gz)
	clErr := gz.Close()

	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}
	if clErr != nil {
		return nil, err
	}

	return buf.Bytes(), nil
}

type asset struct {
	bytes []byte
	info  os.FileInfo
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

func (fi bindataFileInfo) Name() string {
	return fi.name
}
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}
func (fi bindataFileInfo) IsDir() bool {
	return false
}
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _larry3dFlf = []byte("\x1f\x8b\x08\x00\x00\x09\x6e\x88\x00\xff\xb4\x5a\x5d\x6b\x5c\x39\x0f\xbe\x9f\x5f\xa1\x8b\xc0\x69\xe1\x10\xbd\x4d\xfb\x2e\x14\x86\x61\xa0\x17\x85\x65\xae\xf7\xca\xa0\x33\x6d\x27\xd9\xb2\xd3\xa4\x24\xcd\xee\x06\xf2\xe3\x17\xdb\x92\x25\xf9\xf8\xcc\x67\x92\x0d\x5b\x7b\x4e\xc6\x8f\x25\x4b\x8f\x3e\x7c\xae\xb7\xd7\x57\xeb\x0b\xf8\x08\xbf\xc1\xfb\xff\xc1\x3b\xf8\xff\x6c\xbb\xbe\xbf\x7f\x7a\xff\xed\xf2\x7a\x7b\x0d\x5f\x9e\x60\x15\xa7\xf0\x79\xb3\xfd\xb2\xb9\xbf\x81\x37\xe9\xe9\xcd\x72\xfd\xf7\xc3\xe5\xd7\xbb\x1f\x6f\x67\x6f\x1e\x7e\xdd\x6d\x37\xb7\xb0\xfd\xfe\x65\x73\xbf\xde\x6e\x9f\xe0\xfa\xfe\xee\x07\xfc\xfe\xb8\xbe\x85\x4f\xeb\xfb\xee\x01\x7e\x3e\x5e\x5f\x3f\xc5\xd5\xde\xce\x7e\xfd\xb3\x59\xff\xb5\xf9\x16\x97\xfd\xbc\xdd\xdc\xde\xc2\xa7\x3f\xd7\x3f\x7f\x6e\xb6\x5b\x98\xdf\xdc\x7c\x5d\x3e\x7e\x7f\xfc\x7a\xb9\xf9\xf6\xb8\x98\xfd\xb1\xb9\x7f\xf8\x7e\x77\x0b\xef\x2e\xaf\xe0\x0a\xaf\x3e\xe0\xc7\x0f\xb3\xd9\xc5\xc5\x05\xf0\xcf\x72\x06\x3a\x5b\xce\x40\x67\x71\x52\x66\x69\x22\xb3\x3c\xe1\x19\x4f\xf2\x4c\x26\x69\x56\x26\x71\xb6\x5c\xce\x80\x88\xd7\xc2\x00\x21\x8f\xe2\x20\xe4\x55\x78\x18\xbf\x15\x20\x50\xc8\xdf\x0f\x18\x28\xe4\x95\x02\x12\xea\x9a\x66\x94\x97\x76\xab\x5b\x00\x0a\x71\xb5\x8c\x81\x84\x48\xc8\x3b\x65\x41\x79\xa7\x32\xd3\x85\x1d\xca\x68\x12\x67\x0a\x1b\x1f\x52\x06\x4e\x9f\xc4\x6d\xc4\x41\xfc\x4d\x52\x05\xa4\x55\x7e\xbe\xa2\xb4\x12\x86\xf8\x77\xe9\x79\x92\x19\x09\xf3\x56\x45\x48\xde\xac\x87\x85\xd1\x54\x15\x2b\xc2\x8b\x22\x02\x76\x44\x43\xd0\xcf\x03\x6f\x25\xee\x91\x08\x42\x56\x49\xd6\x76\xde\x04\x0c\x81\x80\xd5\x3c\x04\x52\xe5\xb3\xfa\x15\x2c\xfe\x93\x84\x8c\xeb\x23\x20\xcb\x88\x3c\x91\x6d\xe6\x09\xcf\xd2\x84\xb2\xf8\x90\xff\x96\x01\xd2\xa4\x3a\xe1\xb1\xb0\xac\x73\x55\x39\x3e\x47\x0d\x06\x9e\x3d\x63\x1c\x3d\xcb\x17\x03\x22\x44\xf9\x31\xc9\x19\xff\x34\xac\x16\x00\x73\x5a\xce\xe0\x39\xab\x80\x30\x6b\x3b\x20\x4f\x6a\xc0\x11\x7c\xdb\x86\xf1\x42\x20\x93\x1d\x89\x71\x19\xcb\xba\x68\x5a\xae\xb3\xe1\x64\x0c\xf9\x53\xec\x64\x71\x0c\xd0\x63\xe7\x7c\x45\x9c\x65\x28\xde\x32\x04\xe2\x73\x1a\x42\x65\x31\x76\x58\x6d\x9f\x2d\x23\xc4\x7f\xf3\x52\x43\x1c\x67\xc7\x1b\x42\xdc\x43\x3e\xa8\x40\x7c\x2c\xd5\xe2\xd5\xf6\x2b\x4f\x80\xe2\x06\x03\x74\x20\x3e\xb0\x80\x78\x02\xe2\x00\x3d\xf4\xce\xfa\xad\xe9\x3b\xe5\xbb\x71\x05\x26\x27\x91\xf4\x42\xd9\xb8\xd9\xff\xa2\x77\x45\x80\x78\xbe\xc9\xce\x19\xc0\x10\xcc\x21\x60\xf2\x51\xf5\x7f\x86\x89\x6a\x8a\x36\x90\xcf\x9f\x9f\x4e\x1c\x81\x1b\x52\xfe\x91\xbd\x52\xd9\x6a\x32\xc6\xfd\x2b\xec\xdf\x1a\x2f\x88\xee\xa9\x2c\x41\xa4\x3e\xaa\xfe\x99\x8f\x3c\xfb\xb3\xf1\xe5\xec\xa0\x71\xd1\x3c\xd8\x65\xc5\xc6\x8c\x1d\xff\x20\x13\x7c\x00\xf9\x4f\x68\x5f\xf9\x27\xa8\xec\x49\x13\xfb\x4e\xa6\xe9\x32\xd4\x73\x50\x49\x66\x25\x51\x45\x31\xc5\x02\x8c\x01\xec\x52\x31\x79\x89\x54\x24\x0a\x50\x64\x8a\x64\x8d\x80\x85\xdd\xe2\x98\xa5\x92\xd3\x35\x54\x53\xd3\xfa\x38\xb4\x4c\xa9\x91\xc2\xca\x40\x52\xa0\xe2\x4d\x90\x9e\x9c\xa2\x46\x17\xc6\x4c\xf8\x94\xb3\xf2\xbc\x13\x72\x88\x29\x40\xd0\x0b\xfb\xb0\x17\xab\x36\x73\x40\xd8\xcf\xa9\xc2\xe9\x09\x3d\xce\x83\x82\x13\x61\xc1\x8e\xca\x1f\xf2\x11\x06\x2b\xb0\x97\xb8\x25\x72\x33\x78\x0b\x68\x3e\x56\x13\x28\x19\x32\xc9\x2d\x88\x69\x33\xa7\x6b\xb8\xf6\x75\x00\x71\x76\xc4\x0e\x3b\x76\xc0\x2e\xfe\xa6\xe3\x4c\x23\xe6\x37\x75\xb9\x18\xd3\xc6\x00\x63\xaf\xb0\xb6\x03\xc6\x05\x8d\xed\x2c\x80\xe0\x05\x6c\xc7\x53\xb1\xa0\x39\xb8\x92\x72\xf4\xec\x8a\x71\xd9\x1e\xd5\x19\xbd\x3b\x36\xf2\x80\x86\x7b\x98\x4f\x25\xae\x49\x3a\xc2\xae\x21\x41\xa6\x04\x98\xd1\xf7\x8e\x5b\xa8\xe8\x47\x74\x53\x2f\x44\xc5\xf9\x81\x89\x34\x0d\xe2\x72\x73\x80\x39\x2b\x62\x48\xbf\x29\xda\xc6\xc0\xfd\x2c\x71\x7b\x47\x64\xb5\x7a\xa0\xe2\x2d\x26\x6c\xf0\x56\x33\xb3\x14\xc1\x25\xa4\x14\xd2\xd9\xa9\xd5\x5a\xc5\xad\x54\xc1\x6d\x7e\x01\xb0\xa8\xc4\x0d\xe2\xee\xd9\x4e\xf7\x64\x3a\xd9\x60\x72\x1a\x93\xa2\x7f\x18\x38\x5e\x15\x8f\xc0\x63\x0b\x81\x4a\x20\x63\x9b\x19\x8b\x04\x37\xce\x20\x94\x4c\x2e\x9b\x6a\x76\xf9\x98\x4e\xe5\xbc\x24\x8f\x45\x8b\x83\x70\x77\x43\x57\x44\x56\x5f\x51\x3e\x5b\xe1\xac\x5c\x95\x03\x29\xf7\x16\x02\xe5\xb8\x58\x68\xcc\xb8\x42\xe2\xd3\x03\x72\x62\x97\x12\x27\xca\x1a\x83\x17\x6c\x98\x77\x0a\x7d\x0e\x81\xee\x46\x15\x0f\x62\x11\xc5\x2c\x5f\x1d\xd5\xc8\xaa\xf1\xde\x25\x19\x2f\x8f\xba\xb2\xb2\x02\x85\x15\xbc\xac\xac\x06\xd3\x20\x2a\x1e\xaa\x29\x59\x3b\x52\x23\xda\x59\x11\x1c\x2c\x59\x58\x91\x95\x0c\xfb\x73\x24\x03\x5f\x4a\x55\x2d\x01\xaa\x1c\x06\x9c\xc3\xc0\x4b\x38\x8c\x81\x27\xae\xd2\x4d\xca\xa8\x55\xab\x2d\xbb\xe2\x34\x57\x18\x3c\x43\x43\x0f\x9a\xdb\x1d\x04\xaf\xe0\xa4\xd9\xaa\x4d\x57\x49\xe5\xc4\x33\x72\xe4\x7d\xaa\x8e\x54\xa8\xaa\xee\x53\x9c\x52\x55\x87\xc1\x64\xcf\xa7\xa9\x5a\x9f\x95\x4a\x0d\x6c\x39\x6b\xfc\x55\x9a\x03\x67\x7b\x8e\x7f\x86\x5d\x20\x34\x79\x49\xfa\x71\x29\xa6\xa3\x0d\x42\xc3\x1b\x14\x54\xe8\xe4\x4a\x87\x0a\xbd\x43\xe7\x43\x70\xe6\xdd\xc3\xe0\xcc\x7b\x78\x11\xf3\x36\x4a\x07\x6a\xb1\xa4\xa7\x49\xcf\x93\x60\x15\x7f\x8a\x79\xc3\x04\x6d\x81\xd0\x56\x2f\xf5\xd0\xe9\xb4\x75\xba\x88\xa1\x0b\x4e\x44\xab\xe1\xd4\x74\x3b\x3c\xe2\x7a\xda\x6c\x07\xfc\x1e\x4a\x4b\x4c\xeb\xa9\xe9\x03\x86\x33\xe1\x7b\xa6\x6d\x4e\xb5\x43\x21\x18\xd0\x54\x5f\xe0\x73\x7e\x73\x0a\x7f\x51\x45\x9e\x96\x3a\x2d\x71\xf2\xd2\xa6\xf6\xf6\xd9\x7e\x6d\xd0\xc7\xf2\x17\xbc\xb6\x31\x0b\xbc\x43\x77\xe0\x13\xf9\x06\x16\xfe\x4a\x5a\x66\xa8\x94\x45\x1e\x12\x1f\x01\x3c\x72\x9c\x79\x74\x6c\xef\x60\xb4\x0b\x93\xf9\xa4\x9d\xfc\xab\xbb\xe9\xd8\xe2\xc7\x7d\xe6\x5a\x19\x76\x67\xbe\x0b\x6a\x0f\x64\x08\x83\x89\x28\x43\x40\x58\xe4\x88\x52\xdc\xba\x43\x8d\x29\x29\xbf\xaf\xec\xbf\x41\xb0\xf5\x4e\x54\x43\xa5\x05\x27\x05\x5a\xde\x41\x44\x91\x0a\x4b\x2a\x6a\x18\xce\xb1\xc1\x51\xc6\x90\x4b\x78\x28\x81\x9b\xeb\x78\xfd\xb2\x4c\x45\xd2\x54\x72\x10\x81\xcf\x1c\x6a\x7b\x1c\x59\xe4\xf8\x18\x1c\x01\xb0\xfb\x3b\xea\x03\x17\x52\xad\x33\x80\x23\x3d\x1b\x4f\xf7\x79\x60\xc1\x2a\x2c\x3b\x94\xb2\x70\x90\xb1\xb4\x90\x07\xe9\x21\xfb\xc6\xf4\xae\x2e\x5b\x9d\x8f\xf9\x6c\x0c\x9a\x94\xa2\xbe\x9d\xb5\x79\xb0\x40\xae\x65\x01\xa6\x63\x41\x28\xc4\x19\x10\x63\x0d\x9b\x9b\xf9\xee\xa2\xa8\x75\x4f\xb4\x13\x6c\xef\x1f\x4d\x8e\x0b\x6e\xda\x84\xb6\x90\x5c\x71\xaf\xb5\xfd\xe4\xf5\x44\x28\xd7\x13\x78\xce\xf5\xc4\xd4\x7e\x27\x1b\xbe\xab\x70\x19\x48\xba\x3f\x78\x19\xca\x7e\x47\x59\xcc\x94\xc9\xb5\xb3\x46\x12\x3f\x8a\xb3\x0c\xd9\xce\x1a\xfb\x93\xb2\x46\x3f\x92\x48\x27\x4d\x42\x6d\x11\x96\x9b\x34\x3d\x86\xe9\xbe\x84\x51\x92\xba\xa5\xa9\x73\x7c\x3f\x42\xbb\x11\x54\x7a\x11\x18\x47\xb0\xb3\x53\xdd\x3a\x40\xbb\xfd\x21\x94\x6c\xe9\xc8\xed\x83\xa8\xbc\xad\x05\xe9\x01\x73\xc8\x59\xd6\x97\xb8\xbb\xee\x8d\x0e\xb3\xab\x66\x17\xd3\x5f\x64\x12\x51\x39\x7d\xb4\x45\x12\xe5\xf8\xe6\xec\xca\x1b\x96\xb1\x2c\x50\xf6\x04\x32\x97\x6c\x2f\x51\x77\x96\xcf\x4d\xf9\x27\x7c\xe3\xe3\x78\xd1\x60\x51\xa0\xfd\x7a\xeb\xcc\x2d\x7f\x16\xf6\x0c\xe3\xdb\xf5\x52\x56\x6a\x51\x69\x0a\x2c\xf1\x93\x03\x74\x85\x9d\xbd\x15\x78\x85\xc2\xd1\x84\x1d\xbd\xe4\x8d\xc4\x5c\x85\xb5\x12\x1d\x12\x0c\x98\xf3\x2f\xda\xdb\x1b\x11\x26\xb7\x52\x38\x40\x8b\x9a\x2e\x16\x1b\x5c\x70\x68\x52\x88\xea\xb2\x56\x62\x11\xf7\xb0\xac\xa6\xf1\x48\x39\x88\xb1\xc1\xe3\x5a\x4c\x83\x77\x24\x4d\x28\xcb\x81\xd2\x04\x93\x69\xc3\x3c\xf6\xf8\xb2\x1f\xda\x6a\xa1\xd0\xf5\x69\xf5\xe0\x0e\xfe\x9e\x8d\xae\x22\xe8\xc0\xab\x08\xda\x77\x15\xd1\x70\xbd\x19\x50\x79\x05\x62\xe8\xf2\xcd\x6d\xd9\xb9\xee\xdb\x33\xdf\x84\xe7\xfa\x63\x10\x9a\xed\x85\x66\xe3\x66\x73\x63\xfc\xd0\x63\xf0\x97\x79\xac\xfb\xac\x64\xdb\x93\x75\x99\xa1\x26\x86\xb6\x14\xde\x6b\x45\xa3\xa3\xd6\x37\x43\xac\x79\x96\x1a\xc4\xf6\x72\xc6\x31\xf9\x5c\x0c\x84\xe7\x82\x81\x72\x00\xd5\x15\xe4\x04\x06\x34\x3d\x5f\xb0\x3c\x5e\x85\x29\x95\x5e\xc6\x4d\xc5\x55\x57\xb0\x47\xf8\x2d\xa0\x09\x73\xe0\x17\x88\x18\xb8\x4b\x98\xb8\x00\x98\x23\x27\x81\x28\x3e\x8f\x47\xdc\x89\x34\xc4\x83\x66\x71\xab\x5d\x31\x1c\x34\xce\xc2\x90\x8e\x6d\x01\xe2\x24\x68\x8a\x5b\xd6\xf7\x6e\x2e\x80\x42\xea\xfd\x50\x1a\x07\x00\xee\xe2\xca\x5c\x5b\xed\x31\x42\x21\xfc\x4e\xda\xa3\x7d\xd2\xfe\x9c\xdf\x39\x99\x83\xd4\x23\x5a\x8d\x78\xd3\x76\x5e\x59\xbd\x4a\x25\xe3\x52\x4b\x41\xb3\xb0\x02\x0d\x75\x07\xb7\x3c\x5c\x16\xc0\x9c\xce\xef\xe2\xc8\x0b\x3e\x8b\x78\xca\xe9\xc5\x86\xcc\x03\xa9\x92\xcd\xca\x9a\x24\x15\x72\xb7\x6b\x10\xf8\xbd\x08\xa9\x6e\x08\xf3\xdb\x6f\xd9\x64\x08\xb9\x0a\x28\xef\x03\x56\xef\xbf\xd5\x71\x79\x6f\xcc\x06\x9f\x87\xf8\x5c\x44\xae\xc5\xec\x6d\xba\x6a\x11\x8a\x85\x65\x6d\xe1\x49\xbd\xe6\x9d\xf0\xe4\xe0\xf1\xd5\x5a\x45\x4d\xf8\xd7\x6f\xbb\xee\x80\xcf\x0a\xa4\xf2\x45\x2d\x37\x26\x9a\x82\xbd\xc0\xc7\xca\xbd\x3f\xba\x51\x56\xd0\x15\xdc\x61\xd7\xd0\x06\xf9\xe8\x46\x99\x4b\xa6\x6b\x54\xee\x79\xa0\xbd\x67\xb5\x01\xe9\x44\xd4\xaa\xc7\x4d\xa3\xb6\x5c\x39\xe6\xb9\xbc\xa1\x53\x0e\x5d\xa9\xc2\xbf\x90\x56\x50\x1b\xaf\xcd\x2c\x97\xb3\xff\x02\x00\x00\xff\xff\x1d\x76\x41\x67\x61\x2c\x00\x00")

func larry3dFlfBytes() ([]byte, error) {
	return bindataRead(
		_larry3dFlf,
		"larry3d.flf",
	)
}

func larry3dFlf() (*asset, error) {
	bytes, err := larry3dFlfBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "larry3d.flf", size: 11361, mode: os.FileMode(436), modTime: time.Unix(1477497051, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _standardFlf = []byte("\x1f\x8b\x08\x00\x00\x09\x6e\x88\x00\xff\xb4\x7c\x6d\x73\xda\xc8\xb2\xff\x7b\x3e\x45\xbf\xd8\xfa\x07\xea\x1f\x3c\x46\xb6\xb1\x5d\x95\x93\x32\x06\xd9\xd6\x06\x83\x8f\x80\xec\x49\x56\x5b\xb3\x24\x26\x31\xb5\x04\x52\x36\x3e\x7b\x53\x57\xf7\xbb\xdf\x9a\x47\x8d\x66\x7a\xa4\x91\x73\x6e\x6a\xd7\x60\x8c\xfa\x37\x3d\x33\xdd\xbf\x7e\x18\xe9\xcb\xe6\x4b\xb4\xfc\x05\xfa\x70\x02\xbd\x3e\xf4\x4e\xa0\xd7\x83\x43\x88\x8e\x8f\xfb\x47\xad\xd9\x7e\xb9\xbd\x5f\x3e\xde\xc3\xa7\x1f\x70\xbd\x59\x6d\xb7\x30\x7c\x58\x7e\xff\xbe\xda\x6c\xe0\xff\x41\xb2\xe4\xbf\xae\xe1\x88\x9c\x1f\x41\xb7\x0b\x9f\x96\x4f\xab\x7b\xd8\x6d\xe1\xea\x71\xb9\xfd\xeb\xd5\x13\x1c\x3c\xad\xbf\xb6\x92\xed\xe7\xcd\xf3\xfd\xea\x09\x92\xd9\x14\xc6\xcb\xfd\x7a\xdb\xed\xb5\xbe\xac\xbf\x6e\x56\x7b\x78\x5c\x6d\x56\xcb\xa7\x15\x44\x07\x3d\x26\xa0\x17\xc1\xe0\xf9\x2b\xf4\xce\xcf\x8f\x5b\xb7\xbb\xfb\xf5\x97\xf5\xea\x1e\xbe\xec\x1e\x41\x7e\x3d\x3a\x88\xd8\x48\x7e\xdd\x3d\x6c\x61\xb8\xfb\x7b\xb9\x85\x37\x9f\xd9\xcb\xc5\xe7\xcf\xeb\xcd\xc1\xee\xf1\xeb\xdb\x16\xc0\x7e\x07\xcb\xfb\x7b\x89\xf4\xdf\xd1\xeb\xa3\xd7\xc7\xaf\x4f\xfe\x07\x9e\x9e\xbf\x7f\xdf\x3d\xee\xa1\xbd\xd8\xae\x3f\xef\xee\x57\xb0\xf8\xff\x87\xbd\xc3\xc3\xee\x61\xef\xf4\xaa\x73\xd0\xba\x5b\x3d\x7e\x5b\x3f\x3d\xad\x77\x5b\x58\x3f\xc1\xc3\xea\x71\xf5\xe9\x07\x7c\x5d\xff\x7b\xb5\x65\x02\xbf\xb1\xc1\xfc\x80\xfd\xc3\xfa\x09\xbe\xec\xb6\xfb\xd7\xb0\x7c\x82\xcd\x6e\xfb\x95\xbd\xee\x1f\x56\xad\x6f\x62\xb4\x8f\xaf\x9e\x60\xbb\xfc\xb6\x62\x32\xbe\x6f\x96\x9f\xc5\x74\x2c\xe1\xf3\xee\xdb\xb7\xd5\x76\x0f\x9b\xf5\x76\x75\xd0\x2a\x74\xfb\xf4\x03\xee\x96\xcf\x1b\xb8\x7c\x7e\xdc\xef\xb6\xf0\xe6\x69\xb7\x79\xde\xaf\x77\xdb\x8b\xd5\xf2\x71\xff\xb0\x59\x6f\xff\x3a\xd8\xae\xf6\x6f\xa1\x17\x91\xf3\x3e\x1b\xc8\x5a\x4c\x26\x6c\x57\x7f\xc3\xf7\xe5\xe3\xf2\xdb\x6a\xbf\x7a\x6c\x49\xdd\x84\xc0\xab\xe4\x9a\xcd\xd5\x72\x7b\xcf\xde\xfe\xb6\xde\x1e\x00\xdc\x2e\x7f\xc0\x72\xf3\xb4\x83\x4f\x2b\x78\xda\xac\xbf\x3e\xec\x37\x3f\xe0\x9b\x39\xc3\x9f\x56\xfb\xfd\xea\x11\x9e\x9f\x56\xad\xdd\x17\x2e\xfe\xcb\xf3\x66\xd3\xfd\x7b\x7d\xbf\x7f\x20\x7f\xad\x1e\xb7\xe4\xe9\xdb\xf3\xd3\x03\x2c\x37\xfb\xd5\xe3\x76\xb9\x5f\xff\x7b\xf5\xf4\x1a\x3e\x3d\xef\xe1\x7e\xf5\x65\xf9\xbc\xd9\xc3\xee\x79\xff\xfd\x79\xcf\x34\x9f\x4c\xe7\xf0\xf9\x61\xb9\xfd\xba\xba\x3f\x68\xc1\x2f\x17\xd8\xff\x17\x2d\x00\x0a\x17\x2d\xc8\x21\x2f\x7e\x52\xf6\xb3\x4d\x3b\xec\xaf\x00\xf2\x4b\xfc\x6b\x6d\xc8\x81\x7f\xfc\x1e\xde\x03\xff\xf3\x2f\x50\x7e\x55\x17\xb0\x4b\xd8\x7f\xfc\x53\x9a\x43\x9e\x43\x2e\x90\x28\xc0\xc1\x01\xfb\x4c\xfe\xc2\xbf\x9b\xf3\x6b\x72\x9a\xe7\x34\x2f\x24\x19\xe2\xa8\xf8\x34\x87\x9c\xbd\x12\xa0\x7c\x78\x19\xa5\x90\xf1\x71\x01\x10\xfe\x77\x9a\xab\x01\x03\xa5\x42\x0d\x22\xfe\x04\x04\x08\x97\x41\x80\xf0\x91\x10\x4a\xb4\x92\x05\x0e\x55\x83\x6e\x03\x85\x0e\xc8\x2b\x28\x64\x24\xe3\x33\xd4\xa6\x6f\x01\xde\xb0\x4f\x33\x4a\x29\xc9\x88\x31\xd8\x62\x3e\xdb\x7c\x9a\x72\x01\xf8\x8b\xf1\xb3\xc0\x91\x43\x11\xd3\x0e\xce\x0b\x64\x34\x63\x5f\xa5\x42\xf3\x0c\x32\x35\x01\xce\x0b\xa1\x44\x4d\xba\x18\x3b\x1b\x17\x07\xc8\x40\x4e\x0c\x61\xf3\x91\xf1\xef\x64\xc4\x98\xe0\xe2\x32\xd0\xab\xa6\x97\x4c\xaf\x97\xb1\x3e\xe6\xe2\xc8\x8b\xed\x9f\xd6\x04\xd8\x08\xfa\x6b\xec\x9f\x40\x60\xff\x04\x02\xdb\x47\xa1\x08\xa5\x0d\xaa\xa7\x54\x4d\x6a\x69\xbd\x41\xae\x37\x38\xaa\x53\x39\xbf\x62\x8d\xd5\xfc\x6b\x73\xa0\x72\xa2\xf9\x5a\xdb\x03\x13\xbb\xc8\xb4\x1c\xc3\x7e\xf4\x97\x14\x02\x53\x53\x2e\x22\xdb\xbd\x42\x2e\xdb\xc8\xc4\x99\x84\xd2\xc5\x7a\x8e\xa4\x3a\x6c\x45\x32\x35\x83\x1d\x89\x88\x0f\x4f\xad\xa6\x30\x3f\xe3\xad\x92\x59\x2c\xad\xbd\xb6\xf6\xe0\xd9\xdb\xdc\x52\xa3\x06\x1f\xb4\x29\x71\x8b\x13\x62\x5e\xe9\x59\x6e\xab\x39\xc0\xe7\xb6\xa4\x39\xe4\x7a\x69\x41\xaf\xad\x10\x5d\x5e\x54\x7b\x55\x85\x11\x5b\xeb\x5b\x8d\x8c\x6e\x09\xf3\x92\xd7\x7a\x34\xc8\xc5\xce\xfe\x44\xf7\x2a\xfe\xa5\xb2\xc9\x98\x1e\x42\xea\xad\x9c\x40\x26\x4d\xd9\xb1\x5f\xc4\xa6\x6a\xac\xcb\x72\x2f\x19\x77\xa7\x0a\xb5\xd0\x4f\xad\x89\xda\x37\x99\x5a\x05\xed\x74\xd9\x64\xd3\x8e\x43\x02\x7a\x32\xf9\x56\x97\x28\x4c\x1d\xfa\xa7\x32\x19\x68\x6b\x2b\xe3\xd3\x2b\x07\x9b\xc9\x4d\xa5\xac\xbb\x70\x01\x84\xfb\x35\x25\x94\xfd\xa2\x4c\x49\x02\x88\x4d\x51\xcc\x92\x67\x43\x8b\x9d\x91\x83\x61\xf9\x75\x1b\x5a\xcc\x80\xc0\x52\xc3\xd7\x36\xa6\xfe\x9a\xf9\x4c\x19\x1c\x3c\xc7\xd3\x78\x4c\x59\xaf\x2b\xe8\x75\xe5\x3e\xba\x8c\x5c\xe7\x44\xc0\x18\xb6\x76\x0d\x5a\x0c\xcd\x01\x37\x25\x4c\x67\x15\x35\x98\x0e\xd2\x45\x86\xe2\x8b\xae\xa6\xfc\xef\xd2\x61\x16\x4e\xd3\xdd\x6d\xd2\x45\x29\x5e\x54\x34\x69\xe2\x69\x33\xa0\x6a\xfc\x72\x58\x14\x82\x7d\xb9\x30\xb8\x9c\x19\xa0\x20\xe5\x57\xc2\xe8\x72\x38\x90\xcb\x45\x73\x73\x4b\x69\x0d\xd5\x22\x60\xef\x6a\x16\x86\xff\x2f\xe6\x82\xd1\xb2\x1c\x68\x46\xf4\x98\xa1\xe0\x14\x28\xcf\x91\x33\xc3\x99\xd6\x14\x32\x7d\x7d\x56\xcc\x70\xe6\xe0\xff\x1c\xf9\xa1\xfb\x59\xd9\x0f\x14\xbc\xe6\xdb\x55\x81\xc8\x25\x2b\x0e\x43\x86\x37\xa0\x75\xf6\x5e\x4c\x34\xa3\x65\xc1\x8c\x66\xb8\x57\x23\x28\x02\x45\x9c\xc6\x3b\x24\x50\xc2\x8d\x21\x6c\xb6\xa9\xd8\x67\x32\xa6\xcb\x0a\xd7\xcb\x7e\xd1\xa4\x98\xc1\x7b\xd0\xc1\x5d\x66\x11\x63\x49\x50\x59\x96\x25\xce\x92\x68\x09\x75\xe5\x1a\xa2\x95\x50\x2d\x4e\x87\x60\xda\x31\xdb\x26\x24\x82\x10\x35\x18\x7d\xe1\x7b\x1d\xed\x54\x4f\x2a\xfb\xa7\x62\x19\x5f\x98\x5f\x32\x3d\x65\x79\xc2\x99\xe6\xbe\xf0\x3b\x67\xd7\xe8\x09\xd3\x53\xa5\x26\x49\x4d\x4f\xa6\x27\xc6\x76\x0c\x6a\x9f\xb8\xe1\xba\x36\x69\x81\xc0\x26\x9c\xf3\x7e\x26\x06\x29\xf3\x84\xf2\x0b\x12\xa9\x57\xbd\x73\xe2\x00\x2b\xc8\x00\x81\x85\x25\x26\x85\x34\x2a\x93\x3e\x93\xac\xdb\xc6\x2e\x7d\x8d\xfa\xfb\xc2\xf3\x39\x11\x5f\xc1\xae\x07\x18\xbb\x1a\xc0\x05\xe3\x28\xd8\x82\x59\xad\xa5\x84\xc2\xeb\x53\x35\xb8\xe0\x01\xa3\x98\x90\x69\x0f\xe6\xc3\x2c\xbe\xac\xd9\x54\x71\xa9\xf2\x79\x0e\x35\x85\xce\xaa\xdc\x23\x45\xf0\x53\x37\xab\x06\x45\x20\x2c\x5a\x44\x99\xfe\x1c\x45\xcf\xa0\x8a\x53\xe5\x70\x34\x8b\x12\xb5\x63\xcd\x21\x49\x74\x9b\x36\x41\xbb\x5f\x84\x2d\xed\x61\xa0\x83\x29\xed\x64\x3e\x61\xa6\xda\x7f\x5a\x8c\x51\x56\xdf\x22\x49\x24\x44\x86\xc6\x73\x68\x6d\x13\x9b\xb7\x6a\xd2\x89\x1a\x64\xcd\x5b\x07\x16\x63\xbe\x6c\xdf\x08\x3f\x59\xde\xdc\x54\xfb\xbb\x57\x66\xd4\xaa\xb1\x5c\x83\xba\x28\xe2\x2f\x65\x84\xaa\xd4\xc2\x37\x66\x69\x73\x17\x49\xa6\x0e\x51\x4d\xab\x60\x57\xba\x81\x9a\x1a\x59\x45\x80\x58\x61\xb2\x10\x40\x1c\x9c\xa8\xd0\x8b\x8d\xeb\x4b\x22\x4a\x52\x4a\x82\x2c\x59\xb6\xfb\x40\xa8\xef\xad\x34\x03\x84\xf1\x1a\xe9\xef\x78\x03\x63\x79\xa8\x8c\x44\x88\xa4\x3b\xc5\x76\xf6\x6c\xcb\xc2\x88\xca\xd6\x04\xc1\xbd\x81\x37\xa5\x92\x9a\x2e\x38\x79\xad\x54\xdb\xaa\x9a\x3c\xc5\x8a\x25\x29\x6f\xe1\xad\xf1\x3b\xcf\xc4\x24\xcb\x91\x5c\xd0\x1c\x51\xcc\x86\xbf\x3a\xf1\x52\x9b\x76\xa8\x72\x4c\x84\x66\x96\xfd\x31\x04\x24\xcc\x43\x2e\x36\x43\xcd\xba\x5c\x40\x5f\x5c\xf8\xce\xf0\x44\x02\x43\x0e\x27\xd0\x8a\x61\xd7\x94\x4c\xc2\x87\x8d\x98\x95\x4b\x80\xda\xa3\xe7\x99\xfa\x24\xe7\xa6\x2f\xbd\xc6\x45\xab\xd7\x3f\x04\x98\x4c\xbb\x97\x69\x3c\x78\x07\xb3\xbb\xc1\x30\xf6\x57\x9a\x7b\xfd\x1e\x40\x32\x79\x1f\xa7\xf3\x78\x04\xf1\xbf\x86\xe3\xc1\xed\x60\x9e\x4c\x27\x70\x3b\x48\xdf\x85\x51\x55\xaf\x1f\x01\x0c\xe3\xc9\x1c\x66\xc9\xf5\x44\x32\x57\x11\x27\xaa\xa0\xa1\x53\x0e\x1a\x00\x40\xd2\x9a\xa8\x0e\xf7\xfa\x47\x00\x77\xd3\xc5\x64\x64\x88\x31\xea\x14\xaf\x29\x9f\x6f\x5a\x64\xc9\x46\x2a\xd7\xa6\xaf\xad\x5c\x4e\x88\x3c\x06\x18\x2e\xd2\x34\x9e\x0c\x3f\x48\xa9\x44\x14\x88\x45\x19\x56\x9a\x69\xb1\x86\xb2\x5c\xc1\xfe\xca\x8b\x15\xa4\xb4\x20\xbd\xfe\x09\xc0\x87\x78\xa2\x06\x48\x95\x0f\x2f\x3c\x5c\xce\x3f\xcb\x4b\xef\xb0\x20\xb9\xd7\xef\x03\x5c\xa6\xd3\x77\xf1\x04\x2e\x07\xa9\x65\xe0\x34\xb7\x4d\x9e\x1b\x78\xaf\x7f\x0a\x30\x8b\x87\x7c\x7d\x8c\x49\x02\x19\x0e\xf0\x29\x26\x2a\x00\xce\x20\x93\x85\xa3\x8c\x79\x4b\x3e\x4b\xd2\xf0\x7b\xfd\x33\x80\x51\x32\x88\xd3\x78\x96\xcc\xf0\x5d\xca\xcb\x52\x2a\x16\x75\xdf\x19\x9a\x9c\x03\x0c\xa7\x77\x1f\xd2\xe4\xfa\x66\x5e\x5a\x3b\x5d\x6a\xd4\x65\x20\x50\x4e\x91\x45\x85\x9a\xe6\xdb\xfc\x8b\x45\xb1\x89\xe6\x85\x97\x17\x29\x1f\x07\x3a\x3d\x04\xb8\x8a\x6f\x93\x49\x32\x89\x61\x9a\x8e\x92\xc9\x60\x0c\xc9\x64\x94\x0c\x07\xf3\x69\xda\x2a\xd8\x58\x5b\xb6\x36\xaa\xbc\x5c\x6e\x33\x3d\x7f\xef\xb4\x07\x30\x8e\xaf\xe6\xdd\xbb\x69\x32\x99\x27\x93\x6b\x18\x4d\x17\x97\xe3\x18\x06\x93\xeb\x71\x0c\xff\x5c\x4c\xe7\x25\x8b\x50\x4e\x9e\xeb\xa1\xea\x80\xba\x12\xa8\x6b\x81\x65\x7e\xe9\x9d\x46\xc0\x9b\x3f\x7a\x7e\x00\xcb\x0a\xa0\x14\x2f\xa8\xe1\x5a\x13\x7e\x7a\x04\x30\x9b\x5e\xcd\xe1\xe6\xc3\xdd\x4d\x3c\x29\x45\xcc\xa6\x54\xa8\x53\xfc\x18\x20\x8d\xaf\x93\xd9\x3c\x4e\xe3\x51\xd8\xca\xe5\xdc\xef\xc9\x95\xe3\x01\x0b\xd1\x2b\x97\xd3\x9c\x66\xf8\xca\x9d\x00\xdc\x0e\x86\xe9\x74\x12\xd0\x62\xc0\xde\xe9\x21\xf7\x01\x46\xf1\x75\x1a\xc7\x7a\xb8\x45\xec\xa7\x1d\x72\xe1\x8f\x09\x78\x54\x3f\x05\xb8\x1b\x2f\x66\xdd\xdb\x64\xb2\x98\x95\xfc\x96\x98\x3e\xa4\xd1\x42\x99\x7e\xce\xb8\xb5\xc4\x33\x80\xd9\xe2\x2e\x4e\x67\xc3\x34\xb9\x9b\xc3\xfc\xb7\x69\xa9\x5c\x06\x1d\x34\x1e\x28\xf3\x6b\xef\xf4\xdc\x92\x72\x93\xc6\xb1\x19\x57\x50\x55\xdc\xb5\xc2\x3e\x4b\xce\xd9\x21\xc0\x60\xb8\x98\xc7\x30\x18\x32\xcf\xdc\x92\xf1\x06\x11\x5f\x37\x53\x4c\x23\xd1\xec\x9d\xf5\x00\x6e\x93\x61\x3a\x45\xb6\x69\x75\xd5\xf0\x40\x1b\x5a\xae\x85\x45\x00\x77\xc9\x78\x98\x4e\x7f\x33\x16\xab\x60\x34\x00\x55\x5b\x6b\x2b\x89\x3c\x9e\x55\x69\x0e\xdf\x4f\xb6\x47\x3f\x3b\x62\x23\x1c\x8d\xc6\x31\x8c\xa6\xf3\x56\x31\xba\xa2\x6c\x8f\xa8\xc5\x68\x20\x1e\x25\xe3\xf1\xa0\x55\x58\x8a\xfd\x93\xcb\xe8\xd0\x0e\xbf\xe2\xa4\xbc\x0e\xd3\x49\x8c\xb6\x96\x68\xee\x60\xf5\xd9\x56\x9f\x0d\x17\x63\xbf\x97\x52\x4e\x4a\x10\x8d\x5c\xc3\xdc\xb7\x27\xce\x4e\x01\xb8\x6f\x0d\x74\x50\xba\x98\x96\x99\x0d\x04\xdd\x42\x50\x4d\x04\x33\x54\xe1\x30\x67\x00\xef\x17\xe3\xeb\x41\x0a\x57\xe9\x40\x70\xcc\x74\xc2\xc4\x0f\xd2\x79\x9c\xaa\x2d\xa0\x92\x4c\xe6\x0a\xb8\x23\x57\x69\x06\xe1\x1f\xc9\x32\x0d\x01\xc2\xf6\xbc\x50\x48\x14\xfe\x55\x3f\x02\xca\xeb\x79\x8e\xa3\xde\x0c\xc6\x57\x26\x64\x81\xa8\xb2\xa6\x5c\xf4\xaf\x3a\x0a\xaf\x28\x31\x51\x52\x0e\xb8\x35\xd8\xf9\xa1\x0b\xc6\x2d\x4c\x29\x39\xd3\xb5\x48\xad\x27\x37\x39\x43\x53\x6e\x7a\x25\x5d\x69\x59\x5b\xbf\xbe\x72\x10\x66\xc0\xf5\xcf\x45\x3c\x2b\x73\x8b\xec\x90\xc9\xa6\x8d\xee\xac\x8b\xaa\x59\x66\xe5\x11\xbd\xf3\x08\x60\x3c\x98\x27\x13\x18\x0e\xee\x92\xf9\x60\x0c\xe3\x78\x3e\x8f\x53\x18\xc0\x6f\xc9\xfc\x06\xae\xd3\xc1\xfb\xb8\x65\x76\xfd\x18\x35\x29\xd7\x1e\x14\xb6\xf7\xce\x8f\xaa\x31\xb8\x9f\x51\x91\x88\x92\x4c\x1a\x62\x1c\x57\x63\x0c\x93\x74\xb8\xb8\xbd\x1a\xc7\xff\xe2\x42\x89\xca\x6f\x08\xcd\xf2\x66\x40\x27\xd5\x40\xf3\x64\x3c\xe2\xca\xb0\xcc\x48\x62\x64\x4d\x95\xe9\x57\x63\xf8\x02\xaf\x86\xf9\x54\xef\xfc\xb4\x1a\x27\x65\xae\x62\x70\x39\x7d\x1f\x97\xb8\x0d\xda\xbb\x4e\x43\x85\xce\x7c\x40\x42\xb2\x70\xeb\xaa\xcb\x43\x00\x0a\x7e\xe4\x66\xa3\xa2\x5f\xde\x6c\x54\x21\x3b\x43\x72\x98\x54\x23\x9e\x7b\x10\x87\x72\x3f\x14\xde\xfc\x05\xed\xbf\x0e\xb3\xae\x8b\x56\x74\x78\xe8\x41\x89\x7d\xd6\xc3\xc2\x3a\xac\xe5\xe7\x8d\x0b\xa2\xc3\x5e\x35\x86\x6b\x3d\xcc\x35\x37\xc4\xf0\x79\x81\x38\xcc\x7a\xc2\x81\x7c\xae\x20\x0e\xda\xd9\xe1\x38\x3e\x77\x90\x94\x17\x46\x4d\x59\x46\x65\x2f\xb0\xdc\x95\xb4\xbb\x91\xd1\xa1\xcf\xfa\x13\x6b\x31\xd4\x96\x52\xc5\xbf\x3a\xb9\x3e\x8b\x4f\x90\x05\x20\xaa\xb5\x40\xb3\x3c\x48\xb8\xcf\xcc\x93\x30\x77\xc2\x01\x84\x6d\xea\xb6\x4d\xae\xda\x6c\xe6\xa4\xfb\xac\x3c\x9e\xdf\xe8\xbc\x40\xe7\xf5\xa0\xbb\x73\xa5\x36\x79\x51\xee\x77\xbb\x75\x12\xc6\x67\xda\x13\xc4\x03\x6b\x07\xcc\xf7\x8c\xee\xa0\x1e\xfc\xa9\xc2\xaf\xac\xdc\x05\x88\x7a\x3e\x93\x9e\xd6\x13\x62\x60\x29\x2a\xea\xf9\x4c\x7a\x5a\x4f\x88\xc1\x18\x3e\x93\x9e\x06\x12\x62\x30\x90\xcf\xa4\xa7\xf5\x84\x18\x8c\xe1\x33\xe7\x69\xd8\x0e\x0e\xc6\x61\x69\xe6\x62\x3c\x4f\xee\xc6\x2c\xda\x2e\x55\x49\xd4\x57\x19\xf3\x88\x53\x83\xf2\xc4\x60\x56\x9c\x16\xe4\x32\x7c\xa6\x2c\xc7\x3a\x9b\xa7\xd3\x77\xb1\x4d\x3c\x84\xa8\xa0\x54\xa5\x07\x84\xa8\xb6\x17\x41\x06\xea\x33\xe9\x45\x00\xf1\x84\xd5\x3c\xa3\x9e\xcf\x9c\x17\x01\xc4\x13\x8a\xe1\xb3\xe5\x45\xcd\x2e\x85\x2c\x6f\x04\x14\xf9\xcc\x7a\x51\xbd\x83\x1a\x16\x8a\xa3\xc8\x67\xda\x1f\x3c\x93\x46\xf9\xa4\x55\x34\xca\x9d\xca\x5f\x14\xf9\x4c\x7b\x7e\x33\x4d\x27\x4e\x6b\xb1\x38\x24\x54\xb4\x40\x8d\x82\xaf\x2d\x5c\x9b\xf3\xec\x76\x30\xd6\xa2\x67\x37\x83\xf4\x0e\x66\xad\x17\x96\x94\xa3\xe8\x18\x15\x5b\x99\x65\x34\x6a\x53\x47\xd1\x49\x15\x02\xee\x52\x1b\x22\xf4\xab\x10\x42\x1c\x6a\x18\xcc\x69\x15\x0c\xee\x4e\x1b\x2a\x72\x56\x85\x10\xe0\x4c\xc3\x50\xce\xab\x50\xec\xdc\x42\xad\x4a\xbb\xdd\x29\x4e\x76\xbe\x0a\x80\x39\x3a\xc4\x61\xe2\x52\xf2\x2e\x37\x97\xe9\x72\xff\x04\xbd\x81\x19\x80\x71\x30\xc0\x69\x05\x48\xa4\x1e\x8a\xe4\x66\x14\x00\x0d\x8e\x3c\xa8\x5c\xe2\x28\x42\xa5\x63\x99\x84\x8e\x3a\x2e\xc2\x8e\x36\x44\x47\xb8\x51\x63\x19\x84\x8e\x36\x82\x65\xe3\x96\xed\xcd\x1c\xb4\x51\x04\x03\xe0\x86\x1d\x96\x31\x98\xd4\xaf\x0e\xaf\xc9\x0e\x81\xb5\x8d\x70\xe3\x2e\xe7\x0b\x54\x16\x51\xb2\x8a\x66\x56\x74\x84\xdb\xaf\x95\x21\x18\xd5\x54\xbf\x24\xdc\x4e\x03\x72\x02\xb0\x8e\x55\x96\x8a\x49\x5c\x34\x6e\x9c\x81\x19\x01\x84\x9d\x8e\x8b\x8e\x71\xdb\x94\xf9\x00\x0b\xa3\xc4\x05\xaa\xad\x0e\x94\x7d\xa4\xfa\x68\xba\x05\xe3\xd2\xec\x31\x6e\x8a\x58\x06\x50\x0e\x39\x43\x8f\x87\x44\xc7\xb8\x39\x36\xcb\x02\xaa\x3a\xbb\xd1\x31\x6e\x94\xcd\x72\x80\x6a\x04\xdc\x34\x5f\x90\x01\x54\xc3\xe0\x06\xda\x2c\xfe\xaf\x46\xc0\x8d\xb3\x79\xf4\x5f\x8d\x72\x0a\x30\x4a\xde\x27\xb3\x72\xdc\xaf\x43\x24\x1d\x4a\x33\xd9\x76\xe9\x81\x49\xb6\xe5\xe1\xe6\xeb\xe4\x01\x65\xc2\x28\x4e\x22\x29\x9b\x86\x36\x21\x6a\xd8\x76\x32\x20\x80\x70\x63\x7e\x79\x2e\xe0\x90\xec\x09\x6e\xc8\x2f\xcf\x04\x5c\x04\xdc\xa2\x7f\x32\x0f\x70\x61\x70\xb3\xfe\xb9\x2c\xc0\x45\xc1\x4d\xdb\x97\x03\x04\x4c\x97\x75\x60\x28\x3a\xc1\x4d\x1b\xcf\x00\x1a\x1d\x4f\x8b\x4e\x70\x73\xfe\xf0\x73\x53\x64\x29\x70\xf8\x5f\x87\x3d\x6f\xf5\x54\x86\x88\xba\xe1\x6b\x84\x6d\x85\xd9\x86\x95\x9e\x39\x0e\xbe\xb5\x1c\x14\x1d\xae\x01\xa1\x40\x49\x83\x58\x97\xa3\xd4\x74\x52\x2e\xd3\x58\x94\x1c\xf5\xb9\xcc\x2c\x93\x69\x7f\x23\x65\xf0\xad\x65\x81\x18\xc7\xe4\x4c\x8f\x12\xac\x4b\x4d\x37\x65\x7a\x3d\x9d\xc4\xef\x3c\xee\xb1\x56\x99\x36\x6d\x2b\x9c\xca\x9c\x0d\x43\x09\x3f\xbd\x6c\xa0\xf8\x2a\x32\x43\xdb\x1e\x75\x00\x4c\x8d\x08\xb8\x38\xf7\xe8\xbf\x11\x88\xc3\xe0\x71\x9f\x03\x52\x6c\x32\xbd\xc7\xea\xce\x43\x73\xf1\xbe\x72\xcc\x10\x73\x91\xea\xfc\x39\x70\x1a\xc9\x9a\xaa\x82\x13\x0a\x8e\xa4\x80\x48\x91\x90\x04\xe9\x33\xa8\xd6\x67\x34\x9d\x1b\xf9\xe1\xef\x7f\x98\x0c\xd9\x54\x9d\xcb\x2a\x75\x4a\x40\x26\x4e\x23\x6d\x86\x35\xab\x33\x90\x4e\x26\xcb\x94\xcd\x53\x23\x6d\x0f\xd6\x64\x54\xb9\x30\x26\x88\xc2\x68\xa4\x45\xec\xd1\x62\xe4\xd3\x82\x52\x1d\x58\xbb\x35\x56\xec\x76\x1b\x0e\x73\x85\x6a\x61\x81\x30\xc1\x2f\xbc\x05\x80\x81\x78\x0b\xf9\x23\xb4\x0e\xab\x7b\xf3\xfa\x6e\x43\x5e\xd7\x92\xb7\x62\xe7\x34\x27\x0a\x2f\xa7\x68\x5f\x82\x63\xe2\x4c\xe3\x20\x42\xb7\xdb\xcd\x5f\xae\x59\x4d\xb7\xae\x8a\x37\x43\x3b\x68\x1c\xa7\xb2\x6a\x50\xe6\x4d\xea\xf0\x66\x48\xd6\xcd\x51\x7c\x5c\x13\xd7\xf2\x66\x23\x65\x2a\xab\x08\x0a\x24\xcb\x58\x74\x79\x21\xd7\xc8\x49\x52\x6a\x75\xf1\x31\x4d\x5c\xe5\xd3\x7c\xb7\x81\x56\xeb\x83\xb3\x8d\x0f\xe8\xc2\xa4\x9e\x80\xaa\x0b\x87\xf0\xf6\xf3\xbc\xfc\x1c\xae\x4a\x9b\x6a\x7e\xee\xe1\x6c\x83\xa2\xd8\xbe\xd9\xaf\x47\xc1\xff\x3d\x1f\xd3\xc4\x55\x5e\xad\xf9\x8a\xe0\x2c\x83\x81\x88\x6b\xb3\xe0\x22\x1b\x17\xef\x63\x98\x6b\x8c\x95\x29\xc9\xb0\x43\x0d\x14\xdc\x16\x06\xa6\x0a\x4e\x33\x28\x92\x19\x69\x50\x75\x48\x2c\xe8\x1e\x28\x8e\xe4\x63\x9c\x6b\x2b\xa0\x45\xd9\x32\x5c\x21\x9c\x71\x2c\x10\xa3\x28\xd0\xf4\x7e\x2e\x06\xe2\xed\x31\x5d\x23\x46\x49\x7f\xff\xe3\x27\xf4\x89\x70\xa2\xc1\x80\x98\x97\xf9\x09\x9d\x7c\x5c\x73\x1d\x7a\x8e\xa6\x42\xa3\x0e\x15\xb5\x6f\x0e\x84\x93\x8d\x0b\x63\xba\x81\x40\x7d\x3a\x9d\x4e\x47\xc1\xf8\xd8\xe6\x06\xd9\xdb\x3c\x6b\x11\xc3\x27\x90\x39\x47\x56\xab\x6e\x74\xe7\x58\x38\xe5\xa0\x48\xfa\x7e\x51\xc8\x75\xd9\x27\xac\x52\xc9\x91\x7c\xbc\x73\x63\x45\x1e\xe6\x21\xdc\x7f\x34\xbb\x75\x9f\xe3\xe0\xa4\x83\xa1\x88\xa0\xf0\x1f\x4d\x6f\x6d\xe4\x28\x3e\xde\x49\xca\x15\x45\x22\x3c\x69\xe8\xa3\x04\xb8\xe8\xca\xb2\xb7\x2e\x55\x82\x68\xf2\x57\xd4\xe6\xb9\x30\x1f\xaf\x24\xe5\x08\x89\xe8\x7e\x6b\x83\x81\xe2\x64\x62\x49\x56\x91\x97\x42\xa8\x2b\xfb\x73\xc9\x3e\x1e\x49\x1c\x67\xd8\x78\xd0\x38\x6d\x58\x82\xc5\xd1\xe2\xca\xce\x07\x17\xe6\x63\x86\xc4\x8a\x0b\x42\x9f\x28\x61\x44\x1c\x11\x4e\x07\x8e\x64\x50\xc5\x2d\xb9\x6f\x8d\x17\x9a\x53\x21\x54\xc9\x3c\xf2\x79\xff\xc4\x75\xca\x54\x44\x64\x4d\xe6\xd6\xd3\x7c\x1c\x4d\xe7\xe3\x78\x36\x83\xa4\xa5\x43\x30\xa8\x99\xd8\x23\xd7\xa5\x27\xd7\x83\xf9\x22\x8d\x21\xf9\x55\xce\x27\x14\x53\x5a\xdc\xdd\x0e\xc5\xdb\x22\xc1\xcb\xdd\x7a\x34\x07\xb1\xdd\x79\x19\xa2\xa6\x70\x58\x8c\x5c\xde\xa3\x0c\xfa\x2e\x65\x2e\xdc\xe7\xc4\x7f\xc5\x03\x14\x1d\xa1\xf0\x22\x45\x7e\xa1\x9f\x20\x62\x50\x93\x0e\xeb\xcb\xb7\x84\x2a\x44\xdc\x95\xe3\x78\x24\x53\xf5\x10\x31\x72\xa5\x81\x78\xb5\xee\xba\xe6\xd2\x7d\xee\xfb\x9d\xcd\x7e\x14\xca\xe7\xe5\x85\x67\x05\x95\x82\x1f\xc8\xfb\x6c\xc4\x5d\xda\x52\x0f\xc6\xb2\x0a\x08\xf7\xdf\x18\x8c\x42\x09\xb9\x11\xbc\x53\x00\xe0\x2d\x8f\x77\x69\xa9\x2f\x5e\xdc\xb9\x9c\x13\x15\xfa\xfa\x6e\x2f\xe7\x52\x7d\xa7\x84\xc6\x56\x4f\x15\x64\xf6\x96\xf3\xf3\x53\x4a\x03\xe7\x2c\x8c\x27\x80\x3f\x1a\xa0\x83\xb7\x40\x88\xe3\xb8\x70\x2b\xbb\xac\x1e\xb3\x35\xd9\xce\x58\xab\x47\x6d\xae\xe9\xb0\x6a\xd4\x65\x18\x25\x1a\x7b\xd5\xdd\x5b\x63\x35\x47\x35\x3a\xc8\x9c\x86\xaa\xa4\x86\x09\xcb\x9a\xcf\x7b\x5c\xa9\x41\x20\x88\x7a\x87\x1c\x6a\xe2\x20\x57\xd5\xba\x94\xee\x09\xf2\x2c\x89\xf4\xda\xb5\x0a\x79\xda\xde\x5e\x24\x0d\xa4\x71\x4a\x9f\x38\x77\xf3\x73\x0c\xdf\x41\xb3\xb1\x1d\x8c\x15\x10\x44\x3e\xe3\x25\x27\x44\x8a\x24\xfc\x08\x7d\xa5\x2e\x78\xc3\xcc\x41\x31\x58\x87\xaf\x12\x21\x98\x55\x1c\xfb\x0e\x8b\x4e\x2c\x4b\x56\x37\xac\x34\x7f\x00\x12\x87\xc1\xbb\x63\x13\xb7\xde\xaf\x1c\x92\x3a\xa8\xdd\x20\x4c\x3d\xf6\x9d\x05\x9f\x60\xa6\xd7\x48\x9b\x0e\xed\x98\x40\x78\xf7\xdb\x81\xb1\x1c\x6c\xbd\x3e\x16\x8c\xef\x4c\xe9\xc4\x32\xc4\x8c\xbc\xf4\xe1\x54\x1c\x06\xa7\x08\x0b\x84\x97\x62\x84\x2e\x19\xf2\x94\xc1\xda\xb5\xc1\xe3\xfc\x09\xdc\xa5\xf1\x30\x1e\xc5\x23\xb8\xfc\x00\x83\xbb\x29\xdb\xbf\x77\x37\xe6\x51\xb1\x0b\xf5\xd4\x30\xf1\xbe\x0d\x1d\x86\x2b\x0f\xd7\x18\x41\x10\xf6\x54\x12\x05\xee\xad\x37\x4d\xae\x1b\xee\x06\x50\xf2\x0b\xa7\x7c\xec\x29\x33\x49\xd9\x75\x0b\xaf\x25\x1a\x77\x49\x52\x3d\x72\x5f\x6e\x30\xad\xa8\x2c\x83\x79\x58\x0c\x64\x16\xee\x3f\x66\xc1\x71\xf0\x44\xe1\x3f\x8d\xe2\xcb\x20\xa6\x56\xa6\x03\xea\x81\x56\x40\xbb\xc8\x03\xcc\x2a\xce\xfb\x72\x18\x3c\x99\xf8\xcf\x82\x9c\xd4\xdc\x96\xa0\x6e\xe8\x34\xba\x8c\xc5\x59\x3e\xa7\x26\x5f\x8b\x86\x27\x1b\xff\x37\x58\xfe\x74\x64\xaa\xda\x33\x56\xc9\xd7\x78\x16\x8d\xa0\xc9\x52\x20\x9f\x8b\x66\x04\x87\xcb\x75\x6b\xc2\x36\x52\xe7\x88\x46\x19\xb4\xec\x10\xe4\xf3\x83\x4b\x83\x30\xea\xb6\x7c\x23\x96\xaa\xb7\xc4\xaa\xe1\x96\xa1\x7d\xe9\x4b\x6a\x93\x20\xc5\x7a\x6b\x21\x4f\xc4\xe3\x30\x78\xce\x92\x22\x4d\x6f\xcd\x81\xd2\x73\x18\x77\xc1\x79\x03\x90\x13\x5f\xd2\x92\x3a\xf4\xd7\xf4\xc9\x7e\x65\x5e\x3a\xc1\x93\x16\x07\xa6\xcc\x7e\x75\x9a\x74\x8a\xd2\xe3\x89\xaf\xde\x94\xda\xc4\xf7\x73\xeb\x81\x73\x52\x8a\x10\x9f\xe6\xbd\x26\xeb\xe1\x63\x9d\x99\x67\x57\x35\x7f\x54\x22\x87\xc1\xe9\x67\xe6\x9e\x72\xb8\x90\x60\x01\x4f\x9b\xe2\x82\x7d\xdc\x33\x43\x2b\xb3\xd9\x4b\x9f\xf7\xc8\xb1\x70\xfe\xc1\x90\xd4\xa6\x22\x34\xa3\xa1\x9a\xf8\x78\x67\xe6\xb5\x8c\x06\x6a\x18\xa9\xdf\x09\xce\x3c\x0e\x0c\x14\xdd\x39\xa8\xd4\xa1\x88\x32\xfa\x3e\xbe\x99\x79\x6c\xe2\x65\x0b\xd1\xc7\x89\x66\xe6\xda\x84\x34\x89\xea\xf1\x1b\x82\xbd\xf7\xc8\x60\x6b\x60\x3f\xa9\x03\x6a\xce\x37\x1b\x6b\xd0\xc7\xfb\x16\x2e\x4c\x91\x0d\x8b\x57\xdf\xe3\xd4\x8c\x35\xf0\xf1\xc4\xdc\x5a\x83\x97\x3f\xbf\x94\xc3\xe0\x3c\x31\x77\x4f\x63\x04\x8d\xdf\x10\xec\x63\x88\xb9\x93\xa2\x56\x29\xd0\xcd\xbb\x79\xb7\x52\x01\x9c\x20\x1c\x14\xcf\x0a\x74\x2b\x34\xa8\xb9\x05\xae\x68\x18\x68\x13\x23\x59\xb3\x5b\xe0\x38\x4c\xe5\xf9\xdd\x17\x80\x60\xa7\x46\xfa\x3e\x7e\x58\x54\x9d\x1a\x01\x55\xa7\x0f\x57\x06\x27\x88\x0a\x94\xe2\x29\x5a\x0d\xb4\xf1\xb1\xc5\xc2\x6e\x36\xe8\x18\x2e\xab\xbb\x39\x11\x83\xc1\x89\xe2\xe5\x20\xa8\x2e\x3e\xbe\x58\xa0\xb7\x4a\x4d\xb5\x37\xaf\x79\xca\x20\xba\x3a\x38\x65\xd4\x22\xd1\xc6\x5a\x9d\xd6\xdd\x71\x69\x65\x11\xdd\x2e\x74\xbb\x62\xd7\x11\xd2\x78\xd7\x9d\x56\x1e\x1f\xc7\x32\x16\x1d\x9f\x54\x62\xa1\x9a\xf9\xb8\x65\xe1\xf6\x8f\x1a\x3f\x1b\xda\xe8\x52\x9d\xe2\xd4\x62\xa3\x18\x7e\x21\xfc\xb9\x9b\x45\xdf\xea\xd4\xc7\x32\xbf\xb9\xd1\x90\xa8\x25\x92\xcc\x78\xbc\x26\x10\x92\x65\x3f\xff\x9c\x69\x3e\x12\x9c\x88\x90\x71\x80\x1a\x06\xc8\x87\x56\xb2\x41\xbc\xf8\x89\x9f\x1c\xdb\xc7\x55\x1f\x7c\x67\x5e\x05\x34\x03\x86\x06\x37\xef\x72\x2c\x9c\xaf\x2a\x91\x84\x8a\x95\x6b\x8b\x9c\xde\x38\xf5\xf1\x17\x72\x98\xff\xf7\x3f\x40\x14\x9e\xc5\x22\x37\xb9\x23\x99\x43\xf9\x7a\x34\x1f\xed\xfb\xde\x88\x7a\x5a\x55\xf8\xa3\xbd\x39\x00\xde\x9d\xf9\xe8\x24\x1e\x60\x24\x1e\x75\xcf\x51\xe5\x82\x7d\x9d\x9a\x8f\x48\xe3\x96\xfe\xfe\x47\xe3\x07\x93\x73\x10\xbc\x4b\x83\x40\xa8\xd3\x7a\x81\x4f\x82\xe5\xc2\x7d\x7d\x9a\x8f\x6e\xb0\xfe\xb2\xd1\xe3\x1d\x9a\x8f\xde\x30\x3d\x78\xe4\x38\x1d\x8d\xa7\x93\x6b\x71\xb3\x79\x71\x5c\x5e\x3f\x96\xbb\xab\x5b\x56\xdd\x9a\xd0\x36\x1a\x9e\x82\x1a\x9d\x1a\x5c\xa6\x9f\xe8\x87\xbf\x88\x0b\x47\x67\xa0\xd8\x9d\x9f\x36\x15\x36\xa6\x79\xe7\x17\xef\xab\xbc\xfc\x1c\xcc\x35\xe5\x66\x25\xbe\xe4\xfc\x90\x17\x5c\x82\xe9\xd0\x3d\x63\xd3\x2f\x45\xf1\x22\x1a\x8d\xa0\x44\x6f\xc6\xf3\xfa\x40\x3d\x26\x49\x67\x47\x55\xe3\xfe\xdf\x00\x00\x00\xff\xff\xf2\x77\x6b\x98\xab\x6e\x00\x00")

func standardFlfBytes() ([]byte, error) {
	return bindataRead(
		_standardFlf,
		"standard.flf",
	)
}

func standardFlf() (*asset, error) {
	bytes, err := standardFlfBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "standard.flf", size: 28331, mode: os.FileMode(436), modTime: time.Unix(1477320163, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

// Asset loads and returns the asset for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func Asset(name string) ([]byte, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("Asset %s can't read by error: %v", name, err)
		}
		return a.bytes, nil
	}
	return nil, fmt.Errorf("Asset %s not found", name)
}

// MustAsset is like Asset but panics when Asset would return an error.
// It simplifies safe initialization of global variables.
func MustAsset(name string) []byte {
	a, err := Asset(name)
	if err != nil {
		panic("asset: Asset(" + name + "): " + err.Error())
	}

	return a
}

// AssetInfo loads and returns the asset info for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func AssetInfo(name string) (os.FileInfo, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("AssetInfo %s can't read by error: %v", name, err)
		}
		return a.info, nil
	}
	return nil, fmt.Errorf("AssetInfo %s not found", name)
}

// AssetNames returns the names of the assets.
func AssetNames() []string {
	names := make([]string, 0, len(_bindata))
	for name := range _bindata {
		names = append(names, name)
	}
	return names
}

// _bindata is a table, holding each asset generator, mapped to its name.
var _bindata = map[string]func() (*asset, error){
	"larry3d.flf":  larry3dFlf,
	"standard.flf": standardFlf,
}

// AssetDir returns the file names below a certain
// directory embedded in the file by go-bindata.
// For example if you run go-bindata on data/... and data contains the
// following hierarchy:
//     data/
//       foo.txt
//       img/
//         a.png
//         b.png
// then AssetDir("data") would return []string{"foo.txt", "img"}
// AssetDir("data/img") would return []string{"a.png", "b.png"}
// AssetDir("foo.txt") and AssetDir("notexist") would return an error
// AssetDir("") will return []string{"data"}.
func AssetDir(name string) ([]string, error) {
	node := _bintree
	if len(name) != 0 {
		cannonicalName := strings.Replace(name, "\\", "/", -1)
		pathList := strings.Split(cannonicalName, "/")
		for _, p := range pathList {
			node = node.Children[p]
			if node == nil {
				return nil, fmt.Errorf("Asset %s not found", name)
			}
		}
	}
	if node.Func != nil {
		return nil, fmt.Errorf("Asset %s not found", name)
	}
	rv := make([]string, 0, len(node.Children))
	for childName := range node.Children {
		rv = append(rv, childName)
	}
	return rv, nil
}

type bintree struct {
	Func     func() (*asset, error)
	Children map[string]*bintree
}

var _bintree = &bintree{nil, map[string]*bintree{
	"larry3d.flf":  &bintree{larry3dFlf, map[string]*bintree{}},
	"standard.flf": &bintree{standardFlf, map[string]*bintree{}},
}}

// RestoreAsset restores an asset under the given directory
func RestoreAsset(dir, name string) error {
	data, err := Asset(name)
	if err != nil {
		return err
	}
	info, err := AssetInfo(name)
	if err != nil {
		return err
	}
	err = os.MkdirAll(_filePath(dir, filepath.Dir(name)), os.FileMode(0755))
	if err != nil {
		return err
	}
	err = ioutil.WriteFile(_filePath(dir, name), data, info.Mode())
	if err != nil {
		return err
	}
	err = os.Chtimes(_filePath(dir, name), info.ModTime(), info.ModTime())
	if err != nil {
		return err
	}
	return nil
}

// RestoreAssets restores an asset under the given directory recursively
func RestoreAssets(dir, name string) error {
	children, err := AssetDir(name)
	// File
	if err != nil {
		return RestoreAsset(dir, name)
	}
	// Dir
	for _, child := range children {
		err = RestoreAssets(dir, filepath.Join(name, child))
		if err != nil {
			return err
		}
	}
	return nil
}

func _filePath(dir, name string) string {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	return filepath.Join(append([]string{dir}, strings.Split(cannonicalName, "/")...)...)
}
