// Code generated by msgraph.go/gen DO NOT EDIT.

package msgraph

import (
	"context"
	"fmt"
	"io/ioutil"
	"net/http"

	"github.com/yaegashi/msgraph.go/jsonx"
)

// AndroidCertificateProfileBaseRequestBuilder is request builder for AndroidCertificateProfileBase
type AndroidCertificateProfileBaseRequestBuilder struct{ BaseRequestBuilder }

// Request returns AndroidCertificateProfileBaseRequest
func (b *AndroidCertificateProfileBaseRequestBuilder) Request() *AndroidCertificateProfileBaseRequest {
	return &AndroidCertificateProfileBaseRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// AndroidCertificateProfileBaseRequest is request for AndroidCertificateProfileBase
type AndroidCertificateProfileBaseRequest struct{ BaseRequest }

// Get performs GET request for AndroidCertificateProfileBase
func (r *AndroidCertificateProfileBaseRequest) Get(ctx context.Context) (resObj *AndroidCertificateProfileBase, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for AndroidCertificateProfileBase
func (r *AndroidCertificateProfileBaseRequest) Update(ctx context.Context, reqObj *AndroidCertificateProfileBase) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for AndroidCertificateProfileBase
func (r *AndroidCertificateProfileBaseRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// AndroidDeviceOwnerCertificateProfileBaseRequestBuilder is request builder for AndroidDeviceOwnerCertificateProfileBase
type AndroidDeviceOwnerCertificateProfileBaseRequestBuilder struct{ BaseRequestBuilder }

// Request returns AndroidDeviceOwnerCertificateProfileBaseRequest
func (b *AndroidDeviceOwnerCertificateProfileBaseRequestBuilder) Request() *AndroidDeviceOwnerCertificateProfileBaseRequest {
	return &AndroidDeviceOwnerCertificateProfileBaseRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// AndroidDeviceOwnerCertificateProfileBaseRequest is request for AndroidDeviceOwnerCertificateProfileBase
type AndroidDeviceOwnerCertificateProfileBaseRequest struct{ BaseRequest }

// Get performs GET request for AndroidDeviceOwnerCertificateProfileBase
func (r *AndroidDeviceOwnerCertificateProfileBaseRequest) Get(ctx context.Context) (resObj *AndroidDeviceOwnerCertificateProfileBase, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for AndroidDeviceOwnerCertificateProfileBase
func (r *AndroidDeviceOwnerCertificateProfileBaseRequest) Update(ctx context.Context, reqObj *AndroidDeviceOwnerCertificateProfileBase) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for AndroidDeviceOwnerCertificateProfileBase
func (r *AndroidDeviceOwnerCertificateProfileBaseRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// AndroidDeviceOwnerEnrollmentProfileRequestBuilder is request builder for AndroidDeviceOwnerEnrollmentProfile
type AndroidDeviceOwnerEnrollmentProfileRequestBuilder struct{ BaseRequestBuilder }

// Request returns AndroidDeviceOwnerEnrollmentProfileRequest
func (b *AndroidDeviceOwnerEnrollmentProfileRequestBuilder) Request() *AndroidDeviceOwnerEnrollmentProfileRequest {
	return &AndroidDeviceOwnerEnrollmentProfileRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// AndroidDeviceOwnerEnrollmentProfileRequest is request for AndroidDeviceOwnerEnrollmentProfile
type AndroidDeviceOwnerEnrollmentProfileRequest struct{ BaseRequest }

// Get performs GET request for AndroidDeviceOwnerEnrollmentProfile
func (r *AndroidDeviceOwnerEnrollmentProfileRequest) Get(ctx context.Context) (resObj *AndroidDeviceOwnerEnrollmentProfile, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for AndroidDeviceOwnerEnrollmentProfile
func (r *AndroidDeviceOwnerEnrollmentProfileRequest) Update(ctx context.Context, reqObj *AndroidDeviceOwnerEnrollmentProfile) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for AndroidDeviceOwnerEnrollmentProfile
func (r *AndroidDeviceOwnerEnrollmentProfileRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// AndroidDeviceOwnerEnterpriseWiFiConfigurationRequestBuilder is request builder for AndroidDeviceOwnerEnterpriseWiFiConfiguration
type AndroidDeviceOwnerEnterpriseWiFiConfigurationRequestBuilder struct{ BaseRequestBuilder }

// Request returns AndroidDeviceOwnerEnterpriseWiFiConfigurationRequest
func (b *AndroidDeviceOwnerEnterpriseWiFiConfigurationRequestBuilder) Request() *AndroidDeviceOwnerEnterpriseWiFiConfigurationRequest {
	return &AndroidDeviceOwnerEnterpriseWiFiConfigurationRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// AndroidDeviceOwnerEnterpriseWiFiConfigurationRequest is request for AndroidDeviceOwnerEnterpriseWiFiConfiguration
type AndroidDeviceOwnerEnterpriseWiFiConfigurationRequest struct{ BaseRequest }

// Get performs GET request for AndroidDeviceOwnerEnterpriseWiFiConfiguration
func (r *AndroidDeviceOwnerEnterpriseWiFiConfigurationRequest) Get(ctx context.Context) (resObj *AndroidDeviceOwnerEnterpriseWiFiConfiguration, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for AndroidDeviceOwnerEnterpriseWiFiConfiguration
func (r *AndroidDeviceOwnerEnterpriseWiFiConfigurationRequest) Update(ctx context.Context, reqObj *AndroidDeviceOwnerEnterpriseWiFiConfiguration) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for AndroidDeviceOwnerEnterpriseWiFiConfiguration
func (r *AndroidDeviceOwnerEnterpriseWiFiConfigurationRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// AndroidDeviceOwnerScepCertificateProfileRequestBuilder is request builder for AndroidDeviceOwnerScepCertificateProfile
type AndroidDeviceOwnerScepCertificateProfileRequestBuilder struct{ BaseRequestBuilder }

// Request returns AndroidDeviceOwnerScepCertificateProfileRequest
func (b *AndroidDeviceOwnerScepCertificateProfileRequestBuilder) Request() *AndroidDeviceOwnerScepCertificateProfileRequest {
	return &AndroidDeviceOwnerScepCertificateProfileRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// AndroidDeviceOwnerScepCertificateProfileRequest is request for AndroidDeviceOwnerScepCertificateProfile
type AndroidDeviceOwnerScepCertificateProfileRequest struct{ BaseRequest }

// Get performs GET request for AndroidDeviceOwnerScepCertificateProfile
func (r *AndroidDeviceOwnerScepCertificateProfileRequest) Get(ctx context.Context) (resObj *AndroidDeviceOwnerScepCertificateProfile, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for AndroidDeviceOwnerScepCertificateProfile
func (r *AndroidDeviceOwnerScepCertificateProfileRequest) Update(ctx context.Context, reqObj *AndroidDeviceOwnerScepCertificateProfile) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for AndroidDeviceOwnerScepCertificateProfile
func (r *AndroidDeviceOwnerScepCertificateProfileRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// AndroidDeviceOwnerTrustedRootCertificateRequestBuilder is request builder for AndroidDeviceOwnerTrustedRootCertificate
type AndroidDeviceOwnerTrustedRootCertificateRequestBuilder struct{ BaseRequestBuilder }

// Request returns AndroidDeviceOwnerTrustedRootCertificateRequest
func (b *AndroidDeviceOwnerTrustedRootCertificateRequestBuilder) Request() *AndroidDeviceOwnerTrustedRootCertificateRequest {
	return &AndroidDeviceOwnerTrustedRootCertificateRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// AndroidDeviceOwnerTrustedRootCertificateRequest is request for AndroidDeviceOwnerTrustedRootCertificate
type AndroidDeviceOwnerTrustedRootCertificateRequest struct{ BaseRequest }

// Get performs GET request for AndroidDeviceOwnerTrustedRootCertificate
func (r *AndroidDeviceOwnerTrustedRootCertificateRequest) Get(ctx context.Context) (resObj *AndroidDeviceOwnerTrustedRootCertificate, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for AndroidDeviceOwnerTrustedRootCertificate
func (r *AndroidDeviceOwnerTrustedRootCertificateRequest) Update(ctx context.Context, reqObj *AndroidDeviceOwnerTrustedRootCertificate) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for AndroidDeviceOwnerTrustedRootCertificate
func (r *AndroidDeviceOwnerTrustedRootCertificateRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// AndroidDeviceOwnerVPNConfigurationRequestBuilder is request builder for AndroidDeviceOwnerVPNConfiguration
type AndroidDeviceOwnerVPNConfigurationRequestBuilder struct{ BaseRequestBuilder }

// Request returns AndroidDeviceOwnerVPNConfigurationRequest
func (b *AndroidDeviceOwnerVPNConfigurationRequestBuilder) Request() *AndroidDeviceOwnerVPNConfigurationRequest {
	return &AndroidDeviceOwnerVPNConfigurationRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// AndroidDeviceOwnerVPNConfigurationRequest is request for AndroidDeviceOwnerVPNConfiguration
type AndroidDeviceOwnerVPNConfigurationRequest struct{ BaseRequest }

// Get performs GET request for AndroidDeviceOwnerVPNConfiguration
func (r *AndroidDeviceOwnerVPNConfigurationRequest) Get(ctx context.Context) (resObj *AndroidDeviceOwnerVPNConfiguration, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for AndroidDeviceOwnerVPNConfiguration
func (r *AndroidDeviceOwnerVPNConfigurationRequest) Update(ctx context.Context, reqObj *AndroidDeviceOwnerVPNConfiguration) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for AndroidDeviceOwnerVPNConfiguration
func (r *AndroidDeviceOwnerVPNConfigurationRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// AndroidEasEmailProfileConfigurationRequestBuilder is request builder for AndroidEasEmailProfileConfiguration
type AndroidEasEmailProfileConfigurationRequestBuilder struct{ BaseRequestBuilder }

// Request returns AndroidEasEmailProfileConfigurationRequest
func (b *AndroidEasEmailProfileConfigurationRequestBuilder) Request() *AndroidEasEmailProfileConfigurationRequest {
	return &AndroidEasEmailProfileConfigurationRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// AndroidEasEmailProfileConfigurationRequest is request for AndroidEasEmailProfileConfiguration
type AndroidEasEmailProfileConfigurationRequest struct{ BaseRequest }

// Get performs GET request for AndroidEasEmailProfileConfiguration
func (r *AndroidEasEmailProfileConfigurationRequest) Get(ctx context.Context) (resObj *AndroidEasEmailProfileConfiguration, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for AndroidEasEmailProfileConfiguration
func (r *AndroidEasEmailProfileConfigurationRequest) Update(ctx context.Context, reqObj *AndroidEasEmailProfileConfiguration) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for AndroidEasEmailProfileConfiguration
func (r *AndroidEasEmailProfileConfigurationRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// AndroidEnterpriseWiFiConfigurationRequestBuilder is request builder for AndroidEnterpriseWiFiConfiguration
type AndroidEnterpriseWiFiConfigurationRequestBuilder struct{ BaseRequestBuilder }

// Request returns AndroidEnterpriseWiFiConfigurationRequest
func (b *AndroidEnterpriseWiFiConfigurationRequestBuilder) Request() *AndroidEnterpriseWiFiConfigurationRequest {
	return &AndroidEnterpriseWiFiConfigurationRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// AndroidEnterpriseWiFiConfigurationRequest is request for AndroidEnterpriseWiFiConfiguration
type AndroidEnterpriseWiFiConfigurationRequest struct{ BaseRequest }

// Get performs GET request for AndroidEnterpriseWiFiConfiguration
func (r *AndroidEnterpriseWiFiConfigurationRequest) Get(ctx context.Context) (resObj *AndroidEnterpriseWiFiConfiguration, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for AndroidEnterpriseWiFiConfiguration
func (r *AndroidEnterpriseWiFiConfigurationRequest) Update(ctx context.Context, reqObj *AndroidEnterpriseWiFiConfiguration) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for AndroidEnterpriseWiFiConfiguration
func (r *AndroidEnterpriseWiFiConfigurationRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// AndroidForWorkAppConfigurationSchemaRequestBuilder is request builder for AndroidForWorkAppConfigurationSchema
type AndroidForWorkAppConfigurationSchemaRequestBuilder struct{ BaseRequestBuilder }

// Request returns AndroidForWorkAppConfigurationSchemaRequest
func (b *AndroidForWorkAppConfigurationSchemaRequestBuilder) Request() *AndroidForWorkAppConfigurationSchemaRequest {
	return &AndroidForWorkAppConfigurationSchemaRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// AndroidForWorkAppConfigurationSchemaRequest is request for AndroidForWorkAppConfigurationSchema
type AndroidForWorkAppConfigurationSchemaRequest struct{ BaseRequest }

// Get performs GET request for AndroidForWorkAppConfigurationSchema
func (r *AndroidForWorkAppConfigurationSchemaRequest) Get(ctx context.Context) (resObj *AndroidForWorkAppConfigurationSchema, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for AndroidForWorkAppConfigurationSchema
func (r *AndroidForWorkAppConfigurationSchemaRequest) Update(ctx context.Context, reqObj *AndroidForWorkAppConfigurationSchema) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for AndroidForWorkAppConfigurationSchema
func (r *AndroidForWorkAppConfigurationSchemaRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// AndroidForWorkCertificateProfileBaseRequestBuilder is request builder for AndroidForWorkCertificateProfileBase
type AndroidForWorkCertificateProfileBaseRequestBuilder struct{ BaseRequestBuilder }

// Request returns AndroidForWorkCertificateProfileBaseRequest
func (b *AndroidForWorkCertificateProfileBaseRequestBuilder) Request() *AndroidForWorkCertificateProfileBaseRequest {
	return &AndroidForWorkCertificateProfileBaseRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// AndroidForWorkCertificateProfileBaseRequest is request for AndroidForWorkCertificateProfileBase
type AndroidForWorkCertificateProfileBaseRequest struct{ BaseRequest }

// Get performs GET request for AndroidForWorkCertificateProfileBase
func (r *AndroidForWorkCertificateProfileBaseRequest) Get(ctx context.Context) (resObj *AndroidForWorkCertificateProfileBase, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for AndroidForWorkCertificateProfileBase
func (r *AndroidForWorkCertificateProfileBaseRequest) Update(ctx context.Context, reqObj *AndroidForWorkCertificateProfileBase) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for AndroidForWorkCertificateProfileBase
func (r *AndroidForWorkCertificateProfileBaseRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// AndroidForWorkEasEmailProfileBaseRequestBuilder is request builder for AndroidForWorkEasEmailProfileBase
type AndroidForWorkEasEmailProfileBaseRequestBuilder struct{ BaseRequestBuilder }

// Request returns AndroidForWorkEasEmailProfileBaseRequest
func (b *AndroidForWorkEasEmailProfileBaseRequestBuilder) Request() *AndroidForWorkEasEmailProfileBaseRequest {
	return &AndroidForWorkEasEmailProfileBaseRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// AndroidForWorkEasEmailProfileBaseRequest is request for AndroidForWorkEasEmailProfileBase
type AndroidForWorkEasEmailProfileBaseRequest struct{ BaseRequest }

// Get performs GET request for AndroidForWorkEasEmailProfileBase
func (r *AndroidForWorkEasEmailProfileBaseRequest) Get(ctx context.Context) (resObj *AndroidForWorkEasEmailProfileBase, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for AndroidForWorkEasEmailProfileBase
func (r *AndroidForWorkEasEmailProfileBaseRequest) Update(ctx context.Context, reqObj *AndroidForWorkEasEmailProfileBase) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for AndroidForWorkEasEmailProfileBase
func (r *AndroidForWorkEasEmailProfileBaseRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// AndroidForWorkEnrollmentProfileRequestBuilder is request builder for AndroidForWorkEnrollmentProfile
type AndroidForWorkEnrollmentProfileRequestBuilder struct{ BaseRequestBuilder }

// Request returns AndroidForWorkEnrollmentProfileRequest
func (b *AndroidForWorkEnrollmentProfileRequestBuilder) Request() *AndroidForWorkEnrollmentProfileRequest {
	return &AndroidForWorkEnrollmentProfileRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// AndroidForWorkEnrollmentProfileRequest is request for AndroidForWorkEnrollmentProfile
type AndroidForWorkEnrollmentProfileRequest struct{ BaseRequest }

// Get performs GET request for AndroidForWorkEnrollmentProfile
func (r *AndroidForWorkEnrollmentProfileRequest) Get(ctx context.Context) (resObj *AndroidForWorkEnrollmentProfile, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for AndroidForWorkEnrollmentProfile
func (r *AndroidForWorkEnrollmentProfileRequest) Update(ctx context.Context, reqObj *AndroidForWorkEnrollmentProfile) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for AndroidForWorkEnrollmentProfile
func (r *AndroidForWorkEnrollmentProfileRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// AndroidForWorkEnterpriseWiFiConfigurationRequestBuilder is request builder for AndroidForWorkEnterpriseWiFiConfiguration
type AndroidForWorkEnterpriseWiFiConfigurationRequestBuilder struct{ BaseRequestBuilder }

// Request returns AndroidForWorkEnterpriseWiFiConfigurationRequest
func (b *AndroidForWorkEnterpriseWiFiConfigurationRequestBuilder) Request() *AndroidForWorkEnterpriseWiFiConfigurationRequest {
	return &AndroidForWorkEnterpriseWiFiConfigurationRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// AndroidForWorkEnterpriseWiFiConfigurationRequest is request for AndroidForWorkEnterpriseWiFiConfiguration
type AndroidForWorkEnterpriseWiFiConfigurationRequest struct{ BaseRequest }

// Get performs GET request for AndroidForWorkEnterpriseWiFiConfiguration
func (r *AndroidForWorkEnterpriseWiFiConfigurationRequest) Get(ctx context.Context) (resObj *AndroidForWorkEnterpriseWiFiConfiguration, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for AndroidForWorkEnterpriseWiFiConfiguration
func (r *AndroidForWorkEnterpriseWiFiConfigurationRequest) Update(ctx context.Context, reqObj *AndroidForWorkEnterpriseWiFiConfiguration) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for AndroidForWorkEnterpriseWiFiConfiguration
func (r *AndroidForWorkEnterpriseWiFiConfigurationRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// AndroidForWorkImportedPFXCertificateProfileRequestBuilder is request builder for AndroidForWorkImportedPFXCertificateProfile
type AndroidForWorkImportedPFXCertificateProfileRequestBuilder struct{ BaseRequestBuilder }

// Request returns AndroidForWorkImportedPFXCertificateProfileRequest
func (b *AndroidForWorkImportedPFXCertificateProfileRequestBuilder) Request() *AndroidForWorkImportedPFXCertificateProfileRequest {
	return &AndroidForWorkImportedPFXCertificateProfileRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// AndroidForWorkImportedPFXCertificateProfileRequest is request for AndroidForWorkImportedPFXCertificateProfile
type AndroidForWorkImportedPFXCertificateProfileRequest struct{ BaseRequest }

// Get performs GET request for AndroidForWorkImportedPFXCertificateProfile
func (r *AndroidForWorkImportedPFXCertificateProfileRequest) Get(ctx context.Context) (resObj *AndroidForWorkImportedPFXCertificateProfile, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for AndroidForWorkImportedPFXCertificateProfile
func (r *AndroidForWorkImportedPFXCertificateProfileRequest) Update(ctx context.Context, reqObj *AndroidForWorkImportedPFXCertificateProfile) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for AndroidForWorkImportedPFXCertificateProfile
func (r *AndroidForWorkImportedPFXCertificateProfileRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// AndroidForWorkPkcsCertificateProfileRequestBuilder is request builder for AndroidForWorkPkcsCertificateProfile
type AndroidForWorkPkcsCertificateProfileRequestBuilder struct{ BaseRequestBuilder }

// Request returns AndroidForWorkPkcsCertificateProfileRequest
func (b *AndroidForWorkPkcsCertificateProfileRequestBuilder) Request() *AndroidForWorkPkcsCertificateProfileRequest {
	return &AndroidForWorkPkcsCertificateProfileRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// AndroidForWorkPkcsCertificateProfileRequest is request for AndroidForWorkPkcsCertificateProfile
type AndroidForWorkPkcsCertificateProfileRequest struct{ BaseRequest }

// Get performs GET request for AndroidForWorkPkcsCertificateProfile
func (r *AndroidForWorkPkcsCertificateProfileRequest) Get(ctx context.Context) (resObj *AndroidForWorkPkcsCertificateProfile, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for AndroidForWorkPkcsCertificateProfile
func (r *AndroidForWorkPkcsCertificateProfileRequest) Update(ctx context.Context, reqObj *AndroidForWorkPkcsCertificateProfile) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for AndroidForWorkPkcsCertificateProfile
func (r *AndroidForWorkPkcsCertificateProfileRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// AndroidForWorkScepCertificateProfileRequestBuilder is request builder for AndroidForWorkScepCertificateProfile
type AndroidForWorkScepCertificateProfileRequestBuilder struct{ BaseRequestBuilder }

// Request returns AndroidForWorkScepCertificateProfileRequest
func (b *AndroidForWorkScepCertificateProfileRequestBuilder) Request() *AndroidForWorkScepCertificateProfileRequest {
	return &AndroidForWorkScepCertificateProfileRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// AndroidForWorkScepCertificateProfileRequest is request for AndroidForWorkScepCertificateProfile
type AndroidForWorkScepCertificateProfileRequest struct{ BaseRequest }

// Get performs GET request for AndroidForWorkScepCertificateProfile
func (r *AndroidForWorkScepCertificateProfileRequest) Get(ctx context.Context) (resObj *AndroidForWorkScepCertificateProfile, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for AndroidForWorkScepCertificateProfile
func (r *AndroidForWorkScepCertificateProfileRequest) Update(ctx context.Context, reqObj *AndroidForWorkScepCertificateProfile) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for AndroidForWorkScepCertificateProfile
func (r *AndroidForWorkScepCertificateProfileRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// AndroidForWorkSettingsRequestBuilder is request builder for AndroidForWorkSettings
type AndroidForWorkSettingsRequestBuilder struct{ BaseRequestBuilder }

// Request returns AndroidForWorkSettingsRequest
func (b *AndroidForWorkSettingsRequestBuilder) Request() *AndroidForWorkSettingsRequest {
	return &AndroidForWorkSettingsRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// AndroidForWorkSettingsRequest is request for AndroidForWorkSettings
type AndroidForWorkSettingsRequest struct{ BaseRequest }

// Get performs GET request for AndroidForWorkSettings
func (r *AndroidForWorkSettingsRequest) Get(ctx context.Context) (resObj *AndroidForWorkSettings, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for AndroidForWorkSettings
func (r *AndroidForWorkSettingsRequest) Update(ctx context.Context, reqObj *AndroidForWorkSettings) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for AndroidForWorkSettings
func (r *AndroidForWorkSettingsRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// AndroidForWorkTrustedRootCertificateRequestBuilder is request builder for AndroidForWorkTrustedRootCertificate
type AndroidForWorkTrustedRootCertificateRequestBuilder struct{ BaseRequestBuilder }

// Request returns AndroidForWorkTrustedRootCertificateRequest
func (b *AndroidForWorkTrustedRootCertificateRequestBuilder) Request() *AndroidForWorkTrustedRootCertificateRequest {
	return &AndroidForWorkTrustedRootCertificateRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// AndroidForWorkTrustedRootCertificateRequest is request for AndroidForWorkTrustedRootCertificate
type AndroidForWorkTrustedRootCertificateRequest struct{ BaseRequest }

// Get performs GET request for AndroidForWorkTrustedRootCertificate
func (r *AndroidForWorkTrustedRootCertificateRequest) Get(ctx context.Context) (resObj *AndroidForWorkTrustedRootCertificate, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for AndroidForWorkTrustedRootCertificate
func (r *AndroidForWorkTrustedRootCertificateRequest) Update(ctx context.Context, reqObj *AndroidForWorkTrustedRootCertificate) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for AndroidForWorkTrustedRootCertificate
func (r *AndroidForWorkTrustedRootCertificateRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// AndroidForWorkVPNConfigurationRequestBuilder is request builder for AndroidForWorkVPNConfiguration
type AndroidForWorkVPNConfigurationRequestBuilder struct{ BaseRequestBuilder }

// Request returns AndroidForWorkVPNConfigurationRequest
func (b *AndroidForWorkVPNConfigurationRequestBuilder) Request() *AndroidForWorkVPNConfigurationRequest {
	return &AndroidForWorkVPNConfigurationRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// AndroidForWorkVPNConfigurationRequest is request for AndroidForWorkVPNConfiguration
type AndroidForWorkVPNConfigurationRequest struct{ BaseRequest }

// Get performs GET request for AndroidForWorkVPNConfiguration
func (r *AndroidForWorkVPNConfigurationRequest) Get(ctx context.Context) (resObj *AndroidForWorkVPNConfiguration, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for AndroidForWorkVPNConfiguration
func (r *AndroidForWorkVPNConfigurationRequest) Update(ctx context.Context, reqObj *AndroidForWorkVPNConfiguration) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for AndroidForWorkVPNConfiguration
func (r *AndroidForWorkVPNConfigurationRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// AndroidImportedPFXCertificateProfileRequestBuilder is request builder for AndroidImportedPFXCertificateProfile
type AndroidImportedPFXCertificateProfileRequestBuilder struct{ BaseRequestBuilder }

// Request returns AndroidImportedPFXCertificateProfileRequest
func (b *AndroidImportedPFXCertificateProfileRequestBuilder) Request() *AndroidImportedPFXCertificateProfileRequest {
	return &AndroidImportedPFXCertificateProfileRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// AndroidImportedPFXCertificateProfileRequest is request for AndroidImportedPFXCertificateProfile
type AndroidImportedPFXCertificateProfileRequest struct{ BaseRequest }

// Get performs GET request for AndroidImportedPFXCertificateProfile
func (r *AndroidImportedPFXCertificateProfileRequest) Get(ctx context.Context) (resObj *AndroidImportedPFXCertificateProfile, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for AndroidImportedPFXCertificateProfile
func (r *AndroidImportedPFXCertificateProfileRequest) Update(ctx context.Context, reqObj *AndroidImportedPFXCertificateProfile) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for AndroidImportedPFXCertificateProfile
func (r *AndroidImportedPFXCertificateProfileRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// AndroidManagedAppProtectionRequestBuilder is request builder for AndroidManagedAppProtection
type AndroidManagedAppProtectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns AndroidManagedAppProtectionRequest
func (b *AndroidManagedAppProtectionRequestBuilder) Request() *AndroidManagedAppProtectionRequest {
	return &AndroidManagedAppProtectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// AndroidManagedAppProtectionRequest is request for AndroidManagedAppProtection
type AndroidManagedAppProtectionRequest struct{ BaseRequest }

// Get performs GET request for AndroidManagedAppProtection
func (r *AndroidManagedAppProtectionRequest) Get(ctx context.Context) (resObj *AndroidManagedAppProtection, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for AndroidManagedAppProtection
func (r *AndroidManagedAppProtectionRequest) Update(ctx context.Context, reqObj *AndroidManagedAppProtection) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for AndroidManagedAppProtection
func (r *AndroidManagedAppProtectionRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// AndroidManagedStoreAccountEnterpriseSettingsRequestBuilder is request builder for AndroidManagedStoreAccountEnterpriseSettings
type AndroidManagedStoreAccountEnterpriseSettingsRequestBuilder struct{ BaseRequestBuilder }

// Request returns AndroidManagedStoreAccountEnterpriseSettingsRequest
func (b *AndroidManagedStoreAccountEnterpriseSettingsRequestBuilder) Request() *AndroidManagedStoreAccountEnterpriseSettingsRequest {
	return &AndroidManagedStoreAccountEnterpriseSettingsRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// AndroidManagedStoreAccountEnterpriseSettingsRequest is request for AndroidManagedStoreAccountEnterpriseSettings
type AndroidManagedStoreAccountEnterpriseSettingsRequest struct{ BaseRequest }

// Get performs GET request for AndroidManagedStoreAccountEnterpriseSettings
func (r *AndroidManagedStoreAccountEnterpriseSettingsRequest) Get(ctx context.Context) (resObj *AndroidManagedStoreAccountEnterpriseSettings, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for AndroidManagedStoreAccountEnterpriseSettings
func (r *AndroidManagedStoreAccountEnterpriseSettingsRequest) Update(ctx context.Context, reqObj *AndroidManagedStoreAccountEnterpriseSettings) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for AndroidManagedStoreAccountEnterpriseSettings
func (r *AndroidManagedStoreAccountEnterpriseSettingsRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// AndroidManagedStoreAppConfigurationSchemaRequestBuilder is request builder for AndroidManagedStoreAppConfigurationSchema
type AndroidManagedStoreAppConfigurationSchemaRequestBuilder struct{ BaseRequestBuilder }

// Request returns AndroidManagedStoreAppConfigurationSchemaRequest
func (b *AndroidManagedStoreAppConfigurationSchemaRequestBuilder) Request() *AndroidManagedStoreAppConfigurationSchemaRequest {
	return &AndroidManagedStoreAppConfigurationSchemaRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// AndroidManagedStoreAppConfigurationSchemaRequest is request for AndroidManagedStoreAppConfigurationSchema
type AndroidManagedStoreAppConfigurationSchemaRequest struct{ BaseRequest }

// Get performs GET request for AndroidManagedStoreAppConfigurationSchema
func (r *AndroidManagedStoreAppConfigurationSchemaRequest) Get(ctx context.Context) (resObj *AndroidManagedStoreAppConfigurationSchema, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for AndroidManagedStoreAppConfigurationSchema
func (r *AndroidManagedStoreAppConfigurationSchemaRequest) Update(ctx context.Context, reqObj *AndroidManagedStoreAppConfigurationSchema) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for AndroidManagedStoreAppConfigurationSchema
func (r *AndroidManagedStoreAppConfigurationSchemaRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// AndroidPkcsCertificateProfileRequestBuilder is request builder for AndroidPkcsCertificateProfile
type AndroidPkcsCertificateProfileRequestBuilder struct{ BaseRequestBuilder }

// Request returns AndroidPkcsCertificateProfileRequest
func (b *AndroidPkcsCertificateProfileRequestBuilder) Request() *AndroidPkcsCertificateProfileRequest {
	return &AndroidPkcsCertificateProfileRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// AndroidPkcsCertificateProfileRequest is request for AndroidPkcsCertificateProfile
type AndroidPkcsCertificateProfileRequest struct{ BaseRequest }

// Get performs GET request for AndroidPkcsCertificateProfile
func (r *AndroidPkcsCertificateProfileRequest) Get(ctx context.Context) (resObj *AndroidPkcsCertificateProfile, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for AndroidPkcsCertificateProfile
func (r *AndroidPkcsCertificateProfileRequest) Update(ctx context.Context, reqObj *AndroidPkcsCertificateProfile) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for AndroidPkcsCertificateProfile
func (r *AndroidPkcsCertificateProfileRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// AndroidScepCertificateProfileRequestBuilder is request builder for AndroidScepCertificateProfile
type AndroidScepCertificateProfileRequestBuilder struct{ BaseRequestBuilder }

// Request returns AndroidScepCertificateProfileRequest
func (b *AndroidScepCertificateProfileRequestBuilder) Request() *AndroidScepCertificateProfileRequest {
	return &AndroidScepCertificateProfileRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// AndroidScepCertificateProfileRequest is request for AndroidScepCertificateProfile
type AndroidScepCertificateProfileRequest struct{ BaseRequest }

// Get performs GET request for AndroidScepCertificateProfile
func (r *AndroidScepCertificateProfileRequest) Get(ctx context.Context) (resObj *AndroidScepCertificateProfile, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for AndroidScepCertificateProfile
func (r *AndroidScepCertificateProfileRequest) Update(ctx context.Context, reqObj *AndroidScepCertificateProfile) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for AndroidScepCertificateProfile
func (r *AndroidScepCertificateProfileRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// AndroidTrustedRootCertificateRequestBuilder is request builder for AndroidTrustedRootCertificate
type AndroidTrustedRootCertificateRequestBuilder struct{ BaseRequestBuilder }

// Request returns AndroidTrustedRootCertificateRequest
func (b *AndroidTrustedRootCertificateRequestBuilder) Request() *AndroidTrustedRootCertificateRequest {
	return &AndroidTrustedRootCertificateRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// AndroidTrustedRootCertificateRequest is request for AndroidTrustedRootCertificate
type AndroidTrustedRootCertificateRequest struct{ BaseRequest }

// Get performs GET request for AndroidTrustedRootCertificate
func (r *AndroidTrustedRootCertificateRequest) Get(ctx context.Context) (resObj *AndroidTrustedRootCertificate, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for AndroidTrustedRootCertificate
func (r *AndroidTrustedRootCertificateRequest) Update(ctx context.Context, reqObj *AndroidTrustedRootCertificate) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for AndroidTrustedRootCertificate
func (r *AndroidTrustedRootCertificateRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// AndroidVPNConfigurationRequestBuilder is request builder for AndroidVPNConfiguration
type AndroidVPNConfigurationRequestBuilder struct{ BaseRequestBuilder }

// Request returns AndroidVPNConfigurationRequest
func (b *AndroidVPNConfigurationRequestBuilder) Request() *AndroidVPNConfigurationRequest {
	return &AndroidVPNConfigurationRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// AndroidVPNConfigurationRequest is request for AndroidVPNConfiguration
type AndroidVPNConfigurationRequest struct{ BaseRequest }

// Get performs GET request for AndroidVPNConfiguration
func (r *AndroidVPNConfigurationRequest) Get(ctx context.Context) (resObj *AndroidVPNConfiguration, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for AndroidVPNConfiguration
func (r *AndroidVPNConfigurationRequest) Update(ctx context.Context, reqObj *AndroidVPNConfiguration) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for AndroidVPNConfiguration
func (r *AndroidVPNConfigurationRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// AndroidWorkProfileCertificateProfileBaseRequestBuilder is request builder for AndroidWorkProfileCertificateProfileBase
type AndroidWorkProfileCertificateProfileBaseRequestBuilder struct{ BaseRequestBuilder }

// Request returns AndroidWorkProfileCertificateProfileBaseRequest
func (b *AndroidWorkProfileCertificateProfileBaseRequestBuilder) Request() *AndroidWorkProfileCertificateProfileBaseRequest {
	return &AndroidWorkProfileCertificateProfileBaseRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// AndroidWorkProfileCertificateProfileBaseRequest is request for AndroidWorkProfileCertificateProfileBase
type AndroidWorkProfileCertificateProfileBaseRequest struct{ BaseRequest }

// Get performs GET request for AndroidWorkProfileCertificateProfileBase
func (r *AndroidWorkProfileCertificateProfileBaseRequest) Get(ctx context.Context) (resObj *AndroidWorkProfileCertificateProfileBase, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for AndroidWorkProfileCertificateProfileBase
func (r *AndroidWorkProfileCertificateProfileBaseRequest) Update(ctx context.Context, reqObj *AndroidWorkProfileCertificateProfileBase) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for AndroidWorkProfileCertificateProfileBase
func (r *AndroidWorkProfileCertificateProfileBaseRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// AndroidWorkProfileEasEmailProfileBaseRequestBuilder is request builder for AndroidWorkProfileEasEmailProfileBase
type AndroidWorkProfileEasEmailProfileBaseRequestBuilder struct{ BaseRequestBuilder }

// Request returns AndroidWorkProfileEasEmailProfileBaseRequest
func (b *AndroidWorkProfileEasEmailProfileBaseRequestBuilder) Request() *AndroidWorkProfileEasEmailProfileBaseRequest {
	return &AndroidWorkProfileEasEmailProfileBaseRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// AndroidWorkProfileEasEmailProfileBaseRequest is request for AndroidWorkProfileEasEmailProfileBase
type AndroidWorkProfileEasEmailProfileBaseRequest struct{ BaseRequest }

// Get performs GET request for AndroidWorkProfileEasEmailProfileBase
func (r *AndroidWorkProfileEasEmailProfileBaseRequest) Get(ctx context.Context) (resObj *AndroidWorkProfileEasEmailProfileBase, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for AndroidWorkProfileEasEmailProfileBase
func (r *AndroidWorkProfileEasEmailProfileBaseRequest) Update(ctx context.Context, reqObj *AndroidWorkProfileEasEmailProfileBase) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for AndroidWorkProfileEasEmailProfileBase
func (r *AndroidWorkProfileEasEmailProfileBaseRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// AndroidWorkProfileEnterpriseWiFiConfigurationRequestBuilder is request builder for AndroidWorkProfileEnterpriseWiFiConfiguration
type AndroidWorkProfileEnterpriseWiFiConfigurationRequestBuilder struct{ BaseRequestBuilder }

// Request returns AndroidWorkProfileEnterpriseWiFiConfigurationRequest
func (b *AndroidWorkProfileEnterpriseWiFiConfigurationRequestBuilder) Request() *AndroidWorkProfileEnterpriseWiFiConfigurationRequest {
	return &AndroidWorkProfileEnterpriseWiFiConfigurationRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// AndroidWorkProfileEnterpriseWiFiConfigurationRequest is request for AndroidWorkProfileEnterpriseWiFiConfiguration
type AndroidWorkProfileEnterpriseWiFiConfigurationRequest struct{ BaseRequest }

// Get performs GET request for AndroidWorkProfileEnterpriseWiFiConfiguration
func (r *AndroidWorkProfileEnterpriseWiFiConfigurationRequest) Get(ctx context.Context) (resObj *AndroidWorkProfileEnterpriseWiFiConfiguration, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for AndroidWorkProfileEnterpriseWiFiConfiguration
func (r *AndroidWorkProfileEnterpriseWiFiConfigurationRequest) Update(ctx context.Context, reqObj *AndroidWorkProfileEnterpriseWiFiConfiguration) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for AndroidWorkProfileEnterpriseWiFiConfiguration
func (r *AndroidWorkProfileEnterpriseWiFiConfigurationRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// AndroidWorkProfilePkcsCertificateProfileRequestBuilder is request builder for AndroidWorkProfilePkcsCertificateProfile
type AndroidWorkProfilePkcsCertificateProfileRequestBuilder struct{ BaseRequestBuilder }

// Request returns AndroidWorkProfilePkcsCertificateProfileRequest
func (b *AndroidWorkProfilePkcsCertificateProfileRequestBuilder) Request() *AndroidWorkProfilePkcsCertificateProfileRequest {
	return &AndroidWorkProfilePkcsCertificateProfileRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// AndroidWorkProfilePkcsCertificateProfileRequest is request for AndroidWorkProfilePkcsCertificateProfile
type AndroidWorkProfilePkcsCertificateProfileRequest struct{ BaseRequest }

// Get performs GET request for AndroidWorkProfilePkcsCertificateProfile
func (r *AndroidWorkProfilePkcsCertificateProfileRequest) Get(ctx context.Context) (resObj *AndroidWorkProfilePkcsCertificateProfile, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for AndroidWorkProfilePkcsCertificateProfile
func (r *AndroidWorkProfilePkcsCertificateProfileRequest) Update(ctx context.Context, reqObj *AndroidWorkProfilePkcsCertificateProfile) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for AndroidWorkProfilePkcsCertificateProfile
func (r *AndroidWorkProfilePkcsCertificateProfileRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// AndroidWorkProfileScepCertificateProfileRequestBuilder is request builder for AndroidWorkProfileScepCertificateProfile
type AndroidWorkProfileScepCertificateProfileRequestBuilder struct{ BaseRequestBuilder }

// Request returns AndroidWorkProfileScepCertificateProfileRequest
func (b *AndroidWorkProfileScepCertificateProfileRequestBuilder) Request() *AndroidWorkProfileScepCertificateProfileRequest {
	return &AndroidWorkProfileScepCertificateProfileRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// AndroidWorkProfileScepCertificateProfileRequest is request for AndroidWorkProfileScepCertificateProfile
type AndroidWorkProfileScepCertificateProfileRequest struct{ BaseRequest }

// Get performs GET request for AndroidWorkProfileScepCertificateProfile
func (r *AndroidWorkProfileScepCertificateProfileRequest) Get(ctx context.Context) (resObj *AndroidWorkProfileScepCertificateProfile, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for AndroidWorkProfileScepCertificateProfile
func (r *AndroidWorkProfileScepCertificateProfileRequest) Update(ctx context.Context, reqObj *AndroidWorkProfileScepCertificateProfile) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for AndroidWorkProfileScepCertificateProfile
func (r *AndroidWorkProfileScepCertificateProfileRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// AndroidWorkProfileTrustedRootCertificateRequestBuilder is request builder for AndroidWorkProfileTrustedRootCertificate
type AndroidWorkProfileTrustedRootCertificateRequestBuilder struct{ BaseRequestBuilder }

// Request returns AndroidWorkProfileTrustedRootCertificateRequest
func (b *AndroidWorkProfileTrustedRootCertificateRequestBuilder) Request() *AndroidWorkProfileTrustedRootCertificateRequest {
	return &AndroidWorkProfileTrustedRootCertificateRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// AndroidWorkProfileTrustedRootCertificateRequest is request for AndroidWorkProfileTrustedRootCertificate
type AndroidWorkProfileTrustedRootCertificateRequest struct{ BaseRequest }

// Get performs GET request for AndroidWorkProfileTrustedRootCertificate
func (r *AndroidWorkProfileTrustedRootCertificateRequest) Get(ctx context.Context) (resObj *AndroidWorkProfileTrustedRootCertificate, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for AndroidWorkProfileTrustedRootCertificate
func (r *AndroidWorkProfileTrustedRootCertificateRequest) Update(ctx context.Context, reqObj *AndroidWorkProfileTrustedRootCertificate) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for AndroidWorkProfileTrustedRootCertificate
func (r *AndroidWorkProfileTrustedRootCertificateRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// AndroidWorkProfileVPNConfigurationRequestBuilder is request builder for AndroidWorkProfileVPNConfiguration
type AndroidWorkProfileVPNConfigurationRequestBuilder struct{ BaseRequestBuilder }

// Request returns AndroidWorkProfileVPNConfigurationRequest
func (b *AndroidWorkProfileVPNConfigurationRequestBuilder) Request() *AndroidWorkProfileVPNConfigurationRequest {
	return &AndroidWorkProfileVPNConfigurationRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// AndroidWorkProfileVPNConfigurationRequest is request for AndroidWorkProfileVPNConfiguration
type AndroidWorkProfileVPNConfigurationRequest struct{ BaseRequest }

// Get performs GET request for AndroidWorkProfileVPNConfiguration
func (r *AndroidWorkProfileVPNConfigurationRequest) Get(ctx context.Context) (resObj *AndroidWorkProfileVPNConfiguration, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for AndroidWorkProfileVPNConfiguration
func (r *AndroidWorkProfileVPNConfigurationRequest) Update(ctx context.Context, reqObj *AndroidWorkProfileVPNConfiguration) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for AndroidWorkProfileVPNConfiguration
func (r *AndroidWorkProfileVPNConfigurationRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

//
type AndroidManagedAppProtectionCollectionHasPayloadLinksRequestBuilder struct{ BaseRequestBuilder }

// HasPayloadLinks action undocumented
func (b *DeviceAppManagementAndroidManagedAppProtectionsCollectionRequestBuilder) HasPayloadLinks(reqObj *AndroidManagedAppProtectionCollectionHasPayloadLinksRequestParameter) *AndroidManagedAppProtectionCollectionHasPayloadLinksRequestBuilder {
	bb := &AndroidManagedAppProtectionCollectionHasPayloadLinksRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/hasPayloadLinks"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type AndroidManagedAppProtectionCollectionHasPayloadLinksRequest struct{ BaseRequest }

//
func (b *AndroidManagedAppProtectionCollectionHasPayloadLinksRequestBuilder) Request() *AndroidManagedAppProtectionCollectionHasPayloadLinksRequest {
	return &AndroidManagedAppProtectionCollectionHasPayloadLinksRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *AndroidManagedAppProtectionCollectionHasPayloadLinksRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]HasPayloadLinkResultItem, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []HasPayloadLinkResultItem
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []HasPayloadLinkResultItem
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

//
func (r *AndroidManagedAppProtectionCollectionHasPayloadLinksRequest) PostN(ctx context.Context, n int) ([]HasPayloadLinkResultItem, error) {
	return r.Paging(ctx, "POST", "", r.requestObject, n)
}

//
func (r *AndroidManagedAppProtectionCollectionHasPayloadLinksRequest) Post(ctx context.Context) ([]HasPayloadLinkResultItem, error) {
	return r.Paging(ctx, "POST", "", r.requestObject, 0)
}

//
type AndroidDeviceOwnerEnrollmentProfileRevokeTokenRequestBuilder struct{ BaseRequestBuilder }

// RevokeToken action undocumented
func (b *AndroidDeviceOwnerEnrollmentProfileRequestBuilder) RevokeToken(reqObj *AndroidDeviceOwnerEnrollmentProfileRevokeTokenRequestParameter) *AndroidDeviceOwnerEnrollmentProfileRevokeTokenRequestBuilder {
	bb := &AndroidDeviceOwnerEnrollmentProfileRevokeTokenRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/revokeToken"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type AndroidDeviceOwnerEnrollmentProfileRevokeTokenRequest struct{ BaseRequest }

//
func (b *AndroidDeviceOwnerEnrollmentProfileRevokeTokenRequestBuilder) Request() *AndroidDeviceOwnerEnrollmentProfileRevokeTokenRequest {
	return &AndroidDeviceOwnerEnrollmentProfileRevokeTokenRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *AndroidDeviceOwnerEnrollmentProfileRevokeTokenRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type AndroidDeviceOwnerEnrollmentProfileCreateTokenRequestBuilder struct{ BaseRequestBuilder }

// CreateToken action undocumented
func (b *AndroidDeviceOwnerEnrollmentProfileRequestBuilder) CreateToken(reqObj *AndroidDeviceOwnerEnrollmentProfileCreateTokenRequestParameter) *AndroidDeviceOwnerEnrollmentProfileCreateTokenRequestBuilder {
	bb := &AndroidDeviceOwnerEnrollmentProfileCreateTokenRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/createToken"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type AndroidDeviceOwnerEnrollmentProfileCreateTokenRequest struct{ BaseRequest }

//
func (b *AndroidDeviceOwnerEnrollmentProfileCreateTokenRequestBuilder) Request() *AndroidDeviceOwnerEnrollmentProfileCreateTokenRequest {
	return &AndroidDeviceOwnerEnrollmentProfileCreateTokenRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *AndroidDeviceOwnerEnrollmentProfileCreateTokenRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type AndroidForWorkEnrollmentProfileRevokeTokenRequestBuilder struct{ BaseRequestBuilder }

// RevokeToken action undocumented
func (b *AndroidForWorkEnrollmentProfileRequestBuilder) RevokeToken(reqObj *AndroidForWorkEnrollmentProfileRevokeTokenRequestParameter) *AndroidForWorkEnrollmentProfileRevokeTokenRequestBuilder {
	bb := &AndroidForWorkEnrollmentProfileRevokeTokenRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/revokeToken"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type AndroidForWorkEnrollmentProfileRevokeTokenRequest struct{ BaseRequest }

//
func (b *AndroidForWorkEnrollmentProfileRevokeTokenRequestBuilder) Request() *AndroidForWorkEnrollmentProfileRevokeTokenRequest {
	return &AndroidForWorkEnrollmentProfileRevokeTokenRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *AndroidForWorkEnrollmentProfileRevokeTokenRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type AndroidForWorkEnrollmentProfileCreateTokenRequestBuilder struct{ BaseRequestBuilder }

// CreateToken action undocumented
func (b *AndroidForWorkEnrollmentProfileRequestBuilder) CreateToken(reqObj *AndroidForWorkEnrollmentProfileCreateTokenRequestParameter) *AndroidForWorkEnrollmentProfileCreateTokenRequestBuilder {
	bb := &AndroidForWorkEnrollmentProfileCreateTokenRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/createToken"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type AndroidForWorkEnrollmentProfileCreateTokenRequest struct{ BaseRequest }

//
func (b *AndroidForWorkEnrollmentProfileCreateTokenRequestBuilder) Request() *AndroidForWorkEnrollmentProfileCreateTokenRequest {
	return &AndroidForWorkEnrollmentProfileCreateTokenRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *AndroidForWorkEnrollmentProfileCreateTokenRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type AndroidForWorkSettingsRequestSignupURLRequestBuilder struct{ BaseRequestBuilder }

// RequestSignupURL action undocumented
func (b *AndroidForWorkSettingsRequestBuilder) RequestSignupURL(reqObj *AndroidForWorkSettingsRequestSignupURLRequestParameter) *AndroidForWorkSettingsRequestSignupURLRequestBuilder {
	bb := &AndroidForWorkSettingsRequestSignupURLRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/requestSignupUrl"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type AndroidForWorkSettingsRequestSignupURLRequest struct{ BaseRequest }

//
func (b *AndroidForWorkSettingsRequestSignupURLRequestBuilder) Request() *AndroidForWorkSettingsRequestSignupURLRequest {
	return &AndroidForWorkSettingsRequestSignupURLRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *AndroidForWorkSettingsRequestSignupURLRequest) Post(ctx context.Context) (resObj *string, err error) {
	err = r.JSONRequest(ctx, "POST", "", r.requestObject, &resObj)
	return
}

//
type AndroidForWorkSettingsCompleteSignupRequestBuilder struct{ BaseRequestBuilder }

// CompleteSignup action undocumented
func (b *AndroidForWorkSettingsRequestBuilder) CompleteSignup(reqObj *AndroidForWorkSettingsCompleteSignupRequestParameter) *AndroidForWorkSettingsCompleteSignupRequestBuilder {
	bb := &AndroidForWorkSettingsCompleteSignupRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/completeSignup"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type AndroidForWorkSettingsCompleteSignupRequest struct{ BaseRequest }

//
func (b *AndroidForWorkSettingsCompleteSignupRequestBuilder) Request() *AndroidForWorkSettingsCompleteSignupRequest {
	return &AndroidForWorkSettingsCompleteSignupRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *AndroidForWorkSettingsCompleteSignupRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type AndroidForWorkSettingsSyncAppsRequestBuilder struct{ BaseRequestBuilder }

// SyncApps action undocumented
func (b *AndroidForWorkSettingsRequestBuilder) SyncApps(reqObj *AndroidForWorkSettingsSyncAppsRequestParameter) *AndroidForWorkSettingsSyncAppsRequestBuilder {
	bb := &AndroidForWorkSettingsSyncAppsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/syncApps"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type AndroidForWorkSettingsSyncAppsRequest struct{ BaseRequest }

//
func (b *AndroidForWorkSettingsSyncAppsRequestBuilder) Request() *AndroidForWorkSettingsSyncAppsRequest {
	return &AndroidForWorkSettingsSyncAppsRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *AndroidForWorkSettingsSyncAppsRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type AndroidForWorkSettingsUnbindRequestBuilder struct{ BaseRequestBuilder }

// Unbind action undocumented
func (b *AndroidForWorkSettingsRequestBuilder) Unbind(reqObj *AndroidForWorkSettingsUnbindRequestParameter) *AndroidForWorkSettingsUnbindRequestBuilder {
	bb := &AndroidForWorkSettingsUnbindRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/unbind"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type AndroidForWorkSettingsUnbindRequest struct{ BaseRequest }

//
func (b *AndroidForWorkSettingsUnbindRequestBuilder) Request() *AndroidForWorkSettingsUnbindRequest {
	return &AndroidForWorkSettingsUnbindRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *AndroidForWorkSettingsUnbindRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type AndroidManagedStoreAccountEnterpriseSettingsApproveAppsRequestBuilder struct{ BaseRequestBuilder }

// ApproveApps action undocumented
func (b *AndroidManagedStoreAccountEnterpriseSettingsRequestBuilder) ApproveApps(reqObj *AndroidManagedStoreAccountEnterpriseSettingsApproveAppsRequestParameter) *AndroidManagedStoreAccountEnterpriseSettingsApproveAppsRequestBuilder {
	bb := &AndroidManagedStoreAccountEnterpriseSettingsApproveAppsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/approveApps"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type AndroidManagedStoreAccountEnterpriseSettingsApproveAppsRequest struct{ BaseRequest }

//
func (b *AndroidManagedStoreAccountEnterpriseSettingsApproveAppsRequestBuilder) Request() *AndroidManagedStoreAccountEnterpriseSettingsApproveAppsRequest {
	return &AndroidManagedStoreAccountEnterpriseSettingsApproveAppsRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *AndroidManagedStoreAccountEnterpriseSettingsApproveAppsRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type AndroidManagedStoreAccountEnterpriseSettingsRequestSignupURLRequestBuilder struct{ BaseRequestBuilder }

// RequestSignupURL action undocumented
func (b *AndroidManagedStoreAccountEnterpriseSettingsRequestBuilder) RequestSignupURL(reqObj *AndroidManagedStoreAccountEnterpriseSettingsRequestSignupURLRequestParameter) *AndroidManagedStoreAccountEnterpriseSettingsRequestSignupURLRequestBuilder {
	bb := &AndroidManagedStoreAccountEnterpriseSettingsRequestSignupURLRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/requestSignupUrl"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type AndroidManagedStoreAccountEnterpriseSettingsRequestSignupURLRequest struct{ BaseRequest }

//
func (b *AndroidManagedStoreAccountEnterpriseSettingsRequestSignupURLRequestBuilder) Request() *AndroidManagedStoreAccountEnterpriseSettingsRequestSignupURLRequest {
	return &AndroidManagedStoreAccountEnterpriseSettingsRequestSignupURLRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *AndroidManagedStoreAccountEnterpriseSettingsRequestSignupURLRequest) Post(ctx context.Context) (resObj *string, err error) {
	err = r.JSONRequest(ctx, "POST", "", r.requestObject, &resObj)
	return
}

//
type AndroidManagedStoreAccountEnterpriseSettingsCompleteSignupRequestBuilder struct{ BaseRequestBuilder }

// CompleteSignup action undocumented
func (b *AndroidManagedStoreAccountEnterpriseSettingsRequestBuilder) CompleteSignup(reqObj *AndroidManagedStoreAccountEnterpriseSettingsCompleteSignupRequestParameter) *AndroidManagedStoreAccountEnterpriseSettingsCompleteSignupRequestBuilder {
	bb := &AndroidManagedStoreAccountEnterpriseSettingsCompleteSignupRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/completeSignup"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type AndroidManagedStoreAccountEnterpriseSettingsCompleteSignupRequest struct{ BaseRequest }

//
func (b *AndroidManagedStoreAccountEnterpriseSettingsCompleteSignupRequestBuilder) Request() *AndroidManagedStoreAccountEnterpriseSettingsCompleteSignupRequest {
	return &AndroidManagedStoreAccountEnterpriseSettingsCompleteSignupRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *AndroidManagedStoreAccountEnterpriseSettingsCompleteSignupRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type AndroidManagedStoreAccountEnterpriseSettingsSyncAppsRequestBuilder struct{ BaseRequestBuilder }

// SyncApps action undocumented
func (b *AndroidManagedStoreAccountEnterpriseSettingsRequestBuilder) SyncApps(reqObj *AndroidManagedStoreAccountEnterpriseSettingsSyncAppsRequestParameter) *AndroidManagedStoreAccountEnterpriseSettingsSyncAppsRequestBuilder {
	bb := &AndroidManagedStoreAccountEnterpriseSettingsSyncAppsRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/syncApps"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type AndroidManagedStoreAccountEnterpriseSettingsSyncAppsRequest struct{ BaseRequest }

//
func (b *AndroidManagedStoreAccountEnterpriseSettingsSyncAppsRequestBuilder) Request() *AndroidManagedStoreAccountEnterpriseSettingsSyncAppsRequest {
	return &AndroidManagedStoreAccountEnterpriseSettingsSyncAppsRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *AndroidManagedStoreAccountEnterpriseSettingsSyncAppsRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type AndroidManagedStoreAccountEnterpriseSettingsUnbindRequestBuilder struct{ BaseRequestBuilder }

// Unbind action undocumented
func (b *AndroidManagedStoreAccountEnterpriseSettingsRequestBuilder) Unbind(reqObj *AndroidManagedStoreAccountEnterpriseSettingsUnbindRequestParameter) *AndroidManagedStoreAccountEnterpriseSettingsUnbindRequestBuilder {
	bb := &AndroidManagedStoreAccountEnterpriseSettingsUnbindRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/unbind"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type AndroidManagedStoreAccountEnterpriseSettingsUnbindRequest struct{ BaseRequest }

//
func (b *AndroidManagedStoreAccountEnterpriseSettingsUnbindRequestBuilder) Request() *AndroidManagedStoreAccountEnterpriseSettingsUnbindRequest {
	return &AndroidManagedStoreAccountEnterpriseSettingsUnbindRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *AndroidManagedStoreAccountEnterpriseSettingsUnbindRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type AndroidManagedStoreAccountEnterpriseSettingsCreateGooglePlayWebTokenRequestBuilder struct{ BaseRequestBuilder }

// CreateGooglePlayWebToken action undocumented
func (b *AndroidManagedStoreAccountEnterpriseSettingsRequestBuilder) CreateGooglePlayWebToken(reqObj *AndroidManagedStoreAccountEnterpriseSettingsCreateGooglePlayWebTokenRequestParameter) *AndroidManagedStoreAccountEnterpriseSettingsCreateGooglePlayWebTokenRequestBuilder {
	bb := &AndroidManagedStoreAccountEnterpriseSettingsCreateGooglePlayWebTokenRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/createGooglePlayWebToken"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type AndroidManagedStoreAccountEnterpriseSettingsCreateGooglePlayWebTokenRequest struct{ BaseRequest }

//
func (b *AndroidManagedStoreAccountEnterpriseSettingsCreateGooglePlayWebTokenRequestBuilder) Request() *AndroidManagedStoreAccountEnterpriseSettingsCreateGooglePlayWebTokenRequest {
	return &AndroidManagedStoreAccountEnterpriseSettingsCreateGooglePlayWebTokenRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *AndroidManagedStoreAccountEnterpriseSettingsCreateGooglePlayWebTokenRequest) Post(ctx context.Context) (resObj *string, err error) {
	err = r.JSONRequest(ctx, "POST", "", r.requestObject, &resObj)
	return
}

//
type AndroidManagedStoreAccountEnterpriseSettingsSetAndroidDeviceOwnerFullyManagedEnrollmentStateRequestBuilder struct{ BaseRequestBuilder }

// SetAndroidDeviceOwnerFullyManagedEnrollmentState action undocumented
func (b *AndroidManagedStoreAccountEnterpriseSettingsRequestBuilder) SetAndroidDeviceOwnerFullyManagedEnrollmentState(reqObj *AndroidManagedStoreAccountEnterpriseSettingsSetAndroidDeviceOwnerFullyManagedEnrollmentStateRequestParameter) *AndroidManagedStoreAccountEnterpriseSettingsSetAndroidDeviceOwnerFullyManagedEnrollmentStateRequestBuilder {
	bb := &AndroidManagedStoreAccountEnterpriseSettingsSetAndroidDeviceOwnerFullyManagedEnrollmentStateRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/setAndroidDeviceOwnerFullyManagedEnrollmentState"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type AndroidManagedStoreAccountEnterpriseSettingsSetAndroidDeviceOwnerFullyManagedEnrollmentStateRequest struct{ BaseRequest }

//
func (b *AndroidManagedStoreAccountEnterpriseSettingsSetAndroidDeviceOwnerFullyManagedEnrollmentStateRequestBuilder) Request() *AndroidManagedStoreAccountEnterpriseSettingsSetAndroidDeviceOwnerFullyManagedEnrollmentStateRequest {
	return &AndroidManagedStoreAccountEnterpriseSettingsSetAndroidDeviceOwnerFullyManagedEnrollmentStateRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *AndroidManagedStoreAccountEnterpriseSettingsSetAndroidDeviceOwnerFullyManagedEnrollmentStateRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}
