// Code generated by msgraph.go/gen DO NOT EDIT.

package msgraph

import (
	"context"
	"fmt"
	"io/ioutil"
	"net/http"

	"github.com/yaegashi/msgraph.go/jsonx"
)

// Account returns request builder for UserAccountInformation collection
func (b *ProfileRequestBuilder) Account() *ProfileAccountCollectionRequestBuilder {
	bb := &ProfileAccountCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/account"
	return bb
}

// ProfileAccountCollectionRequestBuilder is request builder for UserAccountInformation collection
type ProfileAccountCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for UserAccountInformation collection
func (b *ProfileAccountCollectionRequestBuilder) Request() *ProfileAccountCollectionRequest {
	return &ProfileAccountCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for UserAccountInformation item
func (b *ProfileAccountCollectionRequestBuilder) ID(id string) *UserAccountInformationRequestBuilder {
	bb := &UserAccountInformationRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// ProfileAccountCollectionRequest is request for UserAccountInformation collection
type ProfileAccountCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for UserAccountInformation collection
func (r *ProfileAccountCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]UserAccountInformation, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []UserAccountInformation
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []UserAccountInformation
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for UserAccountInformation collection, max N pages
func (r *ProfileAccountCollectionRequest) GetN(ctx context.Context, n int) ([]UserAccountInformation, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for UserAccountInformation collection
func (r *ProfileAccountCollectionRequest) Get(ctx context.Context) ([]UserAccountInformation, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for UserAccountInformation collection
func (r *ProfileAccountCollectionRequest) Add(ctx context.Context, reqObj *UserAccountInformation) (resObj *UserAccountInformation, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Anniversaries returns request builder for PersonAnniversary collection
func (b *ProfileRequestBuilder) Anniversaries() *ProfileAnniversariesCollectionRequestBuilder {
	bb := &ProfileAnniversariesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/anniversaries"
	return bb
}

// ProfileAnniversariesCollectionRequestBuilder is request builder for PersonAnniversary collection
type ProfileAnniversariesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for PersonAnniversary collection
func (b *ProfileAnniversariesCollectionRequestBuilder) Request() *ProfileAnniversariesCollectionRequest {
	return &ProfileAnniversariesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for PersonAnniversary item
func (b *ProfileAnniversariesCollectionRequestBuilder) ID(id string) *PersonAnniversaryRequestBuilder {
	bb := &PersonAnniversaryRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// ProfileAnniversariesCollectionRequest is request for PersonAnniversary collection
type ProfileAnniversariesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for PersonAnniversary collection
func (r *ProfileAnniversariesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]PersonAnniversary, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []PersonAnniversary
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []PersonAnniversary
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for PersonAnniversary collection, max N pages
func (r *ProfileAnniversariesCollectionRequest) GetN(ctx context.Context, n int) ([]PersonAnniversary, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for PersonAnniversary collection
func (r *ProfileAnniversariesCollectionRequest) Get(ctx context.Context) ([]PersonAnniversary, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for PersonAnniversary collection
func (r *ProfileAnniversariesCollectionRequest) Add(ctx context.Context, reqObj *PersonAnniversary) (resObj *PersonAnniversary, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// EducationalActivities returns request builder for EducationalActivity collection
func (b *ProfileRequestBuilder) EducationalActivities() *ProfileEducationalActivitiesCollectionRequestBuilder {
	bb := &ProfileEducationalActivitiesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/educationalActivities"
	return bb
}

// ProfileEducationalActivitiesCollectionRequestBuilder is request builder for EducationalActivity collection
type ProfileEducationalActivitiesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for EducationalActivity collection
func (b *ProfileEducationalActivitiesCollectionRequestBuilder) Request() *ProfileEducationalActivitiesCollectionRequest {
	return &ProfileEducationalActivitiesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for EducationalActivity item
func (b *ProfileEducationalActivitiesCollectionRequestBuilder) ID(id string) *EducationalActivityRequestBuilder {
	bb := &EducationalActivityRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// ProfileEducationalActivitiesCollectionRequest is request for EducationalActivity collection
type ProfileEducationalActivitiesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for EducationalActivity collection
func (r *ProfileEducationalActivitiesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]EducationalActivity, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []EducationalActivity
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []EducationalActivity
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for EducationalActivity collection, max N pages
func (r *ProfileEducationalActivitiesCollectionRequest) GetN(ctx context.Context, n int) ([]EducationalActivity, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for EducationalActivity collection
func (r *ProfileEducationalActivitiesCollectionRequest) Get(ctx context.Context) ([]EducationalActivity, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for EducationalActivity collection
func (r *ProfileEducationalActivitiesCollectionRequest) Add(ctx context.Context, reqObj *EducationalActivity) (resObj *EducationalActivity, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Emails returns request builder for ItemEmail collection
func (b *ProfileRequestBuilder) Emails() *ProfileEmailsCollectionRequestBuilder {
	bb := &ProfileEmailsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/emails"
	return bb
}

// ProfileEmailsCollectionRequestBuilder is request builder for ItemEmail collection
type ProfileEmailsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for ItemEmail collection
func (b *ProfileEmailsCollectionRequestBuilder) Request() *ProfileEmailsCollectionRequest {
	return &ProfileEmailsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for ItemEmail item
func (b *ProfileEmailsCollectionRequestBuilder) ID(id string) *ItemEmailRequestBuilder {
	bb := &ItemEmailRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// ProfileEmailsCollectionRequest is request for ItemEmail collection
type ProfileEmailsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for ItemEmail collection
func (r *ProfileEmailsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]ItemEmail, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []ItemEmail
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []ItemEmail
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for ItemEmail collection, max N pages
func (r *ProfileEmailsCollectionRequest) GetN(ctx context.Context, n int) ([]ItemEmail, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for ItemEmail collection
func (r *ProfileEmailsCollectionRequest) Get(ctx context.Context) ([]ItemEmail, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for ItemEmail collection
func (r *ProfileEmailsCollectionRequest) Add(ctx context.Context, reqObj *ItemEmail) (resObj *ItemEmail, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Interests returns request builder for PersonInterest collection
func (b *ProfileRequestBuilder) Interests() *ProfileInterestsCollectionRequestBuilder {
	bb := &ProfileInterestsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/interests"
	return bb
}

// ProfileInterestsCollectionRequestBuilder is request builder for PersonInterest collection
type ProfileInterestsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for PersonInterest collection
func (b *ProfileInterestsCollectionRequestBuilder) Request() *ProfileInterestsCollectionRequest {
	return &ProfileInterestsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for PersonInterest item
func (b *ProfileInterestsCollectionRequestBuilder) ID(id string) *PersonInterestRequestBuilder {
	bb := &PersonInterestRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// ProfileInterestsCollectionRequest is request for PersonInterest collection
type ProfileInterestsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for PersonInterest collection
func (r *ProfileInterestsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]PersonInterest, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []PersonInterest
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []PersonInterest
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for PersonInterest collection, max N pages
func (r *ProfileInterestsCollectionRequest) GetN(ctx context.Context, n int) ([]PersonInterest, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for PersonInterest collection
func (r *ProfileInterestsCollectionRequest) Get(ctx context.Context) ([]PersonInterest, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for PersonInterest collection
func (r *ProfileInterestsCollectionRequest) Add(ctx context.Context, reqObj *PersonInterest) (resObj *PersonInterest, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Languages returns request builder for LanguageProficiency collection
func (b *ProfileRequestBuilder) Languages() *ProfileLanguagesCollectionRequestBuilder {
	bb := &ProfileLanguagesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/languages"
	return bb
}

// ProfileLanguagesCollectionRequestBuilder is request builder for LanguageProficiency collection
type ProfileLanguagesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for LanguageProficiency collection
func (b *ProfileLanguagesCollectionRequestBuilder) Request() *ProfileLanguagesCollectionRequest {
	return &ProfileLanguagesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for LanguageProficiency item
func (b *ProfileLanguagesCollectionRequestBuilder) ID(id string) *LanguageProficiencyRequestBuilder {
	bb := &LanguageProficiencyRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// ProfileLanguagesCollectionRequest is request for LanguageProficiency collection
type ProfileLanguagesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for LanguageProficiency collection
func (r *ProfileLanguagesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]LanguageProficiency, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []LanguageProficiency
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []LanguageProficiency
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for LanguageProficiency collection, max N pages
func (r *ProfileLanguagesCollectionRequest) GetN(ctx context.Context, n int) ([]LanguageProficiency, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for LanguageProficiency collection
func (r *ProfileLanguagesCollectionRequest) Get(ctx context.Context) ([]LanguageProficiency, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for LanguageProficiency collection
func (r *ProfileLanguagesCollectionRequest) Add(ctx context.Context, reqObj *LanguageProficiency) (resObj *LanguageProficiency, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Names returns request builder for PersonName collection
func (b *ProfileRequestBuilder) Names() *ProfileNamesCollectionRequestBuilder {
	bb := &ProfileNamesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/names"
	return bb
}

// ProfileNamesCollectionRequestBuilder is request builder for PersonName collection
type ProfileNamesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for PersonName collection
func (b *ProfileNamesCollectionRequestBuilder) Request() *ProfileNamesCollectionRequest {
	return &ProfileNamesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for PersonName item
func (b *ProfileNamesCollectionRequestBuilder) ID(id string) *PersonNameRequestBuilder {
	bb := &PersonNameRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// ProfileNamesCollectionRequest is request for PersonName collection
type ProfileNamesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for PersonName collection
func (r *ProfileNamesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]PersonName, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []PersonName
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []PersonName
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for PersonName collection, max N pages
func (r *ProfileNamesCollectionRequest) GetN(ctx context.Context, n int) ([]PersonName, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for PersonName collection
func (r *ProfileNamesCollectionRequest) Get(ctx context.Context) ([]PersonName, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for PersonName collection
func (r *ProfileNamesCollectionRequest) Add(ctx context.Context, reqObj *PersonName) (resObj *PersonName, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Phones returns request builder for ItemPhone collection
func (b *ProfileRequestBuilder) Phones() *ProfilePhonesCollectionRequestBuilder {
	bb := &ProfilePhonesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/phones"
	return bb
}

// ProfilePhonesCollectionRequestBuilder is request builder for ItemPhone collection
type ProfilePhonesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for ItemPhone collection
func (b *ProfilePhonesCollectionRequestBuilder) Request() *ProfilePhonesCollectionRequest {
	return &ProfilePhonesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for ItemPhone item
func (b *ProfilePhonesCollectionRequestBuilder) ID(id string) *ItemPhoneRequestBuilder {
	bb := &ItemPhoneRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// ProfilePhonesCollectionRequest is request for ItemPhone collection
type ProfilePhonesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for ItemPhone collection
func (r *ProfilePhonesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]ItemPhone, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []ItemPhone
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []ItemPhone
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for ItemPhone collection, max N pages
func (r *ProfilePhonesCollectionRequest) GetN(ctx context.Context, n int) ([]ItemPhone, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for ItemPhone collection
func (r *ProfilePhonesCollectionRequest) Get(ctx context.Context) ([]ItemPhone, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for ItemPhone collection
func (r *ProfilePhonesCollectionRequest) Add(ctx context.Context, reqObj *ItemPhone) (resObj *ItemPhone, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Positions returns request builder for WorkPosition collection
func (b *ProfileRequestBuilder) Positions() *ProfilePositionsCollectionRequestBuilder {
	bb := &ProfilePositionsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/positions"
	return bb
}

// ProfilePositionsCollectionRequestBuilder is request builder for WorkPosition collection
type ProfilePositionsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for WorkPosition collection
func (b *ProfilePositionsCollectionRequestBuilder) Request() *ProfilePositionsCollectionRequest {
	return &ProfilePositionsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for WorkPosition item
func (b *ProfilePositionsCollectionRequestBuilder) ID(id string) *WorkPositionRequestBuilder {
	bb := &WorkPositionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// ProfilePositionsCollectionRequest is request for WorkPosition collection
type ProfilePositionsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for WorkPosition collection
func (r *ProfilePositionsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]WorkPosition, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []WorkPosition
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []WorkPosition
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for WorkPosition collection, max N pages
func (r *ProfilePositionsCollectionRequest) GetN(ctx context.Context, n int) ([]WorkPosition, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for WorkPosition collection
func (r *ProfilePositionsCollectionRequest) Get(ctx context.Context) ([]WorkPosition, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for WorkPosition collection
func (r *ProfilePositionsCollectionRequest) Add(ctx context.Context, reqObj *WorkPosition) (resObj *WorkPosition, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Projects returns request builder for ProjectParticipation collection
func (b *ProfileRequestBuilder) Projects() *ProfileProjectsCollectionRequestBuilder {
	bb := &ProfileProjectsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/projects"
	return bb
}

// ProfileProjectsCollectionRequestBuilder is request builder for ProjectParticipation collection
type ProfileProjectsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for ProjectParticipation collection
func (b *ProfileProjectsCollectionRequestBuilder) Request() *ProfileProjectsCollectionRequest {
	return &ProfileProjectsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for ProjectParticipation item
func (b *ProfileProjectsCollectionRequestBuilder) ID(id string) *ProjectParticipationRequestBuilder {
	bb := &ProjectParticipationRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// ProfileProjectsCollectionRequest is request for ProjectParticipation collection
type ProfileProjectsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for ProjectParticipation collection
func (r *ProfileProjectsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]ProjectParticipation, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []ProjectParticipation
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []ProjectParticipation
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for ProjectParticipation collection, max N pages
func (r *ProfileProjectsCollectionRequest) GetN(ctx context.Context, n int) ([]ProjectParticipation, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for ProjectParticipation collection
func (r *ProfileProjectsCollectionRequest) Get(ctx context.Context) ([]ProjectParticipation, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for ProjectParticipation collection
func (r *ProfileProjectsCollectionRequest) Add(ctx context.Context, reqObj *ProjectParticipation) (resObj *ProjectParticipation, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Skills returns request builder for SkillProficiency collection
func (b *ProfileRequestBuilder) Skills() *ProfileSkillsCollectionRequestBuilder {
	bb := &ProfileSkillsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/skills"
	return bb
}

// ProfileSkillsCollectionRequestBuilder is request builder for SkillProficiency collection
type ProfileSkillsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for SkillProficiency collection
func (b *ProfileSkillsCollectionRequestBuilder) Request() *ProfileSkillsCollectionRequest {
	return &ProfileSkillsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for SkillProficiency item
func (b *ProfileSkillsCollectionRequestBuilder) ID(id string) *SkillProficiencyRequestBuilder {
	bb := &SkillProficiencyRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// ProfileSkillsCollectionRequest is request for SkillProficiency collection
type ProfileSkillsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for SkillProficiency collection
func (r *ProfileSkillsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]SkillProficiency, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []SkillProficiency
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []SkillProficiency
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for SkillProficiency collection, max N pages
func (r *ProfileSkillsCollectionRequest) GetN(ctx context.Context, n int) ([]SkillProficiency, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for SkillProficiency collection
func (r *ProfileSkillsCollectionRequest) Get(ctx context.Context) ([]SkillProficiency, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for SkillProficiency collection
func (r *ProfileSkillsCollectionRequest) Add(ctx context.Context, reqObj *SkillProficiency) (resObj *SkillProficiency, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// WebAccounts returns request builder for WebAccount collection
func (b *ProfileRequestBuilder) WebAccounts() *ProfileWebAccountsCollectionRequestBuilder {
	bb := &ProfileWebAccountsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/webAccounts"
	return bb
}

// ProfileWebAccountsCollectionRequestBuilder is request builder for WebAccount collection
type ProfileWebAccountsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for WebAccount collection
func (b *ProfileWebAccountsCollectionRequestBuilder) Request() *ProfileWebAccountsCollectionRequest {
	return &ProfileWebAccountsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for WebAccount item
func (b *ProfileWebAccountsCollectionRequestBuilder) ID(id string) *WebAccountRequestBuilder {
	bb := &WebAccountRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// ProfileWebAccountsCollectionRequest is request for WebAccount collection
type ProfileWebAccountsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for WebAccount collection
func (r *ProfileWebAccountsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]WebAccount, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []WebAccount
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []WebAccount
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for WebAccount collection, max N pages
func (r *ProfileWebAccountsCollectionRequest) GetN(ctx context.Context, n int) ([]WebAccount, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for WebAccount collection
func (r *ProfileWebAccountsCollectionRequest) Get(ctx context.Context) ([]WebAccount, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for WebAccount collection
func (r *ProfileWebAccountsCollectionRequest) Add(ctx context.Context, reqObj *WebAccount) (resObj *WebAccount, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Websites returns request builder for PersonWebsite collection
func (b *ProfileRequestBuilder) Websites() *ProfileWebsitesCollectionRequestBuilder {
	bb := &ProfileWebsitesCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/websites"
	return bb
}

// ProfileWebsitesCollectionRequestBuilder is request builder for PersonWebsite collection
type ProfileWebsitesCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for PersonWebsite collection
func (b *ProfileWebsitesCollectionRequestBuilder) Request() *ProfileWebsitesCollectionRequest {
	return &ProfileWebsitesCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for PersonWebsite item
func (b *ProfileWebsitesCollectionRequestBuilder) ID(id string) *PersonWebsiteRequestBuilder {
	bb := &PersonWebsiteRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// ProfileWebsitesCollectionRequest is request for PersonWebsite collection
type ProfileWebsitesCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for PersonWebsite collection
func (r *ProfileWebsitesCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]PersonWebsite, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []PersonWebsite
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []PersonWebsite
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for PersonWebsite collection, max N pages
func (r *ProfileWebsitesCollectionRequest) GetN(ctx context.Context, n int) ([]PersonWebsite, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for PersonWebsite collection
func (r *ProfileWebsitesCollectionRequest) Get(ctx context.Context) ([]PersonWebsite, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for PersonWebsite collection
func (r *ProfileWebsitesCollectionRequest) Add(ctx context.Context, reqObj *PersonWebsite) (resObj *PersonWebsite, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}
