// Code generated by msgraph.go/gen DO NOT EDIT.

package msgraph

import (
	"context"
	"fmt"
	"io/ioutil"
	"net/http"

	"github.com/yaegashi/msgraph.go/jsonx"
)

// Connections returns request builder for ExternalConnection collection
func (b *ExternalRequestBuilder) Connections() *ExternalConnectionsCollectionRequestBuilder {
	bb := &ExternalConnectionsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/connections"
	return bb
}

// ExternalConnectionsCollectionRequestBuilder is request builder for ExternalConnection collection
type ExternalConnectionsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for ExternalConnection collection
func (b *ExternalConnectionsCollectionRequestBuilder) Request() *ExternalConnectionsCollectionRequest {
	return &ExternalConnectionsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for ExternalConnection item
func (b *ExternalConnectionsCollectionRequestBuilder) ID(id string) *ExternalConnectionRequestBuilder {
	bb := &ExternalConnectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// ExternalConnectionsCollectionRequest is request for ExternalConnection collection
type ExternalConnectionsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for ExternalConnection collection
func (r *ExternalConnectionsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]ExternalConnection, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []ExternalConnection
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []ExternalConnection
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for ExternalConnection collection, max N pages
func (r *ExternalConnectionsCollectionRequest) GetN(ctx context.Context, n int) ([]ExternalConnection, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for ExternalConnection collection
func (r *ExternalConnectionsCollectionRequest) Get(ctx context.Context) ([]ExternalConnection, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for ExternalConnection collection
func (r *ExternalConnectionsCollectionRequest) Add(ctx context.Context, reqObj *ExternalConnection) (resObj *ExternalConnection, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Items returns request builder for ExternalItem collection
func (b *ExternalConnectionRequestBuilder) Items() *ExternalConnectionItemsCollectionRequestBuilder {
	bb := &ExternalConnectionItemsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/items"
	return bb
}

// ExternalConnectionItemsCollectionRequestBuilder is request builder for ExternalItem collection
type ExternalConnectionItemsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for ExternalItem collection
func (b *ExternalConnectionItemsCollectionRequestBuilder) Request() *ExternalConnectionItemsCollectionRequest {
	return &ExternalConnectionItemsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for ExternalItem item
func (b *ExternalConnectionItemsCollectionRequestBuilder) ID(id string) *ExternalItemRequestBuilder {
	bb := &ExternalItemRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// ExternalConnectionItemsCollectionRequest is request for ExternalItem collection
type ExternalConnectionItemsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for ExternalItem collection
func (r *ExternalConnectionItemsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]ExternalItem, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []ExternalItem
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []ExternalItem
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for ExternalItem collection, max N pages
func (r *ExternalConnectionItemsCollectionRequest) GetN(ctx context.Context, n int) ([]ExternalItem, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for ExternalItem collection
func (r *ExternalConnectionItemsCollectionRequest) Get(ctx context.Context) ([]ExternalItem, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for ExternalItem collection
func (r *ExternalConnectionItemsCollectionRequest) Add(ctx context.Context, reqObj *ExternalItem) (resObj *ExternalItem, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Operations returns request builder for ConnectionOperation collection
func (b *ExternalConnectionRequestBuilder) Operations() *ExternalConnectionOperationsCollectionRequestBuilder {
	bb := &ExternalConnectionOperationsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/operations"
	return bb
}

// ExternalConnectionOperationsCollectionRequestBuilder is request builder for ConnectionOperation collection
type ExternalConnectionOperationsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for ConnectionOperation collection
func (b *ExternalConnectionOperationsCollectionRequestBuilder) Request() *ExternalConnectionOperationsCollectionRequest {
	return &ExternalConnectionOperationsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for ConnectionOperation item
func (b *ExternalConnectionOperationsCollectionRequestBuilder) ID(id string) *ConnectionOperationRequestBuilder {
	bb := &ConnectionOperationRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// ExternalConnectionOperationsCollectionRequest is request for ConnectionOperation collection
type ExternalConnectionOperationsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for ConnectionOperation collection
func (r *ExternalConnectionOperationsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]ConnectionOperation, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []ConnectionOperation
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []ConnectionOperation
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for ConnectionOperation collection, max N pages
func (r *ExternalConnectionOperationsCollectionRequest) GetN(ctx context.Context, n int) ([]ConnectionOperation, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for ConnectionOperation collection
func (r *ExternalConnectionOperationsCollectionRequest) Get(ctx context.Context) ([]ConnectionOperation, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for ConnectionOperation collection
func (r *ExternalConnectionOperationsCollectionRequest) Add(ctx context.Context, reqObj *ConnectionOperation) (resObj *ConnectionOperation, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}

// Schema is navigation property
func (b *ExternalConnectionRequestBuilder) Schema() *SchemaRequestBuilder {
	bb := &SchemaRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/schema"
	return bb
}
