// Code generated by msgraph.go/gen DO NOT EDIT.

package msgraph

import (
	"context"
	"fmt"
	"io/ioutil"
	"net/http"

	"github.com/yaegashi/msgraph.go/jsonx"
)

// WindowsAutopilotDeploymentProfileRequestBuilder is request builder for WindowsAutopilotDeploymentProfile
type WindowsAutopilotDeploymentProfileRequestBuilder struct{ BaseRequestBuilder }

// Request returns WindowsAutopilotDeploymentProfileRequest
func (b *WindowsAutopilotDeploymentProfileRequestBuilder) Request() *WindowsAutopilotDeploymentProfileRequest {
	return &WindowsAutopilotDeploymentProfileRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// WindowsAutopilotDeploymentProfileRequest is request for WindowsAutopilotDeploymentProfile
type WindowsAutopilotDeploymentProfileRequest struct{ BaseRequest }

// Get performs GET request for WindowsAutopilotDeploymentProfile
func (r *WindowsAutopilotDeploymentProfileRequest) Get(ctx context.Context) (resObj *WindowsAutopilotDeploymentProfile, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for WindowsAutopilotDeploymentProfile
func (r *WindowsAutopilotDeploymentProfileRequest) Update(ctx context.Context, reqObj *WindowsAutopilotDeploymentProfile) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for WindowsAutopilotDeploymentProfile
func (r *WindowsAutopilotDeploymentProfileRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// WindowsAutopilotDeploymentProfileAssignmentRequestBuilder is request builder for WindowsAutopilotDeploymentProfileAssignment
type WindowsAutopilotDeploymentProfileAssignmentRequestBuilder struct{ BaseRequestBuilder }

// Request returns WindowsAutopilotDeploymentProfileAssignmentRequest
func (b *WindowsAutopilotDeploymentProfileAssignmentRequestBuilder) Request() *WindowsAutopilotDeploymentProfileAssignmentRequest {
	return &WindowsAutopilotDeploymentProfileAssignmentRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// WindowsAutopilotDeploymentProfileAssignmentRequest is request for WindowsAutopilotDeploymentProfileAssignment
type WindowsAutopilotDeploymentProfileAssignmentRequest struct{ BaseRequest }

// Get performs GET request for WindowsAutopilotDeploymentProfileAssignment
func (r *WindowsAutopilotDeploymentProfileAssignmentRequest) Get(ctx context.Context) (resObj *WindowsAutopilotDeploymentProfileAssignment, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for WindowsAutopilotDeploymentProfileAssignment
func (r *WindowsAutopilotDeploymentProfileAssignmentRequest) Update(ctx context.Context, reqObj *WindowsAutopilotDeploymentProfileAssignment) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for WindowsAutopilotDeploymentProfileAssignment
func (r *WindowsAutopilotDeploymentProfileAssignmentRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// WindowsAutopilotDeviceIdentityRequestBuilder is request builder for WindowsAutopilotDeviceIdentity
type WindowsAutopilotDeviceIdentityRequestBuilder struct{ BaseRequestBuilder }

// Request returns WindowsAutopilotDeviceIdentityRequest
func (b *WindowsAutopilotDeviceIdentityRequestBuilder) Request() *WindowsAutopilotDeviceIdentityRequest {
	return &WindowsAutopilotDeviceIdentityRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// WindowsAutopilotDeviceIdentityRequest is request for WindowsAutopilotDeviceIdentity
type WindowsAutopilotDeviceIdentityRequest struct{ BaseRequest }

// Get performs GET request for WindowsAutopilotDeviceIdentity
func (r *WindowsAutopilotDeviceIdentityRequest) Get(ctx context.Context) (resObj *WindowsAutopilotDeviceIdentity, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for WindowsAutopilotDeviceIdentity
func (r *WindowsAutopilotDeviceIdentityRequest) Update(ctx context.Context, reqObj *WindowsAutopilotDeviceIdentity) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for WindowsAutopilotDeviceIdentity
func (r *WindowsAutopilotDeviceIdentityRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// WindowsAutopilotSettingsRequestBuilder is request builder for WindowsAutopilotSettings
type WindowsAutopilotSettingsRequestBuilder struct{ BaseRequestBuilder }

// Request returns WindowsAutopilotSettingsRequest
func (b *WindowsAutopilotSettingsRequestBuilder) Request() *WindowsAutopilotSettingsRequest {
	return &WindowsAutopilotSettingsRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// WindowsAutopilotSettingsRequest is request for WindowsAutopilotSettings
type WindowsAutopilotSettingsRequest struct{ BaseRequest }

// Get performs GET request for WindowsAutopilotSettings
func (r *WindowsAutopilotSettingsRequest) Get(ctx context.Context) (resObj *WindowsAutopilotSettings, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for WindowsAutopilotSettings
func (r *WindowsAutopilotSettingsRequest) Update(ctx context.Context, reqObj *WindowsAutopilotSettings) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for WindowsAutopilotSettings
func (r *WindowsAutopilotSettingsRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// WindowsCertificateProfileBaseRequestBuilder is request builder for WindowsCertificateProfileBase
type WindowsCertificateProfileBaseRequestBuilder struct{ BaseRequestBuilder }

// Request returns WindowsCertificateProfileBaseRequest
func (b *WindowsCertificateProfileBaseRequestBuilder) Request() *WindowsCertificateProfileBaseRequest {
	return &WindowsCertificateProfileBaseRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// WindowsCertificateProfileBaseRequest is request for WindowsCertificateProfileBase
type WindowsCertificateProfileBaseRequest struct{ BaseRequest }

// Get performs GET request for WindowsCertificateProfileBase
func (r *WindowsCertificateProfileBaseRequest) Get(ctx context.Context) (resObj *WindowsCertificateProfileBase, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for WindowsCertificateProfileBase
func (r *WindowsCertificateProfileBaseRequest) Update(ctx context.Context, reqObj *WindowsCertificateProfileBase) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for WindowsCertificateProfileBase
func (r *WindowsCertificateProfileBaseRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// WindowsDefenderApplicationControlSupplementalPolicyRequestBuilder is request builder for WindowsDefenderApplicationControlSupplementalPolicy
type WindowsDefenderApplicationControlSupplementalPolicyRequestBuilder struct{ BaseRequestBuilder }

// Request returns WindowsDefenderApplicationControlSupplementalPolicyRequest
func (b *WindowsDefenderApplicationControlSupplementalPolicyRequestBuilder) Request() *WindowsDefenderApplicationControlSupplementalPolicyRequest {
	return &WindowsDefenderApplicationControlSupplementalPolicyRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// WindowsDefenderApplicationControlSupplementalPolicyRequest is request for WindowsDefenderApplicationControlSupplementalPolicy
type WindowsDefenderApplicationControlSupplementalPolicyRequest struct{ BaseRequest }

// Get performs GET request for WindowsDefenderApplicationControlSupplementalPolicy
func (r *WindowsDefenderApplicationControlSupplementalPolicyRequest) Get(ctx context.Context) (resObj *WindowsDefenderApplicationControlSupplementalPolicy, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for WindowsDefenderApplicationControlSupplementalPolicy
func (r *WindowsDefenderApplicationControlSupplementalPolicyRequest) Update(ctx context.Context, reqObj *WindowsDefenderApplicationControlSupplementalPolicy) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for WindowsDefenderApplicationControlSupplementalPolicy
func (r *WindowsDefenderApplicationControlSupplementalPolicyRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// WindowsDefenderApplicationControlSupplementalPolicyAssignmentRequestBuilder is request builder for WindowsDefenderApplicationControlSupplementalPolicyAssignment
type WindowsDefenderApplicationControlSupplementalPolicyAssignmentRequestBuilder struct{ BaseRequestBuilder }

// Request returns WindowsDefenderApplicationControlSupplementalPolicyAssignmentRequest
func (b *WindowsDefenderApplicationControlSupplementalPolicyAssignmentRequestBuilder) Request() *WindowsDefenderApplicationControlSupplementalPolicyAssignmentRequest {
	return &WindowsDefenderApplicationControlSupplementalPolicyAssignmentRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// WindowsDefenderApplicationControlSupplementalPolicyAssignmentRequest is request for WindowsDefenderApplicationControlSupplementalPolicyAssignment
type WindowsDefenderApplicationControlSupplementalPolicyAssignmentRequest struct{ BaseRequest }

// Get performs GET request for WindowsDefenderApplicationControlSupplementalPolicyAssignment
func (r *WindowsDefenderApplicationControlSupplementalPolicyAssignmentRequest) Get(ctx context.Context) (resObj *WindowsDefenderApplicationControlSupplementalPolicyAssignment, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for WindowsDefenderApplicationControlSupplementalPolicyAssignment
func (r *WindowsDefenderApplicationControlSupplementalPolicyAssignmentRequest) Update(ctx context.Context, reqObj *WindowsDefenderApplicationControlSupplementalPolicyAssignment) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for WindowsDefenderApplicationControlSupplementalPolicyAssignment
func (r *WindowsDefenderApplicationControlSupplementalPolicyAssignmentRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatusRequestBuilder is request builder for WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus
type WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatusRequestBuilder struct{ BaseRequestBuilder }

// Request returns WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatusRequest
func (b *WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatusRequestBuilder) Request() *WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatusRequest {
	return &WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatusRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatusRequest is request for WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus
type WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatusRequest struct{ BaseRequest }

// Get performs GET request for WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus
func (r *WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatusRequest) Get(ctx context.Context) (resObj *WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus
func (r *WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatusRequest) Update(ctx context.Context, reqObj *WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatus
func (r *WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatusRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummaryRequestBuilder is request builder for WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummary
type WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummaryRequestBuilder struct{ BaseRequestBuilder }

// Request returns WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummaryRequest
func (b *WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummaryRequestBuilder) Request() *WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummaryRequest {
	return &WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummaryRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummaryRequest is request for WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummary
type WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummaryRequest struct{ BaseRequest }

// Get performs GET request for WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummary
func (r *WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummaryRequest) Get(ctx context.Context) (resObj *WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummary, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummary
func (r *WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummaryRequest) Update(ctx context.Context, reqObj *WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummary) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummary
func (r *WindowsDefenderApplicationControlSupplementalPolicyDeploymentSummaryRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// WindowsDeviceMalwareStateRequestBuilder is request builder for WindowsDeviceMalwareState
type WindowsDeviceMalwareStateRequestBuilder struct{ BaseRequestBuilder }

// Request returns WindowsDeviceMalwareStateRequest
func (b *WindowsDeviceMalwareStateRequestBuilder) Request() *WindowsDeviceMalwareStateRequest {
	return &WindowsDeviceMalwareStateRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// WindowsDeviceMalwareStateRequest is request for WindowsDeviceMalwareState
type WindowsDeviceMalwareStateRequest struct{ BaseRequest }

// Get performs GET request for WindowsDeviceMalwareState
func (r *WindowsDeviceMalwareStateRequest) Get(ctx context.Context) (resObj *WindowsDeviceMalwareState, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for WindowsDeviceMalwareState
func (r *WindowsDeviceMalwareStateRequest) Update(ctx context.Context, reqObj *WindowsDeviceMalwareState) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for WindowsDeviceMalwareState
func (r *WindowsDeviceMalwareStateRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// WindowsDomainJoinConfigurationRequestBuilder is request builder for WindowsDomainJoinConfiguration
type WindowsDomainJoinConfigurationRequestBuilder struct{ BaseRequestBuilder }

// Request returns WindowsDomainJoinConfigurationRequest
func (b *WindowsDomainJoinConfigurationRequestBuilder) Request() *WindowsDomainJoinConfigurationRequest {
	return &WindowsDomainJoinConfigurationRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// WindowsDomainJoinConfigurationRequest is request for WindowsDomainJoinConfiguration
type WindowsDomainJoinConfigurationRequest struct{ BaseRequest }

// Get performs GET request for WindowsDomainJoinConfiguration
func (r *WindowsDomainJoinConfigurationRequest) Get(ctx context.Context) (resObj *WindowsDomainJoinConfiguration, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for WindowsDomainJoinConfiguration
func (r *WindowsDomainJoinConfigurationRequest) Update(ctx context.Context, reqObj *WindowsDomainJoinConfiguration) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for WindowsDomainJoinConfiguration
func (r *WindowsDomainJoinConfigurationRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// WindowsFeatureUpdateProfileRequestBuilder is request builder for WindowsFeatureUpdateProfile
type WindowsFeatureUpdateProfileRequestBuilder struct{ BaseRequestBuilder }

// Request returns WindowsFeatureUpdateProfileRequest
func (b *WindowsFeatureUpdateProfileRequestBuilder) Request() *WindowsFeatureUpdateProfileRequest {
	return &WindowsFeatureUpdateProfileRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// WindowsFeatureUpdateProfileRequest is request for WindowsFeatureUpdateProfile
type WindowsFeatureUpdateProfileRequest struct{ BaseRequest }

// Get performs GET request for WindowsFeatureUpdateProfile
func (r *WindowsFeatureUpdateProfileRequest) Get(ctx context.Context) (resObj *WindowsFeatureUpdateProfile, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for WindowsFeatureUpdateProfile
func (r *WindowsFeatureUpdateProfileRequest) Update(ctx context.Context, reqObj *WindowsFeatureUpdateProfile) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for WindowsFeatureUpdateProfile
func (r *WindowsFeatureUpdateProfileRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// WindowsFeatureUpdateProfileAssignmentRequestBuilder is request builder for WindowsFeatureUpdateProfileAssignment
type WindowsFeatureUpdateProfileAssignmentRequestBuilder struct{ BaseRequestBuilder }

// Request returns WindowsFeatureUpdateProfileAssignmentRequest
func (b *WindowsFeatureUpdateProfileAssignmentRequestBuilder) Request() *WindowsFeatureUpdateProfileAssignmentRequest {
	return &WindowsFeatureUpdateProfileAssignmentRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// WindowsFeatureUpdateProfileAssignmentRequest is request for WindowsFeatureUpdateProfileAssignment
type WindowsFeatureUpdateProfileAssignmentRequest struct{ BaseRequest }

// Get performs GET request for WindowsFeatureUpdateProfileAssignment
func (r *WindowsFeatureUpdateProfileAssignmentRequest) Get(ctx context.Context) (resObj *WindowsFeatureUpdateProfileAssignment, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for WindowsFeatureUpdateProfileAssignment
func (r *WindowsFeatureUpdateProfileAssignmentRequest) Update(ctx context.Context, reqObj *WindowsFeatureUpdateProfileAssignment) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for WindowsFeatureUpdateProfileAssignment
func (r *WindowsFeatureUpdateProfileAssignmentRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// WindowsInformationProtectionRequestBuilder is request builder for WindowsInformationProtection
type WindowsInformationProtectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns WindowsInformationProtectionRequest
func (b *WindowsInformationProtectionRequestBuilder) Request() *WindowsInformationProtectionRequest {
	return &WindowsInformationProtectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// WindowsInformationProtectionRequest is request for WindowsInformationProtection
type WindowsInformationProtectionRequest struct{ BaseRequest }

// Get performs GET request for WindowsInformationProtection
func (r *WindowsInformationProtectionRequest) Get(ctx context.Context) (resObj *WindowsInformationProtection, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for WindowsInformationProtection
func (r *WindowsInformationProtectionRequest) Update(ctx context.Context, reqObj *WindowsInformationProtection) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for WindowsInformationProtection
func (r *WindowsInformationProtectionRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// WindowsInformationProtectionAppLearningSummaryRequestBuilder is request builder for WindowsInformationProtectionAppLearningSummary
type WindowsInformationProtectionAppLearningSummaryRequestBuilder struct{ BaseRequestBuilder }

// Request returns WindowsInformationProtectionAppLearningSummaryRequest
func (b *WindowsInformationProtectionAppLearningSummaryRequestBuilder) Request() *WindowsInformationProtectionAppLearningSummaryRequest {
	return &WindowsInformationProtectionAppLearningSummaryRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// WindowsInformationProtectionAppLearningSummaryRequest is request for WindowsInformationProtectionAppLearningSummary
type WindowsInformationProtectionAppLearningSummaryRequest struct{ BaseRequest }

// Get performs GET request for WindowsInformationProtectionAppLearningSummary
func (r *WindowsInformationProtectionAppLearningSummaryRequest) Get(ctx context.Context) (resObj *WindowsInformationProtectionAppLearningSummary, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for WindowsInformationProtectionAppLearningSummary
func (r *WindowsInformationProtectionAppLearningSummaryRequest) Update(ctx context.Context, reqObj *WindowsInformationProtectionAppLearningSummary) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for WindowsInformationProtectionAppLearningSummary
func (r *WindowsInformationProtectionAppLearningSummaryRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// WindowsInformationProtectionAppLockerFileRequestBuilder is request builder for WindowsInformationProtectionAppLockerFile
type WindowsInformationProtectionAppLockerFileRequestBuilder struct{ BaseRequestBuilder }

// Request returns WindowsInformationProtectionAppLockerFileRequest
func (b *WindowsInformationProtectionAppLockerFileRequestBuilder) Request() *WindowsInformationProtectionAppLockerFileRequest {
	return &WindowsInformationProtectionAppLockerFileRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// WindowsInformationProtectionAppLockerFileRequest is request for WindowsInformationProtectionAppLockerFile
type WindowsInformationProtectionAppLockerFileRequest struct{ BaseRequest }

// Get performs GET request for WindowsInformationProtectionAppLockerFile
func (r *WindowsInformationProtectionAppLockerFileRequest) Get(ctx context.Context) (resObj *WindowsInformationProtectionAppLockerFile, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for WindowsInformationProtectionAppLockerFile
func (r *WindowsInformationProtectionAppLockerFileRequest) Update(ctx context.Context, reqObj *WindowsInformationProtectionAppLockerFile) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for WindowsInformationProtectionAppLockerFile
func (r *WindowsInformationProtectionAppLockerFileRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// WindowsInformationProtectionDeviceRegistrationRequestBuilder is request builder for WindowsInformationProtectionDeviceRegistration
type WindowsInformationProtectionDeviceRegistrationRequestBuilder struct{ BaseRequestBuilder }

// Request returns WindowsInformationProtectionDeviceRegistrationRequest
func (b *WindowsInformationProtectionDeviceRegistrationRequestBuilder) Request() *WindowsInformationProtectionDeviceRegistrationRequest {
	return &WindowsInformationProtectionDeviceRegistrationRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// WindowsInformationProtectionDeviceRegistrationRequest is request for WindowsInformationProtectionDeviceRegistration
type WindowsInformationProtectionDeviceRegistrationRequest struct{ BaseRequest }

// Get performs GET request for WindowsInformationProtectionDeviceRegistration
func (r *WindowsInformationProtectionDeviceRegistrationRequest) Get(ctx context.Context) (resObj *WindowsInformationProtectionDeviceRegistration, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for WindowsInformationProtectionDeviceRegistration
func (r *WindowsInformationProtectionDeviceRegistrationRequest) Update(ctx context.Context, reqObj *WindowsInformationProtectionDeviceRegistration) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for WindowsInformationProtectionDeviceRegistration
func (r *WindowsInformationProtectionDeviceRegistrationRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// WindowsInformationProtectionNetworkLearningSummaryRequestBuilder is request builder for WindowsInformationProtectionNetworkLearningSummary
type WindowsInformationProtectionNetworkLearningSummaryRequestBuilder struct{ BaseRequestBuilder }

// Request returns WindowsInformationProtectionNetworkLearningSummaryRequest
func (b *WindowsInformationProtectionNetworkLearningSummaryRequestBuilder) Request() *WindowsInformationProtectionNetworkLearningSummaryRequest {
	return &WindowsInformationProtectionNetworkLearningSummaryRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// WindowsInformationProtectionNetworkLearningSummaryRequest is request for WindowsInformationProtectionNetworkLearningSummary
type WindowsInformationProtectionNetworkLearningSummaryRequest struct{ BaseRequest }

// Get performs GET request for WindowsInformationProtectionNetworkLearningSummary
func (r *WindowsInformationProtectionNetworkLearningSummaryRequest) Get(ctx context.Context) (resObj *WindowsInformationProtectionNetworkLearningSummary, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for WindowsInformationProtectionNetworkLearningSummary
func (r *WindowsInformationProtectionNetworkLearningSummaryRequest) Update(ctx context.Context, reqObj *WindowsInformationProtectionNetworkLearningSummary) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for WindowsInformationProtectionNetworkLearningSummary
func (r *WindowsInformationProtectionNetworkLearningSummaryRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// WindowsInformationProtectionPolicyRequestBuilder is request builder for WindowsInformationProtectionPolicy
type WindowsInformationProtectionPolicyRequestBuilder struct{ BaseRequestBuilder }

// Request returns WindowsInformationProtectionPolicyRequest
func (b *WindowsInformationProtectionPolicyRequestBuilder) Request() *WindowsInformationProtectionPolicyRequest {
	return &WindowsInformationProtectionPolicyRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// WindowsInformationProtectionPolicyRequest is request for WindowsInformationProtectionPolicy
type WindowsInformationProtectionPolicyRequest struct{ BaseRequest }

// Get performs GET request for WindowsInformationProtectionPolicy
func (r *WindowsInformationProtectionPolicyRequest) Get(ctx context.Context) (resObj *WindowsInformationProtectionPolicy, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for WindowsInformationProtectionPolicy
func (r *WindowsInformationProtectionPolicyRequest) Update(ctx context.Context, reqObj *WindowsInformationProtectionPolicy) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for WindowsInformationProtectionPolicy
func (r *WindowsInformationProtectionPolicyRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// WindowsInformationProtectionWipeActionRequestBuilder is request builder for WindowsInformationProtectionWipeAction
type WindowsInformationProtectionWipeActionRequestBuilder struct{ BaseRequestBuilder }

// Request returns WindowsInformationProtectionWipeActionRequest
func (b *WindowsInformationProtectionWipeActionRequestBuilder) Request() *WindowsInformationProtectionWipeActionRequest {
	return &WindowsInformationProtectionWipeActionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// WindowsInformationProtectionWipeActionRequest is request for WindowsInformationProtectionWipeAction
type WindowsInformationProtectionWipeActionRequest struct{ BaseRequest }

// Get performs GET request for WindowsInformationProtectionWipeAction
func (r *WindowsInformationProtectionWipeActionRequest) Get(ctx context.Context) (resObj *WindowsInformationProtectionWipeAction, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for WindowsInformationProtectionWipeAction
func (r *WindowsInformationProtectionWipeActionRequest) Update(ctx context.Context, reqObj *WindowsInformationProtectionWipeAction) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for WindowsInformationProtectionWipeAction
func (r *WindowsInformationProtectionWipeActionRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// WindowsMalwareInformationRequestBuilder is request builder for WindowsMalwareInformation
type WindowsMalwareInformationRequestBuilder struct{ BaseRequestBuilder }

// Request returns WindowsMalwareInformationRequest
func (b *WindowsMalwareInformationRequestBuilder) Request() *WindowsMalwareInformationRequest {
	return &WindowsMalwareInformationRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// WindowsMalwareInformationRequest is request for WindowsMalwareInformation
type WindowsMalwareInformationRequest struct{ BaseRequest }

// Get performs GET request for WindowsMalwareInformation
func (r *WindowsMalwareInformationRequest) Get(ctx context.Context) (resObj *WindowsMalwareInformation, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for WindowsMalwareInformation
func (r *WindowsMalwareInformationRequest) Update(ctx context.Context, reqObj *WindowsMalwareInformation) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for WindowsMalwareInformation
func (r *WindowsMalwareInformationRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// WindowsManagementAppRequestBuilder is request builder for WindowsManagementApp
type WindowsManagementAppRequestBuilder struct{ BaseRequestBuilder }

// Request returns WindowsManagementAppRequest
func (b *WindowsManagementAppRequestBuilder) Request() *WindowsManagementAppRequest {
	return &WindowsManagementAppRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// WindowsManagementAppRequest is request for WindowsManagementApp
type WindowsManagementAppRequest struct{ BaseRequest }

// Get performs GET request for WindowsManagementApp
func (r *WindowsManagementAppRequest) Get(ctx context.Context) (resObj *WindowsManagementApp, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for WindowsManagementApp
func (r *WindowsManagementAppRequest) Update(ctx context.Context, reqObj *WindowsManagementApp) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for WindowsManagementApp
func (r *WindowsManagementAppRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// WindowsManagementAppHealthStateRequestBuilder is request builder for WindowsManagementAppHealthState
type WindowsManagementAppHealthStateRequestBuilder struct{ BaseRequestBuilder }

// Request returns WindowsManagementAppHealthStateRequest
func (b *WindowsManagementAppHealthStateRequestBuilder) Request() *WindowsManagementAppHealthStateRequest {
	return &WindowsManagementAppHealthStateRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// WindowsManagementAppHealthStateRequest is request for WindowsManagementAppHealthState
type WindowsManagementAppHealthStateRequest struct{ BaseRequest }

// Get performs GET request for WindowsManagementAppHealthState
func (r *WindowsManagementAppHealthStateRequest) Get(ctx context.Context) (resObj *WindowsManagementAppHealthState, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for WindowsManagementAppHealthState
func (r *WindowsManagementAppHealthStateRequest) Update(ctx context.Context, reqObj *WindowsManagementAppHealthState) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for WindowsManagementAppHealthState
func (r *WindowsManagementAppHealthStateRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// WindowsPhone81CertificateProfileBaseRequestBuilder is request builder for WindowsPhone81CertificateProfileBase
type WindowsPhone81CertificateProfileBaseRequestBuilder struct{ BaseRequestBuilder }

// Request returns WindowsPhone81CertificateProfileBaseRequest
func (b *WindowsPhone81CertificateProfileBaseRequestBuilder) Request() *WindowsPhone81CertificateProfileBaseRequest {
	return &WindowsPhone81CertificateProfileBaseRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// WindowsPhone81CertificateProfileBaseRequest is request for WindowsPhone81CertificateProfileBase
type WindowsPhone81CertificateProfileBaseRequest struct{ BaseRequest }

// Get performs GET request for WindowsPhone81CertificateProfileBase
func (r *WindowsPhone81CertificateProfileBaseRequest) Get(ctx context.Context) (resObj *WindowsPhone81CertificateProfileBase, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for WindowsPhone81CertificateProfileBase
func (r *WindowsPhone81CertificateProfileBaseRequest) Update(ctx context.Context, reqObj *WindowsPhone81CertificateProfileBase) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for WindowsPhone81CertificateProfileBase
func (r *WindowsPhone81CertificateProfileBaseRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// WindowsPhone81ImportedPFXCertificateProfileRequestBuilder is request builder for WindowsPhone81ImportedPFXCertificateProfile
type WindowsPhone81ImportedPFXCertificateProfileRequestBuilder struct{ BaseRequestBuilder }

// Request returns WindowsPhone81ImportedPFXCertificateProfileRequest
func (b *WindowsPhone81ImportedPFXCertificateProfileRequestBuilder) Request() *WindowsPhone81ImportedPFXCertificateProfileRequest {
	return &WindowsPhone81ImportedPFXCertificateProfileRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// WindowsPhone81ImportedPFXCertificateProfileRequest is request for WindowsPhone81ImportedPFXCertificateProfile
type WindowsPhone81ImportedPFXCertificateProfileRequest struct{ BaseRequest }

// Get performs GET request for WindowsPhone81ImportedPFXCertificateProfile
func (r *WindowsPhone81ImportedPFXCertificateProfileRequest) Get(ctx context.Context) (resObj *WindowsPhone81ImportedPFXCertificateProfile, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for WindowsPhone81ImportedPFXCertificateProfile
func (r *WindowsPhone81ImportedPFXCertificateProfileRequest) Update(ctx context.Context, reqObj *WindowsPhone81ImportedPFXCertificateProfile) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for WindowsPhone81ImportedPFXCertificateProfile
func (r *WindowsPhone81ImportedPFXCertificateProfileRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// WindowsPhone81SCEPCertificateProfileRequestBuilder is request builder for WindowsPhone81SCEPCertificateProfile
type WindowsPhone81SCEPCertificateProfileRequestBuilder struct{ BaseRequestBuilder }

// Request returns WindowsPhone81SCEPCertificateProfileRequest
func (b *WindowsPhone81SCEPCertificateProfileRequestBuilder) Request() *WindowsPhone81SCEPCertificateProfileRequest {
	return &WindowsPhone81SCEPCertificateProfileRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// WindowsPhone81SCEPCertificateProfileRequest is request for WindowsPhone81SCEPCertificateProfile
type WindowsPhone81SCEPCertificateProfileRequest struct{ BaseRequest }

// Get performs GET request for WindowsPhone81SCEPCertificateProfile
func (r *WindowsPhone81SCEPCertificateProfileRequest) Get(ctx context.Context) (resObj *WindowsPhone81SCEPCertificateProfile, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for WindowsPhone81SCEPCertificateProfile
func (r *WindowsPhone81SCEPCertificateProfileRequest) Update(ctx context.Context, reqObj *WindowsPhone81SCEPCertificateProfile) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for WindowsPhone81SCEPCertificateProfile
func (r *WindowsPhone81SCEPCertificateProfileRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// WindowsPhone81TrustedRootCertificateRequestBuilder is request builder for WindowsPhone81TrustedRootCertificate
type WindowsPhone81TrustedRootCertificateRequestBuilder struct{ BaseRequestBuilder }

// Request returns WindowsPhone81TrustedRootCertificateRequest
func (b *WindowsPhone81TrustedRootCertificateRequestBuilder) Request() *WindowsPhone81TrustedRootCertificateRequest {
	return &WindowsPhone81TrustedRootCertificateRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// WindowsPhone81TrustedRootCertificateRequest is request for WindowsPhone81TrustedRootCertificate
type WindowsPhone81TrustedRootCertificateRequest struct{ BaseRequest }

// Get performs GET request for WindowsPhone81TrustedRootCertificate
func (r *WindowsPhone81TrustedRootCertificateRequest) Get(ctx context.Context) (resObj *WindowsPhone81TrustedRootCertificate, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for WindowsPhone81TrustedRootCertificate
func (r *WindowsPhone81TrustedRootCertificateRequest) Update(ctx context.Context, reqObj *WindowsPhone81TrustedRootCertificate) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for WindowsPhone81TrustedRootCertificate
func (r *WindowsPhone81TrustedRootCertificateRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// WindowsPhone81VpnConfigurationRequestBuilder is request builder for WindowsPhone81VpnConfiguration
type WindowsPhone81VpnConfigurationRequestBuilder struct{ BaseRequestBuilder }

// Request returns WindowsPhone81VpnConfigurationRequest
func (b *WindowsPhone81VpnConfigurationRequestBuilder) Request() *WindowsPhone81VpnConfigurationRequest {
	return &WindowsPhone81VpnConfigurationRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// WindowsPhone81VpnConfigurationRequest is request for WindowsPhone81VpnConfiguration
type WindowsPhone81VpnConfigurationRequest struct{ BaseRequest }

// Get performs GET request for WindowsPhone81VpnConfiguration
func (r *WindowsPhone81VpnConfigurationRequest) Get(ctx context.Context) (resObj *WindowsPhone81VpnConfiguration, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for WindowsPhone81VpnConfiguration
func (r *WindowsPhone81VpnConfigurationRequest) Update(ctx context.Context, reqObj *WindowsPhone81VpnConfiguration) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for WindowsPhone81VpnConfiguration
func (r *WindowsPhone81VpnConfigurationRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// WindowsPrivacyDataAccessControlItemRequestBuilder is request builder for WindowsPrivacyDataAccessControlItem
type WindowsPrivacyDataAccessControlItemRequestBuilder struct{ BaseRequestBuilder }

// Request returns WindowsPrivacyDataAccessControlItemRequest
func (b *WindowsPrivacyDataAccessControlItemRequestBuilder) Request() *WindowsPrivacyDataAccessControlItemRequest {
	return &WindowsPrivacyDataAccessControlItemRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// WindowsPrivacyDataAccessControlItemRequest is request for WindowsPrivacyDataAccessControlItem
type WindowsPrivacyDataAccessControlItemRequest struct{ BaseRequest }

// Get performs GET request for WindowsPrivacyDataAccessControlItem
func (r *WindowsPrivacyDataAccessControlItemRequest) Get(ctx context.Context) (resObj *WindowsPrivacyDataAccessControlItem, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for WindowsPrivacyDataAccessControlItem
func (r *WindowsPrivacyDataAccessControlItemRequest) Update(ctx context.Context, reqObj *WindowsPrivacyDataAccessControlItem) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for WindowsPrivacyDataAccessControlItem
func (r *WindowsPrivacyDataAccessControlItemRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// WindowsProtectionStateRequestBuilder is request builder for WindowsProtectionState
type WindowsProtectionStateRequestBuilder struct{ BaseRequestBuilder }

// Request returns WindowsProtectionStateRequest
func (b *WindowsProtectionStateRequestBuilder) Request() *WindowsProtectionStateRequest {
	return &WindowsProtectionStateRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// WindowsProtectionStateRequest is request for WindowsProtectionState
type WindowsProtectionStateRequest struct{ BaseRequest }

// Get performs GET request for WindowsProtectionState
func (r *WindowsProtectionStateRequest) Get(ctx context.Context) (resObj *WindowsProtectionState, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for WindowsProtectionState
func (r *WindowsProtectionStateRequest) Update(ctx context.Context, reqObj *WindowsProtectionState) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for WindowsProtectionState
func (r *WindowsProtectionStateRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// WindowsUniversalAppXRequestBuilder is request builder for WindowsUniversalAppX
type WindowsUniversalAppXRequestBuilder struct{ BaseRequestBuilder }

// Request returns WindowsUniversalAppXRequest
func (b *WindowsUniversalAppXRequestBuilder) Request() *WindowsUniversalAppXRequest {
	return &WindowsUniversalAppXRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// WindowsUniversalAppXRequest is request for WindowsUniversalAppX
type WindowsUniversalAppXRequest struct{ BaseRequest }

// Get performs GET request for WindowsUniversalAppX
func (r *WindowsUniversalAppXRequest) Get(ctx context.Context) (resObj *WindowsUniversalAppX, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for WindowsUniversalAppX
func (r *WindowsUniversalAppXRequest) Update(ctx context.Context, reqObj *WindowsUniversalAppX) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for WindowsUniversalAppX
func (r *WindowsUniversalAppXRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// WindowsUpdateForBusinessConfigurationRequestBuilder is request builder for WindowsUpdateForBusinessConfiguration
type WindowsUpdateForBusinessConfigurationRequestBuilder struct{ BaseRequestBuilder }

// Request returns WindowsUpdateForBusinessConfigurationRequest
func (b *WindowsUpdateForBusinessConfigurationRequestBuilder) Request() *WindowsUpdateForBusinessConfigurationRequest {
	return &WindowsUpdateForBusinessConfigurationRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// WindowsUpdateForBusinessConfigurationRequest is request for WindowsUpdateForBusinessConfiguration
type WindowsUpdateForBusinessConfigurationRequest struct{ BaseRequest }

// Get performs GET request for WindowsUpdateForBusinessConfiguration
func (r *WindowsUpdateForBusinessConfigurationRequest) Get(ctx context.Context) (resObj *WindowsUpdateForBusinessConfiguration, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for WindowsUpdateForBusinessConfiguration
func (r *WindowsUpdateForBusinessConfigurationRequest) Update(ctx context.Context, reqObj *WindowsUpdateForBusinessConfiguration) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for WindowsUpdateForBusinessConfiguration
func (r *WindowsUpdateForBusinessConfigurationRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// WindowsUpdateStateRequestBuilder is request builder for WindowsUpdateState
type WindowsUpdateStateRequestBuilder struct{ BaseRequestBuilder }

// Request returns WindowsUpdateStateRequest
func (b *WindowsUpdateStateRequestBuilder) Request() *WindowsUpdateStateRequest {
	return &WindowsUpdateStateRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// WindowsUpdateStateRequest is request for WindowsUpdateState
type WindowsUpdateStateRequest struct{ BaseRequest }

// Get performs GET request for WindowsUpdateState
func (r *WindowsUpdateStateRequest) Get(ctx context.Context) (resObj *WindowsUpdateState, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for WindowsUpdateState
func (r *WindowsUpdateStateRequest) Update(ctx context.Context, reqObj *WindowsUpdateState) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for WindowsUpdateState
func (r *WindowsUpdateStateRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

// WindowsWiFiEnterpriseEAPConfigurationRequestBuilder is request builder for WindowsWiFiEnterpriseEAPConfiguration
type WindowsWiFiEnterpriseEAPConfigurationRequestBuilder struct{ BaseRequestBuilder }

// Request returns WindowsWiFiEnterpriseEAPConfigurationRequest
func (b *WindowsWiFiEnterpriseEAPConfigurationRequestBuilder) Request() *WindowsWiFiEnterpriseEAPConfigurationRequest {
	return &WindowsWiFiEnterpriseEAPConfigurationRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// WindowsWiFiEnterpriseEAPConfigurationRequest is request for WindowsWiFiEnterpriseEAPConfiguration
type WindowsWiFiEnterpriseEAPConfigurationRequest struct{ BaseRequest }

// Get performs GET request for WindowsWiFiEnterpriseEAPConfiguration
func (r *WindowsWiFiEnterpriseEAPConfigurationRequest) Get(ctx context.Context) (resObj *WindowsWiFiEnterpriseEAPConfiguration, err error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	err = r.JSONRequest(ctx, "GET", query, nil, &resObj)
	return
}

// Update performs PATCH request for WindowsWiFiEnterpriseEAPConfiguration
func (r *WindowsWiFiEnterpriseEAPConfigurationRequest) Update(ctx context.Context, reqObj *WindowsWiFiEnterpriseEAPConfiguration) error {
	return r.JSONRequest(ctx, "PATCH", "", reqObj, nil)
}

// Delete performs DELETE request for WindowsWiFiEnterpriseEAPConfiguration
func (r *WindowsWiFiEnterpriseEAPConfigurationRequest) Delete(ctx context.Context) error {
	return r.JSONRequest(ctx, "DELETE", "", nil, nil)
}

//
type WindowsAutopilotDeploymentProfileCollectionHasPayloadLinksRequestBuilder struct{ BaseRequestBuilder }

// HasPayloadLinks action undocumented
func (b *DeviceManagementWindowsAutopilotDeploymentProfilesCollectionRequestBuilder) HasPayloadLinks(reqObj *WindowsAutopilotDeploymentProfileCollectionHasPayloadLinksRequestParameter) *WindowsAutopilotDeploymentProfileCollectionHasPayloadLinksRequestBuilder {
	bb := &WindowsAutopilotDeploymentProfileCollectionHasPayloadLinksRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/hasPayloadLinks"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type WindowsAutopilotDeploymentProfileCollectionHasPayloadLinksRequest struct{ BaseRequest }

//
func (b *WindowsAutopilotDeploymentProfileCollectionHasPayloadLinksRequestBuilder) Request() *WindowsAutopilotDeploymentProfileCollectionHasPayloadLinksRequest {
	return &WindowsAutopilotDeploymentProfileCollectionHasPayloadLinksRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *WindowsAutopilotDeploymentProfileCollectionHasPayloadLinksRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]HasPayloadLinkResultItem, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []HasPayloadLinkResultItem
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []HasPayloadLinkResultItem
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

//
func (r *WindowsAutopilotDeploymentProfileCollectionHasPayloadLinksRequest) PostN(ctx context.Context, n int) ([]HasPayloadLinkResultItem, error) {
	return r.Paging(ctx, "POST", "", r.requestObject, n)
}

//
func (r *WindowsAutopilotDeploymentProfileCollectionHasPayloadLinksRequest) Post(ctx context.Context) ([]HasPayloadLinkResultItem, error) {
	return r.Paging(ctx, "POST", "", r.requestObject, 0)
}

//
type WindowsAutopilotDeploymentProfileAssignRequestBuilder struct{ BaseRequestBuilder }

// Assign action undocumented
func (b *WindowsAutopilotDeploymentProfileRequestBuilder) Assign(reqObj *WindowsAutopilotDeploymentProfileAssignRequestParameter) *WindowsAutopilotDeploymentProfileAssignRequestBuilder {
	bb := &WindowsAutopilotDeploymentProfileAssignRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/assign"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type WindowsAutopilotDeploymentProfileAssignRequest struct{ BaseRequest }

//
func (b *WindowsAutopilotDeploymentProfileAssignRequestBuilder) Request() *WindowsAutopilotDeploymentProfileAssignRequest {
	return &WindowsAutopilotDeploymentProfileAssignRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *WindowsAutopilotDeploymentProfileAssignRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type WindowsAutopilotDeviceIdentityAssignUserToDeviceRequestBuilder struct{ BaseRequestBuilder }

// AssignUserToDevice action undocumented
func (b *WindowsAutopilotDeviceIdentityRequestBuilder) AssignUserToDevice(reqObj *WindowsAutopilotDeviceIdentityAssignUserToDeviceRequestParameter) *WindowsAutopilotDeviceIdentityAssignUserToDeviceRequestBuilder {
	bb := &WindowsAutopilotDeviceIdentityAssignUserToDeviceRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/assignUserToDevice"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type WindowsAutopilotDeviceIdentityAssignUserToDeviceRequest struct{ BaseRequest }

//
func (b *WindowsAutopilotDeviceIdentityAssignUserToDeviceRequestBuilder) Request() *WindowsAutopilotDeviceIdentityAssignUserToDeviceRequest {
	return &WindowsAutopilotDeviceIdentityAssignUserToDeviceRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *WindowsAutopilotDeviceIdentityAssignUserToDeviceRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type WindowsAutopilotDeviceIdentityUnassignUserFromDeviceRequestBuilder struct{ BaseRequestBuilder }

// UnassignUserFromDevice action undocumented
func (b *WindowsAutopilotDeviceIdentityRequestBuilder) UnassignUserFromDevice(reqObj *WindowsAutopilotDeviceIdentityUnassignUserFromDeviceRequestParameter) *WindowsAutopilotDeviceIdentityUnassignUserFromDeviceRequestBuilder {
	bb := &WindowsAutopilotDeviceIdentityUnassignUserFromDeviceRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/unassignUserFromDevice"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type WindowsAutopilotDeviceIdentityUnassignUserFromDeviceRequest struct{ BaseRequest }

//
func (b *WindowsAutopilotDeviceIdentityUnassignUserFromDeviceRequestBuilder) Request() *WindowsAutopilotDeviceIdentityUnassignUserFromDeviceRequest {
	return &WindowsAutopilotDeviceIdentityUnassignUserFromDeviceRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *WindowsAutopilotDeviceIdentityUnassignUserFromDeviceRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type WindowsAutopilotDeviceIdentityUpdateDevicePropertiesRequestBuilder struct{ BaseRequestBuilder }

// UpdateDeviceProperties action undocumented
func (b *WindowsAutopilotDeviceIdentityRequestBuilder) UpdateDeviceProperties(reqObj *WindowsAutopilotDeviceIdentityUpdateDevicePropertiesRequestParameter) *WindowsAutopilotDeviceIdentityUpdateDevicePropertiesRequestBuilder {
	bb := &WindowsAutopilotDeviceIdentityUpdateDevicePropertiesRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/updateDeviceProperties"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type WindowsAutopilotDeviceIdentityUpdateDevicePropertiesRequest struct{ BaseRequest }

//
func (b *WindowsAutopilotDeviceIdentityUpdateDevicePropertiesRequestBuilder) Request() *WindowsAutopilotDeviceIdentityUpdateDevicePropertiesRequest {
	return &WindowsAutopilotDeviceIdentityUpdateDevicePropertiesRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *WindowsAutopilotDeviceIdentityUpdateDevicePropertiesRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type WindowsAutopilotDeviceIdentityAssignResourceAccountToDeviceRequestBuilder struct{ BaseRequestBuilder }

// AssignResourceAccountToDevice action undocumented
func (b *WindowsAutopilotDeviceIdentityRequestBuilder) AssignResourceAccountToDevice(reqObj *WindowsAutopilotDeviceIdentityAssignResourceAccountToDeviceRequestParameter) *WindowsAutopilotDeviceIdentityAssignResourceAccountToDeviceRequestBuilder {
	bb := &WindowsAutopilotDeviceIdentityAssignResourceAccountToDeviceRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/assignResourceAccountToDevice"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type WindowsAutopilotDeviceIdentityAssignResourceAccountToDeviceRequest struct{ BaseRequest }

//
func (b *WindowsAutopilotDeviceIdentityAssignResourceAccountToDeviceRequestBuilder) Request() *WindowsAutopilotDeviceIdentityAssignResourceAccountToDeviceRequest {
	return &WindowsAutopilotDeviceIdentityAssignResourceAccountToDeviceRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *WindowsAutopilotDeviceIdentityAssignResourceAccountToDeviceRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type WindowsAutopilotDeviceIdentityUnassignResourceAccountFromDeviceRequestBuilder struct{ BaseRequestBuilder }

// UnassignResourceAccountFromDevice action undocumented
func (b *WindowsAutopilotDeviceIdentityRequestBuilder) UnassignResourceAccountFromDevice(reqObj *WindowsAutopilotDeviceIdentityUnassignResourceAccountFromDeviceRequestParameter) *WindowsAutopilotDeviceIdentityUnassignResourceAccountFromDeviceRequestBuilder {
	bb := &WindowsAutopilotDeviceIdentityUnassignResourceAccountFromDeviceRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/unassignResourceAccountFromDevice"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type WindowsAutopilotDeviceIdentityUnassignResourceAccountFromDeviceRequest struct{ BaseRequest }

//
func (b *WindowsAutopilotDeviceIdentityUnassignResourceAccountFromDeviceRequestBuilder) Request() *WindowsAutopilotDeviceIdentityUnassignResourceAccountFromDeviceRequest {
	return &WindowsAutopilotDeviceIdentityUnassignResourceAccountFromDeviceRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *WindowsAutopilotDeviceIdentityUnassignResourceAccountFromDeviceRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type WindowsAutopilotSettingsSyncRequestBuilder struct{ BaseRequestBuilder }

// Sync action undocumented
func (b *WindowsAutopilotSettingsRequestBuilder) Sync(reqObj *WindowsAutopilotSettingsSyncRequestParameter) *WindowsAutopilotSettingsSyncRequestBuilder {
	bb := &WindowsAutopilotSettingsSyncRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/sync"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type WindowsAutopilotSettingsSyncRequest struct{ BaseRequest }

//
func (b *WindowsAutopilotSettingsSyncRequestBuilder) Request() *WindowsAutopilotSettingsSyncRequest {
	return &WindowsAutopilotSettingsSyncRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *WindowsAutopilotSettingsSyncRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type WindowsDefenderApplicationControlSupplementalPolicyAssignRequestBuilder struct{ BaseRequestBuilder }

// Assign action undocumented
func (b *WindowsDefenderApplicationControlSupplementalPolicyRequestBuilder) Assign(reqObj *WindowsDefenderApplicationControlSupplementalPolicyAssignRequestParameter) *WindowsDefenderApplicationControlSupplementalPolicyAssignRequestBuilder {
	bb := &WindowsDefenderApplicationControlSupplementalPolicyAssignRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/assign"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type WindowsDefenderApplicationControlSupplementalPolicyAssignRequest struct{ BaseRequest }

//
func (b *WindowsDefenderApplicationControlSupplementalPolicyAssignRequestBuilder) Request() *WindowsDefenderApplicationControlSupplementalPolicyAssignRequest {
	return &WindowsDefenderApplicationControlSupplementalPolicyAssignRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *WindowsDefenderApplicationControlSupplementalPolicyAssignRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type WindowsFeatureUpdateProfileAssignRequestBuilder struct{ BaseRequestBuilder }

// Assign action undocumented
func (b *WindowsFeatureUpdateProfileRequestBuilder) Assign(reqObj *WindowsFeatureUpdateProfileAssignRequestParameter) *WindowsFeatureUpdateProfileAssignRequestBuilder {
	bb := &WindowsFeatureUpdateProfileAssignRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/assign"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type WindowsFeatureUpdateProfileAssignRequest struct{ BaseRequest }

//
func (b *WindowsFeatureUpdateProfileAssignRequestBuilder) Request() *WindowsFeatureUpdateProfileAssignRequest {
	return &WindowsFeatureUpdateProfileAssignRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *WindowsFeatureUpdateProfileAssignRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type WindowsInformationProtectionAssignRequestBuilder struct{ BaseRequestBuilder }

// Assign action undocumented
func (b *WindowsInformationProtectionRequestBuilder) Assign(reqObj *WindowsInformationProtectionAssignRequestParameter) *WindowsInformationProtectionAssignRequestBuilder {
	bb := &WindowsInformationProtectionAssignRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/assign"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type WindowsInformationProtectionAssignRequest struct{ BaseRequest }

//
func (b *WindowsInformationProtectionAssignRequestBuilder) Request() *WindowsInformationProtectionAssignRequest {
	return &WindowsInformationProtectionAssignRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *WindowsInformationProtectionAssignRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type WindowsInformationProtectionDeviceRegistrationWipeRequestBuilder struct{ BaseRequestBuilder }

// Wipe action undocumented
func (b *WindowsInformationProtectionDeviceRegistrationRequestBuilder) Wipe(reqObj *WindowsInformationProtectionDeviceRegistrationWipeRequestParameter) *WindowsInformationProtectionDeviceRegistrationWipeRequestBuilder {
	bb := &WindowsInformationProtectionDeviceRegistrationWipeRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/wipe"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type WindowsInformationProtectionDeviceRegistrationWipeRequest struct{ BaseRequest }

//
func (b *WindowsInformationProtectionDeviceRegistrationWipeRequestBuilder) Request() *WindowsInformationProtectionDeviceRegistrationWipeRequest {
	return &WindowsInformationProtectionDeviceRegistrationWipeRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *WindowsInformationProtectionDeviceRegistrationWipeRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type WindowsUpdateForBusinessConfigurationExtendFeatureUpdatesPauseRequestBuilder struct{ BaseRequestBuilder }

// ExtendFeatureUpdatesPause action undocumented
func (b *WindowsUpdateForBusinessConfigurationRequestBuilder) ExtendFeatureUpdatesPause(reqObj *WindowsUpdateForBusinessConfigurationExtendFeatureUpdatesPauseRequestParameter) *WindowsUpdateForBusinessConfigurationExtendFeatureUpdatesPauseRequestBuilder {
	bb := &WindowsUpdateForBusinessConfigurationExtendFeatureUpdatesPauseRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/extendFeatureUpdatesPause"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type WindowsUpdateForBusinessConfigurationExtendFeatureUpdatesPauseRequest struct{ BaseRequest }

//
func (b *WindowsUpdateForBusinessConfigurationExtendFeatureUpdatesPauseRequestBuilder) Request() *WindowsUpdateForBusinessConfigurationExtendFeatureUpdatesPauseRequest {
	return &WindowsUpdateForBusinessConfigurationExtendFeatureUpdatesPauseRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *WindowsUpdateForBusinessConfigurationExtendFeatureUpdatesPauseRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}

//
type WindowsUpdateForBusinessConfigurationExtendQualityUpdatesPauseRequestBuilder struct{ BaseRequestBuilder }

// ExtendQualityUpdatesPause action undocumented
func (b *WindowsUpdateForBusinessConfigurationRequestBuilder) ExtendQualityUpdatesPause(reqObj *WindowsUpdateForBusinessConfigurationExtendQualityUpdatesPauseRequestParameter) *WindowsUpdateForBusinessConfigurationExtendQualityUpdatesPauseRequestBuilder {
	bb := &WindowsUpdateForBusinessConfigurationExtendQualityUpdatesPauseRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.BaseRequestBuilder.baseURL += "/extendQualityUpdatesPause"
	bb.BaseRequestBuilder.requestObject = reqObj
	return bb
}

//
type WindowsUpdateForBusinessConfigurationExtendQualityUpdatesPauseRequest struct{ BaseRequest }

//
func (b *WindowsUpdateForBusinessConfigurationExtendQualityUpdatesPauseRequestBuilder) Request() *WindowsUpdateForBusinessConfigurationExtendQualityUpdatesPauseRequest {
	return &WindowsUpdateForBusinessConfigurationExtendQualityUpdatesPauseRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client, requestObject: b.requestObject},
	}
}

//
func (r *WindowsUpdateForBusinessConfigurationExtendQualityUpdatesPauseRequest) Post(ctx context.Context) error {
	return r.JSONRequest(ctx, "POST", "", r.requestObject, nil)
}
