// Code generated by msgraph.go/gen DO NOT EDIT.

package msgraph

import (
	"context"
	"fmt"
	"io/ioutil"
	"net/http"

	"github.com/yaegashi/msgraph.go/jsonx"
)

// Rooms returns request builder for Room collection
func (b *RoomListRequestBuilder) Rooms() *RoomListRoomsCollectionRequestBuilder {
	bb := &RoomListRoomsCollectionRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/rooms"
	return bb
}

// RoomListRoomsCollectionRequestBuilder is request builder for Room collection
type RoomListRoomsCollectionRequestBuilder struct{ BaseRequestBuilder }

// Request returns request for Room collection
func (b *RoomListRoomsCollectionRequestBuilder) Request() *RoomListRoomsCollectionRequest {
	return &RoomListRoomsCollectionRequest{
		BaseRequest: BaseRequest{baseURL: b.baseURL, client: b.client},
	}
}

// ID returns request builder for Room item
func (b *RoomListRoomsCollectionRequestBuilder) ID(id string) *RoomRequestBuilder {
	bb := &RoomRequestBuilder{BaseRequestBuilder: b.BaseRequestBuilder}
	bb.baseURL += "/" + id
	return bb
}

// RoomListRoomsCollectionRequest is request for Room collection
type RoomListRoomsCollectionRequest struct{ BaseRequest }

// Paging perfoms paging operation for Room collection
func (r *RoomListRoomsCollectionRequest) Paging(ctx context.Context, method, path string, obj interface{}, n int) ([]Room, error) {
	req, err := r.NewJSONRequest(method, path, obj)
	if err != nil {
		return nil, err
	}
	if ctx != nil {
		req = req.WithContext(ctx)
	}
	res, err := r.client.Do(req)
	if err != nil {
		return nil, err
	}
	var values []Room
	for {
		if res.StatusCode != http.StatusOK {
			b, _ := ioutil.ReadAll(res.Body)
			res.Body.Close()
			errRes := &ErrorResponse{Response: res}
			err := jsonx.Unmarshal(b, errRes)
			if err != nil {
				return nil, fmt.Errorf("%s: %s", res.Status, string(b))
			}
			return nil, errRes
		}
		var (
			paging Paging
			value  []Room
		)
		err := jsonx.NewDecoder(res.Body).Decode(&paging)
		res.Body.Close()
		if err != nil {
			return nil, err
		}
		err = jsonx.Unmarshal(paging.Value, &value)
		if err != nil {
			return nil, err
		}
		values = append(values, value...)
		if n >= 0 {
			n--
		}
		if n == 0 || len(paging.NextLink) == 0 {
			return values, nil
		}
		req, err = http.NewRequest("GET", paging.NextLink, nil)
		if ctx != nil {
			req = req.WithContext(ctx)
		}
		res, err = r.client.Do(req)
		if err != nil {
			return nil, err
		}
	}
}

// GetN performs GET request for Room collection, max N pages
func (r *RoomListRoomsCollectionRequest) GetN(ctx context.Context, n int) ([]Room, error) {
	var query string
	if r.query != nil {
		query = "?" + r.query.Encode()
	}
	return r.Paging(ctx, "GET", query, nil, n)
}

// Get performs GET request for Room collection
func (r *RoomListRoomsCollectionRequest) Get(ctx context.Context) ([]Room, error) {
	return r.GetN(ctx, 0)
}

// Add performs POST request for Room collection
func (r *RoomListRoomsCollectionRequest) Add(ctx context.Context, reqObj *Room) (resObj *Room, err error) {
	err = r.JSONRequest(ctx, "POST", "", reqObj, &resObj)
	return
}
