# Amazon S3

storage.blob.s3 module stores messages bodies in a bucket on S3-compatible storage.

```
storage.blob.s3 {
    endpoint play.min.io
    secure yes
    access_key "Q3AM3UQ867SPQQA43P2F"
    secret_key "zuf+tfteSlswRu7BJ86wekitnifILbZam1KYY3TG"
    bucket maddy-test

    # optional
    region eu-central-1
    object_prefix maddy/
    creds access_key
}
```

Example:

```
storage.imapsql local_mailboxes {
    ...
    msg_store s3 {
        endpoint s3.amazonaws.com
        access_key "..."
        secret_key "..."
        bucket maddy-messages
        region us-west-2
        creds access_key
    }
}
```

## Configuration directives

### endpoint _address:port_

**Required**.

Root S3 endpoint. e.g. `s3.amazonaws.com`

---

### secure _boolean_
Default: `yes`

Whether TLS should be used.

---

### access_key _string_<br>secret_key _string_

**Required**.

Static S3 credentials.

---

### bucket _name_

**Required**.

S3 bucket name. The bucket must exist and
be read-writable.

---

### region _string_
Default: not set

S3 bucket location. May be called "endpoint" in some manuals.

---

### object_prefix _string_
Default: empty string

String to add to all keys stored by maddy.

Can be useful when S3 is used as a file system.

---

### creds `access_key` | `file_minio` | `file_aws` | `iam`
Default: `access_key`

Credentials to use for accessing the S3 Bucket.

Credential Types:

 - `access_key`: use AWS access key and secret access key 
 - `file_minio`: use credentials for Minio present at ~/.mc/config.json
 - `file_aws`: use credentials for AWS S3 present at ~/.aws/credentials
 - `iam`: use AWS IAM instance profile for credentials.

By default, access_key is used with the access key and secret access key present in the config.
