# Global configuration directives

These directives can be specified outside of any 
configuration blocks and they are applied to all modules.

Some directives can be overridden on per-module basis (e.g. hostname).

**Syntax**: state\_dir _path_ <br>
**Default**: /var/lib/maddy

The path to the state directory. This directory will be used to store all
persistent data and should be writable.

**Syntax**: runtime\_dir _path_ <br>
**Default**: /run/maddy

The path to the runtime directory. Used for Unix sockets and other temporary
objects. Should be writable.

**Syntax**: hostname _domain_ <br>
**Default**: not specified

Internet hostname of this mail server. Typicall FQDN is used. It is recommended
to make sure domain specified here resolved to the public IP of the server.

**Syntax**: autogenerated\_msg\_domain _domain_ <br>
**Default**: not specified

Domain that is used in From field for auto-generated messages (such as Delivery
Status Notifications).

**Syntax**: <br>
tls file _cert\_file_ _pkey\_file_ <br>
tls _module reference_ <br>
tls off <br>
**Default**: not specified

Default TLS certificate to use for all endpoints.

Must be present in either all endpoint modules configuration blocks or as
global directive.

You can also specify other configuration options such as cipher suites and TLS
version. See maddy-tls(5) for details. maddy uses reasonable
cipher suites and TLS versions by default so you generally don't have to worry
about it.

**Syntax**: tls\_client { ... } <br>
**Default**: not specified

This is optional block that specifies various TLS-related options to use when
making outbound connections. See TLS client configuration for details on
directives that can be used in it. maddy uses reasonable cipher suites and TLS
versions by default so you generally don't have to worry about it.

**Syntax**: <br>
log _targets..._ <br>
log off <br>
**Default**: stderr

Write log to one of more "targets".

The target can be one or the following:

- stderr

  Write logs to stderr.

- stderr\_ts

  Write logs to stderr with timestamps.

- syslog

  Send logs to the local syslog daemon.

- _file path_

  Write (append) logs to file.

Example:
```
log syslog /var/log/maddy.log
```

**Note:** Maddy does not perform log files rotation, this is the job of the
logrotate daemon. Send SIGUSR1 to maddy process to make it reopen log files.

**Syntax**: debug _boolean_ <br>
**Default**: no

Enable verbose logging for all modules. You don't need that unless you are
reporting a bug.

