# Lima examples

⭐ = ["Tier 1"](#tier-1)

Default: [`default.yaml`](./default.yaml) (⭐Ubuntu, with containerd/nerdctl)

Distro:
- [`almalinux.yaml`](./almalinux.yaml): AlmaLinux
- [`alpine.yaml`](./alpine.yaml): ⭐Alpine Linux
- [`archlinux.yaml`](./archlinux.yaml): ⭐Arch Linux
- centos.yaml: ~~CentOS Linux 8~~ ([EOL](https://www.centos.org/centos-linux-eol/))
- [`centos-stream.yaml`](./centos-stream.yaml): CentOS Stream 8
- [`debian.yaml`](./debian.yaml): ⭐Debian GNU/Linux
- [`fedora.yaml`](./fedora.yaml): ⭐Fedora
- [`opensuse.yaml`](./opensuse.yaml): ⭐openSUSE Leap
- [`oraclelinux.yaml`](./oraclelinux.yaml): Oracle Linux
- [`rocky.yaml`](./rocky.yaml): Rocky Linux
- [`ubuntu.yaml`](./ubuntu.yaml): Ubuntu (same as `default.yaml` but without extra YAML lines)
- [`ubuntu-lts.yaml`](./ubuntu-lts.yaml): Ubuntu LTS (same as `ubuntu.yaml` but pinned to an LTS version)

Container engines:
- [`docker.yaml`](./docker.yaml): Docker
- [`podman.yaml`](./podman.yaml): Podman
- [`singularity.yaml`](./singularity.yaml): Singularity
- LXD is installed in the default Ubuntu template, so there is no `lxd.yaml`

Container image builders:
- [`buildkit.yaml`](./buildkit.yaml): BuildKit

Container orchestration:
- [`k3s.yaml`](./k3s.yaml): Kubernetes via k3s
- [`k8s.yaml`](./k8s.yaml): Kubernetes via kubeadm
- [`nomad.yaml`](./nomad.yaml): Nomad
- [`faasd.yaml`](./faasd.yaml): [Faasd](https://docs.openfaas.com/deployment/faasd/)

Others:
- [`vmnet.yaml`](./vmnet.yaml): ⭐enable [`vmnet.framework`](../docs/network.md)
- [`deprecated/centos-7.yaml`](./deprecated/centos-7.yaml): [deprecated] CentOS Linux 7
- [`experimental/almalinux-9.yaml`](experimental/almalinux-9.yaml): [experimental] AlmaLinux 9
- [`experimental/centos-stream-9.yaml`](experimental/centos-stream-9.yaml): [experimental] CentOS Stream 9
- [`experimental/9p.yaml`](experimental/9p.yaml): [experimental] use 9p mount type
- [`experimental/riscv64.yaml`](experimental/riscv64.yaml): [experimental] RISC-V
- [`experimental/apptainer.yaml`](./experimental/apptainer.yaml): [experimental] [Apptainer](https://apptainer.org/)

## Tier 1

The "Tier 1" yamls (marked with ⭐) are regularly tested on the CI.

Other yamls are tested only occasionally and manually.

## Usage
Run `limactl start fedora.yaml` to create a Lima instance named "fedora".

To open a shell, run `limactl shell fedora bash` or `LIMA_INSTANCE=fedora lima bash`.
