---
title: "Sonic"
date: 2019-03-03T16:39:46+01:00
draft: false
slug: sonic
dnsprovider:
  since:    "v4.4.0"
  code:     "sonic"
  url:      "https://www.sonic.com/"
---

<!-- THIS DOCUMENTATION IS AUTO-GENERATED. PLEASE DO NOT EDIT. -->
<!-- providers/dns/sonic/sonic.toml -->
<!-- THIS DOCUMENTATION IS AUTO-GENERATED. PLEASE DO NOT EDIT. -->


Configuration for [Sonic](https://www.sonic.com/).


<!--more-->

- Code: `sonic`
- Since: v4.4.0


Here is an example bash command using the Sonic provider:

```bash
SONIC_USER_ID=12345 \
SONIC_API_KEY=4d6fbf2f9ab0fa11697470918d37625851fc0c51 \
lego --email you@example.com --dns sonic --domains my.example.org run
```




## Credentials

| Environment Variable Name | Description |
|-----------------------|-------------|
| `SONIC_API_KEY` | API Key |
| `SONIC_USER_ID` | User ID |

The environment variable names can be suffixed by `_FILE` to reference a file instead of a value.
More information [here]({{% ref "dns#configuration-and-credentials" %}}).


## Additional Configuration

| Environment Variable Name | Description |
|--------------------------------|-------------|
| `SONIC_HTTP_TIMEOUT` | API request timeout |
| `SONIC_POLLING_INTERVAL` | Time between DNS propagation check |
| `SONIC_PROPAGATION_TIMEOUT` | Maximum waiting time for DNS propagation |
| `SONIC_SEQUENCE_INTERVAL` | Time between sequential requests |
| `SONIC_TTL` | The TTL of the TXT record used for the DNS challenge |

The environment variable names can be suffixed by `_FILE` to reference a file instead of a value.
More information [here]({{% ref "dns#configuration-and-credentials" %}}).

## API keys

The API keys must be generated by calling the `dyndns/api_key` endpoint.

Example:

```bash
$ curl -X POST -H "Content-Type: application/json" --data '{"username":"notarealuser","password":"notarealpassword","hostname":"example.com"}' https://public-api.sonic.net/dyndns/api_key
{"userid":"12345","apikey":"4d6fbf2f9ab0fa11697470918d37625851fc0c51","result":200,"message":"OK"}
```

See https://public-api.sonic.net/dyndns/#requesting_an_api_key for additional details.

This `userid` and `apikey` combo allow modifications to any DNS entries connected to the managed domain (hostname).

Hostname should be the toplevel domain managed e.g. `example.com` not `www.example.com`.



## More information

- [API documentation](https://public-api.sonic.net/dyndns/)

<!-- THIS DOCUMENTATION IS AUTO-GENERATED. PLEASE DO NOT EDIT. -->
<!-- providers/dns/sonic/sonic.toml -->
<!-- THIS DOCUMENTATION IS AUTO-GENERATED. PLEASE DO NOT EDIT. -->
