package i18n

const chineseIntroPopupMessage = `
感谢您使用lazygit!与您分享的三件事:

 1) 如果您想了解lazygit的功能，请观看此视频:
      https://youtu.be/CPLdltN7wgE

 2) 请务必阅读最新的发行说明，网址为：:
      https://github.com/jesseduffield/lazygit/releases

 3) 如果您使用的是git，那将使您成为一名程序员! 在您的帮助下，我们可以使
    lazygit更好, 因此，请考虑成为一名贡献者并加入
      https://github.com/jesseduffield/lazygit
    您也可以赞助我，并通过单击捐赠告诉我要做什么。
    右下角的按钮.
    甚至只是给回购交易代码加注星标，我们离20k星就不远了!
`

func chineseTranslationSet() TranslationSet {
	return TranslationSet{
		NotEnoughSpace:                      "没有足够的空间来渲染面板",
		DiffTitle:                           "差异",
		LogTitle:                            "日志",
		FilesTitle:                          "文件",
		BranchesTitle:                       "分支",
		CommitsTitle:                        "提交",
		StashTitle:                          "封存隐藏(Stash)",
		UnstagedChanges:                     `未暂存(Unstaged)更改`,
		StagedChanges:                       `已暂存(Staged)更改`,
		PatchBuildingMainTitle:              `将 行/块 添加到补丁`,
		MergingMainTitle:                    "解决合并冲突",
		MainTitle:                           "主要",
		StagingTitle:                        "正在暂存",
		MergingTitle:                        "合并中",
		NormalTitle:                         "正常",
		CommitMessage:                       "提交信息",
		CredentialsUsername:                 "用户名",
		CredentialsPassword:                 "密码",
		CredentialsPassphrase:               "输入SSH密钥的密码",
		PassUnameWrong:                      "密码, 密码 和/或 用户名错误",
		CommitChanges:                       "提交更改",
		AmendLastCommit:                     "修改最后一次提交",
		SureToAmend:                         "您确定要修改上一次提交吗？之后，您可以从提交面板更改提交消息.",
		NoCommitToAmend:                     "没有提交的修改.",
		CommitChangesWithEditor:             "使用git编辑器提交更改",
		StatusTitle:                         "状态",
		LcNavigate:                          "导航",
		LcMenu:                              "菜单",
		LcExecute:                           "执行",
		LcOpen:                              "打开",
		LcIgnore:                            "忽略",
		LcDelete:                            "删除",
		LcToggleStaged:                      "切换已暂存(staged)",
		LcToggleStagedAll:                   "暂存(stage)/未暂存(unstage)全部",
		LcToggleTreeView:                    "切换文件树视图",
		LcOpenMergeTool:                     "打开外部合并工具 (git mergetool)",
		LcRefresh:                           "刷新",
		LcPush:                              "推送(push)",
		LcPull:                              "拉取(pull)",
		LcEdit:                              "编辑",
		LcScroll:                            "滚动",
		LcAbortMerge:                        "中止合并",
		LcResolveMergeConflicts:             "解决合并冲突",
		MergeConflictsTitle:                 "合并冲突",
		LcCheckout:                          "签出(checkout)",
		NoChangedFiles:                      "没有更改的文件",
		FileHasNoUnstagedChanges:            "文件没有要添加的未暂存更改",
		CannotGitAdd:                        "无法 git add --patch 未跟踪的文件",
		NoFilesDisplay:                      "没有文件可显示",
		NotAFile:                            "不是文件",
		PullWait:                            "拉取中...",
		PushWait:                            "推送中...",
		FetchWait:                           "正在取得...",
		FileNoMergeCons:                     "该文件没有内联合并冲突",
		LcSoftReset:                         "软复位",
		SureTo:                              "你确定要 {{.deleteVerb}} {{.fileName}} (你会丢失你的更改)?",
		AlreadyCheckedOutBranch:             "您已经签出了这个分支",
		SureForceCheckout:                   "您确定要强制签出吗? 您将丢失所有本地更改",
		ForceCheckoutBranch:                 "强制签出分支",
		BranchName:                          "分支名称",
		NewBranchNameBranchOff:              "新分支名称 (分支不属于 {{.branchName}})",
		CantDeleteCheckOutBranch:            "您不能删除已签出的分支!",
		DeleteBranch:                        "删除分支",
		DeleteBranchMessage:                 "您确定要删除分支 {{.selectedBranchName}}?",
		ForceDeleteBranchMessage:            "{{.selectedBranchName}} 没有完全合并. 你确定你要删除它?",
		LcRebaseBranch:                      "将已签出的分支重新部署到该分支",
		CantRebaseOntoSelf:                  "您不能将分支建立在其自身之上",
		CantMergeBranchIntoItself:           "您不能将分支合并到自身中",
		LcForceCheckout:                     "强制签出",
		LcMerge:                             "合并",
		LcCheckoutByName:                    "按名称签出",
		LcNewBranch:                         "新分支",
		LcDeleteBranch:                      "删除分支",
		LcForceDeleteBranch:                 "删除分支 (强制)",
		NoBranchesThisRepo:                  "此仓库没有分支",
		NoTrackingThisBranch:                "该分支没有跟踪",
		CommitMessageConfirm:                "{{.keyBindClose}}: 关闭, {{.keyBindNewLine}}: 新行, {{.keyBindConfirm}}: 确认",
		CommitWithoutMessageErr:             "没有提交消息就无法提交",
		CloseConfirm:                        "{{.keyBindClose}}: 关闭, {{.keyBindConfirm}}: 确认",
		LcClose:                             "关闭",
		LcQuit:                              "退出",
		SureResetThisCommit:                 "您确定要重置为此提交吗?",
		ResetToCommit:                       "重置以提交",
		LcSquashDown:                        "向下聚合(squash down)",
		LcRename:                            "重命名",
		LcResetToThisCommit:                 "重置为此提交",
		LcFixupCommit:                       "修正提交",
		NoCommitsThisBranch:                 "该分支没有提交",
		OnlySquashTopmostCommit:             "只能压缩最高提交",
		YouNoCommitsToSquash:                "您没有提交来压缩",
		CantFixupWhileUnstagedChanges:       "当有未暂存的更改时无法修正",
		Fixup:                               "修正",
		SureFixupThisCommit:                 "您确定要'修复'此提交吗？? 它将合并到下面的提交中",
		SureSquashThisCommit:                "您确定要将这个提交压缩到下面的提交中吗?",
		Squash:                              "压缩",
		LcPickCommit:                        "选择提交 (mid-rebase时)",
		LcRevertCommit:                      "还原提交",
		OnlyRenameTopCommit:                 "只能从lazygit内部重写最高的提交。请使用shift-R",
		LcRenameCommit:                      "改写提交",
		LcDeleteCommit:                      "删除提交",
		LcMoveDownCommit:                    "下移提交",
		LcMoveUpCommit:                      "上移提交",
		LcEditCommit:                        "编辑提交",
		LcAmendToCommit:                     "用staged的修改来修改提交",
		LcRenameCommitEditor:                "使用编辑器重命名提交",
		PotentialErrInGetselectedCommit:     "获取选定提交中的潜在错误 (ui和状态不匹配)",
		Error:                               "错误",
		RunningSubprocess:                   "正在运行的子进程",
		LcSelectHunk:                        "选择块",
		LcNavigateConflicts:                 "解决冲突",
		LcPickHunk:                          "选择块",
		LcPickBothHunks:                     "pick both hunks",
		LcUndo:                              "撤销",
		LcUndoReflog:                        "撤销 (via reflog) (实验性)",
		LcRedoReflog:                        "重做 (via reflog) (实验性)",
		LcPop:                               "pop",
		LcDrop:                              "删除",
		LcApply:                             "恢复",
		NoStashEntries:                      "没有封存隐藏(stach)的条目",
		StashDrop:                           "Stash删除",
		SureDropStashEntry:                  "您确定要删除此隐藏(stach)条目?",
		StashPop:                            "Stash pop(恢复)",
		SurePopStashEntry:                   "您确定要弹出此隐藏条stash目吗？",
		StashApply:                          "Stash apply(恢复)",
		SureApplyStashEntry:                 "您确定要应用此隐藏stash条目?",
		NoStashTo:                           "没有stash到 {{.method}}",
		NoTrackedStagedFilesStash:           "您没有要存储的跟踪/暂存文件到stash",
		StashChanges:                        "Stash更改",
		IssntListOfViews:                    "{{.name}} 不在视图列表中",
		LcNewFocusedViewIs:                  "新的焦点视图是 {{.newFocusedView}}",
		MergeAborted:                        "合并中止",
		OpenConfig:                          "打开配置文件",
		EditConfig:                          "编辑配置文件",
		ForcePush:                           "强制推送",
		ForcePushPrompt:                     "您的分支已与远程分支不同. 按 'esc' 取消, 或 'enter' 强制推送.",
		ForcePushDisabled:                   "您的分支已与远程分支不同并且你已经禁用了强行推送",
		UpdatesRejectedAndForcePushDisabled: "更新被拒绝，您已禁用强制推送",
		LcCheckForUpdate:                    "检查更新",
		CheckingForUpdates:                  "检查更新...",
		OnLatestVersionErr:                  "您已经有最新版本",
		MajorVersionErr:                     "新版本 ({{.newVersion}}) 与当前版本相比，具有向后兼容的更改 ({{.currentVersion}})",
		CouldNotFindBinaryErr:               "在{{.url}处找不到任何二进制文件}",
		AnonymousReportingTitle:             "帮助改善lazygit",
		AnonymousReportingPrompt:            "您是否想启用匿名报告数据以帮助改善lazygit? (enter/esc)",
		MergeToolTitle:                      "合并工具",
		MergeToolPrompt:                     "确定要打开 `git mergetool` 吗?",
		IntroPopupMessage:                   chineseIntroPopupMessage,
		GitconfigParseErr:                   `由于存在未加引号的'\'字符，因此Gogit无法解析您的gitconfig文件。删除这些应该可以解决问题.`,
		LcEditFile:                          `编辑文件`,
		LcOpenFile:                          `打开文件`,
		LcIgnoreFile:                        `添加到 .gitignore`,
		LcRefreshFiles:                      `刷新文件`,
		LcMergeIntoCurrentBranch:            `合并到当前签出的分支`,
		ConfirmQuit:                         `你确定你要退出吗?`,
		SwitchRepo:                          `切换到最近的仓库`,
		LcAllBranchesLogGraph:               `显示所有分支日志`,
		UnsupportedGitService:               `不支持的git服务`,
		LcCreatePullRequest:                 `创建pull请求`,
		LcCopyPullRequestURL:                `将拉取请求URL复制到剪贴板`,
		NoBranchOnRemote:                    `该分支在远程上不存在。您需要先将其推送到远程.`,
		LcFetch:                             `fetch`,
		NoAutomaticGitFetchTitle:            `没有自动git fetch`,
		NoAutomaticGitFetchBody:             `Lazygit不能在私人仓库中使用"git fetch"; 在文件面板中使用'f'手动运行"git fetch"`,
		FileEnter:                           `暂存单个 块/行 用于文件, 或 折叠/展开 目录`,
		FileStagingRequirements:             `只能暂存跟踪文件的单独行`,
		SelectHunk:                          `选择块`,
		StageSelection:                      `切换行 已暂存/未暂存`,
		ResetSelection:                      `删除变更 (git reset)`,
		ToggleDragSelect:                    `切换拖动选择`,
		ToggleSelectHunk:                    `切换选择块`,
		ToggleSelectionForPatch:             `添加/移除 行到patch`,
		TogglePanel:                         `切换到其他面板`,
		CantStageStaged:                     `您无法上演已经上演的变更!`,
		ReturnToFilesPanel:                  `返回文件面板`,
		CantFindHunks:                       `在此补丁中找不到任何块`,
		CantFindHunk:                        `找不到块`,
		FastForward:                         `从上游快速前进此分支`,
		Fetching:                            "抓取和快进{{.from}} -> {{.to}} ...",
		FoundConflicts:                      "冲突！要中止，请按 'esc', 否则按'enter'",
		FoundConflictsTitle:                 "自动合并失败",
		Undo:                                "撤销",
		PickHunk:                            "pick hunk",
		PickBothHunks:                       "pick both hunks",
		ViewMergeRebaseOptions:              "查看 合并/变基 选项",
		NotMergingOrRebasing:                "您目前既不进行基础调整也不进行合并",
		RecentRepos:                         "最近的仓库",
		MergeOptionsTitle:                   "合并选项",
		RebaseOptionsTitle:                  "变基选项",
		CommitMessageTitle:                  "提交讯息",
		LocalBranchesTitle:                  "分支标签",
		SearchTitle:                         "搜索",
		TagsTitle:                           "Tags Tab",
		BranchCommitsTitle:                  "提交标签",
		MenuTitle:                           "菜单",
		RemotesTitle:                        "远程标签",
		CredentialsTitle:                    "证书",
		RemoteBranchesTitle:                 "远程分支 (在远程选项卡中)",
		PatchBuildingTitle:                  "补丁构建中",
		InformationTitle:                    "信息",
		SecondaryTitle:                      "次要",
		ReflogCommitsTitle:                  "Reflog标签",
		Title:                               "标题",
		GlobalTitle:                         "全局键绑定",
		ConflictsResolved:                   "解决所有合并冲突。继续？",
		RebasingTitle:                       "变基",
		ConfirmRebase:                       "您确定要重新设定基准 {{.checkedOutBranch}} onto {{.selectedBranch}} 吗?",
		ConfirmMerge:                        "您确定要合并 {{.selectedBranch}} into {{.checkedOutBranch}} 吗?",
		FwdNoUpstream:                       "无法快进没有上游的分支",
		FwdCommitsToPush:                    "无法快进并提交推送的分支",
		ErrorOccurred:                       "发生错误! 请在以下位置创建问题",
		NoRoom:                              "没有足够的空间",
		YouAreHere:                          "你在这里",
		LcRewordNotSupported:                "当前不支持交互式重新基准化时的重新措词提交",
		LcCherryPickCopy:                    "复制提交 (cherry-pick)",
		LcCherryPickCopyRange:               "复制提交范围 (cherry-pick)",
		LcPasteCommits:                      "粘贴提交 (cherry-pick)",
		SureCherryPick:                      "您确定要对复制的提交进行cherry-pick吗?",
		CherryPick:                          "Cherry-Pick",
		CannotRebaseOntoFirstCommit:         "您不能以交互方式基于第一次提交",
		CannotSquashOntoSecondCommit:        "您不能 聚合(squash)/修正(fixup)第二个提交",
		Donate:                              "捐助",
		AskQuestion:                         "问题咨询",
		PrevLine:                            "选择上一行",
		NextLine:                            "选择下一行",
		PrevHunk:                            "选择上一个块",
		NextHunk:                            "选择下一个块",
		PrevConflict:                        "选择上一个冲突",
		NextConflict:                        "选择下一个冲突",
		SelectTop:                           "选择顶部块",
		SelectBottom:                        "选择底部块",
		ScrollDown:                          "向下滚动",
		ScrollUp:                            "向上滚动",
		LcScrollUpMainPanel:                 "向上滚动主面板",
		LcScrollDownMainPanel:               "向下滚动主面板",
		AmendCommitTitle:                    "修改提交",
		AmendCommitPrompt:                   "您确定要使用暂存文件来修改此提交吗?",
		DeleteCommitTitle:                   "删除提交",
		DeleteCommitPrompt:                  "您确定要删除此提交吗?",
		SquashingStatus:                     "正在聚合(squashing)",
		FixingStatus:                        "fixing up",
		DeletingStatus:                      "正在删除",
		MovingStatus:                        "正在移动",
		RebasingStatus:                      "变基",
		AmendingStatus:                      "修改",
		CherryPickingStatus:                 "cherry-picking",
		UndoingStatus:                       "正在撤销",
		RedoingStatus:                       "正在重做",
		CheckingOutStatus:                   "签出",
		CommittingStatus:                    "正在提交",
		CommitFiles:                         "提交文件",
		LcViewCommitFiles:                   "查看提交的文件",
		CommitFilesTitle:                    "提交文件",
		LcGoBack:                            "返回",
		NoCommiteFiles:                      "没有用于该提交的文件",
		LcCheckoutCommitFile:                "签出文件",
		LcDiscardOldFileChange:              "放弃对此文件的提交更改",
		DiscardFileChangesTitle:             "放弃文件更改",
		DiscardFileChangesPrompt:            "您确定要舍弃此提交对该文件的更改吗？? 如果此文件是在此提交中创建的，它将被删除",
		DisabledForGPG:                      "该功能不适用于使用GPG的用户",
		CreateRepo:                          "不在git仓库中. 创建一个新的git仓库吗? (y/n): ",
		AutoStashTitle:                      "自动存储?",
		AutoStashPrompt:                     "您必须隐藏并弹出更改以使更改生效。自动执行? (enter/esc)",
		StashPrefix:                         "自动隐藏更改 ",
		LcViewDiscardOptions:                "查看'放弃更改‘选项",
		LcCancel:                            "取消",
		LcDiscardAllChanges:                 "放弃所有更改",
		LcDiscardUnstagedChanges:            "放弃未进行的变更",
		LcDiscardAllChangesToAllFiles:       "nuke 工作树",
		LcDiscardAnyUnstagedChanges:         "放弃未进行的变更",
		LcDiscardUntrackedFiles:             "丢弃未跟踪的文件",
		LcHardReset:                         "硬重置",
		LcHardResetUpstream:                 "硬重置到上游分支",
		LcViewResetOptions:                  `查看重置选项`,
		LcCreateFixupCommit:                 `为此提交创建fixup提交`,
		LcSquashAboveCommits:                `聚合所有的'fixup!'高于所选提交的提交 (自动聚合)`,
		SquashAboveCommits:                  `聚合所有的'fixup!'高于所选提交的提交 (自动聚合)`,
		SureSquashAboveCommits:              `您确定要聚合所有修正程序吗! 在{{.commit}}上面提交吗?`,
		CreateFixupCommit:                   `创建修正提交`,
		SureCreateFixupCommit:               `您确定要创建修正程序吗! 提交{{.commit}}?`,
		LcExecuteCustomCommand:              "执行自定义命令",
		CustomCommand:                       "自定义命令:",
		LcCommitChangesWithoutHook:          "提交更改而无需预先提交钩子",
		SkipHookPrefixNotConfigured:         "您尚未配置用于跳过钩子的提交消息前缀. 在您的配置中设置`git.skipHookPrefix ='WIP'`",
		LcResetTo:                           `重置为`,
		PressEnterToReturn:                  "按Enter键返回lazygit",
		LcViewStashOptions:                  "查看隐藏选项",
		LcStashAllChanges:                   "stash更改",
		LcStashStagedChanges:                "stash的staged更改",
		LcStashOptions:                      "Stash选项",
		NotARepository:                      "错误: 必须在git仓库中运行",
		LcJump:                              "跳到面板",
		DiscardPatch:                        "丢弃补丁",
		DiscardPatchConfirm:                 "您一次只能通过一个commit/stash-entry构建补丁. 放弃当前补丁吗?",
		CantPatchWhileRebasingError:         "处于合并或变基状态时，您无法构建修补程序或运行修补程序命令",
		LcToggleAddToPatch:                  "补丁中包含的切换文件",
		ViewPatchOptions:                    "查看自定义补丁选项",
		PatchOptionsTitle:                   "补丁选项",
		NoPatchError:                        "尚未创建补丁. 开始构建补丁, 在提交文件上使用'空格‘或输入以添加特定行",
		LcEnterFile:                         "输入文件以将所选行添加到补丁中(或切换目录折叠)",
		ExitLineByLineMode:                  `退出逐行模式`,
		EnterUpstream:                       `输入上游作为 '<remote> <branchname>'`,
		EnterUpstreamWithSlash:              `输入上游作为 '<remote>/<branchname>'`,
		LcNotTrackingRemote:                 "(不跟踪任何远程)",
		ReturnToRemotesList:                 `返回远程列表`,
		LcAddNewRemote:                      `添加新的远程`,
		LcNewRemoteName:                     `新的远程名称:`,
		LcNewRemoteUrl:                      `新的远程URL:`,
		LcEditRemoteName:                    `输入{{.remoteName}}更新远程名称:`,
		LcEditRemoteUrl:                     `输入{{.remoteName}}更新远程URL:`,
		LcRemoveRemote:                      `删除远程`,
		LcRemoveRemotePrompt:                "您确定要删除远程",
		DeleteRemoteBranch:                  "删除远程分支",
		DeleteRemoteBranchMessage:           "确定要删除远程分支",
		LcSetUpstream:                       "设置为检出分支的上游",
		SetUpstreamTitle:                    "设置上游分支",
		SetUpstreamMessage:                  "您确定要将'{{.checkedOut}}‘的上游分支设置为'{{.selected}}'吗？",
		LcEditRemote:                        "编辑远程",
		LcTagCommit:                         "标签提交",
		TagNameTitle:                        "标签名:",
		LcDeleteTag:                         "删除标签",
		DeleteTagTitle:                      "删除标签",
		DeleteTagPrompt:                     "您确定要删除标签'{{.tagName}}'吗?",
		PushTagTitle:                        "远程将标签'{{.tagName}}'推送到:",
		LcPushTag:                           "推送标签",
		LcCreateTag:                         "创建标签",
		CreateTagTitle:                      "标签名:",
		LcFetchRemote:                       "获取远程",
		FetchingRemoteStatus:                "获取远程",
		LcCheckoutCommit:                    "签出提交",
		SureCheckoutThisCommit:              "您确定要签出此提交吗？?",
		LcGitFlowOptions:                    "显示git-flow选项",
		NotAGitFlowBranch:                   "这似乎不是git flow分支",
		NewGitFlowBranchPrompt:              "新的{{.branchType}}名称:",
		IgnoreTracked:                       "忽略跟踪文件",
		IgnoreTrackedPrompt:                 "您确定要忽略跟踪的文件吗？",
		LcViewResetToUpstreamOptions:        "查看上游重置选项",
		LcNextScreenMode:                    "下一屏模式（正常/半屏/全屏）",
		LcPrevScreenMode:                    "上一屏模式",
		LcStartSearch:                       "开始搜索",
		Panel:                               "面板",
		Keybindings:                         "键绑定",
		LcRenameBranch:                      "重命名分支",
		NewBranchNamePrompt:                 "输入分支的新分支名称",
		RenameBranchWarning:                 "该分支正在跟踪远程服务器。此操作将仅重命名本地分支名称，而不重命名远程分支的名称。继续？",
		LcOpenMenu:                          "打开菜单",
		LcCloseMenu:                         "关闭菜单",
		LcResetCherryPick:                   "重置 cherry-picked(复制)提交选择",
		LcNextTab:                           "下一个标签",
		LcPrevTab:                           "上一个标签",
		LcCantUndoWhileRebasing:             "进行基础调整时无法撤消",
		LcCantRedoWhileRebasing:             "变基时无法重做",
		MustStashWarning:                    "将补丁拉出到索引中需要存储和取消存储所做的更改。如果出现问题，您将可以从存储中访问文件。继续？",
		MustStashTitle:                      "必须stash",
		ConfirmationTitle:                   "确认面板",
		LcPrevPage:                          "上一页",
		LcNextPage:                          "下一页",
		LcGotoTop:                           "滚动到顶部",
		LcGotoBottom:                        "滚动到底部",
		LcFilteringBy:                       "过滤依据",
		ResetInParentheses:                  "(重置)",
		LcOpenFilteringMenu:                 "查看按路径过滤选项",
		LcFilterBy:                          "过滤",
		LcExitFilterMode:                    "停止按路径过滤",
		LcFilterPathOption:                  "输入要过滤的路径",
		LcEnterFileName:                     "输入路径:",
		FilteringMenuTitle:                  "正在过滤",
		MustExitFilterModeTitle:             "命令不可用",
		MustExitFilterModePrompt:            "命令在过滤模式下不可用。退出过滤模式？",
		LcDiff:                              "差异(diff)",
		LcEnterRefToDiff:                    "输入ref到diff",
		LcEnteRefName:                       "输入ref:",
		LcExitDiffMode:                      "退出差异模式",
		DiffingMenuTitle:                    "差异化",
		LcSwapDiff:                          "反向差异方向",
		LcOpenDiffingMenu:                   "打开差异菜单",
		// the actual view is the extras view which I intend to give more tabs in future but for now we'll only mention the command log part
		LcOpenExtrasMenu:                    "打开命令日志菜单",
		LcShowingGitDiff:                    "显示输出:",
		LcCopyCommitShaToClipboard:          "将提交SHA复制到剪贴板",
		LcCopyCommitMessageToClipboard:      "将提交消息复制到剪贴板",
		LcCopyBranchNameToClipboard:         "将分支名称复制到剪贴板",
		LcCopyFileNameToClipboard:           "将文件名复制到剪贴板",
		LcCopyCommitFileNameToClipboard:     "将提交的文件名复制到剪贴板",
		LcCommitPrefixPatternError:          "提交前缀模式错误",
		NoFilesStagedTitle:                  "没有暂存文件",
		NoFilesStagedPrompt:                 "您尚未暂存任何文件。提交所有文件？",
		BranchNotFoundTitle:                 "找不到分支",
		BranchNotFoundPrompt:                "找不到分支。创建一个新分支命名为",
		UnstageLinesTitle:                   "Unstage行",
		UnstageLinesPrompt:                  "您确定要删除所选的行(git reset)吗？这是不可逆的。\n要禁用此对话框，请将'gui.skipUnstageLineWarning'的配置键设置为true",
		LcCreateNewBranchFromCommit:         "从提交创建新分支",
		LcViewStashFiles:                    "查看stash条目的文件",
		LcBuildingPatch:                     "构建补丁",
		LcViewCommits:                       "查看提交",
		MinGitVersionError:                  "Git版本必须至少为2.0(即从2014年开始)。请升级您的git版本。或者在https://github.com/jesseduffield/lazygit/issues上提出一个问题,以使lazygit更加向后兼容。",
		LcRunningCustomCommandStatus:        "运行自定义命令",
		LcSubmoduleStashAndReset:            "存放未提交的子模块更改和更新",
		LcAndResetSubmodules:                "和重置子模块",
		LcEnterSubmodule:                    "输入子模块",
		LcCopySubmoduleNameToClipboard:      "将子模块名称复制到剪贴板",
		RemoveSubmodule:                     "删除子模块",
		LcRemoveSubmodule:                   "删除子模块",
		RemoveSubmodulePrompt:               "您确定要删除子模块'%s'及其对应的目录吗？这是不可逆的。",
		LcResettingSubmoduleStatus:          "重置子模块",
		LcNewSubmoduleName:                  "新的子模块名称:",
		LcNewSubmoduleUrl:                   "新的子模块网址:",
		LcNewSubmodulePath:                  "新的子模块路径:",
		LcAddSubmodule:                      "添加新的子模块",
		LcAddingSubmoduleStatus:             "添加子模块",
		LcUpdateSubmoduleUrl:                "更新子模块'%s'的URL",
		LcUpdatingSubmoduleUrlStatus:        "更新URL",
		LcEditSubmoduleUrl:                  "更新子模块URL",
		LcInitializingSubmoduleStatus:       "初始化子模块",
		LcInitSubmodule:                     "初始化子模块",
		LcViewResetAndRemoveOptions:         "查看重置和删除子模块选项",
		LcSubmoduleUpdate:                   "更新子模块",
		LcUpdatingSubmoduleStatus:           "更新子模块",
		LcBulkInitSubmodules:                "批量初始化子模块",
		LcBulkUpdateSubmodules:              "批量更新子模块",
		LcBulkDeinitSubmodules:              "批量deinit子模块",
		LcViewBulkSubmoduleOptions:          "查看批量子模块选项",
		LcBulkSubmoduleOptions:              "批量子模块选项",
		LcRunningCommand:                    "运行命令",
		SubCommitsTitle:                     "子提交",
		SubmodulesTitle:                     "子模块",
		NavigationTitle:                     "列表面板导航",
		SuggestionsTitle:                    "意见建议",
		PushingTagStatus:                    "推送标签",
		PullRequestURLCopiedToClipboard:     "拉取请求网址已复制到剪贴板",
		CommitMessageCopiedToClipboard:      "提交消息复制到剪贴板",
		LcCopiedToClipboard:                 "复制到剪贴板",
		ErrCannotEditDirectory:              "无法编辑目录:您只能编辑单个文件",
		ErrStageDirWithInlineMergeConflicts: "无法 暂存/取消暂存 包含具有内联合并冲突的文件的目录。请先解决合并冲突",
		ErrRepositoryMovedOrDeleted:         "找不到仓库。它可能已被移动或删除¯\\ _（ツ）_ /¯ ¯\\_(ツ)_/¯",
		CommandLog:                          "命令日志",
		ToggleShowCommandLog:                "切换 显示/隐藏 命令日志",
		FocusCommandLog:                     "焦点命令日志",
		CommandLogHeader:                    "您可以通过按'%s'隐藏或集中显示该面板，或使用 `gui.showCommandLog: false`\n将其永久隐藏在您的配置中",
		RandomTip:                           "随机提示",
		Spans: Spans{
			// TODO: combine this with the original keybinding descriptions (those are all in lowercase atm)
			CheckoutCommit:                    "检出提交",
			CheckoutReflogCommit:              "检出reflog提交",
			CheckoutTag:                       "检出标签",
			CheckoutBranch:                    "检出分支",
			ForceCheckoutBranch:               "强制检出分支",
			DeleteBranch:                      "删除分支",
			Merge:                             "合并",
			RebaseBranch:                      "变基分支",
			RenameBranch:                      "重命名分支",
			CreateBranch:                      "建立分支",
			CherryPick:                        "(Cherry-pick) 粘贴提交",
			CheckoutFile:                      "检出文件",
			DiscardOldFileChange:              "放弃旧文件更改",
			SquashCommitDown:                  "向下聚合提交",
			FixupCommit:                       "修正提交",
			RewordCommit:                      "改写提交",
			DropCommit:                        "删除提交",
			EditCommit:                        "编辑提交",
			AmendCommit:                       "修改提交",
			RevertCommit:                      "还原提交",
			CreateFixupCommit:                 "创建修正提交",
			SquashAllAboveFixupCommits:        "聚合所有以上的修正提交",
			CreateLightweightTag:              "创建轻量级标签",
			CopyCommitMessageToClipboard:      "将提交消息复制到剪贴板",
			MoveCommitUp:                      "向上提交",
			MoveCommitDown:                    "下移提交",
			CustomCommand:                     "自定义命令",
			DiscardAllChangesInDirectory:      "放弃目录中的所有更改",
			DiscardUnstagedChangesInDirectory: "放弃目录中未暂存的更改",
			DiscardAllChangesInFile:           "放弃文件中的所有更改",
			DiscardAllUnstagedChangesInFile:   "丢弃文件中所有未暂存的更改",
			StageFile:                         "暂存文件",
			UnstageFile:                       "未暂存文件",
			UnstageAllFiles:                   "取消暂存所有文件",
			StageAllFiles:                     "暂存所有文件",
			IgnoreFile:                        "忽略文件",
			Commit:                            "提交(Commit)",
			EditFile:                          "编辑文件",
			Push:                              "推送(Push)",
			Pull:                              "拉取(Pull)",
			OpenFile:                          "打开文件",
			StashAllChanges:                   "Stash所有更改",
			StashStagedChanges:                "Stash暂存更改",
			GitFlowFinish:                     "Git流完成",
			GitFlowStart:                      "Git Flow开始",
			CopyToClipboard:                   "复制到剪贴板",
			RemovePatchFromCommit:             "从提交中删除补丁",
			MovePatchToSelectedCommit:         "将补丁移动到选定的提交",
			MovePatchIntoIndex:                "将补丁移到索引",
			MovePatchIntoNewCommit:            "将补丁移到新提交中",
			DeleteRemoteBranch:                "删除远程分支",
			SetBranchUpstream:                 "设置分支上游",
			AddRemote:                         "添加远程",
			RemoveRemote:                      "移除远程",
			UpdateRemote:                      "远程更新",
			ApplyPatch:                        "套用补丁",
			Stash:                             "Stash",
			RemoveSubmodule:                   "删除子模块",
			ResetSubmodule:                    "重置子模块",
			AddSubmodule:                      "添加子模块",
			UpdateSubmoduleUrl:                "更新子模块URL",
			InitialiseSubmodule:               "初始化子模块",
			BulkInitialiseSubmodules:          "批量初始化子模块",
			BulkUpdateSubmodules:              "批量更新子模块",
			BulkStashAndResetSubmodules:       "批量存储和重置子模块",
			BulkDeinitialiseSubmodules:        "批量取消初始化子模块",
			UpdateSubmodule:                   "更新子模块",
			DeleteTag:                         "删除标签",
			PushTag:                           "推送标签",
			NukeWorkingTree:                   "Nuke工作树",
			DiscardUnstagedFileChanges:        "放弃未暂存的文件更改",
			RemoveUntrackedFiles:              "删除未跟踪的文件",
			SoftReset:                         "软重置",
			MixedReset:                        "混合重置",
			HardReset:                         "硬重置",
			FastForwardBranch:                 "快进分支",
			Undo:                              "撤销",
			Redo:                              "重做",
		},
	}
}
