---
title: "help"
linkTitle: "help"
type: docs
description: >
    Help about any command
---

> ```
> kustomize help
> 
> Manages declarative configuration of Kubernetes.
> See https://sigs.k8s.io/kustomize
>
> Usage:
>   kustomize [command]
>
> Available Commands:
>   build                     Print configuration per contents of kustomization.yaml
>   cfg                       Commands for reading and writing configuration.
>   create                    Create a new kustomization in the current directory
>   edit                      Edits a kustomization file
>   fn                        Commands for running functions against configuration.
>   help                      Help about any command
>   install-completion        Install shell completion.
>   live                      Commands for reading and writing resources to a cluster.
>   version                   Prints the kustomize version
>
> Flags:
>   -h, --help          help for kustomize
>       --stack-trace   print a stack-trace on error
> 
> Additional help topics:
>   kustomize docs-fn                   [Alpha] Documentation for developing and invoking Configuration Functions.
>   kustomize docs-fn-spec              [Alpha] Documentation for Configuration Functions Specification.
>   kustomize docs-io-annotations       [Alpha] Documentation for annotations used by io.
>   kustomize docs-merge                [Alpha] Documentation for merging Resources (2-way merge).
>   kustomize docs-merge3               [Alpha] Documentation for merging Resources (3-way merge).
>   kustomize tutorials-command-basics  [Alpha] Tutorials for using basic config commands.
>   kustomize tutorials-function-basics [Alpha] Tutorials for using functions.
> 
> Use "kustomize [command] --help" for more information about a command.