---
title: "v3.1.0"
linkTitle: "v3.1.0"
date: 2019-07-26
description: >
  Kustomize v3.1.0
---

## Extended patches

Since this version, Kustomize allows applying one patch to multiple resources. This works for both Strategic Merge Patch and JSON Patch. Take a look at [patch multiple objects](https://github.com/kubernetes-sigs/kustomize/tree/master/examples/patchMultipleObjects.md).

## Improved Resource Matching

Multiple improvements have been made to allow the user to leverage "namespace"
instead/or with "name suffix/prefix" to segregate resources.

### Patch resolution improvement

The following example demonstrates how using the namespace field in the patch definition,
will let the user define two different patches against two different Deployment having the
same "deploy1" name but in different namespaces in the same Kustomize context/folder.
Unless the `namespace:` field has been specified in the kustomization.yaml, no namespace
value will be handled as Kubernetes `default` namespace.

```yaml
apiVersion: apps/v1
kind: Deployment
metadata:
  name: deploy1
  namespace: main
spec:
  template:
    spec:
      containers:
      - name: nginx
        env:
        - name: ANOTHERENV
          value: TESTVALUE
---
apiVersion: apps/v1
kind: Deployment
metadata:
  name: deploy1
  namespace: production
spec:
  template:
    spec:
      containers:
      - name: main
        env:
        - name: ANOTHERENV
          value: PRODVALUE
```

### Variable resolution improvement

It is possible to add namespace field to the variable declaration. In the following example,
two `Service` objects with the same `elasticsearch` name have been declared.
Specifying the namespace in the objRef of the corresponding varriables, allows Kustomize to
resovlve thoses variables.
If the namespace is not specified, Kustomize will handle it has a "wildcard" value.

Extract of kustomization.yaml:

```yaml
vars:
- name: elasticsearch-test-protocol
  objref:
    kind: Service
    name: elasticsearch
    namespace: test
    apiVersion: v1
  fieldref:
    fieldpath: spec.ports[0].protocol
- name: elasticsearch-dev-protocol
  objref:
    kind: Service
    name: elasticsearch
    namespace: dev
    apiVersion: v1
  fieldref:
    fieldpath: spec.ports[0].protocol

```

### Simultaneous change of names and namespaces

Kustomize is now able to deal with simultaneous changes of name and namespace.
Special attention has been paid the handling of:

- ClusterRoleBinding/RoleBinding "subjects" field,
- ValidatingWebhookConfiguration "webhooks" field.

The user should be able to use a kustomization.yaml as shown in the example bellow
even if ClusterRoleBind,RoleBinding and ValidatingWebookConfiguration are part of the
resources he needs to declare.

Extract of kustomization.yaml:

```yaml
namePrefix: pfx-
nameSuffix: -sfx
namespace: testnamespace

resources:
...
```

### Resource and Kustomize Context matching

Kustomize is now able to support more aggregation patterns.

If for instance, the top level of kustomization.yaml, is simply
combining sub-components, (as in the following example), Kustomize has improved
resource matching capabilities. This removes some of the constraints which were
present on the utilization of prefix/suffix and namespace transformers in the
individual components.

```yaml
resources:
- ../component1
- ../component2
- ../component3
```

## Other improvements

- Image transformation has been improved. This allows the user to update the sha256 of
  an image with another sha256.
- Multiple default transformer configuration entries have been added, removing the need for the
  user to add them as part of the `configurations:` section of the kustomization.yaml.
- `kustomize` help command has been tidied up.
